/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CollectionName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_COLLECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String collection;

    @Deprecated
    protected CollectionName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.collection = null;
    }

    private CollectionName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CollectionName of(String projectNumber, String location, String corpus, String collection) {
        return CollectionName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setCollection(collection).build();
    }

    public static String format(String projectNumber, String location, String corpus, String collection) {
        return CollectionName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setCollection(collection).build().toString();
    }

    public static CollectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_COLLECTION.validatedMatch(formattedString, "CollectionName.parse: formattedString not in valid format");
        return CollectionName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("collection"));
    }

    public static List<CollectionName> parseList(List<String> formattedStrings) {
        ArrayList<CollectionName> list = new ArrayList<CollectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CollectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CollectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CollectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_COLLECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CollectionName collectionName = this;
            synchronized (collectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_COLLECTION.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "collection", this.collection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CollectionName that = (CollectionName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String collection;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getCollection() {
            return this.collection;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        private Builder(CollectionName collectionName) {
            this.projectNumber = collectionName.projectNumber;
            this.location = collectionName.location;
            this.corpus = collectionName.corpus;
            this.collection = collectionName.collection;
        }

        public CollectionName build() {
            return new CollectionName(this);
        }
    }
}

