/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnnotationName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_ASSET_ANNOTATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String asset;
    private final String annotation;

    @Deprecated
    protected AnnotationName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.asset = null;
        this.annotation = null;
    }

    private AnnotationName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.annotation = (String)Preconditions.checkNotNull((Object)builder.getAnnotation());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getAsset() {
        return this.asset;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnnotationName of(String projectNumber, String location, String corpus, String asset, String annotation) {
        return AnnotationName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setAsset(asset).setAnnotation(annotation).build();
    }

    public static String format(String projectNumber, String location, String corpus, String asset, String annotation) {
        return AnnotationName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setAsset(asset).setAnnotation(annotation).build().toString();
    }

    public static AnnotationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_ASSET_ANNOTATION.validatedMatch(formattedString, "AnnotationName.parse: formattedString not in valid format");
        return AnnotationName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("asset"), (String)matchMap.get("annotation"));
    }

    public static List<AnnotationName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotationName> list = new ArrayList<AnnotationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_ASSET_ANNOTATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotationName annotationName = this;
            synchronized (annotationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    if (this.annotation != null) {
                        fieldMapBuilder.put((Object)"annotation", (Object)this.annotation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_ASSET_ANNOTATION.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "asset", this.asset, "annotation", this.annotation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnnotationName that = (AnnotationName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.asset, that.asset) && Objects.equals(this.annotation, that.annotation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        h ^= Objects.hashCode(this.asset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.annotation);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String asset;
        private String annotation;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getAsset() {
            return this.asset;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public Builder setAnnotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        private Builder(AnnotationName annotationName) {
            this.projectNumber = annotationName.projectNumber;
            this.location = annotationName.location;
            this.corpus = annotationName.corpus;
            this.asset = annotationName.asset;
            this.annotation = annotationName.annotation;
        }

        public AnnotationName build() {
            return new AnnotationName(this);
        }
    }
}

