/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OperatorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_OPERATOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/operators/{operator}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String operator;

    @Deprecated
    protected OperatorName() {
        this.project = null;
        this.location = null;
        this.operator = null;
    }

    private OperatorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.operator = (String)Preconditions.checkNotNull((Object)builder.getOperator());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOperator() {
        return this.operator;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OperatorName of(String project, String location, String operator) {
        return OperatorName.newBuilder().setProject(project).setLocation(location).setOperator(operator).build();
    }

    public static String format(String project, String location, String operator) {
        return OperatorName.newBuilder().setProject(project).setLocation(location).setOperator(operator).build().toString();
    }

    public static OperatorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_OPERATOR.validatedMatch(formattedString, "OperatorName.parse: formattedString not in valid format");
        return OperatorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("operator"));
    }

    public static List<OperatorName> parseList(List<String> formattedStrings) {
        ArrayList<OperatorName> list = new ArrayList<OperatorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OperatorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OperatorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OperatorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_OPERATOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OperatorName operatorName = this;
            synchronized (operatorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.operator != null) {
                        fieldMapBuilder.put((Object)"operator", (Object)this.operator);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_OPERATOR.instantiate(new String[]{"project", this.project, "location", this.location, "operator", this.operator});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OperatorName that = (OperatorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.operator, that.operator);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.operator);
    }

    public static class Builder {
        private String project;
        private String location;
        private String operator;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOperator() {
            return this.operator;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        private Builder(OperatorName operatorName) {
            this.project = operatorName.project;
            this.location = operatorName.location;
            this.operator = operatorName.operator;
        }

        public OperatorName build() {
            return new OperatorName(this);
        }
    }
}

