/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p4beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRODUCT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String product;

    @Deprecated
    protected ProductName() {
        this.project = null;
        this.location = null;
        this.product = null;
    }

    private ProductName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProduct() {
        return this.product;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductName of(String project, String location, String product) {
        return ProductName.newBuilder().setProject(project).setLocation(location).setProduct(product).build();
    }

    public static String format(String project, String location, String product) {
        return ProductName.newBuilder().setProject(project).setLocation(location).setProduct(product).build().toString();
    }

    public static ProductName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRODUCT.validatedMatch(formattedString, "ProductName.parse: formattedString not in valid format");
        return ProductName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product"));
    }

    public static List<ProductName> parseList(List<String> formattedStrings) {
        ArrayList<ProductName> list = new ArrayList<ProductName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRODUCT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductName productName = this;
            synchronized (productName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.product != null) {
                        fieldMapBuilder.put((Object)"product", (Object)this.product);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRODUCT.instantiate(new String[]{"project", this.project, "location", this.location, "product", this.product});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProductName that = (ProductName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.product, that.product);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.product);
    }

    public static class Builder {
        private String project;
        private String location;
        private String product;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProduct() {
            return this.product;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        private Builder(ProductName productName) {
            this.project = productName.project;
            this.location = productName.location;
            this.product = productName.product;
        }

        public ProductName build() {
            return new ProductName(this);
        }
    }
}

