/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1p3beta1;

import com.google.cloud.vision.v1p3beta1.Product;
import com.google.cloud.vision.v1p3beta1.ProductOrBuilder;
import com.google.cloud.vision.v1p3beta1.ProductSearchCategory;
import com.google.cloud.vision.v1p3beta1.ProductSearchProto;
import com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProductSearchResults
extends GeneratedMessageV3
implements ProductSearchResultsOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CATEGORY_FIELD_NUMBER = 1;
    private int category_;
    public static final int PRODUCT_CATEGORY_FIELD_NUMBER = 4;
    private volatile Object productCategory_;
    public static final int INDEX_TIME_FIELD_NUMBER = 2;
    private Timestamp indexTime_;
    public static final int PRODUCTS_FIELD_NUMBER = 3;
    private List<ProductInfo> products_;
    public static final int RESULTS_FIELD_NUMBER = 5;
    private List<Result> results_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ProductSearchResults DEFAULT_INSTANCE = new ProductSearchResults();
    private static final Parser<ProductSearchResults> PARSER = new AbstractParser<ProductSearchResults>(){

        public ProductSearchResults parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new ProductSearchResults(input, extensionRegistry);
        }
    };

    private ProductSearchResults(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ProductSearchResults() {
        this.category_ = 0;
        this.productCategory_ = "";
        this.products_ = Collections.emptyList();
        this.results_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ProductSearchResults();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private ProductSearchResults(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block14: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block14;
                    }
                    case 8: {
                        int rawValue;
                        this.category_ = rawValue = input.readEnum();
                        continue block14;
                    }
                    case 18: {
                        Timestamp.Builder subBuilder = null;
                        if (this.indexTime_ != null) {
                            subBuilder = this.indexTime_.toBuilder();
                        }
                        this.indexTime_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block14;
                        subBuilder.mergeFrom(this.indexTime_);
                        this.indexTime_ = subBuilder.buildPartial();
                        continue block14;
                    }
                    case 26: {
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.products_ = new ArrayList<ProductInfo>();
                            mutable_bitField0_ |= 1;
                        }
                        this.products_.add((ProductInfo)input.readMessage(ProductInfo.parser(), extensionRegistry));
                        continue block14;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.productCategory_ = s;
                        continue block14;
                    }
                    case 42: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.results_ = new ArrayList<Result>();
                            mutable_bitField0_ |= 2;
                        }
                        this.results_.add((Result)input.readMessage(Result.parser(), extensionRegistry));
                        continue block14;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.products_ = Collections.unmodifiableList(this.products_);
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.results_ = Collections.unmodifiableList(this.results_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductSearchResults.class, Builder.class);
    }

    @Override
    public int getCategoryValue() {
        return this.category_;
    }

    @Override
    public ProductSearchCategory getCategory() {
        ProductSearchCategory result = ProductSearchCategory.valueOf(this.category_);
        return result == null ? ProductSearchCategory.UNRECOGNIZED : result;
    }

    @Override
    public String getProductCategory() {
        Object ref = this.productCategory_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.productCategory_ = s;
        return s;
    }

    @Override
    public ByteString getProductCategoryBytes() {
        Object ref = this.productCategory_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.productCategory_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasIndexTime() {
        return this.indexTime_ != null;
    }

    @Override
    public Timestamp getIndexTime() {
        return this.indexTime_ == null ? Timestamp.getDefaultInstance() : this.indexTime_;
    }

    @Override
    public TimestampOrBuilder getIndexTimeOrBuilder() {
        return this.getIndexTime();
    }

    @Override
    public List<ProductInfo> getProductsList() {
        return this.products_;
    }

    @Override
    public List<? extends ProductInfoOrBuilder> getProductsOrBuilderList() {
        return this.products_;
    }

    @Override
    public int getProductsCount() {
        return this.products_.size();
    }

    @Override
    public ProductInfo getProducts(int index) {
        return this.products_.get(index);
    }

    @Override
    public ProductInfoOrBuilder getProductsOrBuilder(int index) {
        return this.products_.get(index);
    }

    @Override
    public List<Result> getResultsList() {
        return this.results_;
    }

    @Override
    public List<? extends ResultOrBuilder> getResultsOrBuilderList() {
        return this.results_;
    }

    @Override
    public int getResultsCount() {
        return this.results_.size();
    }

    @Override
    public Result getResults(int index) {
        return this.results_.get(index);
    }

    @Override
    public ResultOrBuilder getResultsOrBuilder(int index) {
        return this.results_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.category_ != ProductSearchCategory.PRODUCT_SEARCH_CATEGORY_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.category_);
        }
        if (this.indexTime_ != null) {
            output.writeMessage(2, (MessageLite)this.getIndexTime());
        }
        for (i = 0; i < this.products_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.products_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.productCategory_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.productCategory_);
        }
        for (i = 0; i < this.results_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.results_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.category_ != ProductSearchCategory.PRODUCT_SEARCH_CATEGORY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.category_);
        }
        if (this.indexTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getIndexTime());
        }
        for (i = 0; i < this.products_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.products_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.productCategory_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.productCategory_);
        }
        for (i = 0; i < this.results_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.results_.get(i)));
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProductSearchResults)) {
            return super.equals(obj);
        }
        ProductSearchResults other = (ProductSearchResults)obj;
        if (this.category_ != other.category_) {
            return false;
        }
        if (!this.getProductCategory().equals(other.getProductCategory())) {
            return false;
        }
        if (this.hasIndexTime() != other.hasIndexTime()) {
            return false;
        }
        if (this.hasIndexTime() && !this.getIndexTime().equals((Object)other.getIndexTime())) {
            return false;
        }
        if (!this.getProductsList().equals(other.getProductsList())) {
            return false;
        }
        if (!this.getResultsList().equals(other.getResultsList())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ProductSearchResults.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.category_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getProductCategory().hashCode();
        if (this.hasIndexTime()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getIndexTime().hashCode();
        }
        if (this.getProductsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getProductsList().hashCode();
        }
        if (this.getResultsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getResultsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static ProductSearchResults parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data);
    }

    public static ProductSearchResults parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductSearchResults parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data);
    }

    public static ProductSearchResults parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductSearchResults parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data);
    }

    public static ProductSearchResults parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ProductSearchResults)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ProductSearchResults parseFrom(InputStream input) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ProductSearchResults parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductSearchResults parseDelimitedFrom(InputStream input) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ProductSearchResults parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ProductSearchResults parseFrom(CodedInputStream input) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ProductSearchResults parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ProductSearchResults)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ProductSearchResults.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ProductSearchResults prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ProductSearchResults getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ProductSearchResults> parser() {
        return PARSER;
    }

    public Parser<ProductSearchResults> getParserForType() {
        return PARSER;
    }

    public ProductSearchResults getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ProductSearchResultsOrBuilder {
        private int bitField0_;
        private int category_ = 0;
        private Object productCategory_ = "";
        private Timestamp indexTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> indexTimeBuilder_;
        private List<ProductInfo> products_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ProductInfo, ProductInfo.Builder, ProductInfoOrBuilder> productsBuilder_;
        private List<Result> results_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Result, Result.Builder, ResultOrBuilder> resultsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductSearchResults.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getProductsFieldBuilder();
                this.getResultsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.category_ = 0;
            this.productCategory_ = "";
            if (this.indexTimeBuilder_ == null) {
                this.indexTime_ = null;
            } else {
                this.indexTime_ = null;
                this.indexTimeBuilder_ = null;
            }
            if (this.productsBuilder_ == null) {
                this.products_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.productsBuilder_.clear();
            }
            if (this.resultsBuilder_ == null) {
                this.results_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.resultsBuilder_.clear();
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
        }

        public ProductSearchResults getDefaultInstanceForType() {
            return ProductSearchResults.getDefaultInstance();
        }

        public ProductSearchResults build() {
            ProductSearchResults result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ProductSearchResults buildPartial() {
            ProductSearchResults result = new ProductSearchResults(this);
            int from_bitField0_ = this.bitField0_;
            result.category_ = this.category_;
            result.productCategory_ = this.productCategory_;
            if (this.indexTimeBuilder_ == null) {
                result.indexTime_ = this.indexTime_;
            } else {
                result.indexTime_ = (Timestamp)this.indexTimeBuilder_.build();
            }
            if (this.productsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.products_ = Collections.unmodifiableList(this.products_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.products_ = this.products_;
            } else {
                result.products_ = this.productsBuilder_.build();
            }
            if (this.resultsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.results_ = Collections.unmodifiableList(this.results_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.results_ = this.results_;
            } else {
                result.results_ = this.resultsBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ProductSearchResults) {
                return this.mergeFrom((ProductSearchResults)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ProductSearchResults other) {
            if (other == ProductSearchResults.getDefaultInstance()) {
                return this;
            }
            if (other.category_ != 0) {
                this.setCategoryValue(other.getCategoryValue());
            }
            if (!other.getProductCategory().isEmpty()) {
                this.productCategory_ = other.productCategory_;
                this.onChanged();
            }
            if (other.hasIndexTime()) {
                this.mergeIndexTime(other.getIndexTime());
            }
            if (this.productsBuilder_ == null) {
                if (!other.products_.isEmpty()) {
                    if (this.products_.isEmpty()) {
                        this.products_ = other.products_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureProductsIsMutable();
                        this.products_.addAll(other.products_);
                    }
                    this.onChanged();
                }
            } else if (!other.products_.isEmpty()) {
                if (this.productsBuilder_.isEmpty()) {
                    this.productsBuilder_.dispose();
                    this.productsBuilder_ = null;
                    this.products_ = other.products_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.productsBuilder_ = alwaysUseFieldBuilders ? this.getProductsFieldBuilder() : null;
                } else {
                    this.productsBuilder_.addAllMessages((Iterable)other.products_);
                }
            }
            if (this.resultsBuilder_ == null) {
                if (!other.results_.isEmpty()) {
                    if (this.results_.isEmpty()) {
                        this.results_ = other.results_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureResultsIsMutable();
                        this.results_.addAll(other.results_);
                    }
                    this.onChanged();
                }
            } else if (!other.results_.isEmpty()) {
                if (this.resultsBuilder_.isEmpty()) {
                    this.resultsBuilder_.dispose();
                    this.resultsBuilder_ = null;
                    this.results_ = other.results_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.resultsBuilder_ = alwaysUseFieldBuilders ? this.getResultsFieldBuilder() : null;
                } else {
                    this.resultsBuilder_.addAllMessages((Iterable)other.results_);
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            ProductSearchResults parsedMessage = null;
            try {
                parsedMessage = (ProductSearchResults)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (ProductSearchResults)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public int getCategoryValue() {
            return this.category_;
        }

        public Builder setCategoryValue(int value) {
            this.category_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ProductSearchCategory getCategory() {
            ProductSearchCategory result = ProductSearchCategory.valueOf(this.category_);
            return result == null ? ProductSearchCategory.UNRECOGNIZED : result;
        }

        public Builder setCategory(ProductSearchCategory value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.category_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCategory() {
            this.category_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getProductCategory() {
            Object ref = this.productCategory_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.productCategory_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getProductCategoryBytes() {
            Object ref = this.productCategory_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.productCategory_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setProductCategory(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.productCategory_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearProductCategory() {
            this.productCategory_ = ProductSearchResults.getDefaultInstance().getProductCategory();
            this.onChanged();
            return this;
        }

        public Builder setProductCategoryBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ProductSearchResults.checkByteStringIsUtf8((ByteString)value);
            this.productCategory_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasIndexTime() {
            return this.indexTimeBuilder_ != null || this.indexTime_ != null;
        }

        @Override
        public Timestamp getIndexTime() {
            if (this.indexTimeBuilder_ == null) {
                return this.indexTime_ == null ? Timestamp.getDefaultInstance() : this.indexTime_;
            }
            return (Timestamp)this.indexTimeBuilder_.getMessage();
        }

        public Builder setIndexTime(Timestamp value) {
            if (this.indexTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.indexTime_ = value;
                this.onChanged();
            } else {
                this.indexTimeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setIndexTime(Timestamp.Builder builderForValue) {
            if (this.indexTimeBuilder_ == null) {
                this.indexTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.indexTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeIndexTime(Timestamp value) {
            if (this.indexTimeBuilder_ == null) {
                this.indexTime_ = this.indexTime_ != null ? Timestamp.newBuilder((Timestamp)this.indexTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.indexTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearIndexTime() {
            if (this.indexTimeBuilder_ == null) {
                this.indexTime_ = null;
                this.onChanged();
            } else {
                this.indexTime_ = null;
                this.indexTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getIndexTimeBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getIndexTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getIndexTimeOrBuilder() {
            if (this.indexTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.indexTimeBuilder_.getMessageOrBuilder();
            }
            return this.indexTime_ == null ? Timestamp.getDefaultInstance() : this.indexTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getIndexTimeFieldBuilder() {
            if (this.indexTimeBuilder_ == null) {
                this.indexTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getIndexTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.indexTime_ = null;
            }
            return this.indexTimeBuilder_;
        }

        private void ensureProductsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.products_ = new ArrayList<ProductInfo>(this.products_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<ProductInfo> getProductsList() {
            if (this.productsBuilder_ == null) {
                return Collections.unmodifiableList(this.products_);
            }
            return this.productsBuilder_.getMessageList();
        }

        @Override
        public int getProductsCount() {
            if (this.productsBuilder_ == null) {
                return this.products_.size();
            }
            return this.productsBuilder_.getCount();
        }

        @Override
        public ProductInfo getProducts(int index) {
            if (this.productsBuilder_ == null) {
                return this.products_.get(index);
            }
            return (ProductInfo)this.productsBuilder_.getMessage(index);
        }

        public Builder setProducts(int index, ProductInfo value) {
            if (this.productsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProductsIsMutable();
                this.products_.set(index, value);
                this.onChanged();
            } else {
                this.productsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setProducts(int index, ProductInfo.Builder builderForValue) {
            if (this.productsBuilder_ == null) {
                this.ensureProductsIsMutable();
                this.products_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.productsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProducts(ProductInfo value) {
            if (this.productsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProductsIsMutable();
                this.products_.add(value);
                this.onChanged();
            } else {
                this.productsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addProducts(int index, ProductInfo value) {
            if (this.productsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureProductsIsMutable();
                this.products_.add(index, value);
                this.onChanged();
            } else {
                this.productsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addProducts(ProductInfo.Builder builderForValue) {
            if (this.productsBuilder_ == null) {
                this.ensureProductsIsMutable();
                this.products_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.productsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProducts(int index, ProductInfo.Builder builderForValue) {
            if (this.productsBuilder_ == null) {
                this.ensureProductsIsMutable();
                this.products_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.productsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllProducts(Iterable<? extends ProductInfo> values) {
            if (this.productsBuilder_ == null) {
                this.ensureProductsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.products_);
                this.onChanged();
            } else {
                this.productsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearProducts() {
            if (this.productsBuilder_ == null) {
                this.products_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.productsBuilder_.clear();
            }
            return this;
        }

        public Builder removeProducts(int index) {
            if (this.productsBuilder_ == null) {
                this.ensureProductsIsMutable();
                this.products_.remove(index);
                this.onChanged();
            } else {
                this.productsBuilder_.remove(index);
            }
            return this;
        }

        public ProductInfo.Builder getProductsBuilder(int index) {
            return (ProductInfo.Builder)this.getProductsFieldBuilder().getBuilder(index);
        }

        @Override
        public ProductInfoOrBuilder getProductsOrBuilder(int index) {
            if (this.productsBuilder_ == null) {
                return this.products_.get(index);
            }
            return (ProductInfoOrBuilder)this.productsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ProductInfoOrBuilder> getProductsOrBuilderList() {
            if (this.productsBuilder_ != null) {
                return this.productsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.products_);
        }

        public ProductInfo.Builder addProductsBuilder() {
            return (ProductInfo.Builder)this.getProductsFieldBuilder().addBuilder((AbstractMessage)ProductInfo.getDefaultInstance());
        }

        public ProductInfo.Builder addProductsBuilder(int index) {
            return (ProductInfo.Builder)this.getProductsFieldBuilder().addBuilder(index, (AbstractMessage)ProductInfo.getDefaultInstance());
        }

        public List<ProductInfo.Builder> getProductsBuilderList() {
            return this.getProductsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ProductInfo, ProductInfo.Builder, ProductInfoOrBuilder> getProductsFieldBuilder() {
            if (this.productsBuilder_ == null) {
                this.productsBuilder_ = new RepeatedFieldBuilderV3(this.products_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.products_ = null;
            }
            return this.productsBuilder_;
        }

        private void ensureResultsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.results_ = new ArrayList<Result>(this.results_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Result> getResultsList() {
            if (this.resultsBuilder_ == null) {
                return Collections.unmodifiableList(this.results_);
            }
            return this.resultsBuilder_.getMessageList();
        }

        @Override
        public int getResultsCount() {
            if (this.resultsBuilder_ == null) {
                return this.results_.size();
            }
            return this.resultsBuilder_.getCount();
        }

        @Override
        public Result getResults(int index) {
            if (this.resultsBuilder_ == null) {
                return this.results_.get(index);
            }
            return (Result)this.resultsBuilder_.getMessage(index);
        }

        public Builder setResults(int index, Result value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.set(index, value);
                this.onChanged();
            } else {
                this.resultsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setResults(int index, Result.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addResults(Result value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.add(value);
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addResults(int index, Result value) {
            if (this.resultsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureResultsIsMutable();
                this.results_.add(index, value);
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addResults(Result.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addResults(int index, Result.Builder builderForValue) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.resultsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllResults(Iterable<? extends Result> values) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.results_);
                this.onChanged();
            } else {
                this.resultsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearResults() {
            if (this.resultsBuilder_ == null) {
                this.results_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.resultsBuilder_.clear();
            }
            return this;
        }

        public Builder removeResults(int index) {
            if (this.resultsBuilder_ == null) {
                this.ensureResultsIsMutable();
                this.results_.remove(index);
                this.onChanged();
            } else {
                this.resultsBuilder_.remove(index);
            }
            return this;
        }

        public Result.Builder getResultsBuilder(int index) {
            return (Result.Builder)this.getResultsFieldBuilder().getBuilder(index);
        }

        @Override
        public ResultOrBuilder getResultsOrBuilder(int index) {
            if (this.resultsBuilder_ == null) {
                return this.results_.get(index);
            }
            return (ResultOrBuilder)this.resultsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ResultOrBuilder> getResultsOrBuilderList() {
            if (this.resultsBuilder_ != null) {
                return this.resultsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.results_);
        }

        public Result.Builder addResultsBuilder() {
            return (Result.Builder)this.getResultsFieldBuilder().addBuilder((AbstractMessage)Result.getDefaultInstance());
        }

        public Result.Builder addResultsBuilder(int index) {
            return (Result.Builder)this.getResultsFieldBuilder().addBuilder(index, (AbstractMessage)Result.getDefaultInstance());
        }

        public List<Result.Builder> getResultsBuilderList() {
            return this.getResultsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Result, Result.Builder, ResultOrBuilder> getResultsFieldBuilder() {
            if (this.resultsBuilder_ == null) {
                this.resultsBuilder_ = new RepeatedFieldBuilderV3(this.results_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.results_ = null;
            }
            return this.resultsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class Result
    extends GeneratedMessageV3
    implements ResultOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PRODUCT_FIELD_NUMBER = 1;
        private Product product_;
        public static final int SCORE_FIELD_NUMBER = 2;
        private float score_;
        public static final int IMAGE_FIELD_NUMBER = 3;
        private volatile Object image_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Result DEFAULT_INSTANCE = new Result();
        private static final Parser<Result> PARSER = new AbstractParser<Result>(){

            public Result parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new Result(input, extensionRegistry);
            }
        };

        private Result(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Result() {
            this.image_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Result();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private Result(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            Product.Builder subBuilder = null;
                            if (this.product_ != null) {
                                subBuilder = this.product_.toBuilder();
                            }
                            this.product_ = (Product)input.readMessage(Product.parser(), extensionRegistry);
                            if (subBuilder == null) continue block12;
                            subBuilder.mergeFrom(this.product_);
                            this.product_ = subBuilder.buildPartial();
                            continue block12;
                        }
                        case 21: {
                            this.score_ = input.readFloat();
                            continue block12;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.image_ = s;
                            continue block12;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_fieldAccessorTable.ensureFieldAccessorsInitialized(Result.class, Builder.class);
        }

        @Override
        public boolean hasProduct() {
            return this.product_ != null;
        }

        @Override
        public Product getProduct() {
            return this.product_ == null ? Product.getDefaultInstance() : this.product_;
        }

        @Override
        public ProductOrBuilder getProductOrBuilder() {
            return this.getProduct();
        }

        @Override
        public float getScore() {
            return this.score_;
        }

        @Override
        public String getImage() {
            Object ref = this.image_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.image_ = s;
            return s;
        }

        @Override
        public ByteString getImageBytes() {
            Object ref = this.image_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.image_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.product_ != null) {
                output.writeMessage(1, (MessageLite)this.getProduct());
            }
            if (this.score_ != 0.0f) {
                output.writeFloat(2, this.score_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.image_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.image_);
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.product_ != null) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getProduct());
            }
            if (this.score_ != 0.0f) {
                size += CodedOutputStream.computeFloatSize((int)2, (float)this.score_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.image_)) {
                size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.image_);
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Result)) {
                return super.equals(obj);
            }
            Result other = (Result)obj;
            if (this.hasProduct() != other.hasProduct()) {
                return false;
            }
            if (this.hasProduct() && !this.getProduct().equals(other.getProduct())) {
                return false;
            }
            if (Float.floatToIntBits(this.getScore()) != Float.floatToIntBits(other.getScore())) {
                return false;
            }
            if (!this.getImage().equals(other.getImage())) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Result.getDescriptor().hashCode();
            if (this.hasProduct()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getProduct().hashCode();
            }
            hash = 37 * hash + 2;
            hash = 53 * hash + Float.floatToIntBits(this.getScore());
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getImage().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static Result parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data);
        }

        public static Result parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Result parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data);
        }

        public static Result parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Result parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data);
        }

        public static Result parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Result)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Result parseFrom(InputStream input) throws IOException {
            return (Result)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Result parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Result)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Result parseDelimitedFrom(InputStream input) throws IOException {
            return (Result)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Result parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Result)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Result parseFrom(CodedInputStream input) throws IOException {
            return (Result)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Result parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Result)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Result.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Result prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Result getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Result> parser() {
            return PARSER;
        }

        public Parser<Result> getParserForType() {
            return PARSER;
        }

        public Result getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ResultOrBuilder {
            private Product product_;
            private SingleFieldBuilderV3<Product, Product.Builder, ProductOrBuilder> productBuilder_;
            private float score_;
            private Object image_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_fieldAccessorTable.ensureFieldAccessorsInitialized(Result.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            public Builder clear() {
                super.clear();
                if (this.productBuilder_ == null) {
                    this.product_ = null;
                } else {
                    this.product_ = null;
                    this.productBuilder_ = null;
                }
                this.score_ = 0.0f;
                this.image_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
            }

            public Result getDefaultInstanceForType() {
                return Result.getDefaultInstance();
            }

            public Result build() {
                Result result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Result buildPartial() {
                Result result = new Result(this);
                if (this.productBuilder_ == null) {
                    result.product_ = this.product_;
                } else {
                    result.product_ = (Product)this.productBuilder_.build();
                }
                result.score_ = this.score_;
                result.image_ = this.image_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Result) {
                    return this.mergeFrom((Result)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Result other) {
                if (other == Result.getDefaultInstance()) {
                    return this;
                }
                if (other.hasProduct()) {
                    this.mergeProduct(other.getProduct());
                }
                if (other.getScore() != 0.0f) {
                    this.setScore(other.getScore());
                }
                if (!other.getImage().isEmpty()) {
                    this.image_ = other.image_;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                Result parsedMessage = null;
                try {
                    parsedMessage = (Result)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (Result)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public boolean hasProduct() {
                return this.productBuilder_ != null || this.product_ != null;
            }

            @Override
            public Product getProduct() {
                if (this.productBuilder_ == null) {
                    return this.product_ == null ? Product.getDefaultInstance() : this.product_;
                }
                return (Product)this.productBuilder_.getMessage();
            }

            public Builder setProduct(Product value) {
                if (this.productBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.product_ = value;
                    this.onChanged();
                } else {
                    this.productBuilder_.setMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder setProduct(Product.Builder builderForValue) {
                if (this.productBuilder_ == null) {
                    this.product_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.productBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder mergeProduct(Product value) {
                if (this.productBuilder_ == null) {
                    this.product_ = this.product_ != null ? Product.newBuilder(this.product_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.productBuilder_.mergeFrom((AbstractMessage)value);
                }
                return this;
            }

            public Builder clearProduct() {
                if (this.productBuilder_ == null) {
                    this.product_ = null;
                    this.onChanged();
                } else {
                    this.product_ = null;
                    this.productBuilder_ = null;
                }
                return this;
            }

            public Product.Builder getProductBuilder() {
                this.onChanged();
                return (Product.Builder)this.getProductFieldBuilder().getBuilder();
            }

            @Override
            public ProductOrBuilder getProductOrBuilder() {
                if (this.productBuilder_ != null) {
                    return (ProductOrBuilder)this.productBuilder_.getMessageOrBuilder();
                }
                return this.product_ == null ? Product.getDefaultInstance() : this.product_;
            }

            private SingleFieldBuilderV3<Product, Product.Builder, ProductOrBuilder> getProductFieldBuilder() {
                if (this.productBuilder_ == null) {
                    this.productBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getProduct(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.product_ = null;
                }
                return this.productBuilder_;
            }

            @Override
            public float getScore() {
                return this.score_;
            }

            public Builder setScore(float value) {
                this.score_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearScore() {
                this.score_ = 0.0f;
                this.onChanged();
                return this;
            }

            @Override
            public String getImage() {
                Object ref = this.image_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.image_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getImageBytes() {
                Object ref = this.image_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.image_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setImage(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.image_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearImage() {
                this.image_ = Result.getDefaultInstance().getImage();
                this.onChanged();
                return this;
            }

            public Builder setImageBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Result.checkByteStringIsUtf8((ByteString)value);
                this.image_ = value;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ResultOrBuilder
    extends MessageOrBuilder {
        public boolean hasProduct();

        public Product getProduct();

        public ProductOrBuilder getProductOrBuilder();

        public float getScore();

        public String getImage();

        public ByteString getImageBytes();
    }

    public static final class ProductInfo
    extends GeneratedMessageV3
    implements ProductInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PRODUCT_ID_FIELD_NUMBER = 1;
        private volatile Object productId_;
        public static final int IMAGE_URI_FIELD_NUMBER = 2;
        private volatile Object imageUri_;
        public static final int SCORE_FIELD_NUMBER = 3;
        private float score_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ProductInfo DEFAULT_INSTANCE = new ProductInfo();
        private static final Parser<ProductInfo> PARSER = new AbstractParser<ProductInfo>(){

            public ProductInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new ProductInfo(input, extensionRegistry);
            }
        };

        private ProductInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ProductInfo() {
            this.productId_ = "";
            this.imageUri_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ProductInfo();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private ProductInfo(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.productId_ = s;
                            continue block12;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.imageUri_ = s;
                            continue block12;
                        }
                        case 29: {
                            this.score_ = input.readFloat();
                            continue block12;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ProductInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ProductInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductInfo.class, Builder.class);
        }

        @Override
        public String getProductId() {
            Object ref = this.productId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.productId_ = s;
            return s;
        }

        @Override
        public ByteString getProductIdBytes() {
            Object ref = this.productId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.productId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getImageUri() {
            Object ref = this.imageUri_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.imageUri_ = s;
            return s;
        }

        @Override
        public ByteString getImageUriBytes() {
            Object ref = this.imageUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.imageUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public float getScore() {
            return this.score_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.productId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.productId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.imageUri_);
            }
            if (this.score_ != 0.0f) {
                output.writeFloat(3, this.score_);
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.productId_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.productId_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.imageUri_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.imageUri_);
            }
            if (this.score_ != 0.0f) {
                size += CodedOutputStream.computeFloatSize((int)3, (float)this.score_);
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProductInfo)) {
                return super.equals(obj);
            }
            ProductInfo other = (ProductInfo)obj;
            if (!this.getProductId().equals(other.getProductId())) {
                return false;
            }
            if (!this.getImageUri().equals(other.getImageUri())) {
                return false;
            }
            if (Float.floatToIntBits(this.getScore()) != Float.floatToIntBits(other.getScore())) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ProductInfo.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getProductId().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getImageUri().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + Float.floatToIntBits(this.getScore());
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static ProductInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data);
        }

        public static ProductInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProductInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data);
        }

        public static ProductInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProductInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data);
        }

        public static ProductInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ProductInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ProductInfo parseFrom(InputStream input) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ProductInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ProductInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ProductInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ProductInfo parseFrom(CodedInputStream input) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ProductInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ProductInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ProductInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ProductInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ProductInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ProductInfo> parser() {
            return PARSER;
        }

        public Parser<ProductInfo> getParserForType() {
            return PARSER;
        }

        public ProductInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ProductInfoOrBuilder {
            private Object productId_ = "";
            private Object imageUri_ = "";
            private float score_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ProductInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ProductInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(ProductInfo.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            public Builder clear() {
                super.clear();
                this.productId_ = "";
                this.imageUri_ = "";
                this.score_ = 0.0f;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ProductSearchProto.internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ProductInfo_descriptor;
            }

            public ProductInfo getDefaultInstanceForType() {
                return ProductInfo.getDefaultInstance();
            }

            public ProductInfo build() {
                ProductInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ProductInfo buildPartial() {
                ProductInfo result = new ProductInfo(this);
                result.productId_ = this.productId_;
                result.imageUri_ = this.imageUri_;
                result.score_ = this.score_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ProductInfo) {
                    return this.mergeFrom((ProductInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ProductInfo other) {
                if (other == ProductInfo.getDefaultInstance()) {
                    return this;
                }
                if (!other.getProductId().isEmpty()) {
                    this.productId_ = other.productId_;
                    this.onChanged();
                }
                if (!other.getImageUri().isEmpty()) {
                    this.imageUri_ = other.imageUri_;
                    this.onChanged();
                }
                if (other.getScore() != 0.0f) {
                    this.setScore(other.getScore());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                ProductInfo parsedMessage = null;
                try {
                    parsedMessage = (ProductInfo)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (ProductInfo)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public String getProductId() {
                Object ref = this.productId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.productId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getProductIdBytes() {
                Object ref = this.productId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.productId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setProductId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.productId_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearProductId() {
                this.productId_ = ProductInfo.getDefaultInstance().getProductId();
                this.onChanged();
                return this;
            }

            public Builder setProductIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ProductInfo.checkByteStringIsUtf8((ByteString)value);
                this.productId_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public String getImageUri() {
                Object ref = this.imageUri_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.imageUri_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getImageUriBytes() {
                Object ref = this.imageUri_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.imageUri_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setImageUri(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.imageUri_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearImageUri() {
                this.imageUri_ = ProductInfo.getDefaultInstance().getImageUri();
                this.onChanged();
                return this;
            }

            public Builder setImageUriBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ProductInfo.checkByteStringIsUtf8((ByteString)value);
                this.imageUri_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public float getScore() {
                return this.score_;
            }

            public Builder setScore(float value) {
                this.score_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearScore() {
                this.score_ = 0.0f;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface ProductInfoOrBuilder
    extends MessageOrBuilder {
        public String getProductId();

        public ByteString getProductIdBytes();

        public String getImageUri();

        public ByteString getImageUriBytes();

        public float getScore();
    }
}

