/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VodStitchDetailName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOD_SESSION_VOD_STITCH_DETAIL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vodSessions/{vod_session}/vodStitchDetails/{vod_stitch_detail}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vodSession;
    private final String vodStitchDetail;

    @Deprecated
    protected VodStitchDetailName() {
        this.project = null;
        this.location = null;
        this.vodSession = null;
        this.vodStitchDetail = null;
    }

    private VodStitchDetailName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vodSession = (String)Preconditions.checkNotNull((Object)builder.getVodSession());
        this.vodStitchDetail = (String)Preconditions.checkNotNull((Object)builder.getVodStitchDetail());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVodSession() {
        return this.vodSession;
    }

    public String getVodStitchDetail() {
        return this.vodStitchDetail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VodStitchDetailName of(String project, String location, String vodSession, String vodStitchDetail) {
        return VodStitchDetailName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).setVodStitchDetail(vodStitchDetail).build();
    }

    public static String format(String project, String location, String vodSession, String vodStitchDetail) {
        return VodStitchDetailName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).setVodStitchDetail(vodStitchDetail).build().toString();
    }

    public static VodStitchDetailName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOD_SESSION_VOD_STITCH_DETAIL.validatedMatch(formattedString, "VodStitchDetailName.parse: formattedString not in valid format");
        return VodStitchDetailName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vod_session"), (String)matchMap.get("vod_stitch_detail"));
    }

    public static List<VodStitchDetailName> parseList(List<String> formattedStrings) {
        ArrayList<VodStitchDetailName> list = new ArrayList<VodStitchDetailName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VodStitchDetailName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VodStitchDetailName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VodStitchDetailName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOD_SESSION_VOD_STITCH_DETAIL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VodStitchDetailName vodStitchDetailName = this;
            synchronized (vodStitchDetailName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vodSession != null) {
                        fieldMapBuilder.put((Object)"vod_session", (Object)this.vodSession);
                    }
                    if (this.vodStitchDetail != null) {
                        fieldMapBuilder.put((Object)"vod_stitch_detail", (Object)this.vodStitchDetail);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOD_SESSION_VOD_STITCH_DETAIL.instantiate(new String[]{"project", this.project, "location", this.location, "vod_session", this.vodSession, "vod_stitch_detail", this.vodStitchDetail});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VodStitchDetailName that = (VodStitchDetailName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vodSession, that.vodSession) && Objects.equals(this.vodStitchDetail, that.vodStitchDetail);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.vodSession);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vodStitchDetail);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vodSession;
        private String vodStitchDetail;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVodSession() {
            return this.vodSession;
        }

        public String getVodStitchDetail() {
            return this.vodStitchDetail;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVodSession(String vodSession) {
            this.vodSession = vodSession;
            return this;
        }

        public Builder setVodStitchDetail(String vodStitchDetail) {
            this.vodStitchDetail = vodStitchDetail;
            return this;
        }

        private Builder(VodStitchDetailName vodStitchDetailName) {
            this.project = vodStitchDetailName.project;
            this.location = vodStitchDetailName.location;
            this.vodSession = vodStitchDetailName.vodSession;
            this.vodStitchDetail = vodStitchDetailName.vodStitchDetail;
        }

        public VodStitchDetailName build() {
            return new VodStitchDetailName(this);
        }
    }
}

