/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LiveConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LIVE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/liveConfigs/{live_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String liveConfig;

    @Deprecated
    protected LiveConfigName() {
        this.project = null;
        this.location = null;
        this.liveConfig = null;
    }

    private LiveConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.liveConfig = (String)Preconditions.checkNotNull((Object)builder.getLiveConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLiveConfig() {
        return this.liveConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LiveConfigName of(String project, String location, String liveConfig) {
        return LiveConfigName.newBuilder().setProject(project).setLocation(location).setLiveConfig(liveConfig).build();
    }

    public static String format(String project, String location, String liveConfig) {
        return LiveConfigName.newBuilder().setProject(project).setLocation(location).setLiveConfig(liveConfig).build().toString();
    }

    public static LiveConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LIVE_CONFIG.validatedMatch(formattedString, "LiveConfigName.parse: formattedString not in valid format");
        return LiveConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("live_config"));
    }

    public static List<LiveConfigName> parseList(List<String> formattedStrings) {
        ArrayList<LiveConfigName> list = new ArrayList<LiveConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LiveConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LiveConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LiveConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LIVE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LiveConfigName liveConfigName = this;
            synchronized (liveConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.liveConfig != null) {
                        fieldMapBuilder.put((Object)"live_config", (Object)this.liveConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LIVE_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "live_config", this.liveConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LiveConfigName that = (LiveConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.liveConfig, that.liveConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.liveConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String liveConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLiveConfig() {
            return this.liveConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLiveConfig(String liveConfig) {
            this.liveConfig = liveConfig;
            return this;
        }

        private Builder(LiveConfigName liveConfigName) {
            this.project = liveConfigName.project;
            this.location = liveConfigName.location;
            this.liveConfig = liveConfigName.liveConfig;
        }

        public LiveConfigName build() {
            return new LiveConfigName(this);
        }
    }
}

