/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VodAdTagDetailName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOD_SESSION_VOD_AD_TAG_DETAIL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vodSessions/{vod_session}/vodAdTagDetails/{vod_ad_tag_detail}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vodSession;
    private final String vodAdTagDetail;

    @Deprecated
    protected VodAdTagDetailName() {
        this.project = null;
        this.location = null;
        this.vodSession = null;
        this.vodAdTagDetail = null;
    }

    private VodAdTagDetailName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vodSession = (String)Preconditions.checkNotNull((Object)builder.getVodSession());
        this.vodAdTagDetail = (String)Preconditions.checkNotNull((Object)builder.getVodAdTagDetail());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVodSession() {
        return this.vodSession;
    }

    public String getVodAdTagDetail() {
        return this.vodAdTagDetail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VodAdTagDetailName of(String project, String location, String vodSession, String vodAdTagDetail) {
        return VodAdTagDetailName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).setVodAdTagDetail(vodAdTagDetail).build();
    }

    public static String format(String project, String location, String vodSession, String vodAdTagDetail) {
        return VodAdTagDetailName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).setVodAdTagDetail(vodAdTagDetail).build().toString();
    }

    public static VodAdTagDetailName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOD_SESSION_VOD_AD_TAG_DETAIL.validatedMatch(formattedString, "VodAdTagDetailName.parse: formattedString not in valid format");
        return VodAdTagDetailName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vod_session"), (String)matchMap.get("vod_ad_tag_detail"));
    }

    public static List<VodAdTagDetailName> parseList(List<String> formattedStrings) {
        ArrayList<VodAdTagDetailName> list = new ArrayList<VodAdTagDetailName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VodAdTagDetailName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VodAdTagDetailName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VodAdTagDetailName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOD_SESSION_VOD_AD_TAG_DETAIL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VodAdTagDetailName vodAdTagDetailName = this;
            synchronized (vodAdTagDetailName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vodSession != null) {
                        fieldMapBuilder.put((Object)"vod_session", (Object)this.vodSession);
                    }
                    if (this.vodAdTagDetail != null) {
                        fieldMapBuilder.put((Object)"vod_ad_tag_detail", (Object)this.vodAdTagDetail);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOD_SESSION_VOD_AD_TAG_DETAIL.instantiate(new String[]{"project", this.project, "location", this.location, "vod_session", this.vodSession, "vod_ad_tag_detail", this.vodAdTagDetail});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VodAdTagDetailName that = (VodAdTagDetailName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vodSession, that.vodSession) && Objects.equals(this.vodAdTagDetail, that.vodAdTagDetail);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.vodSession);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vodAdTagDetail);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vodSession;
        private String vodAdTagDetail;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVodSession() {
            return this.vodSession;
        }

        public String getVodAdTagDetail() {
            return this.vodAdTagDetail;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVodSession(String vodSession) {
            this.vodSession = vodSession;
            return this;
        }

        public Builder setVodAdTagDetail(String vodAdTagDetail) {
            this.vodAdTagDetail = vodAdTagDetail;
            return this;
        }

        private Builder(VodAdTagDetailName vodAdTagDetailName) {
            this.project = vodAdTagDetailName.project;
            this.location = vodAdTagDetailName.location;
            this.vodSession = vodAdTagDetailName.vodSession;
            this.vodAdTagDetail = vodAdTagDetailName.vodAdTagDetail;
        }

        public VodAdTagDetailName build() {
            return new VodAdTagDetailName(this);
        }
    }
}

