/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/endpoint.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Models are deployed into it, and afterwards Endpoint is called to obtain
 * predictions and explanations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.Endpoint}
 */
public final class Endpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.Endpoint)
    EndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Endpoint.newBuilder() to construct.
  private Endpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Endpoint() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    deployedModels_ = java.util.Collections.emptyList();
    etag_ = "";
    network_ = "";
    modelDeploymentMonitoringJob_ = "";
    dedicatedEndpointDns_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Endpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.EndpointProto
        .internal_static_google_cloud_vertexai_v1_Endpoint_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetTrafficSplit();
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.EndpointProto
        .internal_static_google_cloud_vertexai_v1_Endpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.Endpoint.class,
            com.google.cloud.vertexai.api.Endpoint.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Endpoint.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Endpoint.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the Endpoint.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the Endpoint.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the Endpoint.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the Endpoint.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODELS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.DeployedModel> deployedModels_;
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
   * and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
   * respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.DeployedModel> getDeployedModelsList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
   * and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
   * respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.DeployedModelOrBuilder>
      getDeployedModelsOrBuilderList() {
    return deployedModels_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
   * and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
   * respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getDeployedModelsCount() {
    return deployedModels_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
   * and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
   * respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.DeployedModel getDeployedModels(int index) {
    return deployedModels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The models deployed in this Endpoint.
   * To add or remove DeployedModels use
   * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
   * and
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
   * respectively.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.DeployedModelOrBuilder getDeployedModelsOrBuilder(
      int index) {
    return deployedModels_.get(index);
  }

  public static final int TRAFFIC_SPLIT_FIELD_NUMBER = 5;

  private static final class TrafficSplitDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.vertexai.api.EndpointProto
                .internal_static_google_cloud_vertexai_v1_Endpoint_TrafficSplitEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetTrafficSplit() {
    if (trafficSplit_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TrafficSplitDefaultEntryHolder.defaultEntry);
    }
    return trafficSplit_;
  }

  public int getTrafficSplitCount() {
    return internalGetTrafficSplit().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   *
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   *
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public boolean containsTrafficSplit(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTrafficSplit().getMap().containsKey(key);
  }
  /** Use {@link #getTrafficSplitMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
    return getTrafficSplitMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   *
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   *
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
    return internalGetTrafficSplit().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   *
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   *
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map from a DeployedModel's ID to the percentage of this Endpoint's
   * traffic that should be forwarded to that DeployedModel.
   *
   * If a DeployedModel's ID is not listed in this map, then it receives no
   * traffic.
   *
   * The traffic percentage values must add up to 100, or map must be empty if
   * the Endpoint is to not accept any traffic at a moment.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 6;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.vertexai.api.EndpointProto
                .internal_static_google_cloud_vertexai_v1_Endpoint_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Endpoints.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Endpoint was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 10;
  private com.google.cloud.vertexai.api.EncryptionSpec encryptionSpec_;
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.vertexai.api.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }
  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for an Endpoint. If set, this
   * Endpoint and all sub-resources of this Endpoint will be secured by
   * this key.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.vertexai.api.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int NETWORK_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
   * to which the Endpoint should be peered.
   *
   * Private services access must already be configured for the network. If left
   * unspecified, the Endpoint is not peered with any network.
   *
   * Only one of the fields,
   * [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   *
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
   * `projects/{project}/global/networks/{network}`.
   * Where `{project}` is a project number, as in `12345`, and `{network}` is
   * network name.
   * </pre>
   *
   * <code>
   * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The full name of the Google Compute Engine
   * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
   * to which the Endpoint should be peered.
   *
   * Private services access must already be configured for the network. If left
   * unspecified, the Endpoint is not peered with any network.
   *
   * Only one of the fields,
   * [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   *
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
   * `projects/{project}/global/networks/{network}`.
   * Where `{project}` is a project number, as in `12345`, and `{network}` is
   * network name.
   * </pre>
   *
   * <code>
   * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_PRIVATE_SERVICE_CONNECT_FIELD_NUMBER = 17;
  private boolean enablePrivateServiceConnect_ = false;
  /**
   *
   *
   * <pre>
   * Deprecated: If true, expose the Endpoint via private service connect.
   *
   * Only one of the fields,
   * [network][google.cloud.aiplatform.v1.Endpoint.network] or
   * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
   * can be set.
   * </pre>
   *
   * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
   *
   * @deprecated google.cloud.vertexai.v1.Endpoint.enable_private_service_connect is deprecated. See
   *     google/cloud/vertexai/v1/endpoint.proto;l=127
   * @return The enablePrivateServiceConnect.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getEnablePrivateServiceConnect() {
    return enablePrivateServiceConnect_;
  }

  public static final int PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER = 21;
  private com.google.cloud.vertexai.api.PrivateServiceConnectConfig privateServiceConnectConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration for private service connect.
   *
   * [network][google.cloud.aiplatform.v1.Endpoint.network] and
   * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
   * are mutually exclusive.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateServiceConnectConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateServiceConnectConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for private service connect.
   *
   * [network][google.cloud.aiplatform.v1.Endpoint.network] and
   * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
   * are mutually exclusive.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateServiceConnectConfig.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.PrivateServiceConnectConfig
      getPrivateServiceConnectConfig() {
    return privateServiceConnectConfig_ == null
        ? com.google.cloud.vertexai.api.PrivateServiceConnectConfig.getDefaultInstance()
        : privateServiceConnectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration for private service connect.
   *
   * [network][google.cloud.aiplatform.v1.Endpoint.network] and
   * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
   * are mutually exclusive.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.PrivateServiceConnectConfigOrBuilder
      getPrivateServiceConnectConfigOrBuilder() {
    return privateServiceConnectConfig_ == null
        ? com.google.cloud.vertexai.api.PrivateServiceConnectConfig.getDefaultInstance()
        : privateServiceConnectConfig_;
  }

  public static final int MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelDeploymentMonitoringJob_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Model Monitoring job associated with this
   * Endpoint if monitoring is enabled by
   * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public java.lang.String getModelDeploymentMonitoringJob() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelDeploymentMonitoringJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the Model Monitoring job associated with this
   * Endpoint if monitoring is enabled by
   * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
   * Format:
   * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
   * </pre>
   *
   * <code>
   * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for modelDeploymentMonitoringJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
    java.lang.Object ref = modelDeploymentMonitoringJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelDeploymentMonitoringJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICT_REQUEST_RESPONSE_LOGGING_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig
      predictRequestResponseLoggingConfig_;
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   *
   * @return Whether the predictRequestResponseLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasPredictRequestResponseLoggingConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   *
   * @return The predictRequestResponseLoggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig
      getPredictRequestResponseLoggingConfig() {
    return predictRequestResponseLoggingConfig_ == null
        ? com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.getDefaultInstance()
        : predictRequestResponseLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configures the request-response logging for online prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfigOrBuilder
      getPredictRequestResponseLoggingConfigOrBuilder() {
    return predictRequestResponseLoggingConfig_ == null
        ? com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.getDefaultInstance()
        : predictRequestResponseLoggingConfig_;
  }

  public static final int DEDICATED_ENDPOINT_ENABLED_FIELD_NUMBER = 24;
  private boolean dedicatedEndpointEnabled_ = false;
  /**
   *
   *
   * <pre>
   * If true, the endpoint will be exposed through a dedicated
   * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
   * will be isolated from other users' traffic and will have better performance
   * and reliability.
   * Note: Once you enabled dedicated endpoint, you won't be able to send
   * request to the shared DNS {region}-aiplatform.googleapis.com. The
   * limitation will be removed soon.
   * </pre>
   *
   * <code>bool dedicated_endpoint_enabled = 24;</code>
   *
   * @return The dedicatedEndpointEnabled.
   */
  @java.lang.Override
  public boolean getDedicatedEndpointEnabled() {
    return dedicatedEndpointEnabled_;
  }

  public static final int DEDICATED_ENDPOINT_DNS_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dedicatedEndpointDns_ = "";
  /**
   *
   *
   * <pre>
   * Output only. DNS of the dedicated endpoint. Will only be populated if
   * dedicated_endpoint_enabled is true.
   * Format:
   * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
   * </pre>
   *
   * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dedicatedEndpointDns.
   */
  @java.lang.Override
  public java.lang.String getDedicatedEndpointDns() {
    java.lang.Object ref = dedicatedEndpointDns_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dedicatedEndpointDns_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. DNS of the dedicated endpoint. Will only be populated if
   * dedicated_endpoint_enabled is true.
   * Format:
   * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
   * </pre>
   *
   * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for dedicatedEndpointDns.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDedicatedEndpointDnsBytes() {
    java.lang.Object ref = dedicatedEndpointDns_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dedicatedEndpointDns_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 27;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 28;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      output.writeMessage(4, deployedModels_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTrafficSplit(), TrafficSplitDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, modelDeploymentMonitoringJob_);
    }
    if (enablePrivateServiceConnect_ != false) {
      output.writeBool(17, enablePrivateServiceConnect_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(18, getPredictRequestResponseLoggingConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(21, getPrivateServiceConnectConfig());
    }
    if (dedicatedEndpointEnabled_ != false) {
      output.writeBool(24, dedicatedEndpointEnabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dedicatedEndpointDns_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, dedicatedEndpointDns_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(27, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(28, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < deployedModels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, deployedModels_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetTrafficSplit().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
          TrafficSplitDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, trafficSplit__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEncryptionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelDeploymentMonitoringJob_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              14, modelDeploymentMonitoringJob_);
    }
    if (enablePrivateServiceConnect_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(17, enablePrivateServiceConnect_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getPredictRequestResponseLoggingConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, getPrivateServiceConnectConfig());
    }
    if (dedicatedEndpointEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(24, dedicatedEndpointEnabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dedicatedEndpointDns_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, dedicatedEndpointDns_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(28, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.Endpoint)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.Endpoint other = (com.google.cloud.vertexai.api.Endpoint) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDeployedModelsList().equals(other.getDeployedModelsList())) return false;
    if (!internalGetTrafficSplit().equals(other.internalGetTrafficSplit())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (getEnablePrivateServiceConnect() != other.getEnablePrivateServiceConnect()) return false;
    if (hasPrivateServiceConnectConfig() != other.hasPrivateServiceConnectConfig()) return false;
    if (hasPrivateServiceConnectConfig()) {
      if (!getPrivateServiceConnectConfig().equals(other.getPrivateServiceConnectConfig()))
        return false;
    }
    if (!getModelDeploymentMonitoringJob().equals(other.getModelDeploymentMonitoringJob()))
      return false;
    if (hasPredictRequestResponseLoggingConfig() != other.hasPredictRequestResponseLoggingConfig())
      return false;
    if (hasPredictRequestResponseLoggingConfig()) {
      if (!getPredictRequestResponseLoggingConfig()
          .equals(other.getPredictRequestResponseLoggingConfig())) return false;
    }
    if (getDedicatedEndpointEnabled() != other.getDedicatedEndpointEnabled()) return false;
    if (!getDedicatedEndpointDns().equals(other.getDedicatedEndpointDns())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getDeployedModelsCount() > 0) {
      hash = (37 * hash) + DEPLOYED_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getDeployedModelsList().hashCode();
    }
    if (!internalGetTrafficSplit().getMap().isEmpty()) {
      hash = (37 * hash) + TRAFFIC_SPLIT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTrafficSplit().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + ENABLE_PRIVATE_SERVICE_CONNECT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateServiceConnect());
    if (hasPrivateServiceConnectConfig()) {
      hash = (37 * hash) + PRIVATE_SERVICE_CONNECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateServiceConnectConfig().hashCode();
    }
    hash = (37 * hash) + MODEL_DEPLOYMENT_MONITORING_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getModelDeploymentMonitoringJob().hashCode();
    if (hasPredictRequestResponseLoggingConfig()) {
      hash = (37 * hash) + PREDICT_REQUEST_RESPONSE_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPredictRequestResponseLoggingConfig().hashCode();
    }
    hash = (37 * hash) + DEDICATED_ENDPOINT_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDedicatedEndpointEnabled());
    hash = (37 * hash) + DEDICATED_ENDPOINT_DNS_FIELD_NUMBER;
    hash = (53 * hash) + getDedicatedEndpointDns().hashCode();
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.Endpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Models are deployed into it, and afterwards Endpoint is called to obtain
   * predictions and explanations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.Endpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.Endpoint)
      com.google.cloud.vertexai.api.EndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.EndpointProto
          .internal_static_google_cloud_vertexai_v1_Endpoint_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetTrafficSplit();
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableTrafficSplit();
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.EndpointProto
          .internal_static_google_cloud_vertexai_v1_Endpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.Endpoint.class,
              com.google.cloud.vertexai.api.Endpoint.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.Endpoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDeployedModelsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getPrivateServiceConnectConfigFieldBuilder();
        getPredictRequestResponseLoggingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
      } else {
        deployedModels_ = null;
        deployedModelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableTrafficSplit().clear();
      etag_ = "";
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      network_ = "";
      enablePrivateServiceConnect_ = false;
      privateServiceConnectConfig_ = null;
      if (privateServiceConnectConfigBuilder_ != null) {
        privateServiceConnectConfigBuilder_.dispose();
        privateServiceConnectConfigBuilder_ = null;
      }
      modelDeploymentMonitoringJob_ = "";
      predictRequestResponseLoggingConfig_ = null;
      if (predictRequestResponseLoggingConfigBuilder_ != null) {
        predictRequestResponseLoggingConfigBuilder_.dispose();
        predictRequestResponseLoggingConfigBuilder_ = null;
      }
      dedicatedEndpointEnabled_ = false;
      dedicatedEndpointDns_ = "";
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.EndpointProto
          .internal_static_google_cloud_vertexai_v1_Endpoint_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Endpoint getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.Endpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Endpoint build() {
      com.google.cloud.vertexai.api.Endpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Endpoint buildPartial() {
      com.google.cloud.vertexai.api.Endpoint result =
          new com.google.cloud.vertexai.api.Endpoint(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.Endpoint result) {
      if (deployedModelsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          deployedModels_ = java.util.Collections.unmodifiableList(deployedModels_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.deployedModels_ = deployedModels_;
      } else {
        result.deployedModels_ = deployedModelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.Endpoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.trafficSplit_ = internalGetTrafficSplit();
        result.trafficSplit_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.enablePrivateServiceConnect_ = enablePrivateServiceConnect_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.privateServiceConnectConfig_ =
            privateServiceConnectConfigBuilder_ == null
                ? privateServiceConnectConfig_
                : privateServiceConnectConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.modelDeploymentMonitoringJob_ = modelDeploymentMonitoringJob_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.predictRequestResponseLoggingConfig_ =
            predictRequestResponseLoggingConfigBuilder_ == null
                ? predictRequestResponseLoggingConfig_
                : predictRequestResponseLoggingConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.dedicatedEndpointEnabled_ = dedicatedEndpointEnabled_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.dedicatedEndpointDns_ = dedicatedEndpointDns_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.Endpoint) {
        return mergeFrom((com.google.cloud.vertexai.api.Endpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.Endpoint other) {
      if (other == com.google.cloud.vertexai.api.Endpoint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (deployedModelsBuilder_ == null) {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModels_.isEmpty()) {
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDeployedModelsIsMutable();
            deployedModels_.addAll(other.deployedModels_);
          }
          onChanged();
        }
      } else {
        if (!other.deployedModels_.isEmpty()) {
          if (deployedModelsBuilder_.isEmpty()) {
            deployedModelsBuilder_.dispose();
            deployedModelsBuilder_ = null;
            deployedModels_ = other.deployedModels_;
            bitField0_ = (bitField0_ & ~0x00000008);
            deployedModelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeployedModelsFieldBuilder()
                    : null;
          } else {
            deployedModelsBuilder_.addAllMessages(other.deployedModels_);
          }
        }
      }
      internalGetMutableTrafficSplit().mergeFrom(other.internalGetTrafficSplit());
      bitField0_ |= 0x00000010;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.getEnablePrivateServiceConnect() != false) {
        setEnablePrivateServiceConnect(other.getEnablePrivateServiceConnect());
      }
      if (other.hasPrivateServiceConnectConfig()) {
        mergePrivateServiceConnectConfig(other.getPrivateServiceConnectConfig());
      }
      if (!other.getModelDeploymentMonitoringJob().isEmpty()) {
        modelDeploymentMonitoringJob_ = other.modelDeploymentMonitoringJob_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasPredictRequestResponseLoggingConfig()) {
        mergePredictRequestResponseLoggingConfig(other.getPredictRequestResponseLoggingConfig());
      }
      if (other.getDedicatedEndpointEnabled() != false) {
        setDedicatedEndpointEnabled(other.getDedicatedEndpointEnabled());
      }
      if (!other.getDedicatedEndpointDns().isEmpty()) {
        dedicatedEndpointDns_ = other.dedicatedEndpointDns_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.vertexai.api.DeployedModel m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.DeployedModel.parser(), extensionRegistry);
                if (deployedModelsBuilder_ == null) {
                  ensureDeployedModelsIsMutable();
                  deployedModels_.add(m);
                } else {
                  deployedModelsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
                    input.readMessage(
                        TrafficSplitDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableTrafficSplit()
                    .getMutableMap()
                    .put(trafficSplit__.getKey(), trafficSplit__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 106:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 114:
              {
                modelDeploymentMonitoringJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 136:
              {
                enablePrivateServiceConnect_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getPredictRequestResponseLoggingConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 146
            case 170:
              {
                input.readMessage(
                    getPrivateServiceConnectConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 170
            case 192:
              {
                dedicatedEndpointEnabled_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 192
            case 202:
              {
                dedicatedEndpointDns_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 202
            case 216:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00020000;
                break;
              } // case 216
            case 224:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case 224
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Endpoint.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the Endpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the Endpoint.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vertexai.api.DeployedModel> deployedModels_ =
        java.util.Collections.emptyList();

    private void ensureDeployedModelsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        deployedModels_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.DeployedModel>(deployedModels_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.DeployedModel,
            com.google.cloud.vertexai.api.DeployedModel.Builder,
            com.google.cloud.vertexai.api.DeployedModelOrBuilder>
        deployedModelsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.DeployedModel> getDeployedModelsList() {
      if (deployedModelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deployedModels_);
      } else {
        return deployedModelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getDeployedModelsCount() {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.size();
      } else {
        return deployedModelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.DeployedModel getDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(int index, com.google.cloud.vertexai.api.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeployedModels(
        int index, com.google.cloud.vertexai.api.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.set(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(com.google.cloud.vertexai.api.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(int index, com.google.cloud.vertexai.api.DeployedModel value) {
      if (deployedModelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, value);
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        com.google.cloud.vertexai.api.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addDeployedModels(
        int index, com.google.cloud.vertexai.api.DeployedModel.Builder builderForValue) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.add(index, builderForValue.build());
        onChanged();
      } else {
        deployedModelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllDeployedModels(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.DeployedModel> values) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deployedModels_);
        onChanged();
      } else {
        deployedModelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeployedModels() {
      if (deployedModelsBuilder_ == null) {
        deployedModels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        deployedModelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDeployedModels(int index) {
      if (deployedModelsBuilder_ == null) {
        ensureDeployedModelsIsMutable();
        deployedModels_.remove(index);
        onChanged();
      } else {
        deployedModelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.DeployedModel.Builder getDeployedModelsBuilder(int index) {
      return getDeployedModelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.DeployedModelOrBuilder getDeployedModelsOrBuilder(
        int index) {
      if (deployedModelsBuilder_ == null) {
        return deployedModels_.get(index);
      } else {
        return deployedModelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.DeployedModelOrBuilder>
        getDeployedModelsOrBuilderList() {
      if (deployedModelsBuilder_ != null) {
        return deployedModelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deployedModels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.DeployedModel.Builder addDeployedModelsBuilder() {
      return getDeployedModelsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.DeployedModel.Builder addDeployedModelsBuilder(int index) {
      return getDeployedModelsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.DeployedModel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The models deployed in this Endpoint.
     * To add or remove DeployedModels use
     * [EndpointService.DeployModel][google.cloud.aiplatform.v1.EndpointService.DeployModel]
     * and
     * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel]
     * respectively.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.DeployedModel deployed_models = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.DeployedModel.Builder>
        getDeployedModelsBuilderList() {
      return getDeployedModelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.DeployedModel,
            com.google.cloud.vertexai.api.DeployedModel.Builder,
            com.google.cloud.vertexai.api.DeployedModelOrBuilder>
        getDeployedModelsFieldBuilder() {
      if (deployedModelsBuilder_ == null) {
        deployedModelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.DeployedModel,
                com.google.cloud.vertexai.api.DeployedModel.Builder,
                com.google.cloud.vertexai.api.DeployedModelOrBuilder>(
                deployedModels_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        deployedModels_ = null;
      }
      return deployedModelsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetTrafficSplit() {
      if (trafficSplit_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      return trafficSplit_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableTrafficSplit() {
      if (trafficSplit_ == null) {
        trafficSplit_ =
            com.google.protobuf.MapField.newMapField(TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      if (!trafficSplit_.isMutable()) {
        trafficSplit_ = trafficSplit_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return trafficSplit_;
    }

    public int getTrafficSplitCount() {
      return internalGetTrafficSplit().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public boolean containsTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTrafficSplit().getMap().containsKey(key);
    }
    /** Use {@link #getTrafficSplitMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
      return getTrafficSplitMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
      return internalGetTrafficSplit().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTrafficSplit() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableTrafficSplit().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder removeTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTrafficSplit().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableTrafficSplit() {
      bitField0_ |= 0x00000010;
      return internalGetMutableTrafficSplit().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder putTrafficSplit(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableTrafficSplit().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map from a DeployedModel's ID to the percentage of this Endpoint's
     * traffic that should be forwarded to that DeployedModel.
     *
     * If a DeployedModel's ID is not listed in this map, then it receives no
     * traffic.
     *
     * The traffic percentage values must add up to 100, or map must be empty if
     * the Endpoint is to not accept any traffic at a moment.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 5;</code>
     */
    public Builder putAllTrafficSplit(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableTrafficSplit().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     * </pre>
     *
     * <code>string etag = 6;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels with user-defined metadata to organize your Endpoints.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this Endpoint was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.vertexai.api.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.EncryptionSpec,
            com.google.cloud.vertexai.api.EncryptionSpec.Builder,
            com.google.cloud.vertexai.api.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.vertexai.api.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.vertexai.api.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.vertexai.api.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.vertexai.api.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.vertexai.api.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.vertexai.api.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000200);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public com.google.cloud.vertexai.api.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    public com.google.cloud.vertexai.api.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.vertexai.api.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for an Endpoint. If set, this
     * Endpoint and all sub-resources of this Endpoint will be secured by
     * this key.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.EncryptionSpec encryption_spec = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.EncryptionSpec,
            com.google.cloud.vertexai.api.EncryptionSpec.Builder,
            com.google.cloud.vertexai.api.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.EncryptionSpec,
                com.google.cloud.vertexai.api.EncryptionSpec.Builder,
                com.google.cloud.vertexai.api.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     *
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     *
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>
     * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     *
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     *
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>
     * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     *
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     *
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>
     * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     *
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     *
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>
     * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
     * to which the Endpoint should be peered.
     *
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     *
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where `{project}` is a project number, as in `12345`, and `{network}` is
     * network name.
     * </pre>
     *
     * <code>
     * string network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private boolean enablePrivateServiceConnect_;
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.vertexai.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/vertexai/v1/endpoint.proto;l=127
     * @return The enablePrivateServiceConnect.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getEnablePrivateServiceConnect() {
      return enablePrivateServiceConnect_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.vertexai.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/vertexai/v1/endpoint.proto;l=127
     * @param value The enablePrivateServiceConnect to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setEnablePrivateServiceConnect(boolean value) {

      enablePrivateServiceConnect_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: If true, expose the Endpoint via private service connect.
     *
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.Endpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.Endpoint.enable_private_service_connect],
     * can be set.
     * </pre>
     *
     * <code>bool enable_private_service_connect = 17 [deprecated = true];</code>
     *
     * @deprecated google.cloud.vertexai.v1.Endpoint.enable_private_service_connect is deprecated.
     *     See google/cloud/vertexai/v1/endpoint.proto;l=127
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearEnablePrivateServiceConnect() {
      bitField0_ = (bitField0_ & ~0x00000800);
      enablePrivateServiceConnect_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.vertexai.api.PrivateServiceConnectConfig privateServiceConnectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.PrivateServiceConnectConfig,
            com.google.cloud.vertexai.api.PrivateServiceConnectConfig.Builder,
            com.google.cloud.vertexai.api.PrivateServiceConnectConfigOrBuilder>
        privateServiceConnectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateServiceConnectConfig field is set.
     */
    public boolean hasPrivateServiceConnectConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateServiceConnectConfig.
     */
    public com.google.cloud.vertexai.api.PrivateServiceConnectConfig
        getPrivateServiceConnectConfig() {
      if (privateServiceConnectConfigBuilder_ == null) {
        return privateServiceConnectConfig_ == null
            ? com.google.cloud.vertexai.api.PrivateServiceConnectConfig.getDefaultInstance()
            : privateServiceConnectConfig_;
      } else {
        return privateServiceConnectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateServiceConnectConfig(
        com.google.cloud.vertexai.api.PrivateServiceConnectConfig value) {
      if (privateServiceConnectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateServiceConnectConfig_ = value;
      } else {
        privateServiceConnectConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateServiceConnectConfig(
        com.google.cloud.vertexai.api.PrivateServiceConnectConfig.Builder builderForValue) {
      if (privateServiceConnectConfigBuilder_ == null) {
        privateServiceConnectConfig_ = builderForValue.build();
      } else {
        privateServiceConnectConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateServiceConnectConfig(
        com.google.cloud.vertexai.api.PrivateServiceConnectConfig value) {
      if (privateServiceConnectConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && privateServiceConnectConfig_ != null
            && privateServiceConnectConfig_
                != com.google.cloud.vertexai.api.PrivateServiceConnectConfig.getDefaultInstance()) {
          getPrivateServiceConnectConfigBuilder().mergeFrom(value);
        } else {
          privateServiceConnectConfig_ = value;
        }
      } else {
        privateServiceConnectConfigBuilder_.mergeFrom(value);
      }
      if (privateServiceConnectConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateServiceConnectConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      privateServiceConnectConfig_ = null;
      if (privateServiceConnectConfigBuilder_ != null) {
        privateServiceConnectConfigBuilder_.dispose();
        privateServiceConnectConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.PrivateServiceConnectConfig.Builder
        getPrivateServiceConnectConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getPrivateServiceConnectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.PrivateServiceConnectConfigOrBuilder
        getPrivateServiceConnectConfigOrBuilder() {
      if (privateServiceConnectConfigBuilder_ != null) {
        return privateServiceConnectConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateServiceConnectConfig_ == null
            ? com.google.cloud.vertexai.api.PrivateServiceConnectConfig.getDefaultInstance()
            : privateServiceConnectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration for private service connect.
     *
     * [network][google.cloud.aiplatform.v1.Endpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.Endpoint.private_service_connect_config]
     * are mutually exclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PrivateServiceConnectConfig private_service_connect_config = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.PrivateServiceConnectConfig,
            com.google.cloud.vertexai.api.PrivateServiceConnectConfig.Builder,
            com.google.cloud.vertexai.api.PrivateServiceConnectConfigOrBuilder>
        getPrivateServiceConnectConfigFieldBuilder() {
      if (privateServiceConnectConfigBuilder_ == null) {
        privateServiceConnectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.PrivateServiceConnectConfig,
                com.google.cloud.vertexai.api.PrivateServiceConnectConfig.Builder,
                com.google.cloud.vertexai.api.PrivateServiceConnectConfigOrBuilder>(
                getPrivateServiceConnectConfig(), getParentForChildren(), isClean());
        privateServiceConnectConfig_ = null;
      }
      return privateServiceConnectConfigBuilder_;
    }

    private java.lang.Object modelDeploymentMonitoringJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this
     * Endpoint if monitoring is enabled by
     * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The modelDeploymentMonitoringJob.
     */
    public java.lang.String getModelDeploymentMonitoringJob() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelDeploymentMonitoringJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this
     * Endpoint if monitoring is enabled by
     * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for modelDeploymentMonitoringJob.
     */
    public com.google.protobuf.ByteString getModelDeploymentMonitoringJobBytes() {
      java.lang.Object ref = modelDeploymentMonitoringJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelDeploymentMonitoringJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this
     * Endpoint if monitoring is enabled by
     * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelDeploymentMonitoringJob_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this
     * Endpoint if monitoring is enabled by
     * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelDeploymentMonitoringJob() {
      modelDeploymentMonitoringJob_ = getDefaultInstance().getModelDeploymentMonitoringJob();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the Model Monitoring job associated with this
     * Endpoint if monitoring is enabled by
     * [JobService.CreateModelDeploymentMonitoringJob][google.cloud.aiplatform.v1.JobService.CreateModelDeploymentMonitoringJob].
     * Format:
     * `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
     * </pre>
     *
     * <code>
     * string model_deployment_monitoring_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for modelDeploymentMonitoringJob to set.
     * @return This builder for chaining.
     */
    public Builder setModelDeploymentMonitoringJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelDeploymentMonitoringJob_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig
        predictRequestResponseLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig,
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.Builder,
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfigOrBuilder>
        predictRequestResponseLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     *
     * @return Whether the predictRequestResponseLoggingConfig field is set.
     */
    public boolean hasPredictRequestResponseLoggingConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     *
     * @return The predictRequestResponseLoggingConfig.
     */
    public com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig
        getPredictRequestResponseLoggingConfig() {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        return predictRequestResponseLoggingConfig_ == null
            ? com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.getDefaultInstance()
            : predictRequestResponseLoggingConfig_;
      } else {
        return predictRequestResponseLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder setPredictRequestResponseLoggingConfig(
        com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig value) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predictRequestResponseLoggingConfig_ = value;
      } else {
        predictRequestResponseLoggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder setPredictRequestResponseLoggingConfig(
        com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.Builder builderForValue) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfig_ = builderForValue.build();
      } else {
        predictRequestResponseLoggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder mergePredictRequestResponseLoggingConfig(
        com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig value) {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && predictRequestResponseLoggingConfig_ != null
            && predictRequestResponseLoggingConfig_
                != com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig
                    .getDefaultInstance()) {
          getPredictRequestResponseLoggingConfigBuilder().mergeFrom(value);
        } else {
          predictRequestResponseLoggingConfig_ = value;
        }
      } else {
        predictRequestResponseLoggingConfigBuilder_.mergeFrom(value);
      }
      if (predictRequestResponseLoggingConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public Builder clearPredictRequestResponseLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      predictRequestResponseLoggingConfig_ = null;
      if (predictRequestResponseLoggingConfigBuilder_ != null) {
        predictRequestResponseLoggingConfigBuilder_.dispose();
        predictRequestResponseLoggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.Builder
        getPredictRequestResponseLoggingConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getPredictRequestResponseLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    public com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfigOrBuilder
        getPredictRequestResponseLoggingConfigOrBuilder() {
      if (predictRequestResponseLoggingConfigBuilder_ != null) {
        return predictRequestResponseLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return predictRequestResponseLoggingConfig_ == null
            ? com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.getDefaultInstance()
            : predictRequestResponseLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configures the request-response logging for online prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.PredictRequestResponseLoggingConfig predict_request_response_logging_config = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig,
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.Builder,
            com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfigOrBuilder>
        getPredictRequestResponseLoggingConfigFieldBuilder() {
      if (predictRequestResponseLoggingConfigBuilder_ == null) {
        predictRequestResponseLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig,
                com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfig.Builder,
                com.google.cloud.vertexai.api.PredictRequestResponseLoggingConfigOrBuilder>(
                getPredictRequestResponseLoggingConfig(), getParentForChildren(), isClean());
        predictRequestResponseLoggingConfig_ = null;
      }
      return predictRequestResponseLoggingConfigBuilder_;
    }

    private boolean dedicatedEndpointEnabled_;
    /**
     *
     *
     * <pre>
     * If true, the endpoint will be exposed through a dedicated
     * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
     * will be isolated from other users' traffic and will have better performance
     * and reliability.
     * Note: Once you enabled dedicated endpoint, you won't be able to send
     * request to the shared DNS {region}-aiplatform.googleapis.com. The
     * limitation will be removed soon.
     * </pre>
     *
     * <code>bool dedicated_endpoint_enabled = 24;</code>
     *
     * @return The dedicatedEndpointEnabled.
     */
    @java.lang.Override
    public boolean getDedicatedEndpointEnabled() {
      return dedicatedEndpointEnabled_;
    }
    /**
     *
     *
     * <pre>
     * If true, the endpoint will be exposed through a dedicated
     * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
     * will be isolated from other users' traffic and will have better performance
     * and reliability.
     * Note: Once you enabled dedicated endpoint, you won't be able to send
     * request to the shared DNS {region}-aiplatform.googleapis.com. The
     * limitation will be removed soon.
     * </pre>
     *
     * <code>bool dedicated_endpoint_enabled = 24;</code>
     *
     * @param value The dedicatedEndpointEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setDedicatedEndpointEnabled(boolean value) {

      dedicatedEndpointEnabled_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the endpoint will be exposed through a dedicated
     * DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS
     * will be isolated from other users' traffic and will have better performance
     * and reliability.
     * Note: Once you enabled dedicated endpoint, you won't be able to send
     * request to the shared DNS {region}-aiplatform.googleapis.com. The
     * limitation will be removed soon.
     * </pre>
     *
     * <code>bool dedicated_endpoint_enabled = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDedicatedEndpointEnabled() {
      bitField0_ = (bitField0_ & ~0x00008000);
      dedicatedEndpointEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object dedicatedEndpointDns_ = "";
    /**
     *
     *
     * <pre>
     * Output only. DNS of the dedicated endpoint. Will only be populated if
     * dedicated_endpoint_enabled is true.
     * Format:
     * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
     * </pre>
     *
     * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dedicatedEndpointDns.
     */
    public java.lang.String getDedicatedEndpointDns() {
      java.lang.Object ref = dedicatedEndpointDns_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dedicatedEndpointDns_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS of the dedicated endpoint. Will only be populated if
     * dedicated_endpoint_enabled is true.
     * Format:
     * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
     * </pre>
     *
     * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dedicatedEndpointDns.
     */
    public com.google.protobuf.ByteString getDedicatedEndpointDnsBytes() {
      java.lang.Object ref = dedicatedEndpointDns_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dedicatedEndpointDns_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS of the dedicated endpoint. Will only be populated if
     * dedicated_endpoint_enabled is true.
     * Format:
     * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
     * </pre>
     *
     * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dedicatedEndpointDns to set.
     * @return This builder for chaining.
     */
    public Builder setDedicatedEndpointDns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dedicatedEndpointDns_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS of the dedicated endpoint. Will only be populated if
     * dedicated_endpoint_enabled is true.
     * Format:
     * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
     * </pre>
     *
     * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDedicatedEndpointDns() {
      dedicatedEndpointDns_ = getDefaultInstance().getDedicatedEndpointDns();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. DNS of the dedicated endpoint. Will only be populated if
     * dedicated_endpoint_enabled is true.
     * Format:
     * `https://{endpoint_id}.{region}-{project_number}.prediction.vertexai.goog`.
     * </pre>
     *
     * <code>string dedicated_endpoint_dns = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for dedicatedEndpointDns to set.
     * @return This builder for chaining.
     */
    public Builder setDedicatedEndpointDnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dedicatedEndpointDns_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00020000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00040000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.Endpoint)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.Endpoint)
  private static final com.google.cloud.vertexai.api.Endpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.Endpoint();
  }

  public static com.google.cloud.vertexai.api.Endpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Endpoint> PARSER =
      new com.google.protobuf.AbstractParser<Endpoint>() {
        @java.lang.Override
        public Endpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Endpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Endpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.Endpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
