/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.memorystore.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_COLLECTION_BACKUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupCollections/{backup_collection}/backups/{backup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupCollection;
    private final String backup;

    @Deprecated
    protected BackupName() {
        this.project = null;
        this.location = null;
        this.backupCollection = null;
        this.backup = null;
    }

    private BackupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupCollection = (String)Preconditions.checkNotNull((Object)builder.getBackupCollection());
        this.backup = (String)Preconditions.checkNotNull((Object)builder.getBackup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupCollection() {
        return this.backupCollection;
    }

    public String getBackup() {
        return this.backup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupName of(String project, String location, String backupCollection, String backup) {
        return BackupName.newBuilder().setProject(project).setLocation(location).setBackupCollection(backupCollection).setBackup(backup).build();
    }

    public static String format(String project, String location, String backupCollection, String backup) {
        return BackupName.newBuilder().setProject(project).setLocation(location).setBackupCollection(backupCollection).setBackup(backup).build().toString();
    }

    public static BackupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_COLLECTION_BACKUP.validatedMatch(formattedString, "BackupName.parse: formattedString not in valid format");
        return BackupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_collection"), (String)matchMap.get("backup"));
    }

    public static List<BackupName> parseList(List<String> formattedStrings) {
        ArrayList<BackupName> list = new ArrayList<BackupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_COLLECTION_BACKUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupName backupName = this;
            synchronized (backupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupCollection != null) {
                        fieldMapBuilder.put((Object)"backup_collection", (Object)this.backupCollection);
                    }
                    if (this.backup != null) {
                        fieldMapBuilder.put((Object)"backup", (Object)this.backup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_COLLECTION_BACKUP.instantiate(new String[]{"project", this.project, "location", this.location, "backup_collection", this.backupCollection, "backup", this.backup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupName that = (BackupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupCollection, that.backupCollection) && Objects.equals(this.backup, that.backup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.backupCollection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupCollection;
        private String backup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupCollection() {
            return this.backupCollection;
        }

        public String getBackup() {
            return this.backup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupCollection(String backupCollection) {
            this.backupCollection = backupCollection;
            return this;
        }

        public Builder setBackup(String backup) {
            this.backup = backup;
            return this;
        }

        private Builder(BackupName backupName) {
            this.project = backupName.project;
            this.location = backupName.location;
            this.backupCollection = backupName.backupCollection;
            this.backup = backupName.backup;
        }

        public BackupName build() {
            return new BackupName(this);
        }
    }
}

