/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PublicBlueprintName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PUBLIC_LUEPRINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/publicBlueprints/{public_lueprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String publicLueprint;

    @Deprecated
    protected PublicBlueprintName() {
        this.project = null;
        this.location = null;
        this.publicLueprint = null;
    }

    private PublicBlueprintName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.publicLueprint = (String)Preconditions.checkNotNull((Object)builder.getPublicLueprint());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPublicLueprint() {
        return this.publicLueprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PublicBlueprintName of(String project, String location, String publicLueprint) {
        return PublicBlueprintName.newBuilder().setProject(project).setLocation(location).setPublicLueprint(publicLueprint).build();
    }

    public static String format(String project, String location, String publicLueprint) {
        return PublicBlueprintName.newBuilder().setProject(project).setLocation(location).setPublicLueprint(publicLueprint).build().toString();
    }

    public static PublicBlueprintName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PUBLIC_LUEPRINT.validatedMatch(formattedString, "PublicBlueprintName.parse: formattedString not in valid format");
        return PublicBlueprintName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("public_lueprint"));
    }

    public static List<PublicBlueprintName> parseList(List<String> formattedStrings) {
        ArrayList<PublicBlueprintName> list = new ArrayList<PublicBlueprintName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PublicBlueprintName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PublicBlueprintName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PublicBlueprintName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PUBLIC_LUEPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PublicBlueprintName publicBlueprintName = this;
            synchronized (publicBlueprintName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.publicLueprint != null) {
                        fieldMapBuilder.put((Object)"public_lueprint", (Object)this.publicLueprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PUBLIC_LUEPRINT.instantiate(new String[]{"project", this.project, "location", this.location, "public_lueprint", this.publicLueprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PublicBlueprintName that = (PublicBlueprintName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.publicLueprint, that.publicLueprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.publicLueprint);
    }

    public static class Builder {
        private String project;
        private String location;
        private String publicLueprint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPublicLueprint() {
            return this.publicLueprint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPublicLueprint(String publicLueprint) {
            this.publicLueprint = publicLueprint;
            return this;
        }

        private Builder(PublicBlueprintName publicBlueprintName) {
            this.project = publicBlueprintName.project;
            this.location = publicBlueprintName.location;
            this.publicLueprint = publicBlueprintName.publicLueprint;
        }

        public PublicBlueprintName build() {
            return new PublicBlueprintName(this);
        }
    }
}

