/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrchestrationClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORCHESTRATION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String orchestrationCluster;

    @Deprecated
    protected OrchestrationClusterName() {
        this.project = null;
        this.location = null;
        this.orchestrationCluster = null;
    }

    private OrchestrationClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.orchestrationCluster = (String)Preconditions.checkNotNull((Object)builder.getOrchestrationCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrchestrationCluster() {
        return this.orchestrationCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrchestrationClusterName of(String project, String location, String orchestrationCluster) {
        return OrchestrationClusterName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).build();
    }

    public static String format(String project, String location, String orchestrationCluster) {
        return OrchestrationClusterName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).build().toString();
    }

    public static OrchestrationClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORCHESTRATION_CLUSTER.validatedMatch(formattedString, "OrchestrationClusterName.parse: formattedString not in valid format");
        return OrchestrationClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("orchestration_cluster"));
    }

    public static List<OrchestrationClusterName> parseList(List<String> formattedStrings) {
        ArrayList<OrchestrationClusterName> list = new ArrayList<OrchestrationClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrchestrationClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrchestrationClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrchestrationClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrchestrationClusterName orchestrationClusterName = this;
            synchronized (orchestrationClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.orchestrationCluster != null) {
                        fieldMapBuilder.put((Object)"orchestration_cluster", (Object)this.orchestrationCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "orchestration_cluster", this.orchestrationCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrchestrationClusterName that = (OrchestrationClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.orchestrationCluster, that.orchestrationCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.orchestrationCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String orchestrationCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrchestrationCluster() {
            return this.orchestrationCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrchestrationCluster(String orchestrationCluster) {
            this.orchestrationCluster = orchestrationCluster;
            return this;
        }

        private Builder(OrchestrationClusterName orchestrationClusterName) {
            this.project = orchestrationClusterName.project;
            this.location = orchestrationClusterName.location;
            this.orchestrationCluster = orchestrationClusterName.orchestrationCluster;
        }

        public OrchestrationClusterName build() {
            return new OrchestrationClusterName(this);
        }
    }
}

