/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TenantName
implements ResourceName {
    private static final PathTemplate PROJECT_TENANT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String tenant;

    @Deprecated
    protected TenantName() {
        this.project = null;
        this.tenant = null;
    }

    private TenantName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
    }

    public String getProject() {
        return this.project;
    }

    public String getTenant() {
        return this.tenant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TenantName of(String project, String tenant) {
        return TenantName.newBuilder().setProject(project).setTenant(tenant).build();
    }

    public static String format(String project, String tenant) {
        return TenantName.newBuilder().setProject(project).setTenant(tenant).build().toString();
    }

    public static TenantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TENANT.validatedMatch(formattedString, "TenantName.parse: formattedString not in valid format");
        return TenantName.of((String)matchMap.get("project"), (String)matchMap.get("tenant"));
    }

    public static List<TenantName> parseList(List<String> formattedStrings) {
        ArrayList<TenantName> list = new ArrayList<TenantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TenantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TenantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TenantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TENANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TenantName tenantName = this;
            synchronized (tenantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TENANT.instantiate(new String[]{"project", this.project, "tenant", this.tenant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TenantName that = (TenantName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.tenant, that.tenant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tenant);
    }

    public static class Builder {
        private String project;
        private String tenant;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        private Builder(TenantName tenantName) {
            this.project = tenantName.project;
            this.tenant = tenantName.tenant;
        }

        public TenantName build() {
            return new TenantName(this);
        }
    }
}

