/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class JobName
implements ResourceName {
    private static final PathTemplate PROJECT_JOB_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/jobs/{job}");
    private static final PathTemplate PROJECT_TENANT_JOB_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/jobs/{job}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String job;
    private String tenant;

    @Deprecated
    protected JobName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getJob() {
        return this.job;
    }

    public String getTenant() {
        return this.tenant;
    }

    private JobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
        this.pathTemplate = PROJECT_JOB_PATH_TEMPLATE;
    }

    private JobName(ProjectTenantJobBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
        this.pathTemplate = PROJECT_TENANT_JOB_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectJobBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectTenantJobBuilder newProjectTenantJobBuilder() {
        return new ProjectTenantJobBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobName of(String project, String job) {
        return JobName.newProjectJobBuilder().setProject(project).setJob(job).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static JobName ofProjectJobName(String project, String job) {
        return JobName.newProjectJobBuilder().setProject(project).setJob(job).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static JobName ofProjectTenantJobName(String project, String tenant, String job) {
        return JobName.newProjectTenantJobBuilder().setProject(project).setTenant(tenant).setJob(job).build();
    }

    public static String format(String project, String job) {
        return JobName.newBuilder().setProject(project).setJob(job).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectJobName(String project, String job) {
        return JobName.newBuilder().setProject(project).setJob(job).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectTenantJobName(String project, String tenant, String job) {
        return JobName.newProjectTenantJobBuilder().setProject(project).setTenant(tenant).setJob(job).build().toString();
    }

    public static JobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_JOB_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_JOB_PATH_TEMPLATE.match(formattedString);
            return JobName.ofProjectJobName((String)matchMap.get("project"), (String)matchMap.get("job"));
        }
        if (PROJECT_TENANT_JOB_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_TENANT_JOB_PATH_TEMPLATE.match(formattedString);
            return JobName.ofProjectTenantJobName((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("job"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_JOB_PATH_TEMPLATE.matches(formattedString) || PROJECT_TENANT_JOB_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobName jobName = this;
            synchronized (jobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            JobName that = (JobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.job, that.job) && Objects.equals(this.tenant, that.tenant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.job);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tenant);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectTenantJobBuilder {
        private String project;
        private String tenant;
        private String job;

        private ProjectTenantJobBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getJob() {
            return this.job;
        }

        public ProjectTenantJobBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectTenantJobBuilder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ProjectTenantJobBuilder setJob(String job) {
            this.job = job;
            return this;
        }

        public JobName build() {
            return new JobName(this);
        }
    }

    public static class Builder {
        private String project;
        private String job;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getJob() {
            return this.job;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        private Builder(JobName jobName) {
            Preconditions.checkArgument((jobName.pathTemplate == PROJECT_JOB_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when JobName has the pattern of projects/{project}/jobs/{job}.");
            this.project = jobName.project;
            this.job = jobName.job;
        }

        public JobName build() {
            return new JobName(this);
        }
    }
}

