/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class CompanyName
implements ResourceName {
    private static final PathTemplate PROJECT_COMPANY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/companies/{company}");
    private static final PathTemplate PROJECT_TENANT_COMPANY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/companies/{company}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String company;
    private String tenant;

    @Deprecated
    protected CompanyName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getCompany() {
        return this.company;
    }

    public String getTenant() {
        return this.tenant;
    }

    private CompanyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.company = (String)Preconditions.checkNotNull((Object)builder.getCompany());
        this.pathTemplate = PROJECT_COMPANY_PATH_TEMPLATE;
    }

    private CompanyName(ProjectTenantCompanyBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.company = (String)Preconditions.checkNotNull((Object)builder.getCompany());
        this.pathTemplate = PROJECT_TENANT_COMPANY_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectCompanyBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectTenantCompanyBuilder newProjectTenantCompanyBuilder() {
        return new ProjectTenantCompanyBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CompanyName of(String project, String company) {
        return CompanyName.newProjectCompanyBuilder().setProject(project).setCompany(company).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CompanyName ofProjectCompanyName(String project, String company) {
        return CompanyName.newProjectCompanyBuilder().setProject(project).setCompany(company).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CompanyName ofProjectTenantCompanyName(String project, String tenant, String company) {
        return CompanyName.newProjectTenantCompanyBuilder().setProject(project).setTenant(tenant).setCompany(company).build();
    }

    public static String format(String project, String company) {
        return CompanyName.newBuilder().setProject(project).setCompany(company).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectCompanyName(String project, String company) {
        return CompanyName.newBuilder().setProject(project).setCompany(company).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectTenantCompanyName(String project, String tenant, String company) {
        return CompanyName.newProjectTenantCompanyBuilder().setProject(project).setTenant(tenant).setCompany(company).build().toString();
    }

    public static CompanyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_COMPANY_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_COMPANY_PATH_TEMPLATE.match(formattedString);
            return CompanyName.ofProjectCompanyName((String)matchMap.get("project"), (String)matchMap.get("company"));
        }
        if (PROJECT_TENANT_COMPANY_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_TENANT_COMPANY_PATH_TEMPLATE.match(formattedString);
            return CompanyName.ofProjectTenantCompanyName((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("company"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_COMPANY_PATH_TEMPLATE.matches(formattedString) || PROJECT_TENANT_COMPANY_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompanyName companyName = this;
            synchronized (companyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.company != null) {
                        fieldMapBuilder.put((Object)"company", (Object)this.company);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CompanyName that = (CompanyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.company, that.company) && Objects.equals(this.tenant, that.tenant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.company);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tenant);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectTenantCompanyBuilder {
        private String project;
        private String tenant;
        private String company;

        private ProjectTenantCompanyBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getCompany() {
            return this.company;
        }

        public ProjectTenantCompanyBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectTenantCompanyBuilder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ProjectTenantCompanyBuilder setCompany(String company) {
            this.company = company;
            return this;
        }

        public CompanyName build() {
            return new CompanyName(this);
        }
    }

    public static class Builder {
        private String project;
        private String company;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCompany() {
            return this.company;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setCompany(String company) {
            this.company = company;
            return this;
        }

        private Builder(CompanyName companyName) {
            Preconditions.checkArgument((companyName.pathTemplate == PROJECT_COMPANY_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when CompanyName has the pattern of projects/{project}/companies/{company}.");
            this.project = companyName.project;
            this.company = companyName.company;
        }

        public CompanyName build() {
            return new CompanyName(this);
        }
    }
}

