/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompanyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/companies/{company}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String company;

    public String getProject() {
        return this.project;
    }

    public String getCompany() {
        return this.company;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CompanyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.company = (String)Preconditions.checkNotNull((Object)builder.getCompany());
    }

    public static CompanyName of(String project, String company) {
        return CompanyName.newBuilder().setProject(project).setCompany(company).build();
    }

    public static String format(String project, String company) {
        return CompanyName.newBuilder().setProject(project).setCompany(company).build().toString();
    }

    public static CompanyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CompanyName.parse: formattedString not in valid format");
        return CompanyName.of((String)matchMap.get("project"), (String)matchMap.get("company"));
    }

    public static List<CompanyName> parseList(List<String> formattedStrings) {
        ArrayList<CompanyName> list = new ArrayList<CompanyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CompanyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CompanyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CompanyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompanyName companyName = this;
            synchronized (companyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"company", (Object)this.company);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "company", this.company});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CompanyName) {
            CompanyName that = (CompanyName)o;
            return this.project.equals(that.project) && this.company.equals(that.company);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.company.hashCode();
    }

    public static class Builder {
        private String project;
        private String company;

        public String getProject() {
            return this.project;
        }

        public String getCompany() {
            return this.company;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setCompany(String company) {
            this.company = company;
            return this;
        }

        private Builder() {
        }

        private Builder(CompanyName companyName) {
            this.project = companyName.project;
            this.company = companyName.company;
        }

        public CompanyName build() {
            return new CompanyName(this);
        }
    }
}

