/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobName
implements ResourceName {
    private static final PathTemplate PROJECT_TENANT_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/jobs/{job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String tenant;
    private final String job;

    @Deprecated
    protected JobName() {
        this.project = null;
        this.tenant = null;
        this.job = null;
    }

    private JobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getJob() {
        return this.job;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobName of(String project, String tenant, String job) {
        return JobName.newBuilder().setProject(project).setTenant(tenant).setJob(job).build();
    }

    public static String format(String project, String tenant, String job) {
        return JobName.newBuilder().setProject(project).setTenant(tenant).setJob(job).build().toString();
    }

    public static JobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TENANT_JOB.validatedMatch(formattedString, "JobName.parse: formattedString not in valid format");
        return JobName.of((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("job"));
    }

    public static List<JobName> parseList(List<String> formattedStrings) {
        ArrayList<JobName> list = new ArrayList<JobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(JobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<JobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (JobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TENANT_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobName jobName = this;
            synchronized (jobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TENANT_JOB.instantiate(new String[]{"project", this.project, "tenant", this.tenant, "job", this.job});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            JobName that = (JobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.job, that.job);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.tenant);
        h *= 1000003;
        return h ^= Objects.hashCode(this.job);
    }

    public static class Builder {
        private String project;
        private String tenant;
        private String job;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getJob() {
            return this.job;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        private Builder(JobName jobName) {
            this.project = jobName.project;
            this.tenant = jobName.tenant;
            this.job = jobName.job;
        }

        public JobName build() {
            return new JobName(this);
        }
    }
}

