/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storageinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasetConfigs/{dataset_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String datasetConfig;

    @Deprecated
    protected DatasetConfigName() {
        this.project = null;
        this.location = null;
        this.datasetConfig = null;
    }

    private DatasetConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.datasetConfig = (String)Preconditions.checkNotNull((Object)builder.getDatasetConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDatasetConfig() {
        return this.datasetConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatasetConfigName of(String project, String location, String datasetConfig) {
        return DatasetConfigName.newBuilder().setProject(project).setLocation(location).setDatasetConfig(datasetConfig).build();
    }

    public static String format(String project, String location, String datasetConfig) {
        return DatasetConfigName.newBuilder().setProject(project).setLocation(location).setDatasetConfig(datasetConfig).build().toString();
    }

    public static DatasetConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_CONFIG.validatedMatch(formattedString, "DatasetConfigName.parse: formattedString not in valid format");
        return DatasetConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset_config"));
    }

    public static List<DatasetConfigName> parseList(List<String> formattedStrings) {
        ArrayList<DatasetConfigName> list = new ArrayList<DatasetConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatasetConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatasetConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatasetConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatasetConfigName datasetConfigName = this;
            synchronized (datasetConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.datasetConfig != null) {
                        fieldMapBuilder.put((Object)"dataset_config", (Object)this.datasetConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "dataset_config", this.datasetConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatasetConfigName that = (DatasetConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.datasetConfig, that.datasetConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.datasetConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String datasetConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDatasetConfig() {
            return this.datasetConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDatasetConfig(String datasetConfig) {
            this.datasetConfig = datasetConfig;
            return this;
        }

        private Builder(DatasetConfigName datasetConfigName) {
            this.project = datasetConfigName.project;
            this.location = datasetConfigName.location;
            this.datasetConfig = datasetConfigName.datasetConfig;
        }

        public DatasetConfigName build() {
            return new DatasetConfigName(this);
        }
    }
}

