/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * The result of a call to Objects.ListObjects
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ListObjectsResponse}
 */
public final class ListObjectsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ListObjectsResponse)
    ListObjectsResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListObjectsResponse.newBuilder() to construct.
  private ListObjectsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListObjectsResponse() {
    objects_ = java.util.Collections.emptyList();
    prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListObjectsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListObjectsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListObjectsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ListObjectsResponse.class,
            com.google.storage.v2.ListObjectsResponse.Builder.class);
  }

  public static final int OBJECTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.Object> objects_;

  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Object objects = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.Object> getObjectsList() {
    return objects_;
  }

  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Object objects = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ObjectOrBuilder> getObjectsOrBuilderList() {
    return objects_;
  }

  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Object objects = 1;</code>
   */
  @java.lang.Override
  public int getObjectsCount() {
    return objects_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Object objects = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Object getObjects(int index) {
    return objects_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Object objects = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getObjectsOrBuilder(int index) {
    return objects_.get(index);
  }

  public static final int PREFIXES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList prefixes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The list of prefixes of objects matching-but-not-listed up to and including
   * the requested delimiter.
   * </pre>
   *
   * <code>repeated string prefixes = 2;</code>
   *
   * @return A list containing the prefixes.
   */
  public com.google.protobuf.ProtocolStringList getPrefixesList() {
    return prefixes_;
  }

  /**
   *
   *
   * <pre>
   * The list of prefixes of objects matching-but-not-listed up to and including
   * the requested delimiter.
   * </pre>
   *
   * <code>repeated string prefixes = 2;</code>
   *
   * @return The count of prefixes.
   */
  public int getPrefixesCount() {
    return prefixes_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of prefixes of objects matching-but-not-listed up to and including
   * the requested delimiter.
   * </pre>
   *
   * <code>repeated string prefixes = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The prefixes at the given index.
   */
  public java.lang.String getPrefixes(int index) {
    return prefixes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of prefixes of objects matching-but-not-listed up to and including
   * the requested delimiter.
   * </pre>
   *
   * <code>repeated string prefixes = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the prefixes at the given index.
   */
  public com.google.protobuf.ByteString getPrefixesBytes(int index) {
    return prefixes_.getByteString(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";

  /**
   *
   *
   * <pre>
   * The continuation token, used to page through large result sets. Provide
   * this value in a subsequent request to return the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The continuation token, used to page through large result sets. Provide
   * this value in a subsequent request to return the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < objects_.size(); i++) {
      output.writeMessage(1, objects_.get(i));
    }
    for (int i = 0; i < prefixes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, prefixes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < objects_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, objects_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < prefixes_.size(); i++) {
        dataSize += computeStringSizeNoTag(prefixes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPrefixesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ListObjectsResponse)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ListObjectsResponse other =
        (com.google.storage.v2.ListObjectsResponse) obj;

    if (!getObjectsList().equals(other.getObjectsList())) return false;
    if (!getPrefixesList().equals(other.getPrefixesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getObjectsCount() > 0) {
      hash = (37 * hash) + OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectsList().hashCode();
    }
    if (getPrefixesCount() > 0) {
      hash = (37 * hash) + PREFIXES_FIELD_NUMBER;
      hash = (53 * hash) + getPrefixesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ListObjectsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The result of a call to Objects.ListObjects
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ListObjectsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ListObjectsResponse)
      com.google.storage.v2.ListObjectsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ListObjectsResponse.class,
              com.google.storage.v2.ListObjectsResponse.Builder.class);
    }

    // Construct using com.google.storage.v2.ListObjectsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (objectsBuilder_ == null) {
        objects_ = java.util.Collections.emptyList();
      } else {
        objects_ = null;
        objectsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsResponse getDefaultInstanceForType() {
      return com.google.storage.v2.ListObjectsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsResponse build() {
      com.google.storage.v2.ListObjectsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsResponse buildPartial() {
      com.google.storage.v2.ListObjectsResponse result =
          new com.google.storage.v2.ListObjectsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.ListObjectsResponse result) {
      if (objectsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          objects_ = java.util.Collections.unmodifiableList(objects_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.objects_ = objects_;
      } else {
        result.objects_ = objectsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.ListObjectsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        prefixes_.makeImmutable();
        result.prefixes_ = prefixes_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ListObjectsResponse) {
        return mergeFrom((com.google.storage.v2.ListObjectsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ListObjectsResponse other) {
      if (other == com.google.storage.v2.ListObjectsResponse.getDefaultInstance()) return this;
      if (objectsBuilder_ == null) {
        if (!other.objects_.isEmpty()) {
          if (objects_.isEmpty()) {
            objects_ = other.objects_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureObjectsIsMutable();
            objects_.addAll(other.objects_);
          }
          onChanged();
        }
      } else {
        if (!other.objects_.isEmpty()) {
          if (objectsBuilder_.isEmpty()) {
            objectsBuilder_.dispose();
            objectsBuilder_ = null;
            objects_ = other.objects_;
            bitField0_ = (bitField0_ & ~0x00000001);
            objectsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectsFieldBuilder()
                    : null;
          } else {
            objectsBuilder_.addAllMessages(other.objects_);
          }
        }
      }
      if (!other.prefixes_.isEmpty()) {
        if (prefixes_.isEmpty()) {
          prefixes_ = other.prefixes_;
          bitField0_ |= 0x00000002;
        } else {
          ensurePrefixesIsMutable();
          prefixes_.addAll(other.prefixes_);
        }
        onChanged();
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.storage.v2.Object m =
                    input.readMessage(com.google.storage.v2.Object.parser(), extensionRegistry);
                if (objectsBuilder_ == null) {
                  ensureObjectsIsMutable();
                  objects_.add(m);
                } else {
                  objectsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePrefixesIsMutable();
                prefixes_.add(s);
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.storage.v2.Object> objects_ =
        java.util.Collections.emptyList();

    private void ensureObjectsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        objects_ = new java.util.ArrayList<com.google.storage.v2.Object>(objects_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        objectsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public java.util.List<com.google.storage.v2.Object> getObjectsList() {
      if (objectsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objects_);
      } else {
        return objectsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public int getObjectsCount() {
      if (objectsBuilder_ == null) {
        return objects_.size();
      } else {
        return objectsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public com.google.storage.v2.Object getObjects(int index) {
      if (objectsBuilder_ == null) {
        return objects_.get(index);
      } else {
        return objectsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder setObjects(int index, com.google.storage.v2.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.set(index, value);
        onChanged();
      } else {
        objectsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder setObjects(int index, com.google.storage.v2.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder addObjects(com.google.storage.v2.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.add(value);
        onChanged();
      } else {
        objectsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder addObjects(int index, com.google.storage.v2.Object value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectsIsMutable();
        objects_.add(index, value);
        onChanged();
      } else {
        objectsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder addObjects(com.google.storage.v2.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.add(builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder addObjects(int index, com.google.storage.v2.Object.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder addAllObjects(
        java.lang.Iterable<? extends com.google.storage.v2.Object> values) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objects_);
        onChanged();
      } else {
        objectsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder clearObjects() {
      if (objectsBuilder_ == null) {
        objects_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        objectsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public Builder removeObjects(int index) {
      if (objectsBuilder_ == null) {
        ensureObjectsIsMutable();
        objects_.remove(index);
        onChanged();
      } else {
        objectsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public com.google.storage.v2.Object.Builder getObjectsBuilder(int index) {
      return getObjectsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getObjectsOrBuilder(int index) {
      if (objectsBuilder_ == null) {
        return objects_.get(index);
      } else {
        return objectsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public java.util.List<? extends com.google.storage.v2.ObjectOrBuilder>
        getObjectsOrBuilderList() {
      if (objectsBuilder_ != null) {
        return objectsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objects_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public com.google.storage.v2.Object.Builder addObjectsBuilder() {
      return getObjectsFieldBuilder().addBuilder(com.google.storage.v2.Object.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public com.google.storage.v2.Object.Builder addObjectsBuilder(int index) {
      return getObjectsFieldBuilder()
          .addBuilder(index, com.google.storage.v2.Object.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Object objects = 1;</code>
     */
    public java.util.List<com.google.storage.v2.Object.Builder> getObjectsBuilderList() {
      return getObjectsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getObjectsFieldBuilder() {
      if (objectsBuilder_ == null) {
        objectsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                objects_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        objects_ = null;
      }
      return objectsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList prefixes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePrefixesIsMutable() {
      if (!prefixes_.isModifiable()) {
        prefixes_ = new com.google.protobuf.LazyStringArrayList(prefixes_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @return A list containing the prefixes.
     */
    public com.google.protobuf.ProtocolStringList getPrefixesList() {
      prefixes_.makeImmutable();
      return prefixes_;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @return The count of prefixes.
     */
    public int getPrefixesCount() {
      return prefixes_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The prefixes at the given index.
     */
    public java.lang.String getPrefixes(int index) {
      return prefixes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the prefixes at the given index.
     */
    public com.google.protobuf.ByteString getPrefixesBytes(int index) {
      return prefixes_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The prefixes to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrefixesIsMutable();
      prefixes_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param value The prefixes to add.
     * @return This builder for chaining.
     */
    public Builder addPrefixes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrefixesIsMutable();
      prefixes_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param values The prefixes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPrefixes(java.lang.Iterable<java.lang.String> values) {
      ensurePrefixesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, prefixes_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrefixes() {
      prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of prefixes of objects matching-but-not-listed up to and including
     * the requested delimiter.
     * </pre>
     *
     * <code>repeated string prefixes = 2;</code>
     *
     * @param value The bytes of the prefixes to add.
     * @return This builder for chaining.
     */
    public Builder addPrefixesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePrefixesIsMutable();
      prefixes_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object nextPageToken_ = "";

    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ListObjectsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ListObjectsResponse)
  private static final com.google.storage.v2.ListObjectsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ListObjectsResponse();
  }

  public static com.google.storage.v2.ListObjectsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListObjectsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListObjectsResponse>() {
        @java.lang.Override
        public ListObjectsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListObjectsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListObjectsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ListObjectsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
