/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for ListObjects.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ListObjectsRequest}
 */
public final class ListObjectsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ListObjectsRequest)
    ListObjectsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListObjectsRequest.newBuilder() to construct.
  private ListObjectsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListObjectsRequest() {
    parent_ = "";
    pageToken_ = "";
    delimiter_ = "";
    prefix_ = "";
    lexicographicStart_ = "";
    lexicographicEnd_ = "";
    matchGlob_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListObjectsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListObjectsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListObjectsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ListObjectsRequest.class,
            com.google.storage.v2.ListObjectsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for objects.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for objects.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum number of `items` plus `prefixes` to return
   * in a single page of responses. As duplicate `prefixes` are
   * omitted, fewer total results may be returned than requested. The service
   * will use this parameter or 1,000 items, whichever is smaller.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * A previously-returned page token representing part of the larger set of
   * results to view.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A previously-returned page token representing part of the larger set of
   * results to view.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELIMITER_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object delimiter_ = "";
  /**
   *
   *
   * <pre>
   * If set, returns results in a directory-like mode. `items` will contain
   * only objects whose names, aside from the `prefix`, do not
   * contain `delimiter`. Objects whose names, aside from the
   * `prefix`, contain `delimiter` will have their name,
   * truncated after the `delimiter`, returned in
   * `prefixes`. Duplicate `prefixes` are omitted.
   * </pre>
   *
   * <code>string delimiter = 4;</code>
   *
   * @return The delimiter.
   */
  @java.lang.Override
  public java.lang.String getDelimiter() {
    java.lang.Object ref = delimiter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      delimiter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If set, returns results in a directory-like mode. `items` will contain
   * only objects whose names, aside from the `prefix`, do not
   * contain `delimiter`. Objects whose names, aside from the
   * `prefix`, contain `delimiter` will have their name,
   * truncated after the `delimiter`, returned in
   * `prefixes`. Duplicate `prefixes` are omitted.
   * </pre>
   *
   * <code>string delimiter = 4;</code>
   *
   * @return The bytes for delimiter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDelimiterBytes() {
    java.lang.Object ref = delimiter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      delimiter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_TRAILING_DELIMITER_FIELD_NUMBER = 5;
  private boolean includeTrailingDelimiter_ = false;
  /**
   *
   *
   * <pre>
   * If true, objects that end in exactly one instance of `delimiter`
   * will have their metadata included in `items` in addition to
   * `prefixes`.
   * </pre>
   *
   * <code>bool include_trailing_delimiter = 5;</code>
   *
   * @return The includeTrailingDelimiter.
   */
  @java.lang.Override
  public boolean getIncludeTrailingDelimiter() {
    return includeTrailingDelimiter_;
  }

  public static final int PREFIX_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object prefix_ = "";
  /**
   *
   *
   * <pre>
   * Filter results to objects whose names begin with this prefix.
   * </pre>
   *
   * <code>string prefix = 6;</code>
   *
   * @return The prefix.
   */
  @java.lang.Override
  public java.lang.String getPrefix() {
    java.lang.Object ref = prefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      prefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter results to objects whose names begin with this prefix.
   * </pre>
   *
   * <code>string prefix = 6;</code>
   *
   * @return The bytes for prefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrefixBytes() {
    java.lang.Object ref = prefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      prefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSIONS_FIELD_NUMBER = 7;
  private boolean versions_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, lists all versions of an object as distinct results.
   * For more information, see
   * [Object
   * Versioning](https://cloud.google.com/storage/docs/object-versioning).
   * </pre>
   *
   * <code>bool versions = 7;</code>
   *
   * @return The versions.
   */
  @java.lang.Override
  public boolean getVersions() {
    return versions_;
  }

  public static final int READ_MASK_FIELD_NUMBER = 8;
  private com.google.protobuf.FieldMask readMask_;
  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read from each result.
   * If no mask is specified, will default to all fields except items.acl and
   * items.owner.
   * * may be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
   *
   * @return Whether the readMask field is set.
   */
  @java.lang.Override
  public boolean hasReadMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read from each result.
   * If no mask is specified, will default to all fields except items.acl and
   * items.owner.
   * * may be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
   *
   * @return The readMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getReadMask() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }
  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read from each result.
   * If no mask is specified, will default to all fields except items.acl and
   * items.owner.
   * * may be used to mean "all fields".
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }

  public static final int LEXICOGRAPHIC_START_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lexicographicStart_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * objects listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicStart.
   */
  @java.lang.Override
  public java.lang.String getLexicographicStart() {
    java.lang.Object ref = lexicographicStart_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lexicographicStart_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * objects listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicStart.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLexicographicStartBytes() {
    java.lang.Object ref = lexicographicStart_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lexicographicStart_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LEXICOGRAPHIC_END_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lexicographicEnd_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the objects
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicEnd.
   */
  @java.lang.Override
  public java.lang.String getLexicographicEnd() {
    java.lang.Object ref = lexicographicEnd_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lexicographicEnd_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the objects
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicEnd.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLexicographicEndBytes() {
    java.lang.Object ref = lexicographicEnd_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lexicographicEnd_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_GLOB_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object matchGlob_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects and prefixes that match this glob
   * pattern. See [List Objects Using
   * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
   * for the full syntax.
   * </pre>
   *
   * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The matchGlob.
   */
  @java.lang.Override
  public java.lang.String getMatchGlob() {
    java.lang.Object ref = matchGlob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      matchGlob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter results to objects and prefixes that match this glob
   * pattern. See [List Objects Using
   * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
   * for the full syntax.
   * </pre>
   *
   * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for matchGlob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMatchGlobBytes() {
    java.lang.Object ref = matchGlob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      matchGlob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delimiter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, delimiter_);
    }
    if (includeTrailingDelimiter_ != false) {
      output.writeBool(5, includeTrailingDelimiter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, prefix_);
    }
    if (versions_ != false) {
      output.writeBool(7, versions_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getReadMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicStart_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, lexicographicStart_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicEnd_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, lexicographicEnd_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, matchGlob_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delimiter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, delimiter_);
    }
    if (includeTrailingDelimiter_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, includeTrailingDelimiter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, prefix_);
    }
    if (versions_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, versions_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getReadMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicStart_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, lexicographicStart_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lexicographicEnd_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, lexicographicEnd_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, matchGlob_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ListObjectsRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ListObjectsRequest other = (com.google.storage.v2.ListObjectsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getDelimiter().equals(other.getDelimiter())) return false;
    if (getIncludeTrailingDelimiter() != other.getIncludeTrailingDelimiter()) return false;
    if (!getPrefix().equals(other.getPrefix())) return false;
    if (getVersions() != other.getVersions()) return false;
    if (hasReadMask() != other.hasReadMask()) return false;
    if (hasReadMask()) {
      if (!getReadMask().equals(other.getReadMask())) return false;
    }
    if (!getLexicographicStart().equals(other.getLexicographicStart())) return false;
    if (!getLexicographicEnd().equals(other.getLexicographicEnd())) return false;
    if (!getMatchGlob().equals(other.getMatchGlob())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + DELIMITER_FIELD_NUMBER;
    hash = (53 * hash) + getDelimiter().hashCode();
    hash = (37 * hash) + INCLUDE_TRAILING_DELIMITER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeTrailingDelimiter());
    hash = (37 * hash) + PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getPrefix().hashCode();
    hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVersions());
    if (hasReadMask()) {
      hash = (37 * hash) + READ_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getReadMask().hashCode();
    }
    hash = (37 * hash) + LEXICOGRAPHIC_START_FIELD_NUMBER;
    hash = (53 * hash) + getLexicographicStart().hashCode();
    hash = (37 * hash) + LEXICOGRAPHIC_END_FIELD_NUMBER;
    hash = (53 * hash) + getLexicographicEnd().hashCode();
    hash = (37 * hash) + MATCH_GLOB_FIELD_NUMBER;
    hash = (53 * hash) + getMatchGlob().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListObjectsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ListObjectsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for ListObjects.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ListObjectsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ListObjectsRequest)
      com.google.storage.v2.ListObjectsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ListObjectsRequest.class,
              com.google.storage.v2.ListObjectsRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.ListObjectsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      delimiter_ = "";
      includeTrailingDelimiter_ = false;
      prefix_ = "";
      versions_ = false;
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      lexicographicStart_ = "";
      lexicographicEnd_ = "";
      matchGlob_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListObjectsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsRequest getDefaultInstanceForType() {
      return com.google.storage.v2.ListObjectsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsRequest build() {
      com.google.storage.v2.ListObjectsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ListObjectsRequest buildPartial() {
      com.google.storage.v2.ListObjectsRequest result =
          new com.google.storage.v2.ListObjectsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.ListObjectsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.delimiter_ = delimiter_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.includeTrailingDelimiter_ = includeTrailingDelimiter_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.prefix_ = prefix_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.versions_ = versions_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.readMask_ = readMaskBuilder_ == null ? readMask_ : readMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.lexicographicStart_ = lexicographicStart_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.lexicographicEnd_ = lexicographicEnd_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.matchGlob_ = matchGlob_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ListObjectsRequest) {
        return mergeFrom((com.google.storage.v2.ListObjectsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ListObjectsRequest other) {
      if (other == com.google.storage.v2.ListObjectsRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDelimiter().isEmpty()) {
        delimiter_ = other.delimiter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getIncludeTrailingDelimiter() != false) {
        setIncludeTrailingDelimiter(other.getIncludeTrailingDelimiter());
      }
      if (!other.getPrefix().isEmpty()) {
        prefix_ = other.prefix_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getVersions() != false) {
        setVersions(other.getVersions());
      }
      if (other.hasReadMask()) {
        mergeReadMask(other.getReadMask());
      }
      if (!other.getLexicographicStart().isEmpty()) {
        lexicographicStart_ = other.lexicographicStart_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getLexicographicEnd().isEmpty()) {
        lexicographicEnd_ = other.lexicographicEnd_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getMatchGlob().isEmpty()) {
        matchGlob_ = other.matchGlob_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                delimiter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                includeTrailingDelimiter_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                prefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                versions_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getReadMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 82:
              {
                lexicographicStart_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                lexicographicEnd_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 114:
              {
                matchGlob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for objects.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for objects.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for objects.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for objects.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which to look for objects.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Maximum number of `items` plus `prefixes` to return
     * in a single page of responses. As duplicate `prefixes` are
     * omitted, fewer total results may be returned than requested. The service
     * will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of `items` plus `prefixes` to return
     * in a single page of responses. As duplicate `prefixes` are
     * omitted, fewer total results may be returned than requested. The service
     * will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of `items` plus `prefixes` to return
     * in a single page of responses. As duplicate `prefixes` are
     * omitted, fewer total results may be returned than requested. The service
     * will use this parameter or 1,000 items, whichever is smaller.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A previously-returned page token representing part of the larger set of
     * results to view.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A previously-returned page token representing part of the larger set of
     * results to view.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A previously-returned page token representing part of the larger set of
     * results to view.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A previously-returned page token representing part of the larger set of
     * results to view.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A previously-returned page token representing part of the larger set of
     * results to view.
     * </pre>
     *
     * <code>string page_token = 3;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object delimiter_ = "";
    /**
     *
     *
     * <pre>
     * If set, returns results in a directory-like mode. `items` will contain
     * only objects whose names, aside from the `prefix`, do not
     * contain `delimiter`. Objects whose names, aside from the
     * `prefix`, contain `delimiter` will have their name,
     * truncated after the `delimiter`, returned in
     * `prefixes`. Duplicate `prefixes` are omitted.
     * </pre>
     *
     * <code>string delimiter = 4;</code>
     *
     * @return The delimiter.
     */
    public java.lang.String getDelimiter() {
      java.lang.Object ref = delimiter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        delimiter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, returns results in a directory-like mode. `items` will contain
     * only objects whose names, aside from the `prefix`, do not
     * contain `delimiter`. Objects whose names, aside from the
     * `prefix`, contain `delimiter` will have their name,
     * truncated after the `delimiter`, returned in
     * `prefixes`. Duplicate `prefixes` are omitted.
     * </pre>
     *
     * <code>string delimiter = 4;</code>
     *
     * @return The bytes for delimiter.
     */
    public com.google.protobuf.ByteString getDelimiterBytes() {
      java.lang.Object ref = delimiter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        delimiter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, returns results in a directory-like mode. `items` will contain
     * only objects whose names, aside from the `prefix`, do not
     * contain `delimiter`. Objects whose names, aside from the
     * `prefix`, contain `delimiter` will have their name,
     * truncated after the `delimiter`, returned in
     * `prefixes`. Duplicate `prefixes` are omitted.
     * </pre>
     *
     * <code>string delimiter = 4;</code>
     *
     * @param value The delimiter to set.
     * @return This builder for chaining.
     */
    public Builder setDelimiter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      delimiter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns results in a directory-like mode. `items` will contain
     * only objects whose names, aside from the `prefix`, do not
     * contain `delimiter`. Objects whose names, aside from the
     * `prefix`, contain `delimiter` will have their name,
     * truncated after the `delimiter`, returned in
     * `prefixes`. Duplicate `prefixes` are omitted.
     * </pre>
     *
     * <code>string delimiter = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelimiter() {
      delimiter_ = getDefaultInstance().getDelimiter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns results in a directory-like mode. `items` will contain
     * only objects whose names, aside from the `prefix`, do not
     * contain `delimiter`. Objects whose names, aside from the
     * `prefix`, contain `delimiter` will have their name,
     * truncated after the `delimiter`, returned in
     * `prefixes`. Duplicate `prefixes` are omitted.
     * </pre>
     *
     * <code>string delimiter = 4;</code>
     *
     * @param value The bytes for delimiter to set.
     * @return This builder for chaining.
     */
    public Builder setDelimiterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      delimiter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean includeTrailingDelimiter_;
    /**
     *
     *
     * <pre>
     * If true, objects that end in exactly one instance of `delimiter`
     * will have their metadata included in `items` in addition to
     * `prefixes`.
     * </pre>
     *
     * <code>bool include_trailing_delimiter = 5;</code>
     *
     * @return The includeTrailingDelimiter.
     */
    @java.lang.Override
    public boolean getIncludeTrailingDelimiter() {
      return includeTrailingDelimiter_;
    }
    /**
     *
     *
     * <pre>
     * If true, objects that end in exactly one instance of `delimiter`
     * will have their metadata included in `items` in addition to
     * `prefixes`.
     * </pre>
     *
     * <code>bool include_trailing_delimiter = 5;</code>
     *
     * @param value The includeTrailingDelimiter to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeTrailingDelimiter(boolean value) {

      includeTrailingDelimiter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, objects that end in exactly one instance of `delimiter`
     * will have their metadata included in `items` in addition to
     * `prefixes`.
     * </pre>
     *
     * <code>bool include_trailing_delimiter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeTrailingDelimiter() {
      bitField0_ = (bitField0_ & ~0x00000010);
      includeTrailingDelimiter_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object prefix_ = "";
    /**
     *
     *
     * <pre>
     * Filter results to objects whose names begin with this prefix.
     * </pre>
     *
     * <code>string prefix = 6;</code>
     *
     * @return The prefix.
     */
    public java.lang.String getPrefix() {
      java.lang.Object ref = prefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        prefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter results to objects whose names begin with this prefix.
     * </pre>
     *
     * <code>string prefix = 6;</code>
     *
     * @return The bytes for prefix.
     */
    public com.google.protobuf.ByteString getPrefixBytes() {
      java.lang.Object ref = prefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        prefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter results to objects whose names begin with this prefix.
     * </pre>
     *
     * <code>string prefix = 6;</code>
     *
     * @param value The prefix to set.
     * @return This builder for chaining.
     */
    public Builder setPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      prefix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter results to objects whose names begin with this prefix.
     * </pre>
     *
     * <code>string prefix = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrefix() {
      prefix_ = getDefaultInstance().getPrefix();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter results to objects whose names begin with this prefix.
     * </pre>
     *
     * <code>string prefix = 6;</code>
     *
     * @param value The bytes for prefix to set.
     * @return This builder for chaining.
     */
    public Builder setPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      prefix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean versions_;
    /**
     *
     *
     * <pre>
     * If `true`, lists all versions of an object as distinct results.
     * For more information, see
     * [Object
     * Versioning](https://cloud.google.com/storage/docs/object-versioning).
     * </pre>
     *
     * <code>bool versions = 7;</code>
     *
     * @return The versions.
     */
    @java.lang.Override
    public boolean getVersions() {
      return versions_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, lists all versions of an object as distinct results.
     * For more information, see
     * [Object
     * Versioning](https://cloud.google.com/storage/docs/object-versioning).
     * </pre>
     *
     * <code>bool versions = 7;</code>
     *
     * @param value The versions to set.
     * @return This builder for chaining.
     */
    public Builder setVersions(boolean value) {

      versions_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, lists all versions of an object as distinct results.
     * For more information, see
     * [Object
     * Versioning](https://cloud.google.com/storage/docs/object-versioning).
     * </pre>
     *
     * <code>bool versions = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      versions_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask readMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        readMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     *
     * @return Whether the readMask field is set.
     */
    public boolean hasReadMask() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     *
     * @return The readMask.
     */
    public com.google.protobuf.FieldMask getReadMask() {
      if (readMaskBuilder_ == null) {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      } else {
        return readMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readMask_ = value;
      } else {
        readMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (readMaskBuilder_ == null) {
        readMask_ = builderForValue.build();
      } else {
        readMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public Builder mergeReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && readMask_ != null
            && readMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getReadMaskBuilder().mergeFrom(value);
        } else {
          readMask_ = value;
        }
      } else {
        readMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public Builder clearReadMask() {
      bitField0_ = (bitField0_ & ~0x00000080);
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public com.google.protobuf.FieldMask.Builder getReadMaskBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getReadMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
      if (readMaskBuilder_ != null) {
        return readMaskBuilder_.getMessageOrBuilder();
      } else {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Mask specifying which fields to read from each result.
     * If no mask is specified, will default to all fields except items.acl and
     * items.owner.
     * * may be used to mean "all fields".
     * </pre>
     *
     * <code>optional .google.protobuf.FieldMask read_mask = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getReadMaskFieldBuilder() {
      if (readMaskBuilder_ == null) {
        readMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getReadMask(), getParentForChildren(), isClean());
        readMask_ = null;
      }
      return readMaskBuilder_;
    }

    private java.lang.Object lexicographicStart_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * objects listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The lexicographicStart.
     */
    public java.lang.String getLexicographicStart() {
      java.lang.Object ref = lexicographicStart_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lexicographicStart_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * objects listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for lexicographicStart.
     */
    public com.google.protobuf.ByteString getLexicographicStartBytes() {
      java.lang.Object ref = lexicographicStart_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lexicographicStart_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * objects listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The lexicographicStart to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicStart(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lexicographicStart_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * objects listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLexicographicStart() {
      lexicographicStart_ = getDefaultInstance().getLexicographicStart();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically equal
     * to or after lexicographic_start. If lexicographic_end is also set, the
     * objects listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_start = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for lexicographicStart to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicStartBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lexicographicStart_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object lexicographicEnd_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the objects
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The lexicographicEnd.
     */
    public java.lang.String getLexicographicEnd() {
      java.lang.Object ref = lexicographicEnd_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lexicographicEnd_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the objects
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for lexicographicEnd.
     */
    public com.google.protobuf.ByteString getLexicographicEndBytes() {
      java.lang.Object ref = lexicographicEnd_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lexicographicEnd_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the objects
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The lexicographicEnd to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicEnd(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lexicographicEnd_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the objects
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLexicographicEnd() {
      lexicographicEnd_ = getDefaultInstance().getLexicographicEnd();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects whose names are lexicographically
     * before lexicographic_end. If lexicographic_start is also set, the objects
     * listed have names between lexicographic_start (inclusive) and
     * lexicographic_end (exclusive).
     * </pre>
     *
     * <code>string lexicographic_end = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for lexicographicEnd to set.
     * @return This builder for chaining.
     */
    public Builder setLexicographicEndBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lexicographicEnd_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object matchGlob_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects and prefixes that match this glob
     * pattern. See [List Objects Using
     * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
     * for the full syntax.
     * </pre>
     *
     * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The matchGlob.
     */
    public java.lang.String getMatchGlob() {
      java.lang.Object ref = matchGlob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchGlob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects and prefixes that match this glob
     * pattern. See [List Objects Using
     * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
     * for the full syntax.
     * </pre>
     *
     * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for matchGlob.
     */
    public com.google.protobuf.ByteString getMatchGlobBytes() {
      java.lang.Object ref = matchGlob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchGlob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects and prefixes that match this glob
     * pattern. See [List Objects Using
     * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
     * for the full syntax.
     * </pre>
     *
     * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The matchGlob to set.
     * @return This builder for chaining.
     */
    public Builder setMatchGlob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchGlob_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects and prefixes that match this glob
     * pattern. See [List Objects Using
     * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
     * for the full syntax.
     * </pre>
     *
     * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchGlob() {
      matchGlob_ = getDefaultInstance().getMatchGlob();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter results to objects and prefixes that match this glob
     * pattern. See [List Objects Using
     * Glob](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob)
     * for the full syntax.
     * </pre>
     *
     * <code>string match_glob = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for matchGlob to set.
     * @return This builder for chaining.
     */
    public Builder setMatchGlobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchGlob_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ListObjectsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ListObjectsRequest)
  private static final com.google.storage.v2.ListObjectsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ListObjectsRequest();
  }

  public static com.google.storage.v2.ListObjectsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListObjectsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListObjectsRequest>() {
        @java.lang.Override
        public ListObjectsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListObjectsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListObjectsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ListObjectsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
