/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * A bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.Bucket}
 */
public final class Bucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket)
    BucketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Bucket.newBuilder() to construct.
  private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Bucket() {
    name_ = "";
    bucketId_ = "";
    project_ = "";
    location_ = "";
    locationType_ = "";
    storageClass_ = "";
    acl_ = java.util.Collections.emptyList();
    defaultObjectAcl_ = java.util.Collections.emptyList();
    cors_ = java.util.Collections.emptyList();
    zoneAffinity_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Bucket();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Bucket(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              bucketId_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              project_ = s;
              break;
            }
          case 32:
            {
              metageneration_ = input.readInt64();
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              locationType_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              storageClass_ = s;
              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                acl_ = new java.util.ArrayList<com.google.storage.v2.BucketAccessControl>();
                mutable_bitField0_ |= 0x00000001;
              }
              acl_.add(
                  input.readMessage(
                      com.google.storage.v2.BucketAccessControl.parser(), extensionRegistry));
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                defaultObjectAcl_ =
                    new java.util.ArrayList<com.google.storage.v2.ObjectAccessControl>();
                mutable_bitField0_ |= 0x00000002;
              }
              defaultObjectAcl_.add(
                  input.readMessage(
                      com.google.storage.v2.ObjectAccessControl.parser(), extensionRegistry));
              break;
            }
          case 82:
            {
              com.google.storage.v2.Bucket.Lifecycle.Builder subBuilder = null;
              if (lifecycle_ != null) {
                subBuilder = lifecycle_.toBuilder();
              }
              lifecycle_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Lifecycle.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(lifecycle_);
                lifecycle_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                cors_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Cors>();
                mutable_bitField0_ |= 0x00000004;
              }
              cors_.add(
                  input.readMessage(com.google.storage.v2.Bucket.Cors.parser(), extensionRegistry));
              break;
            }
          case 106:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 112:
            {
              defaultEventBasedHold_ = input.readBool();
              break;
            }
          case 122:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000008;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          case 130:
            {
              com.google.storage.v2.Bucket.Website.Builder subBuilder = null;
              if (website_ != null) {
                subBuilder = website_.toBuilder();
              }
              website_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Website.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(website_);
                website_ = subBuilder.buildPartial();
              }

              break;
            }
          case 138:
            {
              com.google.storage.v2.Bucket.Versioning.Builder subBuilder = null;
              if (versioning_ != null) {
                subBuilder = versioning_.toBuilder();
              }
              versioning_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Versioning.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(versioning_);
                versioning_ = subBuilder.buildPartial();
              }

              break;
            }
          case 146:
            {
              com.google.storage.v2.Bucket.Logging.Builder subBuilder = null;
              if (logging_ != null) {
                subBuilder = logging_.toBuilder();
              }
              logging_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Logging.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(logging_);
                logging_ = subBuilder.buildPartial();
              }

              break;
            }
          case 154:
            {
              com.google.storage.v2.Owner.Builder subBuilder = null;
              if (owner_ != null) {
                subBuilder = owner_.toBuilder();
              }
              owner_ = input.readMessage(com.google.storage.v2.Owner.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(owner_);
                owner_ = subBuilder.buildPartial();
              }

              break;
            }
          case 162:
            {
              com.google.storage.v2.Bucket.Encryption.Builder subBuilder = null;
              if (encryption_ != null) {
                subBuilder = encryption_.toBuilder();
              }
              encryption_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Encryption.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryption_);
                encryption_ = subBuilder.buildPartial();
              }

              break;
            }
          case 170:
            {
              com.google.storage.v2.Bucket.Billing.Builder subBuilder = null;
              if (billing_ != null) {
                subBuilder = billing_.toBuilder();
              }
              billing_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.Billing.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(billing_);
                billing_ = subBuilder.buildPartial();
              }

              break;
            }
          case 178:
            {
              com.google.storage.v2.Bucket.RetentionPolicy.Builder subBuilder = null;
              if (retentionPolicy_ != null) {
                subBuilder = retentionPolicy_.toBuilder();
              }
              retentionPolicy_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.RetentionPolicy.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(retentionPolicy_);
                retentionPolicy_ = subBuilder.buildPartial();
              }

              break;
            }
          case 186:
            {
              com.google.storage.v2.Bucket.IamConfig.Builder subBuilder = null;
              if (iamConfig_ != null) {
                subBuilder = iamConfig_.toBuilder();
              }
              iamConfig_ =
                  input.readMessage(
                      com.google.storage.v2.Bucket.IamConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(iamConfig_);
                iamConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 194:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                zoneAffinity_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000010;
              }
              zoneAffinity_.add(s);
              break;
            }
          case 200:
            {
              satisfiesPzs_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        acl_ = java.util.Collections.unmodifiableList(acl_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        defaultObjectAcl_ = java.util.Collections.unmodifiableList(defaultObjectAcl_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        cors_ = java.util.Collections.unmodifiableList(cors_);
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        zoneAffinity_ = zoneAffinity_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_Bucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.Bucket.class, com.google.storage.v2.Bucket.Builder.class);
  }

  public interface BillingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Billing)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1;</code>
     *
     * @return The requesterPays.
     */
    boolean getRequesterPays();
  }
  /**
   *
   *
   * <pre>
   * Billing properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Billing}
   */
  public static final class Billing extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Billing)
      BillingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Billing.newBuilder() to construct.
    private Billing(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Billing() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Billing();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Billing(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                requesterPays_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Billing.class,
              com.google.storage.v2.Bucket.Billing.Builder.class);
    }

    public static final int REQUESTER_PAYS_FIELD_NUMBER = 1;
    private boolean requesterPays_;
    /**
     *
     *
     * <pre>
     * When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1;</code>
     *
     * @return The requesterPays.
     */
    @java.lang.Override
    public boolean getRequesterPays() {
      return requesterPays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (requesterPays_ != false) {
        output.writeBool(1, requesterPays_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (requesterPays_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, requesterPays_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Billing)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Billing other = (com.google.storage.v2.Bucket.Billing) obj;

      if (getRequesterPays() != other.getRequesterPays()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUESTER_PAYS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequesterPays());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Billing prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Billing properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Billing}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Billing)
        com.google.storage.v2.Bucket.BillingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Billing.class,
                com.google.storage.v2.Bucket.Billing.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Billing.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        requesterPays_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Billing.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing build() {
        com.google.storage.v2.Bucket.Billing result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing buildPartial() {
        com.google.storage.v2.Bucket.Billing result =
            new com.google.storage.v2.Bucket.Billing(this);
        result.requesterPays_ = requesterPays_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Billing) {
          return mergeFrom((com.google.storage.v2.Bucket.Billing) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Billing other) {
        if (other == com.google.storage.v2.Bucket.Billing.getDefaultInstance()) return this;
        if (other.getRequesterPays() != false) {
          setRequesterPays(other.getRequesterPays());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Billing parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Billing) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean requesterPays_;
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @return The requesterPays.
       */
      @java.lang.Override
      public boolean getRequesterPays() {
        return requesterPays_;
      }
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @param value The requesterPays to set.
       * @return This builder for chaining.
       */
      public Builder setRequesterPays(boolean value) {

        requesterPays_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequesterPays() {

        requesterPays_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Billing)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Billing)
    private static final com.google.storage.v2.Bucket.Billing DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Billing();
    }

    public static com.google.storage.v2.Bucket.Billing getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Billing> PARSER =
        new com.google.protobuf.AbstractParser<Billing>() {
          @java.lang.Override
          public Billing parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Billing(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Billing> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Billing> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CorsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Cors)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return A list containing the origin.
     */
    java.util.List<java.lang.String> getOriginList();
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return The count of origin.
     */
    int getOriginCount();
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    java.lang.String getOrigin(int index);
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    com.google.protobuf.ByteString getOriginBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return A list containing the method.
     */
    java.util.List<java.lang.String> getMethodList();
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return The count of method.
     */
    int getMethodCount();
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    java.lang.String getMethod(int index);
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    com.google.protobuf.ByteString getMethodBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return A list containing the responseHeader.
     */
    java.util.List<java.lang.String> getResponseHeaderList();
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return The count of responseHeader.
     */
    int getResponseHeaderCount();
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    java.lang.String getResponseHeader(int index);
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    com.google.protobuf.ByteString getResponseHeaderBytes(int index);

    /**
     *
     *
     * <pre>
     * The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4;</code>
     *
     * @return The maxAgeSeconds.
     */
    int getMaxAgeSeconds();
  }
  /**
   *
   *
   * <pre>
   * Cross-Origin Response sharing (CORS) properties for a bucket.
   * For more on Cloud Storage and CORS, see
   * https://cloud.google.com/storage/docs/cross-origin.
   * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Cors}
   */
  public static final class Cors extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Cors)
      CorsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Cors.newBuilder() to construct.
    private Cors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Cors() {
      origin_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      responseHeader_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Cors();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Cors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  origin_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                origin_.add(s);
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  method_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000002;
                }
                method_.add(s);
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                  responseHeader_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000004;
                }
                responseHeader_.add(s);
                break;
              }
            case 32:
              {
                maxAgeSeconds_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          origin_ = origin_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          method_ = method_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          responseHeader_ = responseHeader_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Cors.class,
              com.google.storage.v2.Bucket.Cors.Builder.class);
    }

    public static final int ORIGIN_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList origin_;
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return A list containing the origin.
     */
    public com.google.protobuf.ProtocolStringList getOriginList() {
      return origin_;
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @return The count of origin.
     */
    public int getOriginCount() {
      return origin_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    public java.lang.String getOrigin(int index) {
      return origin_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of Origins eligible to receive CORS response headers. See
     * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    public com.google.protobuf.ByteString getOriginBytes(int index) {
      return origin_.getByteString(index);
    }

    public static final int METHOD_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList method_;
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return A list containing the method.
     */
    public com.google.protobuf.ProtocolStringList getMethodList() {
      return method_;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @return The count of method.
     */
    public int getMethodCount() {
      return method_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    public java.lang.String getMethod(int index) {
      return method_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP methods on which to include CORS response headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    public com.google.protobuf.ByteString getMethodBytes(int index) {
      return method_.getByteString(index);
    }

    public static final int RESPONSE_HEADER_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList responseHeader_;
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return A list containing the responseHeader.
     */
    public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
      return responseHeader_;
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @return The count of responseHeader.
     */
    public int getResponseHeaderCount() {
      return responseHeader_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    public java.lang.String getResponseHeader(int index) {
      return responseHeader_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
      return responseHeader_.getByteString(index);
    }

    public static final int MAX_AGE_SECONDS_FIELD_NUMBER = 4;
    private int maxAgeSeconds_;
    /**
     *
     *
     * <pre>
     * The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4;</code>
     *
     * @return The maxAgeSeconds.
     */
    @java.lang.Override
    public int getMaxAgeSeconds() {
      return maxAgeSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < origin_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, origin_.getRaw(i));
      }
      for (int i = 0; i < method_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, method_.getRaw(i));
      }
      for (int i = 0; i < responseHeader_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, responseHeader_.getRaw(i));
      }
      if (maxAgeSeconds_ != 0) {
        output.writeInt32(4, maxAgeSeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < origin_.size(); i++) {
          dataSize += computeStringSizeNoTag(origin_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getOriginList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < method_.size(); i++) {
          dataSize += computeStringSizeNoTag(method_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMethodList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < responseHeader_.size(); i++) {
          dataSize += computeStringSizeNoTag(responseHeader_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResponseHeaderList().size();
      }
      if (maxAgeSeconds_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxAgeSeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Cors)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Cors other = (com.google.storage.v2.Bucket.Cors) obj;

      if (!getOriginList().equals(other.getOriginList())) return false;
      if (!getMethodList().equals(other.getMethodList())) return false;
      if (!getResponseHeaderList().equals(other.getResponseHeaderList())) return false;
      if (getMaxAgeSeconds() != other.getMaxAgeSeconds()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getOriginCount() > 0) {
        hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
        hash = (53 * hash) + getOriginList().hashCode();
      }
      if (getMethodCount() > 0) {
        hash = (37 * hash) + METHOD_FIELD_NUMBER;
        hash = (53 * hash) + getMethodList().hashCode();
      }
      if (getResponseHeaderCount() > 0) {
        hash = (37 * hash) + RESPONSE_HEADER_FIELD_NUMBER;
        hash = (53 * hash) + getResponseHeaderList().hashCode();
      }
      hash = (37 * hash) + MAX_AGE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAgeSeconds();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Cors prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Cross-Origin Response sharing (CORS) properties for a bucket.
     * For more on Cloud Storage and CORS, see
     * https://cloud.google.com/storage/docs/cross-origin.
     * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Cors}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Cors)
        com.google.storage.v2.Bucket.CorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Cors.class,
                com.google.storage.v2.Bucket.Cors.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Cors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        origin_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        responseHeader_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        maxAgeSeconds_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Cors.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors build() {
        com.google.storage.v2.Bucket.Cors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors buildPartial() {
        com.google.storage.v2.Bucket.Cors result = new com.google.storage.v2.Bucket.Cors(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          origin_ = origin_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.origin_ = origin_;
        if (((bitField0_ & 0x00000002) != 0)) {
          method_ = method_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.method_ = method_;
        if (((bitField0_ & 0x00000004) != 0)) {
          responseHeader_ = responseHeader_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.responseHeader_ = responseHeader_;
        result.maxAgeSeconds_ = maxAgeSeconds_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Cors) {
          return mergeFrom((com.google.storage.v2.Bucket.Cors) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Cors other) {
        if (other == com.google.storage.v2.Bucket.Cors.getDefaultInstance()) return this;
        if (!other.origin_.isEmpty()) {
          if (origin_.isEmpty()) {
            origin_ = other.origin_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureOriginIsMutable();
            origin_.addAll(other.origin_);
          }
          onChanged();
        }
        if (!other.method_.isEmpty()) {
          if (method_.isEmpty()) {
            method_ = other.method_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMethodIsMutable();
            method_.addAll(other.method_);
          }
          onChanged();
        }
        if (!other.responseHeader_.isEmpty()) {
          if (responseHeader_.isEmpty()) {
            responseHeader_ = other.responseHeader_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureResponseHeaderIsMutable();
            responseHeader_.addAll(other.responseHeader_);
          }
          onChanged();
        }
        if (other.getMaxAgeSeconds() != 0) {
          setMaxAgeSeconds(other.getMaxAgeSeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Cors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Cors) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList origin_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureOriginIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          origin_ = new com.google.protobuf.LazyStringArrayList(origin_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return A list containing the origin.
       */
      public com.google.protobuf.ProtocolStringList getOriginList() {
        return origin_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return The count of origin.
       */
      public int getOriginCount() {
        return origin_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The origin at the given index.
       */
      public java.lang.String getOrigin(int index) {
        return origin_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the origin at the given index.
       */
      public com.google.protobuf.ByteString getOriginBytes(int index) {
        return origin_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The origin to set.
       * @return This builder for chaining.
       */
      public Builder setOrigin(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param value The origin to add.
       * @return This builder for chaining.
       */
      public Builder addOrigin(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param values The origin to add.
       * @return This builder for chaining.
       */
      public Builder addAllOrigin(java.lang.Iterable<java.lang.String> values) {
        ensureOriginIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, origin_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrigin() {
        origin_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of Origins eligible to receive CORS response headers. See
       * [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1;</code>
       *
       * @param value The bytes of the origin to add.
       * @return This builder for chaining.
       */
      public Builder addOriginBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureOriginIsMutable();
        origin_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList method_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureMethodIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          method_ = new com.google.protobuf.LazyStringArrayList(method_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return A list containing the method.
       */
      public com.google.protobuf.ProtocolStringList getMethodList() {
        return method_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return The count of method.
       */
      public int getMethodCount() {
        return method_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The method at the given index.
       */
      public java.lang.String getMethod(int index) {
        return method_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the method at the given index.
       */
      public com.google.protobuf.ByteString getMethodBytes(int index) {
        return method_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The method to set.
       * @return This builder for chaining.
       */
      public Builder setMethod(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param value The method to add.
       * @return This builder for chaining.
       */
      public Builder addMethod(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param values The method to add.
       * @return This builder for chaining.
       */
      public Builder addAllMethod(java.lang.Iterable<java.lang.String> values) {
        ensureMethodIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, method_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMethod() {
        method_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP methods on which to include CORS response headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2;</code>
       *
       * @param value The bytes of the method to add.
       * @return This builder for chaining.
       */
      public Builder addMethodBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMethodIsMutable();
        method_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList responseHeader_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureResponseHeaderIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          responseHeader_ = new com.google.protobuf.LazyStringArrayList(responseHeader_);
          bitField0_ |= 0x00000004;
        }
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return A list containing the responseHeader.
       */
      public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
        return responseHeader_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return The count of responseHeader.
       */
      public int getResponseHeaderCount() {
        return responseHeader_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The responseHeader at the given index.
       */
      public java.lang.String getResponseHeader(int index) {
        return responseHeader_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the responseHeader at the given index.
       */
      public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
        return responseHeader_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The responseHeader to set.
       * @return This builder for chaining.
       */
      public Builder setResponseHeader(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param value The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeader(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param values The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addAllResponseHeader(java.lang.Iterable<java.lang.String> values) {
        ensureResponseHeaderIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseHeader_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResponseHeader() {
        responseHeader_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3;</code>
       *
       * @param value The bytes of the responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeaderBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        onChanged();
        return this;
      }

      private int maxAgeSeconds_;
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @return The maxAgeSeconds.
       */
      @java.lang.Override
      public int getMaxAgeSeconds() {
        return maxAgeSeconds_;
      }
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @param value The maxAgeSeconds to set.
       * @return This builder for chaining.
       */
      public Builder setMaxAgeSeconds(int value) {

        maxAgeSeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxAgeSeconds() {

        maxAgeSeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Cors)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Cors)
    private static final com.google.storage.v2.Bucket.Cors DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Cors();
    }

    public static com.google.storage.v2.Bucket.Cors getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Cors> PARSER =
        new com.google.protobuf.AbstractParser<Cors>() {
          @java.lang.Override
          public Cors parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Cors(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Cors> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Cors> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A Cloud KMS key that will be used to encrypt objects inserted into this
     * bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The defaultKmsKey.
     */
    java.lang.String getDefaultKmsKey();
    /**
     *
     *
     * <pre>
     * A Cloud KMS key that will be used to encrypt objects inserted into this
     * bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for defaultKmsKey.
     */
    com.google.protobuf.ByteString getDefaultKmsKeyBytes();
  }
  /**
   *
   *
   * <pre>
   * Encryption properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Encryption}
   */
  public static final class Encryption extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption)
      EncryptionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Encryption.newBuilder() to construct.
    private Encryption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Encryption() {
      defaultKmsKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Encryption();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Encryption(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                defaultKmsKey_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Encryption.class,
              com.google.storage.v2.Bucket.Encryption.Builder.class);
    }

    public static final int DEFAULT_KMS_KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object defaultKmsKey_;
    /**
     *
     *
     * <pre>
     * A Cloud KMS key that will be used to encrypt objects inserted into this
     * bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The defaultKmsKey.
     */
    @java.lang.Override
    public java.lang.String getDefaultKmsKey() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultKmsKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A Cloud KMS key that will be used to encrypt objects inserted into this
     * bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for defaultKmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultKmsKey_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultKmsKey_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Encryption)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Encryption other = (com.google.storage.v2.Bucket.Encryption) obj;

      if (!getDefaultKmsKey().equals(other.getDefaultKmsKey())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEFAULT_KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultKmsKey().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Encryption prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Encryption properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Encryption}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption)
        com.google.storage.v2.Bucket.EncryptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.class,
                com.google.storage.v2.Bucket.Encryption.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Encryption.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        defaultKmsKey_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Encryption.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption build() {
        com.google.storage.v2.Bucket.Encryption result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption buildPartial() {
        com.google.storage.v2.Bucket.Encryption result =
            new com.google.storage.v2.Bucket.Encryption(this);
        result.defaultKmsKey_ = defaultKmsKey_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Encryption) {
          return mergeFrom((com.google.storage.v2.Bucket.Encryption) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Encryption other) {
        if (other == com.google.storage.v2.Bucket.Encryption.getDefaultInstance()) return this;
        if (!other.getDefaultKmsKey().isEmpty()) {
          defaultKmsKey_ = other.defaultKmsKey_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Encryption parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Encryption) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object defaultKmsKey_ = "";
      /**
       *
       *
       * <pre>
       * A Cloud KMS key that will be used to encrypt objects inserted into this
       * bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The defaultKmsKey.
       */
      public java.lang.String getDefaultKmsKey() {
        java.lang.Object ref = defaultKmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultKmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud KMS key that will be used to encrypt objects inserted into this
       * bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for defaultKmsKey.
       */
      public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
        java.lang.Object ref = defaultKmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultKmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud KMS key that will be used to encrypt objects inserted into this
       * bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        defaultKmsKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud KMS key that will be used to encrypt objects inserted into this
       * bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultKmsKey() {

        defaultKmsKey_ = getDefaultInstance().getDefaultKmsKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud KMS key that will be used to encrypt objects inserted into this
       * bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>string default_kms_key = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        defaultKmsKey_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption)
    private static final com.google.storage.v2.Bucket.Encryption DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Encryption();
    }

    public static com.google.storage.v2.Bucket.Encryption getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Encryption> PARSER =
        new com.google.protobuf.AbstractParser<Encryption>() {
          @java.lang.Override
          public Encryption parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Encryption(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Encryption> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Encryption> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IamConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    boolean hasUniformBucketLevelAccess();
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess getUniformBucketLevelAccess();
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for publicAccessPrevention.
     */
    int getPublicAccessPreventionValue();
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
     * </code>
     *
     * @return The publicAccessPrevention.
     */
    com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention getPublicAccessPrevention();
  }
  /**
   *
   *
   * <pre>
   * Bucket restriction options.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
   */
  public static final class IamConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig)
      IamConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IamConfig.newBuilder() to construct.
    private IamConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IamConfig() {
      publicAccessPrevention_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IamConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IamConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder subBuilder =
                    null;
                if (uniformBucketLevelAccess_ != null) {
                  subBuilder = uniformBucketLevelAccess_.toBuilder();
                }
                uniformBucketLevelAccess_ =
                    input.readMessage(
                        com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(uniformBucketLevelAccess_);
                  uniformBucketLevelAccess_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                int rawValue = input.readEnum();

                publicAccessPrevention_ = rawValue;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.IamConfig.class,
              com.google.storage.v2.Bucket.IamConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Public Access Prevention config values.
     * </pre>
     *
     * Protobuf enum {@code google.storage.v2.Bucket.IamConfig.PublicAccessPrevention}
     */
    public enum PublicAccessPrevention implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No specified PublicAccessPrevention.
       * </pre>
       *
       * <code>PUBLIC_ACCESS_PREVENTION_UNSPECIFIED = 0;</code>
       */
      PUBLIC_ACCESS_PREVENTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Prevents access from being granted to public members 'allUsers' and
       * 'allAuthenticatedUsers'. Prevents attempts to grant new access to
       * public members.
       * </pre>
       *
       * <code>ENFORCED = 1;</code>
       */
      ENFORCED(1),
      /**
       *
       *
       * <pre>
       * This setting is inherited from Org Policy. Does not prevent access from
       * being granted to public members 'allUsers' or 'allAuthenticatedUsers'.
       * </pre>
       *
       * <code>INHERITED = 2;</code>
       */
      INHERITED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No specified PublicAccessPrevention.
       * </pre>
       *
       * <code>PUBLIC_ACCESS_PREVENTION_UNSPECIFIED = 0;</code>
       */
      public static final int PUBLIC_ACCESS_PREVENTION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Prevents access from being granted to public members 'allUsers' and
       * 'allAuthenticatedUsers'. Prevents attempts to grant new access to
       * public members.
       * </pre>
       *
       * <code>ENFORCED = 1;</code>
       */
      public static final int ENFORCED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * This setting is inherited from Org Policy. Does not prevent access from
       * being granted to public members 'allUsers' or 'allAuthenticatedUsers'.
       * </pre>
       *
       * <code>INHERITED = 2;</code>
       */
      public static final int INHERITED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PublicAccessPrevention valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PublicAccessPrevention forNumber(int value) {
        switch (value) {
          case 0:
            return PUBLIC_ACCESS_PREVENTION_UNSPECIFIED;
          case 1:
            return ENFORCED;
          case 2:
            return INHERITED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PublicAccessPrevention>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<PublicAccessPrevention>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<PublicAccessPrevention>() {
                public PublicAccessPrevention findValueByNumber(int number) {
                  return PublicAccessPrevention.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storage.v2.Bucket.IamConfig.getDescriptor().getEnumTypes().get(0);
      }

      private static final PublicAccessPrevention[] VALUES = values();

      public static PublicAccessPrevention valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PublicAccessPrevention(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storage.v2.Bucket.IamConfig.PublicAccessPrevention)
    }

    public interface UniformBucketLevelAccessOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * If set, access checks only use bucket-level IAM policies or above.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      boolean getEnabled();

      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return Whether the lockTime field is set.
       */
      boolean hasLockTime();
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return The lockTime.
       */
      com.google.protobuf.Timestamp getLockTime();
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Uniform Bucket level access.
     * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
     */
    public static final class UniformBucketLevelAccess
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        UniformBucketLevelAccessOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use UniformBucketLevelAccess.newBuilder() to construct.
      private UniformBucketLevelAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private UniformBucketLevelAccess() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new UniformBucketLevelAccess();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private UniformBucketLevelAccess(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  break;
                }
              case 18:
                {
                  com.google.protobuf.Timestamp.Builder subBuilder = null;
                  if (lockTime_ != null) {
                    subBuilder = lockTime_.toBuilder();
                  }
                  lockTime_ =
                      input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(lockTime_);
                    lockTime_ = subBuilder.buildPartial();
                  }

                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
      }

      public static final int ENABLED_FIELD_NUMBER = 1;
      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * If set, access checks only use bucket-level IAM policies or above.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      public static final int LOCK_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp lockTime_;
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return Whether the lockTime field is set.
       */
      @java.lang.Override
      public boolean hasLockTime() {
        return lockTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       *
       * @return The lockTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getLockTime() {
        return lockTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lockTime_;
      }
      /**
       *
       *
       * <pre>
       * The deadline time for changing
       * `iamConfig.uniformBucketLevelAccess.enabled` from
       * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
       * Mutable until the specified deadline is reached, but not afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
        return getLockTime();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (enabled_ != false) {
          output.writeBool(1, enabled_);
        }
        if (lockTime_ != null) {
          output.writeMessage(2, getLockTime());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (enabled_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
        }
        if (lockTime_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLockTime());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other =
            (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) obj;

        if (getEnabled() != other.getEnabled()) return false;
        if (hasLockTime() != other.hasLockTime()) return false;
        if (hasLockTime()) {
          if (!getLockTime().equals(other.getLockTime())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ENABLED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
        if (hasLockTime()) {
          hash = (37 * hash) + LOCK_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getLockTime().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Settings for Uniform Bucket level access.
       * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          enabled_ = false;

          if (lockTimeBuilder_ == null) {
            lockTime_ = null;
          } else {
            lockTime_ = null;
            lockTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess build() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess buildPartial() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result =
              new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess(this);
          result.enabled_ = enabled_;
          if (lockTimeBuilder_ == null) {
            result.lockTime_ = lockTime_;
          } else {
            result.lockTime_ = lockTimeBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other) {
          if (other
              == com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
                  .getDefaultInstance()) return this;
          if (other.getEnabled() != false) {
            setEnabled(other.getEnabled());
          }
          if (other.hasLockTime()) {
            mergeLockTime(other.getLockTime());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage =
                (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
                    e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private boolean enabled_;
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @return The enabled.
         */
        @java.lang.Override
        public boolean getEnabled() {
          return enabled_;
        }
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @param value The enabled to set.
         * @return This builder for chaining.
         */
        public Builder setEnabled(boolean value) {

          enabled_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set, access checks only use bucket-level IAM policies or above.
         * </pre>
         *
         * <code>bool enabled = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEnabled() {

          enabled_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp lockTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            lockTimeBuilder_;
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         *
         * @return Whether the lockTime field is set.
         */
        public boolean hasLockTime() {
          return lockTimeBuilder_ != null || lockTime_ != null;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         *
         * @return The lockTime.
         */
        public com.google.protobuf.Timestamp getLockTime() {
          if (lockTimeBuilder_ == null) {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          } else {
            return lockTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            lockTime_ = value;
            onChanged();
          } else {
            lockTimeBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (lockTimeBuilder_ == null) {
            lockTime_ = builderForValue.build();
            onChanged();
          } else {
            lockTimeBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder mergeLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (lockTime_ != null) {
              lockTime_ =
                  com.google.protobuf.Timestamp.newBuilder(lockTime_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              lockTime_ = value;
            }
            onChanged();
          } else {
            lockTimeBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public Builder clearLockTime() {
          if (lockTimeBuilder_ == null) {
            lockTime_ = null;
            onChanged();
          } else {
            lockTime_ = null;
            lockTimeBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getLockTimeBuilder() {

          onChanged();
          return getLockTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
          if (lockTimeBuilder_ != null) {
            return lockTimeBuilder_.getMessageOrBuilder();
          } else {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * The deadline time for changing
         * `iamConfig.uniformBucketLevelAccess.enabled` from
         * true to false in [RFC 3339](https://tools.ietf.org/html/rfc3339).
         * Mutable until the specified deadline is reached, but not afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getLockTimeFieldBuilder() {
          if (lockTimeBuilder_ == null) {
            lockTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getLockTime(), getParentForChildren(), isClean());
            lockTime_ = null;
          }
          return lockTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      private static final com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess();
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<UniformBucketLevelAccess> PARSER =
          new com.google.protobuf.AbstractParser<UniformBucketLevelAccess>() {
            @java.lang.Override
            public UniformBucketLevelAccess parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new UniformBucketLevelAccess(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<UniformBucketLevelAccess> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UniformBucketLevelAccess> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER = 1;
    private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        uniformBucketLevelAccess_;
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    @java.lang.Override
    public boolean hasUniformBucketLevelAccess() {
      return uniformBucketLevelAccess_ != null;
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        getUniformBucketLevelAccess() {
      return uniformBucketLevelAccess_ == null
          ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
          : uniformBucketLevelAccess_;
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder() {
      return getUniformBucketLevelAccess();
    }

    public static final int PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER = 2;
    private int publicAccessPrevention_;
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for publicAccessPrevention.
     */
    @java.lang.Override
    public int getPublicAccessPreventionValue() {
      return publicAccessPrevention_;
    }
    /**
     *
     *
     * <pre>
     * Whether IAM will enforce public access prevention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
     * </code>
     *
     * @return The publicAccessPrevention.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
        getPublicAccessPrevention() {
      @SuppressWarnings("deprecation")
      com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention result =
          com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention.valueOf(
              publicAccessPrevention_);
      return result == null
          ? com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (uniformBucketLevelAccess_ != null) {
        output.writeMessage(1, getUniformBucketLevelAccess());
      }
      if (publicAccessPrevention_
          != com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
              .PUBLIC_ACCESS_PREVENTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, publicAccessPrevention_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (uniformBucketLevelAccess_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getUniformBucketLevelAccess());
      }
      if (publicAccessPrevention_
          != com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
              .PUBLIC_ACCESS_PREVENTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, publicAccessPrevention_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.IamConfig other = (com.google.storage.v2.Bucket.IamConfig) obj;

      if (hasUniformBucketLevelAccess() != other.hasUniformBucketLevelAccess()) return false;
      if (hasUniformBucketLevelAccess()) {
        if (!getUniformBucketLevelAccess().equals(other.getUniformBucketLevelAccess()))
          return false;
      }
      if (publicAccessPrevention_ != other.publicAccessPrevention_) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUniformBucketLevelAccess()) {
        hash = (37 * hash) + UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + getUniformBucketLevelAccess().hashCode();
      }
      hash = (37 * hash) + PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER;
      hash = (53 * hash) + publicAccessPrevention_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.IamConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Bucket restriction options.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig)
        com.google.storage.v2.Bucket.IamConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.class,
                com.google.storage.v2.Bucket.IamConfig.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.IamConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccess_ = null;
        } else {
          uniformBucketLevelAccess_ = null;
          uniformBucketLevelAccessBuilder_ = null;
        }
        publicAccessPrevention_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.IamConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig build() {
        com.google.storage.v2.Bucket.IamConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig buildPartial() {
        com.google.storage.v2.Bucket.IamConfig result =
            new com.google.storage.v2.Bucket.IamConfig(this);
        if (uniformBucketLevelAccessBuilder_ == null) {
          result.uniformBucketLevelAccess_ = uniformBucketLevelAccess_;
        } else {
          result.uniformBucketLevelAccess_ = uniformBucketLevelAccessBuilder_.build();
        }
        result.publicAccessPrevention_ = publicAccessPrevention_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.IamConfig) {
          return mergeFrom((com.google.storage.v2.Bucket.IamConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.IamConfig other) {
        if (other == com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()) return this;
        if (other.hasUniformBucketLevelAccess()) {
          mergeUniformBucketLevelAccess(other.getUniformBucketLevelAccess());
        }
        if (other.publicAccessPrevention_ != 0) {
          setPublicAccessPreventionValue(other.getPublicAccessPreventionValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.IamConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.IamConfig) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          uniformBucketLevelAccess_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          uniformBucketLevelAccessBuilder_;
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       *
       * @return Whether the uniformBucketLevelAccess field is set.
       */
      public boolean hasUniformBucketLevelAccess() {
        return uniformBucketLevelAccessBuilder_ != null || uniformBucketLevelAccess_ != null;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       *
       * @return The uniformBucketLevelAccess.
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getUniformBucketLevelAccess() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        } else {
          return uniformBucketLevelAccessBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          uniformBucketLevelAccess_ = value;
          onChanged();
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder builderForValue) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccess_ = builderForValue.build();
          onChanged();
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder mergeUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (uniformBucketLevelAccess_ != null) {
            uniformBucketLevelAccess_ =
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.newBuilder(
                        uniformBucketLevelAccess_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            uniformBucketLevelAccess_ = value;
          }
          onChanged();
        } else {
          uniformBucketLevelAccessBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public Builder clearUniformBucketLevelAccess() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccess_ = null;
          onChanged();
        } else {
          uniformBucketLevelAccess_ = null;
          uniformBucketLevelAccessBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder
          getUniformBucketLevelAccessBuilder() {

        onChanged();
        return getUniformBucketLevelAccessFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
          getUniformBucketLevelAccessOrBuilder() {
        if (uniformBucketLevelAccessBuilder_ != null) {
          return uniformBucketLevelAccessBuilder_.getMessageOrBuilder();
        } else {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        }
      }
      /**
       *
       *
       * <pre>
       * Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          getUniformBucketLevelAccessFieldBuilder() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>(
                  getUniformBucketLevelAccess(), getParentForChildren(), isClean());
          uniformBucketLevelAccess_ = null;
        }
        return uniformBucketLevelAccessBuilder_;
      }

      private int publicAccessPrevention_ = 0;
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for publicAccessPrevention.
       */
      @java.lang.Override
      public int getPublicAccessPreventionValue() {
        return publicAccessPrevention_;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPreventionValue(int value) {

        publicAccessPrevention_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
       * </code>
       *
       * @return The publicAccessPrevention.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention
          getPublicAccessPrevention() {
        @SuppressWarnings("deprecation")
        com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention result =
            com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention.valueOf(
                publicAccessPrevention_);
        return result == null
            ? com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
       * </code>
       *
       * @param value The publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPrevention(
          com.google.storage.v2.Bucket.IamConfig.PublicAccessPrevention value) {
        if (value == null) {
          throw new NullPointerException();
        }

        publicAccessPrevention_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether IAM will enforce public access prevention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.PublicAccessPrevention public_access_prevention = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicAccessPrevention() {

        publicAccessPrevention_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig)
    private static final com.google.storage.v2.Bucket.IamConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig();
    }

    public static com.google.storage.v2.Bucket.IamConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IamConfig> PARSER =
        new com.google.protobuf.AbstractParser<IamConfig>() {
          @java.lang.Override
          public IamConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IamConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IamConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IamConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LifecycleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index);
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    int getRuleCount();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList();
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Lifecycle properties of a bucket.
   * For more information, see https://cloud.google.com/storage/docs/lifecycle.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
   */
  public static final class Lifecycle extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle)
      LifecycleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Lifecycle.newBuilder() to construct.
    private Lifecycle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Lifecycle() {
      rule_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Lifecycle();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Lifecycle(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  rule_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Lifecycle.Rule>();
                  mutable_bitField0_ |= 0x00000001;
                }
                rule_.add(
                    input.readMessage(
                        com.google.storage.v2.Bucket.Lifecycle.Rule.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          rule_ = java.util.Collections.unmodifiableList(rule_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Lifecycle.class,
              com.google.storage.v2.Bucket.Lifecycle.Builder.class);
    }

    public interface RuleOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return Whether the action field is set.
       */
      boolean hasAction();
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return The action.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction();
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder();

      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return Whether the condition field is set.
       */
      boolean hasCondition();
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return The condition.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition();
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder getConditionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A lifecycle Rule, combining an action to take on an object and a
     * condition which will trigger that action.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
     */
    public static final class Rule extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule)
        RuleOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Rule.newBuilder() to construct.
      private Rule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Rule() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Rule();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      private Rule(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder subBuilder = null;
                  if (action_ != null) {
                    subBuilder = action_.toBuilder();
                  }
                  action_ =
                      input.readMessage(
                          com.google.storage.v2.Bucket.Lifecycle.Rule.Action.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(action_);
                    action_ = subBuilder.buildPartial();
                  }

                  break;
                }
              case 18:
                {
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder subBuilder = null;
                  if (condition_ != null) {
                    subBuilder = condition_.toBuilder();
                  }
                  condition_ =
                      input.readMessage(
                          com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.parser(),
                          extensionRegistry);
                  if (subBuilder != null) {
                    subBuilder.mergeFrom(condition_);
                    condition_ = subBuilder.buildPartial();
                  }

                  break;
                }
              default:
                {
                  if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
      }

      public interface ActionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete` and
         * `SetStorageClass` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The type.
         */
        java.lang.String getType();
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete` and
         * `SetStorageClass` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The bytes for type.
         */
        com.google.protobuf.ByteString getTypeBytes();

        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The storageClass.
         */
        java.lang.String getStorageClass();
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The bytes for storageClass.
         */
        com.google.protobuf.ByteString getStorageClassBytes();
      }
      /**
       *
       *
       * <pre>
       * An action to take on an object.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
       */
      public static final class Action extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          ActionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Action.newBuilder() to construct.
        private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Action() {
          type_ = "";
          storageClass_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Action();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Action(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    type_ = s;
                    break;
                  }
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();

                    storageClass_ = s;
                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
        }

        public static final int TYPE_FIELD_NUMBER = 1;
        private volatile java.lang.Object type_;
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete` and
         * `SetStorageClass` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The type.
         */
        @java.lang.Override
        public java.lang.String getType() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            type_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the action. Currently, only `Delete` and
         * `SetStorageClass` are supported.
         * </pre>
         *
         * <code>string type = 1;</code>
         *
         * @return The bytes for type.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTypeBytes() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            type_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int STORAGE_CLASS_FIELD_NUMBER = 2;
        private volatile java.lang.Object storageClass_;
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The storageClass.
         */
        @java.lang.Override
        public java.lang.String getStorageClass() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            storageClass_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Target storage class. Required iff the type of the action is
         * SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2;</code>
         *
         * @return The bytes for storageClass.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getStorageClassBytes() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            storageClass_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, storageClass_);
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, storageClass_);
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Action other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Action) obj;

          if (!getType().equals(other.getType())) return false;
          if (!getStorageClass().equals(other.getStorageClass())) return false;
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getType().hashCode();
          hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
          hash = (53 * hash) + getStorageClass().hashCode();
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * An action to take on an object.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Action.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            type_ = "";

            storageClass_ = "";

            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Action(this);
            result.type_ = type_;
            result.storageClass_ = storageClass_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Action) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Action other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance())
              return this;
            if (!other.getType().isEmpty()) {
              type_ = other.type_;
              onChanged();
            }
            if (!other.getStorageClass().isEmpty()) {
              storageClass_ = other.storageClass_;
              onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.storage.v2.Bucket.Lifecycle.Rule.Action) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private java.lang.Object type_ = "";
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete` and
           * `SetStorageClass` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return The type.
           */
          public java.lang.String getType() {
            java.lang.Object ref = type_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              type_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete` and
           * `SetStorageClass` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return The bytes for type.
           */
          public com.google.protobuf.ByteString getTypeBytes() {
            java.lang.Object ref = type_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              type_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete` and
           * `SetStorageClass` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            type_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete` and
           * `SetStorageClass` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {

            type_ = getDefaultInstance().getType();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Type of the action. Currently, only `Delete` and
           * `SetStorageClass` are supported.
           * </pre>
           *
           * <code>string type = 1;</code>
           *
           * @param value The bytes for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            type_ = value;
            onChanged();
            return this;
          }

          private java.lang.Object storageClass_ = "";
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return The storageClass.
           */
          public java.lang.String getStorageClass() {
            java.lang.Object ref = storageClass_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              storageClass_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return The bytes for storageClass.
           */
          public com.google.protobuf.ByteString getStorageClassBytes() {
            java.lang.Object ref = storageClass_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              storageClass_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @param value The storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }

            storageClass_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearStorageClass() {

            storageClass_ = getDefaultInstance().getStorageClass();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Target storage class. Required iff the type of the action is
           * SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2;</code>
           *
           * @param value The bytes for storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);

            storageClass_ = value;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Action DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Action();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Action> PARSER =
            new com.google.protobuf.AbstractParser<Action>() {
              @java.lang.Override
              public Action parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Action(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Action> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Action> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        boolean hasAgeDays();
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        int getAgeDays();

        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return Whether the createdBefore field is set.
         */
        boolean hasCreatedBefore();
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return The createdBefore.
         */
        com.google.type.Date getCreatedBefore();
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         */
        com.google.type.DateOrBuilder getCreatedBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        boolean hasIsLive();
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        boolean getIsLive();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        boolean hasNumNewerVersions();
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        int getNumNewerVersions();

        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return A list containing the matchesStorageClass.
         */
        java.util.List<java.lang.String> getMatchesStorageClassList();
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return The count of matchesStorageClass.
         */
        int getMatchesStorageClassCount();
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        java.lang.String getMatchesStorageClass(int index);
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        com.google.protobuf.ByteString getMatchesStorageClassBytes(int index);

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        boolean hasDaysSinceCustomTime();
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        int getDaysSinceCustomTime();

        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        boolean hasCustomTimeBefore();
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return The customTimeBefore.
         */
        com.google.type.Date getCustomTimeBefore();
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         */
        com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        boolean hasDaysSinceNoncurrentTime();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        int getDaysSinceNoncurrentTime();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        boolean hasNoncurrentTimeBefore();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return The noncurrentTimeBefore.
         */
        com.google.type.Date getNoncurrentTimeBefore();
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         */
        com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition of an object which triggers some action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
       */
      public static final class Condition extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          ConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Condition.newBuilder() to construct.
        private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Condition() {
          matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Condition();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
          return this.unknownFields;
        }

        private Condition(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    bitField0_ |= 0x00000001;
                    ageDays_ = input.readInt32();
                    break;
                  }
                case 18:
                  {
                    com.google.type.Date.Builder subBuilder = null;
                    if (createdBefore_ != null) {
                      subBuilder = createdBefore_.toBuilder();
                    }
                    createdBefore_ =
                        input.readMessage(com.google.type.Date.parser(), extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(createdBefore_);
                      createdBefore_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                case 24:
                  {
                    bitField0_ |= 0x00000002;
                    isLive_ = input.readBool();
                    break;
                  }
                case 32:
                  {
                    bitField0_ |= 0x00000004;
                    numNewerVersions_ = input.readInt32();
                    break;
                  }
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                      matchesStorageClass_ = new com.google.protobuf.LazyStringArrayList();
                      mutable_bitField0_ |= 0x00000008;
                    }
                    matchesStorageClass_.add(s);
                    break;
                  }
                case 56:
                  {
                    bitField0_ |= 0x00000008;
                    daysSinceCustomTime_ = input.readInt32();
                    break;
                  }
                case 66:
                  {
                    com.google.type.Date.Builder subBuilder = null;
                    if (customTimeBefore_ != null) {
                      subBuilder = customTimeBefore_.toBuilder();
                    }
                    customTimeBefore_ =
                        input.readMessage(com.google.type.Date.parser(), extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(customTimeBefore_);
                      customTimeBefore_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                case 72:
                  {
                    bitField0_ |= 0x00000010;
                    daysSinceNoncurrentTime_ = input.readInt32();
                    break;
                  }
                case 82:
                  {
                    com.google.type.Date.Builder subBuilder = null;
                    if (noncurrentTimeBefore_ != null) {
                      subBuilder = noncurrentTimeBefore_.toBuilder();
                    }
                    noncurrentTimeBefore_ =
                        input.readMessage(com.google.type.Date.parser(), extensionRegistry);
                    if (subBuilder != null) {
                      subBuilder.mergeFrom(noncurrentTimeBefore_);
                      noncurrentTimeBefore_ = subBuilder.buildPartial();
                    }

                    break;
                  }
                default:
                  {
                    if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                      done = true;
                    }
                    break;
                  }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(this);
          } finally {
            if (((mutable_bitField0_ & 0x00000008) != 0)) {
              matchesStorageClass_ = matchesStorageClass_.getUnmodifiableView();
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
        }

        private int bitField0_;
        public static final int AGE_DAYS_FIELD_NUMBER = 1;
        private int ageDays_;
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        @java.lang.Override
        public boolean hasAgeDays() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        @java.lang.Override
        public int getAgeDays() {
          return ageDays_;
        }

        public static final int CREATED_BEFORE_FIELD_NUMBER = 2;
        private com.google.type.Date createdBefore_;
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return Whether the createdBefore field is set.
         */
        @java.lang.Override
        public boolean hasCreatedBefore() {
          return createdBefore_ != null;
        }
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         *
         * @return The createdBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCreatedBefore() {
          return createdBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : createdBefore_;
        }
        /**
         *
         *
         * <pre>
         * This condition is satisfied when an object is created before midnight
         * of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
          return getCreatedBefore();
        }

        public static final int IS_LIVE_FIELD_NUMBER = 3;
        private boolean isLive_;
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        @java.lang.Override
        public boolean hasIsLive() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        @java.lang.Override
        public boolean getIsLive() {
          return isLive_;
        }

        public static final int NUM_NEWER_VERSIONS_FIELD_NUMBER = 4;
        private int numNewerVersions_;
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        @java.lang.Override
        public boolean hasNumNewerVersions() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        @java.lang.Override
        public int getNumNewerVersions() {
          return numNewerVersions_;
        }

        public static final int MATCHES_STORAGE_CLASS_FIELD_NUMBER = 5;
        private com.google.protobuf.LazyStringList matchesStorageClass_;
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return A list containing the matchesStorageClass.
         */
        public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
          return matchesStorageClass_;
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @return The count of matchesStorageClass.
         */
        public int getMatchesStorageClassCount() {
          return matchesStorageClass_.size();
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        public java.lang.String getMatchesStorageClass(int index) {
          return matchesStorageClass_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Objects having any of the storage classes specified by this condition
         * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
         * `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>repeated string matches_storage_class = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
          return matchesStorageClass_.getByteString(index);
        }

        public static final int DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER = 7;
        private int daysSinceCustomTime_;
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceCustomTime() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        @java.lang.Override
        public int getDaysSinceCustomTime() {
          return daysSinceCustomTime_;
        }

        public static final int CUSTOM_TIME_BEFORE_FIELD_NUMBER = 8;
        private com.google.type.Date customTimeBefore_;
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasCustomTimeBefore() {
          return customTimeBefore_ != null;
        }
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         *
         * @return The customTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCustomTimeBefore() {
          return customTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : customTimeBefore_;
        }
        /**
         *
         *
         * <pre>
         * An object matches this condition if the custom timestamp set on the
         * object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
          return getCustomTimeBefore();
        }

        public static final int DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER = 9;
        private int daysSinceNoncurrentTime_;
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceNoncurrentTime() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        @java.lang.Override
        public int getDaysSinceNoncurrentTime() {
          return daysSinceNoncurrentTime_;
        }

        public static final int NONCURRENT_TIME_BEFORE_FIELD_NUMBER = 10;
        private com.google.type.Date noncurrentTimeBefore_;
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasNoncurrentTimeBefore() {
          return noncurrentTimeBefore_ != null;
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         *
         * @return The noncurrentTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getNoncurrentTimeBefore() {
          return noncurrentTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : noncurrentTimeBefore_;
        }
        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if it became noncurrent before
         * the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date noncurrent_time_before = 10;</code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
          return getNoncurrentTimeBefore();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(1, ageDays_);
          }
          if (createdBefore_ != null) {
            output.writeMessage(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeBool(3, isLive_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeInt32(4, numNewerVersions_);
          }
          for (int i = 0; i < matchesStorageClass_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 5, matchesStorageClass_.getRaw(i));
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            output.writeInt32(7, daysSinceCustomTime_);
          }
          if (customTimeBefore_ != null) {
            output.writeMessage(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            output.writeInt32(9, daysSinceNoncurrentTime_);
          }
          if (noncurrentTimeBefore_ != null) {
            output.writeMessage(10, getNoncurrentTimeBefore());
          }
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, ageDays_);
          }
          if (createdBefore_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isLive_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, numNewerVersions_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesStorageClass_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesStorageClass_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesStorageClassList().size();
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, daysSinceCustomTime_);
          }
          if (customTimeBefore_ != null) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeInt32Size(9, daysSinceNoncurrentTime_);
          }
          if (noncurrentTimeBefore_ != null) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    10, getNoncurrentTimeBefore());
          }
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) obj;

          if (hasAgeDays() != other.hasAgeDays()) return false;
          if (hasAgeDays()) {
            if (getAgeDays() != other.getAgeDays()) return false;
          }
          if (hasCreatedBefore() != other.hasCreatedBefore()) return false;
          if (hasCreatedBefore()) {
            if (!getCreatedBefore().equals(other.getCreatedBefore())) return false;
          }
          if (hasIsLive() != other.hasIsLive()) return false;
          if (hasIsLive()) {
            if (getIsLive() != other.getIsLive()) return false;
          }
          if (hasNumNewerVersions() != other.hasNumNewerVersions()) return false;
          if (hasNumNewerVersions()) {
            if (getNumNewerVersions() != other.getNumNewerVersions()) return false;
          }
          if (!getMatchesStorageClassList().equals(other.getMatchesStorageClassList()))
            return false;
          if (hasDaysSinceCustomTime() != other.hasDaysSinceCustomTime()) return false;
          if (hasDaysSinceCustomTime()) {
            if (getDaysSinceCustomTime() != other.getDaysSinceCustomTime()) return false;
          }
          if (hasCustomTimeBefore() != other.hasCustomTimeBefore()) return false;
          if (hasCustomTimeBefore()) {
            if (!getCustomTimeBefore().equals(other.getCustomTimeBefore())) return false;
          }
          if (hasDaysSinceNoncurrentTime() != other.hasDaysSinceNoncurrentTime()) return false;
          if (hasDaysSinceNoncurrentTime()) {
            if (getDaysSinceNoncurrentTime() != other.getDaysSinceNoncurrentTime()) return false;
          }
          if (hasNoncurrentTimeBefore() != other.hasNoncurrentTimeBefore()) return false;
          if (hasNoncurrentTimeBefore()) {
            if (!getNoncurrentTimeBefore().equals(other.getNoncurrentTimeBefore())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasAgeDays()) {
            hash = (37 * hash) + AGE_DAYS_FIELD_NUMBER;
            hash = (53 * hash) + getAgeDays();
          }
          if (hasCreatedBefore()) {
            hash = (37 * hash) + CREATED_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCreatedBefore().hashCode();
          }
          if (hasIsLive()) {
            hash = (37 * hash) + IS_LIVE_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLive());
          }
          if (hasNumNewerVersions()) {
            hash = (37 * hash) + NUM_NEWER_VERSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getNumNewerVersions();
          }
          if (getMatchesStorageClassCount() > 0) {
            hash = (37 * hash) + MATCHES_STORAGE_CLASS_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesStorageClassList().hashCode();
          }
          if (hasDaysSinceCustomTime()) {
            hash = (37 * hash) + DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceCustomTime();
          }
          if (hasCustomTimeBefore()) {
            hash = (37 * hash) + CUSTOM_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCustomTimeBefore().hashCode();
          }
          if (hasDaysSinceNoncurrentTime()) {
            hash = (37 * hash) + DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceNoncurrentTime();
          }
          if (hasNoncurrentTimeBefore()) {
            hash = (37 * hash) + NONCURRENT_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getNoncurrentTimeBefore().hashCode();
          }
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A condition of an object which triggers some action.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            ageDays_ = 0;
            bitField0_ = (bitField0_ & ~0x00000001);
            if (createdBeforeBuilder_ == null) {
              createdBefore_ = null;
            } else {
              createdBefore_ = null;
              createdBeforeBuilder_ = null;
            }
            isLive_ = false;
            bitField0_ = (bitField0_ & ~0x00000002);
            numNewerVersions_ = 0;
            bitField0_ = (bitField0_ & ~0x00000004);
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000008);
            daysSinceCustomTime_ = 0;
            bitField0_ = (bitField0_ & ~0x00000010);
            if (customTimeBeforeBuilder_ == null) {
              customTimeBefore_ = null;
            } else {
              customTimeBefore_ = null;
              customTimeBeforeBuilder_ = null;
            }
            daysSinceNoncurrentTime_ = 0;
            bitField0_ = (bitField0_ & ~0x00000020);
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBefore_ = null;
            } else {
              noncurrentTimeBefore_ = null;
              noncurrentTimeBeforeBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.ageDays_ = ageDays_;
              to_bitField0_ |= 0x00000001;
            }
            if (createdBeforeBuilder_ == null) {
              result.createdBefore_ = createdBefore_;
            } else {
              result.createdBefore_ = createdBeforeBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.isLive_ = isLive_;
              to_bitField0_ |= 0x00000002;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.numNewerVersions_ = numNewerVersions_;
              to_bitField0_ |= 0x00000004;
            }
            if (((bitField0_ & 0x00000008) != 0)) {
              matchesStorageClass_ = matchesStorageClass_.getUnmodifiableView();
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.matchesStorageClass_ = matchesStorageClass_;
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.daysSinceCustomTime_ = daysSinceCustomTime_;
              to_bitField0_ |= 0x00000008;
            }
            if (customTimeBeforeBuilder_ == null) {
              result.customTimeBefore_ = customTimeBefore_;
            } else {
              result.customTimeBefore_ = customTimeBeforeBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.daysSinceNoncurrentTime_ = daysSinceNoncurrentTime_;
              to_bitField0_ |= 0x00000010;
            }
            if (noncurrentTimeBeforeBuilder_ == null) {
              result.noncurrentTimeBefore_ = noncurrentTimeBefore_;
            } else {
              result.noncurrentTimeBefore_ = noncurrentTimeBeforeBuilder_.build();
            }
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance())
              return this;
            if (other.hasAgeDays()) {
              setAgeDays(other.getAgeDays());
            }
            if (other.hasCreatedBefore()) {
              mergeCreatedBefore(other.getCreatedBefore());
            }
            if (other.hasIsLive()) {
              setIsLive(other.getIsLive());
            }
            if (other.hasNumNewerVersions()) {
              setNumNewerVersions(other.getNumNewerVersions());
            }
            if (!other.matchesStorageClass_.isEmpty()) {
              if (matchesStorageClass_.isEmpty()) {
                matchesStorageClass_ = other.matchesStorageClass_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureMatchesStorageClassIsMutable();
                matchesStorageClass_.addAll(other.matchesStorageClass_);
              }
              onChanged();
            }
            if (other.hasDaysSinceCustomTime()) {
              setDaysSinceCustomTime(other.getDaysSinceCustomTime());
            }
            if (other.hasCustomTimeBefore()) {
              mergeCustomTimeBefore(other.getCustomTimeBefore());
            }
            if (other.hasDaysSinceNoncurrentTime()) {
              setDaysSinceNoncurrentTime(other.getDaysSinceNoncurrentTime());
            }
            if (other.hasNoncurrentTimeBefore()) {
              mergeNoncurrentTimeBefore(other.getNoncurrentTimeBefore());
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage =
                  (com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }

          private int bitField0_;

          private int ageDays_;
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return Whether the ageDays field is set.
           */
          @java.lang.Override
          public boolean hasAgeDays() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return The ageDays.
           */
          @java.lang.Override
          public int getAgeDays() {
            return ageDays_;
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @param value The ageDays to set.
           * @return This builder for chaining.
           */
          public Builder setAgeDays(int value) {
            bitField0_ |= 0x00000001;
            ageDays_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAgeDays() {
            bitField0_ = (bitField0_ & ~0x00000001);
            ageDays_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date createdBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              createdBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           *
           * @return Whether the createdBefore field is set.
           */
          public boolean hasCreatedBefore() {
            return createdBeforeBuilder_ != null || createdBefore_ != null;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           *
           * @return The createdBefore.
           */
          public com.google.type.Date getCreatedBefore() {
            if (createdBeforeBuilder_ == null) {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            } else {
              return createdBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder setCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              createdBefore_ = value;
              onChanged();
            } else {
              createdBeforeBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder setCreatedBefore(com.google.type.Date.Builder builderForValue) {
            if (createdBeforeBuilder_ == null) {
              createdBefore_ = builderForValue.build();
              onChanged();
            } else {
              createdBeforeBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder mergeCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (createdBefore_ != null) {
                createdBefore_ =
                    com.google.type.Date.newBuilder(createdBefore_).mergeFrom(value).buildPartial();
              } else {
                createdBefore_ = value;
              }
              onChanged();
            } else {
              createdBeforeBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public Builder clearCreatedBefore() {
            if (createdBeforeBuilder_ == null) {
              createdBefore_ = null;
              onChanged();
            } else {
              createdBefore_ = null;
              createdBeforeBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public com.google.type.Date.Builder getCreatedBeforeBuilder() {

            onChanged();
            return getCreatedBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
            if (createdBeforeBuilder_ != null) {
              return createdBeforeBuilder_.getMessageOrBuilder();
            } else {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is satisfied when an object is created before midnight
           * of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCreatedBeforeFieldBuilder() {
            if (createdBeforeBuilder_ == null) {
              createdBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCreatedBefore(), getParentForChildren(), isClean());
              createdBefore_ = null;
            }
            return createdBeforeBuilder_;
          }

          private boolean isLive_;
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return Whether the isLive field is set.
           */
          @java.lang.Override
          public boolean hasIsLive() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return The isLive.
           */
          @java.lang.Override
          public boolean getIsLive() {
            return isLive_;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @param value The isLive to set.
           * @return This builder for chaining.
           */
          public Builder setIsLive(boolean value) {
            bitField0_ |= 0x00000002;
            isLive_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearIsLive() {
            bitField0_ = (bitField0_ & ~0x00000002);
            isLive_ = false;
            onChanged();
            return this;
          }

          private int numNewerVersions_;
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return Whether the numNewerVersions field is set.
           */
          @java.lang.Override
          public boolean hasNumNewerVersions() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return The numNewerVersions.
           */
          @java.lang.Override
          public int getNumNewerVersions() {
            return numNewerVersions_;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @param value The numNewerVersions to set.
           * @return This builder for chaining.
           */
          public Builder setNumNewerVersions(int value) {
            bitField0_ |= 0x00000004;
            numNewerVersions_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearNumNewerVersions() {
            bitField0_ = (bitField0_ & ~0x00000004);
            numNewerVersions_ = 0;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringList matchesStorageClass_ =
              com.google.protobuf.LazyStringArrayList.EMPTY;

          private void ensureMatchesStorageClassIsMutable() {
            if (!((bitField0_ & 0x00000008) != 0)) {
              matchesStorageClass_ =
                  new com.google.protobuf.LazyStringArrayList(matchesStorageClass_);
              bitField0_ |= 0x00000008;
            }
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return A list containing the matchesStorageClass.
           */
          public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
            return matchesStorageClass_.getUnmodifiableView();
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return The count of matchesStorageClass.
           */
          public int getMatchesStorageClassCount() {
            return matchesStorageClass_.size();
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index of the element to return.
           * @return The matchesStorageClass at the given index.
           */
          public java.lang.String getMatchesStorageClass(int index) {
            return matchesStorageClass_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesStorageClass at the given index.
           */
          public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
            return matchesStorageClass_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param index The index to set the value at.
           * @param value The matchesStorageClass to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesStorageClass(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.set(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param value The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param values The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesStorageClass(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesStorageClassIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesStorageClass_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesStorageClass() {
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.EMPTY;
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Objects having any of the storage classes specified by this condition
           * will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
           * `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>repeated string matches_storage_class = 5;</code>
           *
           * @param value The bytes of the matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            onChanged();
            return this;
          }

          private int daysSinceCustomTime_;
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return Whether the daysSinceCustomTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceCustomTime() {
            return ((bitField0_ & 0x00000010) != 0);
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return The daysSinceCustomTime.
           */
          @java.lang.Override
          public int getDaysSinceCustomTime() {
            return daysSinceCustomTime_;
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @param value The daysSinceCustomTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceCustomTime(int value) {
            bitField0_ |= 0x00000010;
            daysSinceCustomTime_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceCustomTime() {
            bitField0_ = (bitField0_ & ~0x00000010);
            daysSinceCustomTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date customTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              customTimeBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           *
           * @return Whether the customTimeBefore field is set.
           */
          public boolean hasCustomTimeBefore() {
            return customTimeBeforeBuilder_ != null || customTimeBefore_ != null;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           *
           * @return The customTimeBefore.
           */
          public com.google.type.Date getCustomTimeBefore() {
            if (customTimeBeforeBuilder_ == null) {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            } else {
              return customTimeBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              customTimeBefore_ = value;
              onChanged();
            } else {
              customTimeBeforeBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBefore_ = builderForValue.build();
              onChanged();
            } else {
              customTimeBeforeBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder mergeCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (customTimeBefore_ != null) {
                customTimeBefore_ =
                    com.google.type.Date.newBuilder(customTimeBefore_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                customTimeBefore_ = value;
              }
              onChanged();
            } else {
              customTimeBeforeBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public Builder clearCustomTimeBefore() {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBefore_ = null;
              onChanged();
            } else {
              customTimeBefore_ = null;
              customTimeBeforeBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public com.google.type.Date.Builder getCustomTimeBeforeBuilder() {

            onChanged();
            return getCustomTimeBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
            if (customTimeBeforeBuilder_ != null) {
              return customTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * An object matches this condition if the custom timestamp set on the
           * object is before the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date custom_time_before = 8;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCustomTimeBeforeFieldBuilder() {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCustomTimeBefore(), getParentForChildren(), isClean());
              customTimeBefore_ = null;
            }
            return customTimeBeforeBuilder_;
          }

          private int daysSinceNoncurrentTime_;
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return Whether the daysSinceNoncurrentTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceNoncurrentTime() {
            return ((bitField0_ & 0x00000020) != 0);
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return The daysSinceNoncurrentTime.
           */
          @java.lang.Override
          public int getDaysSinceNoncurrentTime() {
            return daysSinceNoncurrentTime_;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @param value The daysSinceNoncurrentTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceNoncurrentTime(int value) {
            bitField0_ |= 0x00000020;
            daysSinceNoncurrentTime_ = value;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceNoncurrentTime() {
            bitField0_ = (bitField0_ & ~0x00000020);
            daysSinceNoncurrentTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date noncurrentTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              noncurrentTimeBeforeBuilder_;
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           *
           * @return Whether the noncurrentTimeBefore field is set.
           */
          public boolean hasNoncurrentTimeBefore() {
            return noncurrentTimeBeforeBuilder_ != null || noncurrentTimeBefore_ != null;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           *
           * @return The noncurrentTimeBefore.
           */
          public com.google.type.Date getNoncurrentTimeBefore() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            } else {
              return noncurrentTimeBeforeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              noncurrentTimeBefore_ = value;
              onChanged();
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBefore_ = builderForValue.build();
              onChanged();
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(builderForValue.build());
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder mergeNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (noncurrentTimeBefore_ != null) {
                noncurrentTimeBefore_ =
                    com.google.type.Date.newBuilder(noncurrentTimeBefore_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                noncurrentTimeBefore_ = value;
              }
              onChanged();
            } else {
              noncurrentTimeBeforeBuilder_.mergeFrom(value);
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public Builder clearNoncurrentTimeBefore() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBefore_ = null;
              onChanged();
            } else {
              noncurrentTimeBefore_ = null;
              noncurrentTimeBeforeBuilder_ = null;
            }

            return this;
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public com.google.type.Date.Builder getNoncurrentTimeBeforeBuilder() {

            onChanged();
            return getNoncurrentTimeBeforeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
            if (noncurrentTimeBeforeBuilder_ != null) {
              return noncurrentTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            }
          }
          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if it became noncurrent before
           * the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date noncurrent_time_before = 10;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getNoncurrentTimeBeforeFieldBuilder() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getNoncurrentTimeBefore(), getParentForChildren(), isClean());
              noncurrentTimeBefore_ = null;
            }
            return noncurrentTimeBeforeBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Condition DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Condition> PARSER =
            new com.google.protobuf.AbstractParser<Condition>() {
              @java.lang.Override
              public Condition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                return new Condition(input, extensionRegistry);
              }
            };

        public static com.google.protobuf.Parser<Condition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Condition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int ACTION_FIELD_NUMBER = 1;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return Whether the action field is set.
       */
      @java.lang.Override
      public boolean hasAction() {
        return action_ != null;
      }
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       *
       * @return The action.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
        return action_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
            : action_;
      }
      /**
       *
       *
       * <pre>
       * The action to take.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
        return getAction();
      }

      public static final int CONDITION_FIELD_NUMBER = 2;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return Whether the condition field is set.
       */
      @java.lang.Override
      public boolean hasCondition() {
        return condition_ != null;
      }
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
        return condition_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
            : condition_;
      }
      /**
       *
       *
       * <pre>
       * The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
          getConditionOrBuilder() {
        return getCondition();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (action_ != null) {
          output.writeMessage(1, getAction());
        }
        if (condition_ != null) {
          output.writeMessage(2, getCondition());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (action_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAction());
        }
        if (condition_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCondition());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Lifecycle.Rule other =
            (com.google.storage.v2.Bucket.Lifecycle.Rule) obj;

        if (hasAction() != other.hasAction()) return false;
        if (hasAction()) {
          if (!getAction().equals(other.getAction())) return false;
        }
        if (hasCondition() != other.hasCondition()) return false;
        if (hasCondition()) {
          if (!getCondition().equals(other.getCondition())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasAction()) {
          hash = (37 * hash) + ACTION_FIELD_NUMBER;
          hash = (53 * hash) + getAction().hashCode();
        }
        if (hasCondition()) {
          hash = (37 * hash) + CONDITION_FIELD_NUMBER;
          hash = (53 * hash) + getCondition().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle Rule, combining an action to take on an object and a
       * condition which will trigger that action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule)
          com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
        }

        // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (actionBuilder_ == null) {
            action_ = null;
          } else {
            action_ = null;
            actionBuilder_ = null;
          }
          if (conditionBuilder_ == null) {
            condition_ = null;
          } else {
            condition_ = null;
            conditionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule build() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule buildPartial() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result =
              new com.google.storage.v2.Bucket.Lifecycle.Rule(this);
          if (actionBuilder_ == null) {
            result.action_ = action_;
          } else {
            result.action_ = actionBuilder_.build();
          }
          if (conditionBuilder_ == null) {
            result.condition_ = condition_;
          } else {
            result.condition_ = conditionBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule) {
            return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule other) {
          if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance())
            return this;
          if (other.hasAction()) {
            mergeAction(other.getAction());
          }
          if (other.hasCondition()) {
            mergeCondition(other.getCondition());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.storage.v2.Bucket.Lifecycle.Rule parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.storage.v2.Bucket.Lifecycle.Rule) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            actionBuilder_;
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         *
         * @return Whether the action field is set.
         */
        public boolean hasAction() {
          return actionBuilder_ != null || action_ != null;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         *
         * @return The action.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
          if (actionBuilder_ == null) {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          } else {
            return actionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder setAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            action_ = value;
            onChanged();
          } else {
            actionBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder setAction(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder builderForValue) {
          if (actionBuilder_ == null) {
            action_ = builderForValue.build();
            onChanged();
          } else {
            actionBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder mergeAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (action_ != null) {
              action_ =
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.newBuilder(action_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              action_ = value;
            }
            onChanged();
          } else {
            actionBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public Builder clearAction() {
          if (actionBuilder_ == null) {
            action_ = null;
            onChanged();
          } else {
            action_ = null;
            actionBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder getActionBuilder() {

          onChanged();
          return getActionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
          if (actionBuilder_ != null) {
            return actionBuilder_.getMessageOrBuilder();
          } else {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          }
        }
        /**
         *
         *
         * <pre>
         * The action to take.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            getActionFieldBuilder() {
          if (actionBuilder_ == null) {
            actionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>(
                    getAction(), getParentForChildren(), isClean());
            action_ = null;
          }
          return actionBuilder_;
        }

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            conditionBuilder_;
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         *
         * @return Whether the condition field is set.
         */
        public boolean hasCondition() {
          return conditionBuilder_ != null || condition_ != null;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         *
         * @return The condition.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
          if (conditionBuilder_ == null) {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          } else {
            return conditionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder setCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            condition_ = value;
            onChanged();
          } else {
            conditionBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder setCondition(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder builderForValue) {
          if (conditionBuilder_ == null) {
            condition_ = builderForValue.build();
            onChanged();
          } else {
            conditionBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder mergeCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (condition_ != null) {
              condition_ =
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.newBuilder(condition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              condition_ = value;
            }
            onChanged();
          } else {
            conditionBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public Builder clearCondition() {
          if (conditionBuilder_ == null) {
            condition_ = null;
            onChanged();
          } else {
            condition_ = null;
            conditionBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder getConditionBuilder() {

          onChanged();
          return getConditionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
            getConditionOrBuilder() {
          if (conditionBuilder_ != null) {
            return conditionBuilder_.getMessageOrBuilder();
          } else {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          }
        }
        /**
         *
         *
         * <pre>
         * The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            getConditionFieldBuilder() {
          if (conditionBuilder_ == null) {
            conditionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>(
                    getCondition(), getParentForChildren(), isClean());
            condition_ = null;
          }
          return conditionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      private static final com.google.storage.v2.Bucket.Lifecycle.Rule DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule();
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Rule> PARSER =
          new com.google.protobuf.AbstractParser<Rule>() {
            @java.lang.Override
            public Rule parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              return new Rule(input, extensionRegistry);
            }
          };

      public static com.google.protobuf.Parser<Rule> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Rule> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int RULE_FIELD_NUMBER = 1;
    private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_;
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
      return rule_;
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList() {
      return rule_;
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public int getRuleCount() {
      return rule_.size();
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
      return rule_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A lifecycle management rule, which is made of an action to take and the
     * condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
      return rule_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < rule_.size(); i++) {
        output.writeMessage(1, rule_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < rule_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, rule_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Lifecycle other = (com.google.storage.v2.Bucket.Lifecycle) obj;

      if (!getRuleList().equals(other.getRuleList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRuleCount() > 0) {
        hash = (37 * hash) + RULE_FIELD_NUMBER;
        hash = (53 * hash) + getRuleList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Lifecycle properties of a bucket.
     * For more information, see https://cloud.google.com/storage/docs/lifecycle.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle)
        com.google.storage.v2.Bucket.LifecycleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.class,
                com.google.storage.v2.Bucket.Lifecycle.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Lifecycle.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRuleFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ruleBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle build() {
        com.google.storage.v2.Bucket.Lifecycle result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle buildPartial() {
        com.google.storage.v2.Bucket.Lifecycle result =
            new com.google.storage.v2.Bucket.Lifecycle(this);
        int from_bitField0_ = bitField0_;
        if (ruleBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            rule_ = java.util.Collections.unmodifiableList(rule_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.rule_ = rule_;
        } else {
          result.rule_ = ruleBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Lifecycle) {
          return mergeFrom((com.google.storage.v2.Bucket.Lifecycle) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle other) {
        if (other == com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()) return this;
        if (ruleBuilder_ == null) {
          if (!other.rule_.isEmpty()) {
            if (rule_.isEmpty()) {
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRuleIsMutable();
              rule_.addAll(other.rule_);
            }
            onChanged();
          }
        } else {
          if (!other.rule_.isEmpty()) {
            if (ruleBuilder_.isEmpty()) {
              ruleBuilder_.dispose();
              ruleBuilder_ = null;
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
              ruleBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRuleFieldBuilder()
                      : null;
            } else {
              ruleBuilder_.addAllMessages(other.rule_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Lifecycle parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Lifecycle) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_ =
          java.util.Collections.emptyList();

      private void ensureRuleIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          rule_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Lifecycle.Rule>(rule_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          ruleBuilder_;

      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
        if (ruleBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rule_);
        } else {
          return ruleBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public int getRuleCount() {
        if (ruleBuilder_ == null) {
          return rule_.size();
        } else {
          return ruleBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder setRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.set(index, value);
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder setRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.set(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(index, value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder addAllRule(
          java.lang.Iterable<? extends com.google.storage.v2.Bucket.Lifecycle.Rule> values) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rule_);
          onChanged();
        } else {
          ruleBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder clearRule() {
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          ruleBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public Builder removeRule(int index) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.remove(index);
          onChanged();
        } else {
          ruleBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder getRuleBuilder(int index) {
        return getRuleFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleOrBuilderList() {
        if (ruleBuilder_ != null) {
          return ruleBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rule_);
        }
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder() {
        return getRuleFieldBuilder()
            .addBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder(int index) {
        return getRuleFieldBuilder()
            .addBuilder(index, com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A lifecycle management rule, which is made of an action to take and the
       * condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1;</code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule.Builder>
          getRuleBuilderList() {
        return getRuleFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleFieldBuilder() {
        if (ruleBuilder_ == null) {
          ruleBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storage.v2.Bucket.Lifecycle.Rule,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
                  com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>(
                  rule_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          rule_ = null;
        }
        return ruleBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle)
    private static final com.google.storage.v2.Bucket.Lifecycle DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle();
    }

    public static com.google.storage.v2.Bucket.Lifecycle getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Lifecycle> PARSER =
        new com.google.protobuf.AbstractParser<Lifecycle>() {
          @java.lang.Override
          public Lifecycle parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Lifecycle(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Lifecycle> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Lifecycle> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoggingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Logging)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed.
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The logBucket.
     */
    java.lang.String getLogBucket();
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed.
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The bytes for logBucket.
     */
    com.google.protobuf.ByteString getLogBucketBytes();

    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The logObjectPrefix.
     */
    java.lang.String getLogObjectPrefix();
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    com.google.protobuf.ByteString getLogObjectPrefixBytes();
  }
  /**
   *
   *
   * <pre>
   * Logging-related properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Logging}
   */
  public static final class Logging extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Logging)
      LoggingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Logging.newBuilder() to construct.
    private Logging(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Logging() {
      logBucket_ = "";
      logObjectPrefix_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Logging();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Logging(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                logBucket_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                logObjectPrefix_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Logging.class,
              com.google.storage.v2.Bucket.Logging.Builder.class);
    }

    public static final int LOG_BUCKET_FIELD_NUMBER = 1;
    private volatile java.lang.Object logBucket_;
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed.
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The logBucket.
     */
    @java.lang.Override
    public java.lang.String getLogBucket() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logBucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The destination bucket where the current bucket's logs should be placed.
     * </pre>
     *
     * <code>string log_bucket = 1;</code>
     *
     * @return The bytes for logBucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogBucketBytes() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_OBJECT_PREFIX_FIELD_NUMBER = 2;
    private volatile java.lang.Object logObjectPrefix_;
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The logObjectPrefix.
     */
    @java.lang.Override
    public java.lang.String getLogObjectPrefix() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logObjectPrefix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2;</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logObjectPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, logObjectPrefix_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, logObjectPrefix_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Logging)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Logging other = (com.google.storage.v2.Bucket.Logging) obj;

      if (!getLogBucket().equals(other.getLogBucket())) return false;
      if (!getLogObjectPrefix().equals(other.getLogObjectPrefix())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOG_BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getLogBucket().hashCode();
      hash = (37 * hash) + LOG_OBJECT_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getLogObjectPrefix().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Logging prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Logging-related properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Logging}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Logging)
        com.google.storage.v2.Bucket.LoggingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Logging.class,
                com.google.storage.v2.Bucket.Logging.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Logging.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        logBucket_ = "";

        logObjectPrefix_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Logging.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging build() {
        com.google.storage.v2.Bucket.Logging result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging buildPartial() {
        com.google.storage.v2.Bucket.Logging result =
            new com.google.storage.v2.Bucket.Logging(this);
        result.logBucket_ = logBucket_;
        result.logObjectPrefix_ = logObjectPrefix_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Logging) {
          return mergeFrom((com.google.storage.v2.Bucket.Logging) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Logging other) {
        if (other == com.google.storage.v2.Bucket.Logging.getDefaultInstance()) return this;
        if (!other.getLogBucket().isEmpty()) {
          logBucket_ = other.logBucket_;
          onChanged();
        }
        if (!other.getLogObjectPrefix().isEmpty()) {
          logObjectPrefix_ = other.logObjectPrefix_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Logging parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Logging) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object logBucket_ = "";
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed.
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return The logBucket.
       */
      public java.lang.String getLogBucket() {
        java.lang.Object ref = logBucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logBucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed.
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return The bytes for logBucket.
       */
      public com.google.protobuf.ByteString getLogBucketBytes() {
        java.lang.Object ref = logBucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logBucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed.
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @param value The logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        logBucket_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed.
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogBucket() {

        logBucket_ = getDefaultInstance().getLogBucket();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The destination bucket where the current bucket's logs should be placed.
       * </pre>
       *
       * <code>string log_bucket = 1;</code>
       *
       * @param value The bytes for logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        logBucket_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object logObjectPrefix_ = "";
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return The logObjectPrefix.
       */
      public java.lang.String getLogObjectPrefix() {
        java.lang.Object ref = logObjectPrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logObjectPrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return The bytes for logObjectPrefix.
       */
      public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
        java.lang.Object ref = logObjectPrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logObjectPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @param value The logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        logObjectPrefix_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogObjectPrefix() {

        logObjectPrefix_ = getDefaultInstance().getLogObjectPrefix();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2;</code>
       *
       * @param value The bytes for logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        logObjectPrefix_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Logging)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Logging)
    private static final com.google.storage.v2.Bucket.Logging DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Logging();
    }

    public static com.google.storage.v2.Bucket.Logging getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Logging> PARSER =
        new com.google.protobuf.AbstractParser<Logging>() {
          @java.lang.Override
          public Logging parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Logging(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Logging> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Logging> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RetentionPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.RetentionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    boolean hasEffectiveTime();
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return The effectiveTime.
     */
    com.google.protobuf.Timestamp getEffectiveTime();
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2;</code>
     *
     * @return The isLocked.
     */
    boolean getIsLocked();

    /**
     *
     *
     * <pre>
     * The duration in seconds that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes.
     * </pre>
     *
     * <code>int64 retention_period = 3;</code>
     *
     * @return The retentionPeriod.
     */
    long getRetentionPeriod();
  }
  /**
   *
   *
   * <pre>
   * Retention policy properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
   */
  public static final class RetentionPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.RetentionPolicy)
      RetentionPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RetentionPolicy.newBuilder() to construct.
    private RetentionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RetentionPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RetentionPolicy();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RetentionPolicy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (effectiveTime_ != null) {
                  subBuilder = effectiveTime_.toBuilder();
                }
                effectiveTime_ =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(effectiveTime_);
                  effectiveTime_ = subBuilder.buildPartial();
                }

                break;
              }
            case 16:
              {
                isLocked_ = input.readBool();
                break;
              }
            case 24:
              {
                retentionPeriod_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.RetentionPolicy.class,
              com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
    }

    public static final int EFFECTIVE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp effectiveTime_;
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveTime() {
      return effectiveTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return The effectiveTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEffectiveTime() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }
    /**
     *
     *
     * <pre>
     * Server-determined value that indicates the time from which policy was
     * enforced and effective. This value is in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      return getEffectiveTime();
    }

    public static final int IS_LOCKED_FIELD_NUMBER = 2;
    private boolean isLocked_;
    /**
     *
     *
     * <pre>
     * Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2;</code>
     *
     * @return The isLocked.
     */
    @java.lang.Override
    public boolean getIsLocked() {
      return isLocked_;
    }

    public static final int RETENTION_PERIOD_FIELD_NUMBER = 3;
    private long retentionPeriod_;
    /**
     *
     *
     * <pre>
     * The duration in seconds that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes.
     * </pre>
     *
     * <code>int64 retention_period = 3;</code>
     *
     * @return The retentionPeriod.
     */
    @java.lang.Override
    public long getRetentionPeriod() {
      return retentionPeriod_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (effectiveTime_ != null) {
        output.writeMessage(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        output.writeBool(2, isLocked_);
      }
      if (retentionPeriod_ != 0L) {
        output.writeInt64(3, retentionPeriod_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (effectiveTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isLocked_);
      }
      if (retentionPeriod_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, retentionPeriod_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.RetentionPolicy)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.RetentionPolicy other =
          (com.google.storage.v2.Bucket.RetentionPolicy) obj;

      if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
      if (hasEffectiveTime()) {
        if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
      }
      if (getIsLocked() != other.getIsLocked()) return false;
      if (getRetentionPeriod() != other.getRetentionPeriod()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEffectiveTime()) {
        hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEffectiveTime().hashCode();
      }
      hash = (37 * hash) + IS_LOCKED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLocked());
      hash = (37 * hash) + RETENTION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRetentionPeriod());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.RetentionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Retention policy properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.RetentionPolicy)
        com.google.storage.v2.Bucket.RetentionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.RetentionPolicy.class,
                com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.RetentionPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = null;
        } else {
          effectiveTime_ = null;
          effectiveTimeBuilder_ = null;
        }
        isLocked_ = false;

        retentionPeriod_ = 0L;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy build() {
        com.google.storage.v2.Bucket.RetentionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy buildPartial() {
        com.google.storage.v2.Bucket.RetentionPolicy result =
            new com.google.storage.v2.Bucket.RetentionPolicy(this);
        if (effectiveTimeBuilder_ == null) {
          result.effectiveTime_ = effectiveTime_;
        } else {
          result.effectiveTime_ = effectiveTimeBuilder_.build();
        }
        result.isLocked_ = isLocked_;
        result.retentionPeriod_ = retentionPeriod_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.RetentionPolicy) {
          return mergeFrom((com.google.storage.v2.Bucket.RetentionPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.RetentionPolicy other) {
        if (other == com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()) return this;
        if (other.hasEffectiveTime()) {
          mergeEffectiveTime(other.getEffectiveTime());
        }
        if (other.getIsLocked() != false) {
          setIsLocked(other.getIsLocked());
        }
        if (other.getRetentionPeriod() != 0L) {
          setRetentionPeriod(other.getRetentionPeriod());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.RetentionPolicy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.RetentionPolicy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.Timestamp effectiveTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          effectiveTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      public boolean hasEffectiveTime() {
        return effectiveTimeBuilder_ != null || effectiveTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       *
       * @return The effectiveTime.
       */
      public com.google.protobuf.Timestamp getEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        } else {
          return effectiveTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          effectiveTime_ = value;
          onChanged();
        } else {
          effectiveTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = builderForValue.build();
          onChanged();
        } else {
          effectiveTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (effectiveTime_ != null) {
            effectiveTime_ =
                com.google.protobuf.Timestamp.newBuilder(effectiveTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            effectiveTime_ = value;
          }
          onChanged();
        } else {
          effectiveTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public Builder clearEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = null;
          onChanged();
        } else {
          effectiveTime_ = null;
          effectiveTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {

        onChanged();
        return getEffectiveTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        if (effectiveTimeBuilder_ != null) {
          return effectiveTimeBuilder_.getMessageOrBuilder();
        } else {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Server-determined value that indicates the time from which policy was
       * enforced and effective. This value is in
       * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp effective_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEffectiveTimeFieldBuilder() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEffectiveTime(), getParentForChildren(), isClean());
          effectiveTime_ = null;
        }
        return effectiveTimeBuilder_;
      }

      private boolean isLocked_;
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @return The isLocked.
       */
      @java.lang.Override
      public boolean getIsLocked() {
        return isLocked_;
      }
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @param value The isLocked to set.
       * @return This builder for chaining.
       */
      public Builder setIsLocked(boolean value) {

        isLocked_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsLocked() {

        isLocked_ = false;
        onChanged();
        return this;
      }

      private long retentionPeriod_;
      /**
       *
       *
       * <pre>
       * The duration in seconds that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes.
       * </pre>
       *
       * <code>int64 retention_period = 3;</code>
       *
       * @return The retentionPeriod.
       */
      @java.lang.Override
      public long getRetentionPeriod() {
        return retentionPeriod_;
      }
      /**
       *
       *
       * <pre>
       * The duration in seconds that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes.
       * </pre>
       *
       * <code>int64 retention_period = 3;</code>
       *
       * @param value The retentionPeriod to set.
       * @return This builder for chaining.
       */
      public Builder setRetentionPeriod(long value) {

        retentionPeriod_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration in seconds that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes.
       * </pre>
       *
       * <code>int64 retention_period = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRetentionPeriod() {

        retentionPeriod_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.RetentionPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.RetentionPolicy)
    private static final com.google.storage.v2.Bucket.RetentionPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.RetentionPolicy();
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RetentionPolicy> PARSER =
        new com.google.protobuf.AbstractParser<RetentionPolicy>() {
          @java.lang.Override
          public RetentionPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RetentionPolicy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RetentionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RetentionPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VersioningOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Versioning)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Properties of a bucket related to versioning.
   * For more on Cloud Storage versioning, see
   * https://cloud.google.com/storage/docs/object-versioning.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Versioning}
   */
  public static final class Versioning extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Versioning)
      VersioningOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Versioning.newBuilder() to construct.
    private Versioning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Versioning() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Versioning();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Versioning(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enabled_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Versioning.class,
              com.google.storage.v2.Bucket.Versioning.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Versioning)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Versioning other = (com.google.storage.v2.Bucket.Versioning) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Versioning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Properties of a bucket related to versioning.
     * For more on Cloud Storage versioning, see
     * https://cloud.google.com/storage/docs/object-versioning.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Versioning}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Versioning)
        com.google.storage.v2.Bucket.VersioningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Versioning.class,
                com.google.storage.v2.Bucket.Versioning.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Versioning.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        enabled_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Versioning.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning build() {
        com.google.storage.v2.Bucket.Versioning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning buildPartial() {
        com.google.storage.v2.Bucket.Versioning result =
            new com.google.storage.v2.Bucket.Versioning(this);
        result.enabled_ = enabled_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Versioning) {
          return mergeFrom((com.google.storage.v2.Bucket.Versioning) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Versioning other) {
        if (other == com.google.storage.v2.Bucket.Versioning.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Versioning parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Versioning) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {

        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Versioning)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Versioning)
    private static final com.google.storage.v2.Bucket.Versioning DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Versioning();
    }

    public static com.google.storage.v2.Bucket.Versioning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Versioning> PARSER =
        new com.google.protobuf.AbstractParser<Versioning>() {
          @java.lang.Override
          public Versioning parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Versioning(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Versioning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Versioning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebsiteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Website)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The mainPageSuffix.
     */
    java.lang.String getMainPageSuffix();
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    com.google.protobuf.ByteString getMainPageSuffixBytes();

    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The notFoundPage.
     */
    java.lang.String getNotFoundPage();
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The bytes for notFoundPage.
     */
    com.google.protobuf.ByteString getNotFoundPageBytes();
  }
  /**
   *
   *
   * <pre>
   * Properties of a bucket related to accessing the contents as a static
   * website. For more on hosting a static website via Cloud Storage, see
   * https://cloud.google.com/storage/docs/hosting-static-website.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Website}
   */
  public static final class Website extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Website)
      WebsiteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Website.newBuilder() to construct.
    private Website(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Website() {
      mainPageSuffix_ = "";
      notFoundPage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Website();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Website(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                mainPageSuffix_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                notFoundPage_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Website.class,
              com.google.storage.v2.Bucket.Website.Builder.class);
    }

    public static final int MAIN_PAGE_SUFFIX_FIELD_NUMBER = 1;
    private volatile java.lang.Object mainPageSuffix_;
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The mainPageSuffix.
     */
    @java.lang.Override
    public java.lang.String getMainPageSuffix() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainPageSuffix_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, the service will ensure the path
     * has a trailing '/', append this suffix, and attempt to retrieve the
     * resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1;</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainPageSuffixBytes() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainPageSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NOT_FOUND_PAGE_FIELD_NUMBER = 2;
    private volatile java.lang.Object notFoundPage_;
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The notFoundPage.
     */
    @java.lang.Override
    public java.lang.String getNotFoundPage() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notFoundPage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2;</code>
     *
     * @return The bytes for notFoundPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNotFoundPageBytes() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notFoundPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, notFoundPage_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, notFoundPage_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Website)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Website other = (com.google.storage.v2.Bucket.Website) obj;

      if (!getMainPageSuffix().equals(other.getMainPageSuffix())) return false;
      if (!getNotFoundPage().equals(other.getNotFoundPage())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAIN_PAGE_SUFFIX_FIELD_NUMBER;
      hash = (53 * hash) + getMainPageSuffix().hashCode();
      hash = (37 * hash) + NOT_FOUND_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getNotFoundPage().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Website prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Properties of a bucket related to accessing the contents as a static
     * website. For more on hosting a static website via Cloud Storage, see
     * https://cloud.google.com/storage/docs/hosting-static-website.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Website}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Website)
        com.google.storage.v2.Bucket.WebsiteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Website.class,
                com.google.storage.v2.Bucket.Website.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Website.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        mainPageSuffix_ = "";

        notFoundPage_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Website.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website build() {
        com.google.storage.v2.Bucket.Website result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website buildPartial() {
        com.google.storage.v2.Bucket.Website result =
            new com.google.storage.v2.Bucket.Website(this);
        result.mainPageSuffix_ = mainPageSuffix_;
        result.notFoundPage_ = notFoundPage_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Website) {
          return mergeFrom((com.google.storage.v2.Bucket.Website) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Website other) {
        if (other == com.google.storage.v2.Bucket.Website.getDefaultInstance()) return this;
        if (!other.getMainPageSuffix().isEmpty()) {
          mainPageSuffix_ = other.mainPageSuffix_;
          onChanged();
        }
        if (!other.getNotFoundPage().isEmpty()) {
          notFoundPage_ = other.notFoundPage_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.storage.v2.Bucket.Website parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.storage.v2.Bucket.Website) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object mainPageSuffix_ = "";
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return The mainPageSuffix.
       */
      public java.lang.String getMainPageSuffix() {
        java.lang.Object ref = mainPageSuffix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mainPageSuffix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return The bytes for mainPageSuffix.
       */
      public com.google.protobuf.ByteString getMainPageSuffixBytes() {
        java.lang.Object ref = mainPageSuffix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mainPageSuffix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @param value The mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        mainPageSuffix_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMainPageSuffix() {

        mainPageSuffix_ = getDefaultInstance().getMainPageSuffix();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, the service will ensure the path
       * has a trailing '/', append this suffix, and attempt to retrieve the
       * resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1;</code>
       *
       * @param value The bytes for mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        mainPageSuffix_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object notFoundPage_ = "";
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return The notFoundPage.
       */
      public java.lang.String getNotFoundPage() {
        java.lang.Object ref = notFoundPage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          notFoundPage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return The bytes for notFoundPage.
       */
      public com.google.protobuf.ByteString getNotFoundPageBytes() {
        java.lang.Object ref = notFoundPage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          notFoundPage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @param value The notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        notFoundPage_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNotFoundPage() {

        notFoundPage_ = getDefaultInstance().getNotFoundPage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2;</code>
       *
       * @param value The bytes for notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        notFoundPage_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Website)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Website)
    private static final com.google.storage.v2.Bucket.Website DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Website();
    }

    public static com.google.storage.v2.Bucket.Website getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Website> PARSER =
        new com.google.protobuf.AbstractParser<Website>() {
          @java.lang.Override
          public Website parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Website(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Website> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Website> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object bucketId_;
  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
   * `name` field. For globally unique buckets, this is equal to the "bucket
   * name" of other Cloud Storage APIs. Example: "pub".
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bucketId.
   */
  @java.lang.Override
  public java.lang.String getBucketId() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
   * `name` field. For globally unique buckets, this is equal to the "bucket
   * name" of other Cloud Storage APIs. Example: "pub".
   * </pre>
   *
   * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for bucketId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketIdBytes() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_FIELD_NUMBER = 3;
  private volatile java.lang.Object project_;
  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The project which owns this bucket.
   * </pre>
   *
   * <code>
   * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METAGENERATION_FIELD_NUMBER = 4;
  private long metageneration_;
  /**
   *
   *
   * <pre>
   * Output only. The metadata generation of this bucket.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metageneration.
   */
  @java.lang.Override
  public long getMetageneration() {
    return metageneration_;
  }

  public static final int LOCATION_FIELD_NUMBER = 5;
  private volatile java.lang.Object location_;
  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the bucket resides
   * in physical storage within this region.  Defaults to `US`. See the
   * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
   * guide] for the authoritative list. Attempting to update this field after
   * the bucket is created will result in an error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The location of the bucket. Object data for objects in the bucket resides
   * in physical storage within this region.  Defaults to `US`. See the
   * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
   * guide] for the authoritative list. Attempting to update this field after
   * the bucket is created will result in an error.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_TYPE_FIELD_NUMBER = 6;
  private volatile java.lang.Object locationType_;
  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The locationType.
   */
  @java.lang.Override
  public java.lang.String getLocationType() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for locationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationTypeBytes() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_CLASS_FIELD_NUMBER = 7;
  private volatile java.lang.Object storageClass_;
  /**
   *
   *
   * <pre>
   * The bucket's default storage class, used whenever no storageClass is
   * specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it will default
   * to `STANDARD`. For more information, see
   * https://developers.google.com/storage/docs/storage-classes.
   * </pre>
   *
   * <code>string storage_class = 7;</code>
   *
   * @return The storageClass.
   */
  @java.lang.Override
  public java.lang.String getStorageClass() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageClass_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The bucket's default storage class, used whenever no storageClass is
   * specified for a newly-created object. This defines how objects in the
   * bucket are stored and determines the SLA and the cost of storage.
   * If this value is not specified when the bucket is created, it will default
   * to `STANDARD`. For more information, see
   * https://developers.google.com/storage/docs/storage-classes.
   * </pre>
   *
   * <code>string storage_class = 7;</code>
   *
   * @return The bytes for storageClass.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageClassBytes() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageClass_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACL_FIELD_NUMBER = 8;
  private java.util.List<com.google.storage.v2.BucketAccessControl> acl_;
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.BucketAccessControl> getAclList() {
    return acl_;
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.BucketAccessControlOrBuilder>
      getAclOrBuilderList() {
    return acl_;
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public int getAclCount() {
    return acl_.size();
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketAccessControl getAcl(int index) {
    return acl_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Access controls on the bucket.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketAccessControlOrBuilder getAclOrBuilder(int index) {
    return acl_.get(index);
  }

  public static final int DEFAULT_OBJECT_ACL_FIELD_NUMBER = 9;
  private java.util.List<com.google.storage.v2.ObjectAccessControl> defaultObjectAcl_;
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.ObjectAccessControl> getDefaultObjectAclList() {
    return defaultObjectAcl_;
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
      getDefaultObjectAclOrBuilderList() {
    return defaultObjectAcl_;
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public int getDefaultObjectAclCount() {
    return defaultObjectAcl_.size();
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControl getDefaultObjectAcl(int index) {
    return defaultObjectAcl_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Default access controls to apply to new objects when no ACL is provided.
   * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
   * requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControlOrBuilder getDefaultObjectAclOrBuilder(
      int index) {
    return defaultObjectAcl_.get(index);
  }

  public static final int LIFECYCLE_FIELD_NUMBER = 10;
  private com.google.storage.v2.Bucket.Lifecycle lifecycle_;
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   *
   * @return Whether the lifecycle field is set.
   */
  @java.lang.Override
  public boolean hasLifecycle() {
    return lifecycle_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   *
   * @return The lifecycle.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Lifecycle getLifecycle() {
    return lifecycle_ == null
        ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
        : lifecycle_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's lifecycle config. See
   * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
   * for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.LifecycleOrBuilder getLifecycleOrBuilder() {
    return getLifecycle();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket in
   * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket in
   * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the bucket in
   * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int CORS_FIELD_NUMBER = 12;
  private java.util.List<com.google.storage.v2.Bucket.Cors> cors_;
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.Bucket.Cors> getCorsList() {
    return cors_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.Bucket.CorsOrBuilder>
      getCorsOrBuilderList() {
    return cors_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public int getCorsCount() {
    return cors_.size();
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Cors getCors(int index) {
    return cors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
   * (CORS) config.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.CorsOrBuilder getCorsOrBuilder(int index) {
    return cors_.get(index);
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The modification time of the bucket.
   * Attempting to set or update this field will result in a
   * [FieldViolation][google.rpc.BadRequest.FieldViolation].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int DEFAULT_EVENT_BASED_HOLD_FIELD_NUMBER = 14;
  private boolean defaultEventBasedHold_;
  /**
   *
   *
   * <pre>
   * The default value for event-based hold on newly created objects in this
   * bucket.  Event-based hold is a way to retain objects indefinitely until an
   * event occurs, signified by the
   * hold's release. After being released, such objects will be subject to
   * bucket-level retention (if any).  One sample use case of this flag is for
   * banks to hold loan documents for at least 3 years after loan is paid in
   * full. Here, bucket-level retention is 3 years and the event is loan being
   * paid in full. In this example, these objects will be held intact for any
   * number of years until the event has occurred (event-based hold on the
   * object is released) and then 3 more years after that. That means retention
   * duration of the objects begins from the moment event-based hold
   * transitioned from true to false.  Objects under event-based hold cannot be
   * deleted, overwritten or archived until the hold is removed.
   * </pre>
   *
   * <code>bool default_event_based_hold = 14;</code>
   *
   * @return The defaultEventBasedHold.
   */
  @java.lang.Override
  public boolean getDefaultEventBasedHold() {
    return defaultEventBasedHold_;
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-provided labels, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WEBSITE_FIELD_NUMBER = 16;
  private com.google.storage.v2.Bucket.Website website_;
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   *
   * @return Whether the website field is set.
   */
  @java.lang.Override
  public boolean hasWebsite() {
    return website_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   *
   * @return The website.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Website getWebsite() {
    return website_ == null ? com.google.storage.v2.Bucket.Website.getDefaultInstance() : website_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's website config, controlling how the service behaves
   * when accessing bucket contents as a web site. See the
   * [https://cloud.google.com/storage/docs/static-website][Static Website
   * Examples] for more information.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Website website = 16;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.WebsiteOrBuilder getWebsiteOrBuilder() {
    return getWebsite();
  }

  public static final int VERSIONING_FIELD_NUMBER = 17;
  private com.google.storage.v2.Bucket.Versioning versioning_;
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   *
   * @return Whether the versioning field is set.
   */
  @java.lang.Override
  public boolean hasVersioning() {
    return versioning_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   *
   * @return The versioning.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Versioning getVersioning() {
    return versioning_ == null
        ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
        : versioning_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's versioning config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.VersioningOrBuilder getVersioningOrBuilder() {
    return getVersioning();
  }

  public static final int LOGGING_FIELD_NUMBER = 18;
  private com.google.storage.v2.Bucket.Logging logging_;
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   *
   * @return Whether the logging field is set.
   */
  @java.lang.Override
  public boolean hasLogging() {
    return logging_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   *
   * @return The logging.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Logging getLogging() {
    return logging_ == null ? com.google.storage.v2.Bucket.Logging.getDefaultInstance() : logging_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's logging config, which defines the destination bucket
   * and name prefix (if any) for the current bucket's logs.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.LoggingOrBuilder getLoggingOrBuilder() {
    return getLogging();
  }

  public static final int OWNER_FIELD_NUMBER = 19;
  private com.google.storage.v2.Owner owner_;
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the owner field is set.
   */
  @java.lang.Override
  public boolean hasOwner() {
    return owner_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The owner.
   */
  @java.lang.Override
  public com.google.storage.v2.Owner getOwner() {
    return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The owner of the bucket. This is always the project team's owner group.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
    return getOwner();
  }

  public static final int ENCRYPTION_FIELD_NUMBER = 20;
  private com.google.storage.v2.Bucket.Encryption encryption_;
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   *
   * @return Whether the encryption field is set.
   */
  @java.lang.Override
  public boolean hasEncryption() {
    return encryption_ != null;
  }
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   *
   * @return The encryption.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Encryption getEncryption() {
    return encryption_ == null
        ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
        : encryption_;
  }
  /**
   *
   *
   * <pre>
   * Encryption config for a bucket.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.EncryptionOrBuilder getEncryptionOrBuilder() {
    return getEncryption();
  }

  public static final int BILLING_FIELD_NUMBER = 21;
  private com.google.storage.v2.Bucket.Billing billing_;
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   *
   * @return Whether the billing field is set.
   */
  @java.lang.Override
  public boolean hasBilling() {
    return billing_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   *
   * @return The billing.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.Billing getBilling() {
    return billing_ == null ? com.google.storage.v2.Bucket.Billing.getDefaultInstance() : billing_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's billing config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.BillingOrBuilder getBillingOrBuilder() {
    return getBilling();
  }

  public static final int RETENTION_POLICY_FIELD_NUMBER = 22;
  private com.google.storage.v2.Bucket.RetentionPolicy retentionPolicy_;
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   *
   * @return Whether the retentionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetentionPolicy() {
    return retentionPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   *
   * @return The retentionPolicy.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.RetentionPolicy getRetentionPolicy() {
    return retentionPolicy_ == null
        ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
        : retentionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's retention policy. The retention policy enforces a minimum
   * retention time for all objects contained in the bucket, based on their
   * creation time. Any attempt to overwrite or delete objects younger than the
   * retention period will result in a PERMISSION_DENIED error.  An unlocked
   * retention policy can be modified or removed from the bucket via a
   * storage.buckets.update operation. A locked retention policy cannot be
   * removed or shortened in duration for the lifetime of the bucket.
   * Attempting to remove or decrease period of a locked retention policy will
   * result in a PERMISSION_DENIED error.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.RetentionPolicyOrBuilder getRetentionPolicyOrBuilder() {
    return getRetentionPolicy();
  }

  public static final int IAM_CONFIG_FIELD_NUMBER = 23;
  private com.google.storage.v2.Bucket.IamConfig iamConfig_;
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   *
   * @return Whether the iamConfig field is set.
   */
  @java.lang.Override
  public boolean hasIamConfig() {
    return iamConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   *
   * @return The iamConfig.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.IamConfig getIamConfig() {
    return iamConfig_ == null
        ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
        : iamConfig_;
  }
  /**
   *
   *
   * <pre>
   * The bucket's IAM config.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket.IamConfigOrBuilder getIamConfigOrBuilder() {
    return getIamConfig();
  }

  public static final int ZONE_AFFINITY_FIELD_NUMBER = 24;
  private com.google.protobuf.LazyStringList zoneAffinity_;
  /**
   *
   *
   * <pre>
   * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
   * Requests for data from outside the specified affinities are still allowed
   * but won't be able to use zonal quota. The values are case-insensitive.
   * Attempting to update this field after bucket is created will result in an
   * error.
   * </pre>
   *
   * <code>
   * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the zoneAffinity.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getZoneAffinityList() {
    return zoneAffinity_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
   * Requests for data from outside the specified affinities are still allowed
   * but won't be able to use zonal quota. The values are case-insensitive.
   * Attempting to update this field after bucket is created will result in an
   * error.
   * </pre>
   *
   * <code>
   * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The count of zoneAffinity.
   */
  @java.lang.Deprecated
  public int getZoneAffinityCount() {
    return zoneAffinity_.size();
  }
  /**
   *
   *
   * <pre>
   * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
   * Requests for data from outside the specified affinities are still allowed
   * but won't be able to use zonal quota. The values are case-insensitive.
   * Attempting to update this field after bucket is created will result in an
   * error.
   * </pre>
   *
   * <code>
   * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The zoneAffinity at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getZoneAffinity(int index) {
    return zoneAffinity_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
   * Requests for data from outside the specified affinities are still allowed
   * but won't be able to use zonal quota. The values are case-insensitive.
   * Attempting to update this field after bucket is created will result in an
   * error.
   * </pre>
   *
   * <code>
   * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the zoneAffinity at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getZoneAffinityBytes(int index) {
    return zoneAffinity_.getByteString(index);
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 25;
  private boolean satisfiesPzs_;
  /**
   *
   *
   * <pre>
   * Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 25;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, project_);
    }
    if (metageneration_ != 0L) {
      output.writeInt64(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, locationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, storageClass_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      output.writeMessage(8, acl_.get(i));
    }
    for (int i = 0; i < defaultObjectAcl_.size(); i++) {
      output.writeMessage(9, defaultObjectAcl_.get(i));
    }
    if (lifecycle_ != null) {
      output.writeMessage(10, getLifecycle());
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    for (int i = 0; i < cors_.size(); i++) {
      output.writeMessage(12, cors_.get(i));
    }
    if (updateTime_ != null) {
      output.writeMessage(13, getUpdateTime());
    }
    if (defaultEventBasedHold_ != false) {
      output.writeBool(14, defaultEventBasedHold_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (website_ != null) {
      output.writeMessage(16, getWebsite());
    }
    if (versioning_ != null) {
      output.writeMessage(17, getVersioning());
    }
    if (logging_ != null) {
      output.writeMessage(18, getLogging());
    }
    if (owner_ != null) {
      output.writeMessage(19, getOwner());
    }
    if (encryption_ != null) {
      output.writeMessage(20, getEncryption());
    }
    if (billing_ != null) {
      output.writeMessage(21, getBilling());
    }
    if (retentionPolicy_ != null) {
      output.writeMessage(22, getRetentionPolicy());
    }
    if (iamConfig_ != null) {
      output.writeMessage(23, getIamConfig());
    }
    for (int i = 0; i < zoneAffinity_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, zoneAffinity_.getRaw(i));
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(25, satisfiesPzs_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, project_);
    }
    if (metageneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, locationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, storageClass_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, acl_.get(i));
    }
    for (int i = 0; i < defaultObjectAcl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, defaultObjectAcl_.get(i));
    }
    if (lifecycle_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getLifecycle());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    for (int i = 0; i < cors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, cors_.get(i));
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getUpdateTime());
    }
    if (defaultEventBasedHold_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, defaultEventBasedHold_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (website_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getWebsite());
    }
    if (versioning_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getVersioning());
    }
    if (logging_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLogging());
    }
    if (owner_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getOwner());
    }
    if (encryption_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getEncryption());
    }
    if (billing_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getBilling());
    }
    if (retentionPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getRetentionPolicy());
    }
    if (iamConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getIamConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < zoneAffinity_.size(); i++) {
        dataSize += computeStringSizeNoTag(zoneAffinity_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getZoneAffinityList().size();
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(25, satisfiesPzs_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.Bucket)) {
      return super.equals(obj);
    }
    com.google.storage.v2.Bucket other = (com.google.storage.v2.Bucket) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getBucketId().equals(other.getBucketId())) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (getMetageneration() != other.getMetageneration()) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getLocationType().equals(other.getLocationType())) return false;
    if (!getStorageClass().equals(other.getStorageClass())) return false;
    if (!getAclList().equals(other.getAclList())) return false;
    if (!getDefaultObjectAclList().equals(other.getDefaultObjectAclList())) return false;
    if (hasLifecycle() != other.hasLifecycle()) return false;
    if (hasLifecycle()) {
      if (!getLifecycle().equals(other.getLifecycle())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getCorsList().equals(other.getCorsList())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getDefaultEventBasedHold() != other.getDefaultEventBasedHold()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasWebsite() != other.hasWebsite()) return false;
    if (hasWebsite()) {
      if (!getWebsite().equals(other.getWebsite())) return false;
    }
    if (hasVersioning() != other.hasVersioning()) return false;
    if (hasVersioning()) {
      if (!getVersioning().equals(other.getVersioning())) return false;
    }
    if (hasLogging() != other.hasLogging()) return false;
    if (hasLogging()) {
      if (!getLogging().equals(other.getLogging())) return false;
    }
    if (hasOwner() != other.hasOwner()) return false;
    if (hasOwner()) {
      if (!getOwner().equals(other.getOwner())) return false;
    }
    if (hasEncryption() != other.hasEncryption()) return false;
    if (hasEncryption()) {
      if (!getEncryption().equals(other.getEncryption())) return false;
    }
    if (hasBilling() != other.hasBilling()) return false;
    if (hasBilling()) {
      if (!getBilling().equals(other.getBilling())) return false;
    }
    if (hasRetentionPolicy() != other.hasRetentionPolicy()) return false;
    if (hasRetentionPolicy()) {
      if (!getRetentionPolicy().equals(other.getRetentionPolicy())) return false;
    }
    if (hasIamConfig() != other.hasIamConfig()) return false;
    if (hasIamConfig()) {
      if (!getIamConfig().equals(other.getIamConfig())) return false;
    }
    if (!getZoneAffinityList().equals(other.getZoneAffinityList())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + BUCKET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBucketId().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + METAGENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMetageneration());
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + LOCATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getLocationType().hashCode();
    hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
    hash = (53 * hash) + getStorageClass().hashCode();
    if (getAclCount() > 0) {
      hash = (37 * hash) + ACL_FIELD_NUMBER;
      hash = (53 * hash) + getAclList().hashCode();
    }
    if (getDefaultObjectAclCount() > 0) {
      hash = (37 * hash) + DEFAULT_OBJECT_ACL_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultObjectAclList().hashCode();
    }
    if (hasLifecycle()) {
      hash = (37 * hash) + LIFECYCLE_FIELD_NUMBER;
      hash = (53 * hash) + getLifecycle().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getCorsCount() > 0) {
      hash = (37 * hash) + CORS_FIELD_NUMBER;
      hash = (53 * hash) + getCorsList().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DEFAULT_EVENT_BASED_HOLD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDefaultEventBasedHold());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasWebsite()) {
      hash = (37 * hash) + WEBSITE_FIELD_NUMBER;
      hash = (53 * hash) + getWebsite().hashCode();
    }
    if (hasVersioning()) {
      hash = (37 * hash) + VERSIONING_FIELD_NUMBER;
      hash = (53 * hash) + getVersioning().hashCode();
    }
    if (hasLogging()) {
      hash = (37 * hash) + LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + getLogging().hashCode();
    }
    if (hasOwner()) {
      hash = (37 * hash) + OWNER_FIELD_NUMBER;
      hash = (53 * hash) + getOwner().hashCode();
    }
    if (hasEncryption()) {
      hash = (37 * hash) + ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryption().hashCode();
    }
    if (hasBilling()) {
      hash = (37 * hash) + BILLING_FIELD_NUMBER;
      hash = (53 * hash) + getBilling().hashCode();
    }
    if (hasRetentionPolicy()) {
      hash = (37 * hash) + RETENTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionPolicy().hashCode();
    }
    if (hasIamConfig()) {
      hash = (37 * hash) + IAM_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIamConfig().hashCode();
    }
    if (getZoneAffinityCount() > 0) {
      hash = (37 * hash) + ZONE_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getZoneAffinityList().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.Bucket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Bucket parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Bucket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.Bucket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket)
      com.google.storage.v2.BucketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 15:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 15:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.class, com.google.storage.v2.Bucket.Builder.class);
    }

    // Construct using com.google.storage.v2.Bucket.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAclFieldBuilder();
        getDefaultObjectAclFieldBuilder();
        getCorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      bucketId_ = "";

      project_ = "";

      metageneration_ = 0L;

      location_ = "";

      locationType_ = "";

      storageClass_ = "";

      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        aclBuilder_.clear();
      }
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAcl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        defaultObjectAclBuilder_.clear();
      }
      if (lifecycleBuilder_ == null) {
        lifecycle_ = null;
      } else {
        lifecycle_ = null;
        lifecycleBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (corsBuilder_ == null) {
        cors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        corsBuilder_.clear();
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      defaultEventBasedHold_ = false;

      internalGetMutableLabels().clear();
      if (websiteBuilder_ == null) {
        website_ = null;
      } else {
        website_ = null;
        websiteBuilder_ = null;
      }
      if (versioningBuilder_ == null) {
        versioning_ = null;
      } else {
        versioning_ = null;
        versioningBuilder_ = null;
      }
      if (loggingBuilder_ == null) {
        logging_ = null;
      } else {
        logging_ = null;
        loggingBuilder_ = null;
      }
      if (ownerBuilder_ == null) {
        owner_ = null;
      } else {
        owner_ = null;
        ownerBuilder_ = null;
      }
      if (encryptionBuilder_ == null) {
        encryption_ = null;
      } else {
        encryption_ = null;
        encryptionBuilder_ = null;
      }
      if (billingBuilder_ == null) {
        billing_ = null;
      } else {
        billing_ = null;
        billingBuilder_ = null;
      }
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = null;
      } else {
        retentionPolicy_ = null;
        retentionPolicyBuilder_ = null;
      }
      if (iamConfigBuilder_ == null) {
        iamConfig_ = null;
      } else {
        iamConfig_ = null;
        iamConfigBuilder_ = null;
      }
      zoneAffinity_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      satisfiesPzs_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket getDefaultInstanceForType() {
      return com.google.storage.v2.Bucket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket build() {
      com.google.storage.v2.Bucket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket buildPartial() {
      com.google.storage.v2.Bucket result = new com.google.storage.v2.Bucket(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.bucketId_ = bucketId_;
      result.project_ = project_;
      result.metageneration_ = metageneration_;
      result.location_ = location_;
      result.locationType_ = locationType_;
      result.storageClass_ = storageClass_;
      if (aclBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          acl_ = java.util.Collections.unmodifiableList(acl_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.acl_ = acl_;
      } else {
        result.acl_ = aclBuilder_.build();
      }
      if (defaultObjectAclBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          defaultObjectAcl_ = java.util.Collections.unmodifiableList(defaultObjectAcl_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.defaultObjectAcl_ = defaultObjectAcl_;
      } else {
        result.defaultObjectAcl_ = defaultObjectAclBuilder_.build();
      }
      if (lifecycleBuilder_ == null) {
        result.lifecycle_ = lifecycle_;
      } else {
        result.lifecycle_ = lifecycleBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (corsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          cors_ = java.util.Collections.unmodifiableList(cors_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.cors_ = cors_;
      } else {
        result.cors_ = corsBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.defaultEventBasedHold_ = defaultEventBasedHold_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (websiteBuilder_ == null) {
        result.website_ = website_;
      } else {
        result.website_ = websiteBuilder_.build();
      }
      if (versioningBuilder_ == null) {
        result.versioning_ = versioning_;
      } else {
        result.versioning_ = versioningBuilder_.build();
      }
      if (loggingBuilder_ == null) {
        result.logging_ = logging_;
      } else {
        result.logging_ = loggingBuilder_.build();
      }
      if (ownerBuilder_ == null) {
        result.owner_ = owner_;
      } else {
        result.owner_ = ownerBuilder_.build();
      }
      if (encryptionBuilder_ == null) {
        result.encryption_ = encryption_;
      } else {
        result.encryption_ = encryptionBuilder_.build();
      }
      if (billingBuilder_ == null) {
        result.billing_ = billing_;
      } else {
        result.billing_ = billingBuilder_.build();
      }
      if (retentionPolicyBuilder_ == null) {
        result.retentionPolicy_ = retentionPolicy_;
      } else {
        result.retentionPolicy_ = retentionPolicyBuilder_.build();
      }
      if (iamConfigBuilder_ == null) {
        result.iamConfig_ = iamConfig_;
      } else {
        result.iamConfig_ = iamConfigBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        zoneAffinity_ = zoneAffinity_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.zoneAffinity_ = zoneAffinity_;
      result.satisfiesPzs_ = satisfiesPzs_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.Bucket) {
        return mergeFrom((com.google.storage.v2.Bucket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.Bucket other) {
      if (other == com.google.storage.v2.Bucket.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getBucketId().isEmpty()) {
        bucketId_ = other.bucketId_;
        onChanged();
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        onChanged();
      }
      if (other.getMetageneration() != 0L) {
        setMetageneration(other.getMetageneration());
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        onChanged();
      }
      if (!other.getLocationType().isEmpty()) {
        locationType_ = other.locationType_;
        onChanged();
      }
      if (!other.getStorageClass().isEmpty()) {
        storageClass_ = other.storageClass_;
        onChanged();
      }
      if (aclBuilder_ == null) {
        if (!other.acl_.isEmpty()) {
          if (acl_.isEmpty()) {
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAclIsMutable();
            acl_.addAll(other.acl_);
          }
          onChanged();
        }
      } else {
        if (!other.acl_.isEmpty()) {
          if (aclBuilder_.isEmpty()) {
            aclBuilder_.dispose();
            aclBuilder_ = null;
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000001);
            aclBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAclFieldBuilder()
                    : null;
          } else {
            aclBuilder_.addAllMessages(other.acl_);
          }
        }
      }
      if (defaultObjectAclBuilder_ == null) {
        if (!other.defaultObjectAcl_.isEmpty()) {
          if (defaultObjectAcl_.isEmpty()) {
            defaultObjectAcl_ = other.defaultObjectAcl_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDefaultObjectAclIsMutable();
            defaultObjectAcl_.addAll(other.defaultObjectAcl_);
          }
          onChanged();
        }
      } else {
        if (!other.defaultObjectAcl_.isEmpty()) {
          if (defaultObjectAclBuilder_.isEmpty()) {
            defaultObjectAclBuilder_.dispose();
            defaultObjectAclBuilder_ = null;
            defaultObjectAcl_ = other.defaultObjectAcl_;
            bitField0_ = (bitField0_ & ~0x00000002);
            defaultObjectAclBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDefaultObjectAclFieldBuilder()
                    : null;
          } else {
            defaultObjectAclBuilder_.addAllMessages(other.defaultObjectAcl_);
          }
        }
      }
      if (other.hasLifecycle()) {
        mergeLifecycle(other.getLifecycle());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (corsBuilder_ == null) {
        if (!other.cors_.isEmpty()) {
          if (cors_.isEmpty()) {
            cors_ = other.cors_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureCorsIsMutable();
            cors_.addAll(other.cors_);
          }
          onChanged();
        }
      } else {
        if (!other.cors_.isEmpty()) {
          if (corsBuilder_.isEmpty()) {
            corsBuilder_.dispose();
            corsBuilder_ = null;
            cors_ = other.cors_;
            bitField0_ = (bitField0_ & ~0x00000004);
            corsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCorsFieldBuilder()
                    : null;
          } else {
            corsBuilder_.addAllMessages(other.cors_);
          }
        }
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getDefaultEventBasedHold() != false) {
        setDefaultEventBasedHold(other.getDefaultEventBasedHold());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasWebsite()) {
        mergeWebsite(other.getWebsite());
      }
      if (other.hasVersioning()) {
        mergeVersioning(other.getVersioning());
      }
      if (other.hasLogging()) {
        mergeLogging(other.getLogging());
      }
      if (other.hasOwner()) {
        mergeOwner(other.getOwner());
      }
      if (other.hasEncryption()) {
        mergeEncryption(other.getEncryption());
      }
      if (other.hasBilling()) {
        mergeBilling(other.getBilling());
      }
      if (other.hasRetentionPolicy()) {
        mergeRetentionPolicy(other.getRetentionPolicy());
      }
      if (other.hasIamConfig()) {
        mergeIamConfig(other.getIamConfig());
      }
      if (!other.zoneAffinity_.isEmpty()) {
        if (zoneAffinity_.isEmpty()) {
          zoneAffinity_ = other.zoneAffinity_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureZoneAffinityIsMutable();
          zoneAffinity_.addAll(other.zoneAffinity_);
        }
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.storage.v2.Bucket parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.storage.v2.Bucket) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object bucketId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
     * `name` field. For globally unique buckets, this is equal to the "bucket
     * name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bucketId.
     */
    public java.lang.String getBucketId() {
      java.lang.Object ref = bucketId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
     * `name` field. For globally unique buckets, this is equal to the "bucket
     * name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for bucketId.
     */
    public com.google.protobuf.ByteString getBucketIdBytes() {
      java.lang.Object ref = bucketId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
     * `name` field. For globally unique buckets, this is equal to the "bucket
     * name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      bucketId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
     * `name` field. For globally unique buckets, this is equal to the "bucket
     * name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketId() {

      bucketId_ = getDefaultInstance().getBucketId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The user-chosen part of the bucket name. The `{bucket}` portion of the
     * `name` field. For globally unique buckets, this is equal to the "bucket
     * name" of other Cloud Storage APIs. Example: "pub".
     * </pre>
     *
     * <code>string bucket_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      bucketId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      project_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {

      project_ = getDefaultInstance().getProject();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The project which owns this bucket.
     * </pre>
     *
     * <code>
     * string project = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      project_ = value;
      onChanged();
      return this;
    }

    private long metageneration_;
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metageneration.
     */
    @java.lang.Override
    public long getMetageneration() {
      return metageneration_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metageneration to set.
     * @return This builder for chaining.
     */
    public Builder setMetageneration(long value) {

      metageneration_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metadata generation of this bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetageneration() {

      metageneration_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the bucket resides
     * in physical storage within this region.  Defaults to `US`. See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the bucket resides
     * in physical storage within this region.  Defaults to `US`. See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the bucket resides
     * in physical storage within this region.  Defaults to `US`. See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      location_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the bucket resides
     * in physical storage within this region.  Defaults to `US`. See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {

      location_ = getDefaultInstance().getLocation();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The location of the bucket. Object data for objects in the bucket resides
     * in physical storage within this region.  Defaults to `US`. See the
     * [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
     * guide] for the authoritative list. Attempting to update this field after
     * the bucket is created will result in an error.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      location_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locationType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The locationType.
     */
    public java.lang.String getLocationType() {
      java.lang.Object ref = locationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for locationType.
     */
    public com.google.protobuf.ByteString getLocationTypeBytes() {
      java.lang.Object ref = locationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationType() {

      locationType_ = getDefaultInstance().getLocationType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region, multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationType_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object storageClass_ = "";
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return The storageClass.
     */
    public java.lang.String getStorageClass() {
      java.lang.Object ref = storageClass_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageClass_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return The bytes for storageClass.
     */
    public com.google.protobuf.ByteString getStorageClassBytes() {
      java.lang.Object ref = storageClass_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @param value The storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClass(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      storageClass_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageClass() {

      storageClass_ = getDefaultInstance().getStorageClass();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's default storage class, used whenever no storageClass is
     * specified for a newly-created object. This defines how objects in the
     * bucket are stored and determines the SLA and the cost of storage.
     * If this value is not specified when the bucket is created, it will default
     * to `STANDARD`. For more information, see
     * https://developers.google.com/storage/docs/storage-classes.
     * </pre>
     *
     * <code>string storage_class = 7;</code>
     *
     * @param value The bytes for storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      storageClass_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.storage.v2.BucketAccessControl> acl_ =
        java.util.Collections.emptyList();

    private void ensureAclIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        acl_ = new java.util.ArrayList<com.google.storage.v2.BucketAccessControl>(acl_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.BucketAccessControl,
            com.google.storage.v2.BucketAccessControl.Builder,
            com.google.storage.v2.BucketAccessControlOrBuilder>
        aclBuilder_;

    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<com.google.storage.v2.BucketAccessControl> getAclList() {
      if (aclBuilder_ == null) {
        return java.util.Collections.unmodifiableList(acl_);
      } else {
        return aclBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public int getAclCount() {
      if (aclBuilder_ == null) {
        return acl_.size();
      } else {
        return aclBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl getAcl(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder setAcl(int index, com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.set(index, value);
        onChanged();
      } else {
        aclBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder setAcl(
        int index, com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.set(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(value);
        onChanged();
      } else {
        aclBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(int index, com.google.storage.v2.BucketAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(index, value);
        onChanged();
      } else {
        aclBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAcl(
        int index, com.google.storage.v2.BucketAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder addAllAcl(
        java.lang.Iterable<? extends com.google.storage.v2.BucketAccessControl> values) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, acl_);
        onChanged();
      } else {
        aclBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder clearAcl() {
      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        aclBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public Builder removeAcl(int index) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.remove(index);
        onChanged();
      } else {
        aclBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder getAclBuilder(int index) {
      return getAclFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControlOrBuilder getAclOrBuilder(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<? extends com.google.storage.v2.BucketAccessControlOrBuilder>
        getAclOrBuilderList() {
      if (aclBuilder_ != null) {
        return aclBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(acl_);
      }
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder addAclBuilder() {
      return getAclFieldBuilder()
          .addBuilder(com.google.storage.v2.BucketAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public com.google.storage.v2.BucketAccessControl.Builder addAclBuilder(int index) {
      return getAclFieldBuilder()
          .addBuilder(index, com.google.storage.v2.BucketAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Access controls on the bucket.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.BucketAccessControl acl = 8;</code>
     */
    public java.util.List<com.google.storage.v2.BucketAccessControl.Builder> getAclBuilderList() {
      return getAclFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.BucketAccessControl,
            com.google.storage.v2.BucketAccessControl.Builder,
            com.google.storage.v2.BucketAccessControlOrBuilder>
        getAclFieldBuilder() {
      if (aclBuilder_ == null) {
        aclBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.BucketAccessControl,
                com.google.storage.v2.BucketAccessControl.Builder,
                com.google.storage.v2.BucketAccessControlOrBuilder>(
                acl_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        acl_ = null;
      }
      return aclBuilder_;
    }

    private java.util.List<com.google.storage.v2.ObjectAccessControl> defaultObjectAcl_ =
        java.util.Collections.emptyList();

    private void ensureDefaultObjectAclIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        defaultObjectAcl_ =
            new java.util.ArrayList<com.google.storage.v2.ObjectAccessControl>(defaultObjectAcl_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        defaultObjectAclBuilder_;

    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl> getDefaultObjectAclList() {
      if (defaultObjectAclBuilder_ == null) {
        return java.util.Collections.unmodifiableList(defaultObjectAcl_);
      } else {
        return defaultObjectAclBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public int getDefaultObjectAclCount() {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.size();
      } else {
        return defaultObjectAclBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl getDefaultObjectAcl(int index) {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.get(index);
      } else {
        return defaultObjectAclBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder setDefaultObjectAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.set(index, value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder setDefaultObjectAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.set(index, builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (defaultObjectAclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(index, value);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(
        com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addDefaultObjectAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.add(index, builderForValue.build());
        onChanged();
      } else {
        defaultObjectAclBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder addAllDefaultObjectAcl(
        java.lang.Iterable<? extends com.google.storage.v2.ObjectAccessControl> values) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, defaultObjectAcl_);
        onChanged();
      } else {
        defaultObjectAclBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder clearDefaultObjectAcl() {
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAcl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        defaultObjectAclBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public Builder removeDefaultObjectAcl(int index) {
      if (defaultObjectAclBuilder_ == null) {
        ensureDefaultObjectAclIsMutable();
        defaultObjectAcl_.remove(index);
        onChanged();
      } else {
        defaultObjectAclBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder getDefaultObjectAclBuilder(int index) {
      return getDefaultObjectAclFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControlOrBuilder getDefaultObjectAclOrBuilder(
        int index) {
      if (defaultObjectAclBuilder_ == null) {
        return defaultObjectAcl_.get(index);
      } else {
        return defaultObjectAclBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
        getDefaultObjectAclOrBuilderList() {
      if (defaultObjectAclBuilder_ != null) {
        return defaultObjectAclBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(defaultObjectAcl_);
      }
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addDefaultObjectAclBuilder() {
      return getDefaultObjectAclFieldBuilder()
          .addBuilder(com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addDefaultObjectAclBuilder(int index) {
      return getDefaultObjectAclFieldBuilder()
          .addBuilder(index, com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Default access controls to apply to new objects when no ACL is provided.
     * If iamConfig.uniformBucketLevelAccess is enabled on this bucket,
     * requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ObjectAccessControl default_object_acl = 9;</code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl.Builder>
        getDefaultObjectAclBuilderList() {
      return getDefaultObjectAclFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        getDefaultObjectAclFieldBuilder() {
      if (defaultObjectAclBuilder_ == null) {
        defaultObjectAclBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.ObjectAccessControl,
                com.google.storage.v2.ObjectAccessControl.Builder,
                com.google.storage.v2.ObjectAccessControlOrBuilder>(
                defaultObjectAcl_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        defaultObjectAcl_ = null;
      }
      return defaultObjectAclBuilder_;
    }

    private com.google.storage.v2.Bucket.Lifecycle lifecycle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Lifecycle,
            com.google.storage.v2.Bucket.Lifecycle.Builder,
            com.google.storage.v2.Bucket.LifecycleOrBuilder>
        lifecycleBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     *
     * @return Whether the lifecycle field is set.
     */
    public boolean hasLifecycle() {
      return lifecycleBuilder_ != null || lifecycle_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     *
     * @return The lifecycle.
     */
    public com.google.storage.v2.Bucket.Lifecycle getLifecycle() {
      if (lifecycleBuilder_ == null) {
        return lifecycle_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
            : lifecycle_;
      } else {
        return lifecycleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder setLifecycle(com.google.storage.v2.Bucket.Lifecycle value) {
      if (lifecycleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifecycle_ = value;
        onChanged();
      } else {
        lifecycleBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder setLifecycle(com.google.storage.v2.Bucket.Lifecycle.Builder builderForValue) {
      if (lifecycleBuilder_ == null) {
        lifecycle_ = builderForValue.build();
        onChanged();
      } else {
        lifecycleBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder mergeLifecycle(com.google.storage.v2.Bucket.Lifecycle value) {
      if (lifecycleBuilder_ == null) {
        if (lifecycle_ != null) {
          lifecycle_ =
              com.google.storage.v2.Bucket.Lifecycle.newBuilder(lifecycle_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lifecycle_ = value;
        }
        onChanged();
      } else {
        lifecycleBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public Builder clearLifecycle() {
      if (lifecycleBuilder_ == null) {
        lifecycle_ = null;
        onChanged();
      } else {
        lifecycle_ = null;
        lifecycleBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public com.google.storage.v2.Bucket.Lifecycle.Builder getLifecycleBuilder() {

      onChanged();
      return getLifecycleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    public com.google.storage.v2.Bucket.LifecycleOrBuilder getLifecycleOrBuilder() {
      if (lifecycleBuilder_ != null) {
        return lifecycleBuilder_.getMessageOrBuilder();
      } else {
        return lifecycle_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()
            : lifecycle_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's lifecycle config. See
     * [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
     * for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Lifecycle lifecycle = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Lifecycle,
            com.google.storage.v2.Bucket.Lifecycle.Builder,
            com.google.storage.v2.Bucket.LifecycleOrBuilder>
        getLifecycleFieldBuilder() {
      if (lifecycleBuilder_ == null) {
        lifecycleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle,
                com.google.storage.v2.Bucket.Lifecycle.Builder,
                com.google.storage.v2.Bucket.LifecycleOrBuilder>(
                getLifecycle(), getParentForChildren(), isClean());
        lifecycle_ = null;
      }
      return lifecycleBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the bucket in
     * [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.util.List<com.google.storage.v2.Bucket.Cors> cors_ =
        java.util.Collections.emptyList();

    private void ensureCorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        cors_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Cors>(cors_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket.Cors,
            com.google.storage.v2.Bucket.Cors.Builder,
            com.google.storage.v2.Bucket.CorsOrBuilder>
        corsBuilder_;

    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket.Cors> getCorsList() {
      if (corsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cors_);
      } else {
        return corsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public int getCorsCount() {
      if (corsBuilder_ == null) {
        return cors_.size();
      } else {
        return corsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors getCors(int index) {
      if (corsBuilder_ == null) {
        return cors_.get(index);
      } else {
        return corsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder setCors(int index, com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.set(index, value);
        onChanged();
      } else {
        corsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder setCors(int index, com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.set(index, builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.add(value);
        onChanged();
      } else {
        corsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(int index, com.google.storage.v2.Bucket.Cors value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCorsIsMutable();
        cors_.add(index, value);
        onChanged();
      } else {
        corsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.add(builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addCors(int index, com.google.storage.v2.Bucket.Cors.Builder builderForValue) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.add(index, builderForValue.build());
        onChanged();
      } else {
        corsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder addAllCors(
        java.lang.Iterable<? extends com.google.storage.v2.Bucket.Cors> values) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cors_);
        onChanged();
      } else {
        corsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder clearCors() {
      if (corsBuilder_ == null) {
        cors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        corsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public Builder removeCors(int index) {
      if (corsBuilder_ == null) {
        ensureCorsIsMutable();
        cors_.remove(index);
        onChanged();
      } else {
        corsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder getCorsBuilder(int index) {
      return getCorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.CorsOrBuilder getCorsOrBuilder(int index) {
      if (corsBuilder_ == null) {
        return cors_.get(index);
      } else {
        return corsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<? extends com.google.storage.v2.Bucket.CorsOrBuilder>
        getCorsOrBuilderList() {
      if (corsBuilder_ != null) {
        return corsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder addCorsBuilder() {
      return getCorsFieldBuilder()
          .addBuilder(com.google.storage.v2.Bucket.Cors.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public com.google.storage.v2.Bucket.Cors.Builder addCorsBuilder(int index) {
      return getCorsFieldBuilder()
          .addBuilder(index, com.google.storage.v2.Bucket.Cors.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
     * (CORS) config.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket.Cors cors = 12;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket.Cors.Builder> getCorsBuilderList() {
      return getCorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket.Cors,
            com.google.storage.v2.Bucket.Cors.Builder,
            com.google.storage.v2.Bucket.CorsOrBuilder>
        getCorsFieldBuilder() {
      if (corsBuilder_ == null) {
        corsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.Bucket.Cors,
                com.google.storage.v2.Bucket.Cors.Builder,
                com.google.storage.v2.Bucket.CorsOrBuilder>(
                cors_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        cors_ = null;
      }
      return corsBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The modification time of the bucket.
     * Attempting to set or update this field will result in a
     * [FieldViolation][google.rpc.BadRequest.FieldViolation].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean defaultEventBasedHold_;
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @return The defaultEventBasedHold.
     */
    @java.lang.Override
    public boolean getDefaultEventBasedHold() {
      return defaultEventBasedHold_;
    }
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @param value The defaultEventBasedHold to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultEventBasedHold(boolean value) {

      defaultEventBasedHold_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default value for event-based hold on newly created objects in this
     * bucket.  Event-based hold is a way to retain objects indefinitely until an
     * event occurs, signified by the
     * hold's release. After being released, such objects will be subject to
     * bucket-level retention (if any).  One sample use case of this flag is for
     * banks to hold loan documents for at least 3 years after loan is paid in
     * full. Here, bucket-level retention is 3 years and the event is loan being
     * paid in full. In this example, these objects will be held intact for any
     * number of years until the event has occurred (event-based hold on the
     * object is released) and then 3 more years after that. That means retention
     * duration of the objects begins from the moment event-based hold
     * transitioned from true to false.  Objects under event-based hold cannot be
     * deleted, overwritten or archived until the hold is removed.
     * </pre>
     *
     * <code>bool default_event_based_hold = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultEventBasedHold() {

      defaultEventBasedHold_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided labels, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.storage.v2.Bucket.Website website_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Website,
            com.google.storage.v2.Bucket.Website.Builder,
            com.google.storage.v2.Bucket.WebsiteOrBuilder>
        websiteBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     *
     * @return Whether the website field is set.
     */
    public boolean hasWebsite() {
      return websiteBuilder_ != null || website_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     *
     * @return The website.
     */
    public com.google.storage.v2.Bucket.Website getWebsite() {
      if (websiteBuilder_ == null) {
        return website_ == null
            ? com.google.storage.v2.Bucket.Website.getDefaultInstance()
            : website_;
      } else {
        return websiteBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder setWebsite(com.google.storage.v2.Bucket.Website value) {
      if (websiteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        website_ = value;
        onChanged();
      } else {
        websiteBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder setWebsite(com.google.storage.v2.Bucket.Website.Builder builderForValue) {
      if (websiteBuilder_ == null) {
        website_ = builderForValue.build();
        onChanged();
      } else {
        websiteBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder mergeWebsite(com.google.storage.v2.Bucket.Website value) {
      if (websiteBuilder_ == null) {
        if (website_ != null) {
          website_ =
              com.google.storage.v2.Bucket.Website.newBuilder(website_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          website_ = value;
        }
        onChanged();
      } else {
        websiteBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public Builder clearWebsite() {
      if (websiteBuilder_ == null) {
        website_ = null;
        onChanged();
      } else {
        website_ = null;
        websiteBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public com.google.storage.v2.Bucket.Website.Builder getWebsiteBuilder() {

      onChanged();
      return getWebsiteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    public com.google.storage.v2.Bucket.WebsiteOrBuilder getWebsiteOrBuilder() {
      if (websiteBuilder_ != null) {
        return websiteBuilder_.getMessageOrBuilder();
      } else {
        return website_ == null
            ? com.google.storage.v2.Bucket.Website.getDefaultInstance()
            : website_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's website config, controlling how the service behaves
     * when accessing bucket contents as a web site. See the
     * [https://cloud.google.com/storage/docs/static-website][Static Website
     * Examples] for more information.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Website website = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Website,
            com.google.storage.v2.Bucket.Website.Builder,
            com.google.storage.v2.Bucket.WebsiteOrBuilder>
        getWebsiteFieldBuilder() {
      if (websiteBuilder_ == null) {
        websiteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Website,
                com.google.storage.v2.Bucket.Website.Builder,
                com.google.storage.v2.Bucket.WebsiteOrBuilder>(
                getWebsite(), getParentForChildren(), isClean());
        website_ = null;
      }
      return websiteBuilder_;
    }

    private com.google.storage.v2.Bucket.Versioning versioning_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Versioning,
            com.google.storage.v2.Bucket.Versioning.Builder,
            com.google.storage.v2.Bucket.VersioningOrBuilder>
        versioningBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     *
     * @return Whether the versioning field is set.
     */
    public boolean hasVersioning() {
      return versioningBuilder_ != null || versioning_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     *
     * @return The versioning.
     */
    public com.google.storage.v2.Bucket.Versioning getVersioning() {
      if (versioningBuilder_ == null) {
        return versioning_ == null
            ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
            : versioning_;
      } else {
        return versioningBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder setVersioning(com.google.storage.v2.Bucket.Versioning value) {
      if (versioningBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versioning_ = value;
        onChanged();
      } else {
        versioningBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder setVersioning(com.google.storage.v2.Bucket.Versioning.Builder builderForValue) {
      if (versioningBuilder_ == null) {
        versioning_ = builderForValue.build();
        onChanged();
      } else {
        versioningBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder mergeVersioning(com.google.storage.v2.Bucket.Versioning value) {
      if (versioningBuilder_ == null) {
        if (versioning_ != null) {
          versioning_ =
              com.google.storage.v2.Bucket.Versioning.newBuilder(versioning_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          versioning_ = value;
        }
        onChanged();
      } else {
        versioningBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public Builder clearVersioning() {
      if (versioningBuilder_ == null) {
        versioning_ = null;
        onChanged();
      } else {
        versioning_ = null;
        versioningBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public com.google.storage.v2.Bucket.Versioning.Builder getVersioningBuilder() {

      onChanged();
      return getVersioningFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    public com.google.storage.v2.Bucket.VersioningOrBuilder getVersioningOrBuilder() {
      if (versioningBuilder_ != null) {
        return versioningBuilder_.getMessageOrBuilder();
      } else {
        return versioning_ == null
            ? com.google.storage.v2.Bucket.Versioning.getDefaultInstance()
            : versioning_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's versioning config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Versioning versioning = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Versioning,
            com.google.storage.v2.Bucket.Versioning.Builder,
            com.google.storage.v2.Bucket.VersioningOrBuilder>
        getVersioningFieldBuilder() {
      if (versioningBuilder_ == null) {
        versioningBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Versioning,
                com.google.storage.v2.Bucket.Versioning.Builder,
                com.google.storage.v2.Bucket.VersioningOrBuilder>(
                getVersioning(), getParentForChildren(), isClean());
        versioning_ = null;
      }
      return versioningBuilder_;
    }

    private com.google.storage.v2.Bucket.Logging logging_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Logging,
            com.google.storage.v2.Bucket.Logging.Builder,
            com.google.storage.v2.Bucket.LoggingOrBuilder>
        loggingBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     *
     * @return Whether the logging field is set.
     */
    public boolean hasLogging() {
      return loggingBuilder_ != null || logging_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     *
     * @return The logging.
     */
    public com.google.storage.v2.Bucket.Logging getLogging() {
      if (loggingBuilder_ == null) {
        return logging_ == null
            ? com.google.storage.v2.Bucket.Logging.getDefaultInstance()
            : logging_;
      } else {
        return loggingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder setLogging(com.google.storage.v2.Bucket.Logging value) {
      if (loggingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logging_ = value;
        onChanged();
      } else {
        loggingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder setLogging(com.google.storage.v2.Bucket.Logging.Builder builderForValue) {
      if (loggingBuilder_ == null) {
        logging_ = builderForValue.build();
        onChanged();
      } else {
        loggingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder mergeLogging(com.google.storage.v2.Bucket.Logging value) {
      if (loggingBuilder_ == null) {
        if (logging_ != null) {
          logging_ =
              com.google.storage.v2.Bucket.Logging.newBuilder(logging_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          logging_ = value;
        }
        onChanged();
      } else {
        loggingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public Builder clearLogging() {
      if (loggingBuilder_ == null) {
        logging_ = null;
        onChanged();
      } else {
        logging_ = null;
        loggingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public com.google.storage.v2.Bucket.Logging.Builder getLoggingBuilder() {

      onChanged();
      return getLoggingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    public com.google.storage.v2.Bucket.LoggingOrBuilder getLoggingOrBuilder() {
      if (loggingBuilder_ != null) {
        return loggingBuilder_.getMessageOrBuilder();
      } else {
        return logging_ == null
            ? com.google.storage.v2.Bucket.Logging.getDefaultInstance()
            : logging_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's logging config, which defines the destination bucket
     * and name prefix (if any) for the current bucket's logs.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Logging logging = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Logging,
            com.google.storage.v2.Bucket.Logging.Builder,
            com.google.storage.v2.Bucket.LoggingOrBuilder>
        getLoggingFieldBuilder() {
      if (loggingBuilder_ == null) {
        loggingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Logging,
                com.google.storage.v2.Bucket.Logging.Builder,
                com.google.storage.v2.Bucket.LoggingOrBuilder>(
                getLogging(), getParentForChildren(), isClean());
        logging_ = null;
      }
      return loggingBuilder_;
    }

    private com.google.storage.v2.Owner owner_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        ownerBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the owner field is set.
     */
    public boolean hasOwner() {
      return ownerBuilder_ != null || owner_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The owner.
     */
    public com.google.storage.v2.Owner getOwner() {
      if (ownerBuilder_ == null) {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      } else {
        return ownerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        owner_ = value;
        onChanged();
      } else {
        ownerBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner.Builder builderForValue) {
      if (ownerBuilder_ == null) {
        owner_ = builderForValue.build();
        onChanged();
      } else {
        ownerBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (owner_ != null) {
          owner_ = com.google.storage.v2.Owner.newBuilder(owner_).mergeFrom(value).buildPartial();
        } else {
          owner_ = value;
        }
        onChanged();
      } else {
        ownerBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOwner() {
      if (ownerBuilder_ == null) {
        owner_ = null;
        onChanged();
      } else {
        owner_ = null;
        ownerBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.Owner.Builder getOwnerBuilder() {

      onChanged();
      return getOwnerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
      if (ownerBuilder_ != null) {
        return ownerBuilder_.getMessageOrBuilder();
      } else {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The owner of the bucket. This is always the project team's owner group.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        getOwnerFieldBuilder() {
      if (ownerBuilder_ == null) {
        ownerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Owner,
                com.google.storage.v2.Owner.Builder,
                com.google.storage.v2.OwnerOrBuilder>(
                getOwner(), getParentForChildren(), isClean());
        owner_ = null;
      }
      return ownerBuilder_;
    }

    private com.google.storage.v2.Bucket.Encryption encryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Encryption,
            com.google.storage.v2.Bucket.Encryption.Builder,
            com.google.storage.v2.Bucket.EncryptionOrBuilder>
        encryptionBuilder_;
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     *
     * @return Whether the encryption field is set.
     */
    public boolean hasEncryption() {
      return encryptionBuilder_ != null || encryption_ != null;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     *
     * @return The encryption.
     */
    public com.google.storage.v2.Bucket.Encryption getEncryption() {
      if (encryptionBuilder_ == null) {
        return encryption_ == null
            ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
            : encryption_;
      } else {
        return encryptionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder setEncryption(com.google.storage.v2.Bucket.Encryption value) {
      if (encryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryption_ = value;
        onChanged();
      } else {
        encryptionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder setEncryption(com.google.storage.v2.Bucket.Encryption.Builder builderForValue) {
      if (encryptionBuilder_ == null) {
        encryption_ = builderForValue.build();
        onChanged();
      } else {
        encryptionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder mergeEncryption(com.google.storage.v2.Bucket.Encryption value) {
      if (encryptionBuilder_ == null) {
        if (encryption_ != null) {
          encryption_ =
              com.google.storage.v2.Bucket.Encryption.newBuilder(encryption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryption_ = value;
        }
        onChanged();
      } else {
        encryptionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public Builder clearEncryption() {
      if (encryptionBuilder_ == null) {
        encryption_ = null;
        onChanged();
      } else {
        encryption_ = null;
        encryptionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public com.google.storage.v2.Bucket.Encryption.Builder getEncryptionBuilder() {

      onChanged();
      return getEncryptionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    public com.google.storage.v2.Bucket.EncryptionOrBuilder getEncryptionOrBuilder() {
      if (encryptionBuilder_ != null) {
        return encryptionBuilder_.getMessageOrBuilder();
      } else {
        return encryption_ == null
            ? com.google.storage.v2.Bucket.Encryption.getDefaultInstance()
            : encryption_;
      }
    }
    /**
     *
     *
     * <pre>
     * Encryption config for a bucket.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Encryption encryption = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Encryption,
            com.google.storage.v2.Bucket.Encryption.Builder,
            com.google.storage.v2.Bucket.EncryptionOrBuilder>
        getEncryptionFieldBuilder() {
      if (encryptionBuilder_ == null) {
        encryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Encryption,
                com.google.storage.v2.Bucket.Encryption.Builder,
                com.google.storage.v2.Bucket.EncryptionOrBuilder>(
                getEncryption(), getParentForChildren(), isClean());
        encryption_ = null;
      }
      return encryptionBuilder_;
    }

    private com.google.storage.v2.Bucket.Billing billing_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Billing,
            com.google.storage.v2.Bucket.Billing.Builder,
            com.google.storage.v2.Bucket.BillingOrBuilder>
        billingBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     *
     * @return Whether the billing field is set.
     */
    public boolean hasBilling() {
      return billingBuilder_ != null || billing_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     *
     * @return The billing.
     */
    public com.google.storage.v2.Bucket.Billing getBilling() {
      if (billingBuilder_ == null) {
        return billing_ == null
            ? com.google.storage.v2.Bucket.Billing.getDefaultInstance()
            : billing_;
      } else {
        return billingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder setBilling(com.google.storage.v2.Bucket.Billing value) {
      if (billingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        billing_ = value;
        onChanged();
      } else {
        billingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder setBilling(com.google.storage.v2.Bucket.Billing.Builder builderForValue) {
      if (billingBuilder_ == null) {
        billing_ = builderForValue.build();
        onChanged();
      } else {
        billingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder mergeBilling(com.google.storage.v2.Bucket.Billing value) {
      if (billingBuilder_ == null) {
        if (billing_ != null) {
          billing_ =
              com.google.storage.v2.Bucket.Billing.newBuilder(billing_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          billing_ = value;
        }
        onChanged();
      } else {
        billingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public Builder clearBilling() {
      if (billingBuilder_ == null) {
        billing_ = null;
        onChanged();
      } else {
        billing_ = null;
        billingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public com.google.storage.v2.Bucket.Billing.Builder getBillingBuilder() {

      onChanged();
      return getBillingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    public com.google.storage.v2.Bucket.BillingOrBuilder getBillingOrBuilder() {
      if (billingBuilder_ != null) {
        return billingBuilder_.getMessageOrBuilder();
      } else {
        return billing_ == null
            ? com.google.storage.v2.Bucket.Billing.getDefaultInstance()
            : billing_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's billing config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.Billing billing = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.Billing,
            com.google.storage.v2.Bucket.Billing.Builder,
            com.google.storage.v2.Bucket.BillingOrBuilder>
        getBillingFieldBuilder() {
      if (billingBuilder_ == null) {
        billingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Billing,
                com.google.storage.v2.Bucket.Billing.Builder,
                com.google.storage.v2.Bucket.BillingOrBuilder>(
                getBilling(), getParentForChildren(), isClean());
        billing_ = null;
      }
      return billingBuilder_;
    }

    private com.google.storage.v2.Bucket.RetentionPolicy retentionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.RetentionPolicy,
            com.google.storage.v2.Bucket.RetentionPolicy.Builder,
            com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>
        retentionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     *
     * @return Whether the retentionPolicy field is set.
     */
    public boolean hasRetentionPolicy() {
      return retentionPolicyBuilder_ != null || retentionPolicy_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     *
     * @return The retentionPolicy.
     */
    public com.google.storage.v2.Bucket.RetentionPolicy getRetentionPolicy() {
      if (retentionPolicyBuilder_ == null) {
        return retentionPolicy_ == null
            ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      } else {
        return retentionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder setRetentionPolicy(com.google.storage.v2.Bucket.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionPolicy_ = value;
        onChanged();
      } else {
        retentionPolicyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder setRetentionPolicy(
        com.google.storage.v2.Bucket.RetentionPolicy.Builder builderForValue) {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = builderForValue.build();
        onChanged();
      } else {
        retentionPolicyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder mergeRetentionPolicy(com.google.storage.v2.Bucket.RetentionPolicy value) {
      if (retentionPolicyBuilder_ == null) {
        if (retentionPolicy_ != null) {
          retentionPolicy_ =
              com.google.storage.v2.Bucket.RetentionPolicy.newBuilder(retentionPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          retentionPolicy_ = value;
        }
        onChanged();
      } else {
        retentionPolicyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public Builder clearRetentionPolicy() {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicy_ = null;
        onChanged();
      } else {
        retentionPolicy_ = null;
        retentionPolicyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public com.google.storage.v2.Bucket.RetentionPolicy.Builder getRetentionPolicyBuilder() {

      onChanged();
      return getRetentionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    public com.google.storage.v2.Bucket.RetentionPolicyOrBuilder getRetentionPolicyOrBuilder() {
      if (retentionPolicyBuilder_ != null) {
        return retentionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retentionPolicy_ == null
            ? com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()
            : retentionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's retention policy. The retention policy enforces a minimum
     * retention time for all objects contained in the bucket, based on their
     * creation time. Any attempt to overwrite or delete objects younger than the
     * retention period will result in a PERMISSION_DENIED error.  An unlocked
     * retention policy can be modified or removed from the bucket via a
     * storage.buckets.update operation. A locked retention policy cannot be
     * removed or shortened in duration for the lifetime of the bucket.
     * Attempting to remove or decrease period of a locked retention policy will
     * result in a PERMISSION_DENIED error.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.RetentionPolicy retention_policy = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.RetentionPolicy,
            com.google.storage.v2.Bucket.RetentionPolicy.Builder,
            com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>
        getRetentionPolicyFieldBuilder() {
      if (retentionPolicyBuilder_ == null) {
        retentionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.RetentionPolicy,
                com.google.storage.v2.Bucket.RetentionPolicy.Builder,
                com.google.storage.v2.Bucket.RetentionPolicyOrBuilder>(
                getRetentionPolicy(), getParentForChildren(), isClean());
        retentionPolicy_ = null;
      }
      return retentionPolicyBuilder_;
    }

    private com.google.storage.v2.Bucket.IamConfig iamConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.IamConfig,
            com.google.storage.v2.Bucket.IamConfig.Builder,
            com.google.storage.v2.Bucket.IamConfigOrBuilder>
        iamConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     *
     * @return Whether the iamConfig field is set.
     */
    public boolean hasIamConfig() {
      return iamConfigBuilder_ != null || iamConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     *
     * @return The iamConfig.
     */
    public com.google.storage.v2.Bucket.IamConfig getIamConfig() {
      if (iamConfigBuilder_ == null) {
        return iamConfig_ == null
            ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
            : iamConfig_;
      } else {
        return iamConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder setIamConfig(com.google.storage.v2.Bucket.IamConfig value) {
      if (iamConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        iamConfig_ = value;
        onChanged();
      } else {
        iamConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder setIamConfig(com.google.storage.v2.Bucket.IamConfig.Builder builderForValue) {
      if (iamConfigBuilder_ == null) {
        iamConfig_ = builderForValue.build();
        onChanged();
      } else {
        iamConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder mergeIamConfig(com.google.storage.v2.Bucket.IamConfig value) {
      if (iamConfigBuilder_ == null) {
        if (iamConfig_ != null) {
          iamConfig_ =
              com.google.storage.v2.Bucket.IamConfig.newBuilder(iamConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          iamConfig_ = value;
        }
        onChanged();
      } else {
        iamConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public Builder clearIamConfig() {
      if (iamConfigBuilder_ == null) {
        iamConfig_ = null;
        onChanged();
      } else {
        iamConfig_ = null;
        iamConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public com.google.storage.v2.Bucket.IamConfig.Builder getIamConfigBuilder() {

      onChanged();
      return getIamConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    public com.google.storage.v2.Bucket.IamConfigOrBuilder getIamConfigOrBuilder() {
      if (iamConfigBuilder_ != null) {
        return iamConfigBuilder_.getMessageOrBuilder();
      } else {
        return iamConfig_ == null
            ? com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()
            : iamConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bucket's IAM config.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket.IamConfig iam_config = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket.IamConfig,
            com.google.storage.v2.Bucket.IamConfig.Builder,
            com.google.storage.v2.Bucket.IamConfigOrBuilder>
        getIamConfigFieldBuilder() {
      if (iamConfigBuilder_ == null) {
        iamConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.IamConfig,
                com.google.storage.v2.Bucket.IamConfig.Builder,
                com.google.storage.v2.Bucket.IamConfigOrBuilder>(
                getIamConfig(), getParentForChildren(), isClean());
        iamConfig_ = null;
      }
      return iamConfigBuilder_;
    }

    private com.google.protobuf.LazyStringList zoneAffinity_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureZoneAffinityIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        zoneAffinity_ = new com.google.protobuf.LazyStringArrayList(zoneAffinity_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the zoneAffinity.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getZoneAffinityList() {
      return zoneAffinity_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The count of zoneAffinity.
     */
    @java.lang.Deprecated
    public int getZoneAffinityCount() {
      return zoneAffinity_.size();
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The zoneAffinity at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getZoneAffinity(int index) {
      return zoneAffinity_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the zoneAffinity at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getZoneAffinityBytes(int index) {
      return zoneAffinity_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The zoneAffinity to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setZoneAffinity(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZoneAffinityIsMutable();
      zoneAffinity_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The zoneAffinity to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addZoneAffinity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZoneAffinityIsMutable();
      zoneAffinity_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The zoneAffinity to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllZoneAffinity(java.lang.Iterable<java.lang.String> values) {
      ensureZoneAffinityIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, zoneAffinity_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearZoneAffinity() {
      zoneAffinity_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The zone or zones from which the bucket is intended to use zonal quota.
     * Requests for data from outside the specified affinities are still allowed
     * but won't be able to use zonal quota. The values are case-insensitive.
     * Attempting to update this field after bucket is created will result in an
     * error.
     * </pre>
     *
     * <code>
     * repeated string zone_affinity = 24 [deprecated = true, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes of the zoneAffinity to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addZoneAffinityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureZoneAffinityIsMutable();
      zoneAffinity_.add(value);
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {

      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket)
  private static final com.google.storage.v2.Bucket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.Bucket();
  }

  public static com.google.storage.v2.Bucket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Bucket> PARSER =
      new com.google.protobuf.AbstractParser<Bucket>() {
        @java.lang.Override
        public Bucket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Bucket(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Bucket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Bucket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.Bucket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
