/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * Request message to update the `IntelligenceConfig` resource associated with
 * your organization.
 *
 * **IAM Permissions**:
 *
 * Requires `storage.intelligenceConfigs.update`
 * [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on
 * the organization.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest}
 */
public final class UpdateOrganizationIntelligenceConfigRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest)
    UpdateOrganizationIntelligenceConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UpdateOrganizationIntelligenceConfigRequest.newBuilder() to construct.
  private UpdateOrganizationIntelligenceConfigRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateOrganizationIntelligenceConfigRequest() {
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateOrganizationIntelligenceConfigRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_UpdateOrganizationIntelligenceConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_UpdateOrganizationIntelligenceConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest.class,
            com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int INTELLIGENCE_CONFIG_FIELD_NUMBER = 1;
  private com.google.storage.control.v2.IntelligenceConfig intelligenceConfig_;

  /**
   *
   *
   * <pre>
   * Required. The `IntelligenceConfig` resource to be updated.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the intelligenceConfig field is set.
   */
  @java.lang.Override
  public boolean hasIntelligenceConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The `IntelligenceConfig` resource to be updated.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The intelligenceConfig.
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfig getIntelligenceConfig() {
    return intelligenceConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance()
        : intelligenceConfig_;
  }

  /**
   *
   *
   * <pre>
   * Required. The `IntelligenceConfig` resource to be updated.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.IntelligenceConfigOrBuilder
      getIntelligenceConfigOrBuilder() {
    return intelligenceConfig_ == null
        ? com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance()
        : intelligenceConfig_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 2;
  private com.google.protobuf.FieldMask updateMask_;

  /**
   *
   *
   * <pre>
   * Required. The `update_mask` that specifies the fields within the
   * `IntelligenceConfig` resource that should be modified by this update. Only
   * the listed fields are updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The `update_mask` that specifies the fields within the
   * `IntelligenceConfig` resource that should be modified by this update. Only
   * the listed fields are updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  /**
   *
   *
   * <pre>
   * Required. The `update_mask` that specifies the fields within the
   * `IntelligenceConfig` resource that should be modified by this update. Only
   * the listed fields are updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The ID that uniquely identifies the request, preventing duplicate
   * processing.
   * </pre>
   *
   * <code>
   * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The ID that uniquely identifies the request, preventing duplicate
   * processing.
   * </pre>
   *
   * <code>
   * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getIntelligenceConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIntelligenceConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest other =
        (com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest) obj;

    if (hasIntelligenceConfig() != other.hasIntelligenceConfig()) return false;
    if (hasIntelligenceConfig()) {
      if (!getIntelligenceConfig().equals(other.getIntelligenceConfig())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIntelligenceConfig()) {
      hash = (37 * hash) + INTELLIGENCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIntelligenceConfig().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message to update the `IntelligenceConfig` resource associated with
   * your organization.
   *
   * **IAM Permissions**:
   *
   * Requires `storage.intelligenceConfigs.update`
   * [IAM](https://cloud.google.com/iam/docs/overview#permissions) permission on
   * the organization.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest)
      com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_UpdateOrganizationIntelligenceConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_UpdateOrganizationIntelligenceConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest.class,
              com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIntelligenceConfigFieldBuilder();
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      intelligenceConfig_ = null;
      if (intelligenceConfigBuilder_ != null) {
        intelligenceConfigBuilder_.dispose();
        intelligenceConfigBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_UpdateOrganizationIntelligenceConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
        getDefaultInstanceForType() {
      return com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest build() {
      com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
        buildPartial() {
      com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest result =
          new com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.intelligenceConfig_ =
            intelligenceConfigBuilder_ == null
                ? intelligenceConfig_
                : intelligenceConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest) {
        return mergeFrom(
            (com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest other) {
      if (other
          == com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
              .getDefaultInstance()) return this;
      if (other.hasIntelligenceConfig()) {
        mergeIntelligenceConfig(other.getIntelligenceConfig());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getIntelligenceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.control.v2.IntelligenceConfig intelligenceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig,
            com.google.storage.control.v2.IntelligenceConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfigOrBuilder>
        intelligenceConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the intelligenceConfig field is set.
     */
    public boolean hasIntelligenceConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The intelligenceConfig.
     */
    public com.google.storage.control.v2.IntelligenceConfig getIntelligenceConfig() {
      if (intelligenceConfigBuilder_ == null) {
        return intelligenceConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance()
            : intelligenceConfig_;
      } else {
        return intelligenceConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setIntelligenceConfig(com.google.storage.control.v2.IntelligenceConfig value) {
      if (intelligenceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intelligenceConfig_ = value;
      } else {
        intelligenceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setIntelligenceConfig(
        com.google.storage.control.v2.IntelligenceConfig.Builder builderForValue) {
      if (intelligenceConfigBuilder_ == null) {
        intelligenceConfig_ = builderForValue.build();
      } else {
        intelligenceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeIntelligenceConfig(com.google.storage.control.v2.IntelligenceConfig value) {
      if (intelligenceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && intelligenceConfig_ != null
            && intelligenceConfig_
                != com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance()) {
          getIntelligenceConfigBuilder().mergeFrom(value);
        } else {
          intelligenceConfig_ = value;
        }
      } else {
        intelligenceConfigBuilder_.mergeFrom(value);
      }
      if (intelligenceConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearIntelligenceConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      intelligenceConfig_ = null;
      if (intelligenceConfigBuilder_ != null) {
        intelligenceConfigBuilder_.dispose();
        intelligenceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfig.Builder getIntelligenceConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getIntelligenceConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.control.v2.IntelligenceConfigOrBuilder
        getIntelligenceConfigOrBuilder() {
      if (intelligenceConfigBuilder_ != null) {
        return intelligenceConfigBuilder_.getMessageOrBuilder();
      } else {
        return intelligenceConfig_ == null
            ? com.google.storage.control.v2.IntelligenceConfig.getDefaultInstance()
            : intelligenceConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The `IntelligenceConfig` resource to be updated.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.IntelligenceConfig intelligence_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.IntelligenceConfig,
            com.google.storage.control.v2.IntelligenceConfig.Builder,
            com.google.storage.control.v2.IntelligenceConfigOrBuilder>
        getIntelligenceConfigFieldBuilder() {
      if (intelligenceConfigBuilder_ == null) {
        intelligenceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.IntelligenceConfig,
                com.google.storage.control.v2.IntelligenceConfig.Builder,
                com.google.storage.control.v2.IntelligenceConfigOrBuilder>(
                getIntelligenceConfig(), getParentForChildren(), isClean());
        intelligenceConfig_ = null;
      }
      return intelligenceConfigBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The `update_mask` that specifies the fields within the
     * `IntelligenceConfig` resource that should be modified by this update. Only
     * the listed fields are updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private java.lang.Object requestId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The ID that uniquely identifies the request, preventing duplicate
     * processing.
     * </pre>
     *
     * <code>
     * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The ID that uniquely identifies the request, preventing duplicate
     * processing.
     * </pre>
     *
     * <code>
     * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The ID that uniquely identifies the request, preventing duplicate
     * processing.
     * </pre>
     *
     * <code>
     * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The ID that uniquely identifies the request, preventing duplicate
     * processing.
     * </pre>
     *
     * <code>
     * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The ID that uniquely identifies the request, preventing duplicate
     * processing.
     * </pre>
     *
     * <code>
     * string request_id = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest)
  private static final com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest();
  }

  public static com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateOrganizationIntelligenceConfigRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<UpdateOrganizationIntelligenceConfigRequest>() {
            @java.lang.Override
            public UpdateOrganizationIntelligenceConfigRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<UpdateOrganizationIntelligenceConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateOrganizationIntelligenceConfigRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
