/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * The storage layout configuration of a bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.StorageLayout}
 */
public final class StorageLayout extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.StorageLayout)
    StorageLayoutOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StorageLayout.newBuilder() to construct.
  private StorageLayout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StorageLayout() {
    name_ = "";
    location_ = "";
    locationType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StorageLayout();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_StorageLayout_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_StorageLayout_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.StorageLayout.class,
            com.google.storage.control.v2.StorageLayout.Builder.class);
  }

  public interface CustomPlacementConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.control.v2.StorageLayout.CustomPlacementConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return A list containing the dataLocations.
     */
    java.util.List<java.lang.String> getDataLocationsList();

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return The count of dataLocations.
     */
    int getDataLocationsCount();

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    java.lang.String getDataLocations(int index);

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    com.google.protobuf.ByteString getDataLocationsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Configuration for Custom Dual Regions.  It should specify precisely two
   * eligible regions within the same Multiregion. More information on regions
   * may be found [here](https://cloud.google.com/storage/docs/locations).
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.StorageLayout.CustomPlacementConfig}
   */
  public static final class CustomPlacementConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.control.v2.StorageLayout.CustomPlacementConfig)
      CustomPlacementConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CustomPlacementConfig.newBuilder() to construct.
    private CustomPlacementConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomPlacementConfig() {
      dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomPlacementConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_CustomPlacementConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_CustomPlacementConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.class,
              com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder.class);
    }

    public static final int DATA_LOCATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList dataLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return A list containing the dataLocations.
     */
    public com.google.protobuf.ProtocolStringList getDataLocationsList() {
      return dataLocations_;
    }

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @return The count of dataLocations.
     */
    public int getDataLocationsCount() {
      return dataLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    public java.lang.String getDataLocations(int index) {
      return dataLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
      return dataLocations_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dataLocations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataLocations_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < dataLocations_.size(); i++) {
          dataSize += computeStringSizeNoTag(dataLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDataLocationsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.control.v2.StorageLayout.CustomPlacementConfig)) {
        return super.equals(obj);
      }
      com.google.storage.control.v2.StorageLayout.CustomPlacementConfig other =
          (com.google.storage.control.v2.StorageLayout.CustomPlacementConfig) obj;

      if (!getDataLocationsList().equals(other.getDataLocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDataLocationsCount() > 0) {
        hash = (37 * hash) + DATA_LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDataLocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for Custom Dual Regions.  It should specify precisely two
     * eligible regions within the same Multiregion. More information on regions
     * may be found [here](https://cloud.google.com/storage/docs/locations).
     * </pre>
     *
     * Protobuf type {@code google.storage.control.v2.StorageLayout.CustomPlacementConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.control.v2.StorageLayout.CustomPlacementConfig)
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_CustomPlacementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.class,
                com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder.class);
      }

      // Construct using
      // com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
          getDefaultInstanceForType() {
        return com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig build() {
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig buildPartial() {
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig result =
            new com.google.storage.control.v2.StorageLayout.CustomPlacementConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.storage.control.v2.StorageLayout.CustomPlacementConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          dataLocations_.makeImmutable();
          result.dataLocations_ = dataLocations_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.control.v2.StorageLayout.CustomPlacementConfig) {
          return mergeFrom(
              (com.google.storage.control.v2.StorageLayout.CustomPlacementConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storage.control.v2.StorageLayout.CustomPlacementConfig other) {
        if (other
            == com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
                .getDefaultInstance()) return this;
        if (!other.dataLocations_.isEmpty()) {
          if (dataLocations_.isEmpty()) {
            dataLocations_ = other.dataLocations_;
            bitField0_ |= 0x00000001;
          } else {
            ensureDataLocationsIsMutable();
            dataLocations_.addAll(other.dataLocations_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDataLocationsIsMutable();
                  dataLocations_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList dataLocations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDataLocationsIsMutable() {
        if (!dataLocations_.isModifiable()) {
          dataLocations_ = new com.google.protobuf.LazyStringArrayList(dataLocations_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return A list containing the dataLocations.
       */
      public com.google.protobuf.ProtocolStringList getDataLocationsList() {
        dataLocations_.makeImmutable();
        return dataLocations_;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return The count of dataLocations.
       */
      public int getDataLocationsCount() {
        return dataLocations_.size();
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The dataLocations at the given index.
       */
      public java.lang.String getDataLocations(int index) {
        return dataLocations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dataLocations at the given index.
       */
      public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
        return dataLocations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The dataLocations to set.
       * @return This builder for chaining.
       */
      public Builder setDataLocations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param value The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param values The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllDataLocations(java.lang.Iterable<java.lang.String> values) {
        ensureDataLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataLocations_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataLocations() {
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1;</code>
       *
       * @param value The bytes of the dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.control.v2.StorageLayout.CustomPlacementConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.control.v2.StorageLayout.CustomPlacementConfig)
    private static final com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.control.v2.StorageLayout.CustomPlacementConfig();
    }

    public static com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomPlacementConfig> PARSER =
        new com.google.protobuf.AbstractParser<CustomPlacementConfig>() {
          @java.lang.Override
          public CustomPlacementConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomPlacementConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomPlacementConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HierarchicalNamespaceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.control.v2.StorageLayout.HierarchicalNamespace)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enables the hierarchical namespace feature.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }

  /**
   *
   *
   * <pre>
   * Configuration for a bucket's hierarchical namespace feature.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.StorageLayout.HierarchicalNamespace}
   */
  public static final class HierarchicalNamespace extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.control.v2.StorageLayout.HierarchicalNamespace)
      HierarchicalNamespaceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use HierarchicalNamespace.newBuilder() to construct.
    private HierarchicalNamespace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HierarchicalNamespace() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HierarchicalNamespace();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_HierarchicalNamespace_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_HierarchicalNamespace_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.class,
              com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;

    /**
     *
     *
     * <pre>
     * Enables the hierarchical namespace feature.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.control.v2.StorageLayout.HierarchicalNamespace)) {
        return super.equals(obj);
      }
      com.google.storage.control.v2.StorageLayout.HierarchicalNamespace other =
          (com.google.storage.control.v2.StorageLayout.HierarchicalNamespace) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for a bucket's hierarchical namespace feature.
     * </pre>
     *
     * Protobuf type {@code google.storage.control.v2.StorageLayout.HierarchicalNamespace}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.control.v2.StorageLayout.HierarchicalNamespace)
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_HierarchicalNamespace_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_HierarchicalNamespace_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.class,
                com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder.class);
      }

      // Construct using
      // com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.control.v2.StorageControlProto
            .internal_static_google_storage_control_v2_StorageLayout_HierarchicalNamespace_descriptor;
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
          getDefaultInstanceForType() {
        return com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace build() {
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace buildPartial() {
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace result =
            new com.google.storage.control.v2.StorageLayout.HierarchicalNamespace(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.storage.control.v2.StorageLayout.HierarchicalNamespace result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.control.v2.StorageLayout.HierarchicalNamespace) {
          return mergeFrom(
              (com.google.storage.control.v2.StorageLayout.HierarchicalNamespace) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storage.control.v2.StorageLayout.HierarchicalNamespace other) {
        if (other
            == com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;

      /**
       *
       *
       * <pre>
       * Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      /**
       *
       *
       * <pre>
       * Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Enables the hierarchical namespace feature.
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.control.v2.StorageLayout.HierarchicalNamespace)
    }

    // @@protoc_insertion_point(class_scope:google.storage.control.v2.StorageLayout.HierarchicalNamespace)
    private static final com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.control.v2.StorageLayout.HierarchicalNamespace();
    }

    public static com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HierarchicalNamespace> PARSER =
        new com.google.protobuf.AbstractParser<HierarchicalNamespace>() {
          @java.lang.Override
          public HierarchicalNamespace parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HierarchicalNamespace> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HierarchicalNamespace> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The name of the StorageLayout resource.
   * Format: `projects/{project}/buckets/{bucket}/storageLayout`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The name of the StorageLayout resource.
   * Format: `projects/{project}/buckets/{bucket}/storageLayout`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The location of the bucket.
   * </pre>
   *
   * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The location of the bucket.
   * </pre>
   *
   * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationType_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The locationType.
   */
  @java.lang.Override
  public java.lang.String getLocationType() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The location type of the bucket (region, dual-region,
   * multi-region, etc).
   * </pre>
   *
   * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for locationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationTypeBytes() {
    java.lang.Object ref = locationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_PLACEMENT_CONFIG_FIELD_NUMBER = 4;
  private com.google.storage.control.v2.StorageLayout.CustomPlacementConfig customPlacementConfig_;

  /**
   *
   *
   * <pre>
   * Output only. The data placement configuration for custom dual region. If
   * there is no configuration, this is not a custom dual region bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the customPlacementConfig field is set.
   */
  @java.lang.Override
  public boolean hasCustomPlacementConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The data placement configuration for custom dual region. If
   * there is no configuration, this is not a custom dual region bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The customPlacementConfig.
   */
  @java.lang.Override
  public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
      getCustomPlacementConfig() {
    return customPlacementConfig_ == null
        ? com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.getDefaultInstance()
        : customPlacementConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The data placement configuration for custom dual region. If
   * there is no configuration, this is not a custom dual region bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder
      getCustomPlacementConfigOrBuilder() {
    return customPlacementConfig_ == null
        ? com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.getDefaultInstance()
        : customPlacementConfig_;
  }

  public static final int HIERARCHICAL_NAMESPACE_FIELD_NUMBER = 5;
  private com.google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchicalNamespace_;

  /**
   *
   *
   * <pre>
   * Output only. The bucket's hierarchical namespace configuration. If there is
   * no configuration, the hierarchical namespace is disabled.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the hierarchicalNamespace field is set.
   */
  @java.lang.Override
  public boolean hasHierarchicalNamespace() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The bucket's hierarchical namespace configuration. If there is
   * no configuration, the hierarchical namespace is disabled.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The hierarchicalNamespace.
   */
  @java.lang.Override
  public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
      getHierarchicalNamespace() {
    return hierarchicalNamespace_ == null
        ? com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.getDefaultInstance()
        : hierarchicalNamespace_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The bucket's hierarchical namespace configuration. If there is
   * no configuration, the hierarchical namespace is disabled.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder
      getHierarchicalNamespaceOrBuilder() {
    return hierarchicalNamespace_ == null
        ? com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.getDefaultInstance()
        : hierarchicalNamespace_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, locationType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCustomPlacementConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getHierarchicalNamespace());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, locationType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCustomPlacementConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getHierarchicalNamespace());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.StorageLayout)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.StorageLayout other =
        (com.google.storage.control.v2.StorageLayout) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getLocationType().equals(other.getLocationType())) return false;
    if (hasCustomPlacementConfig() != other.hasCustomPlacementConfig()) return false;
    if (hasCustomPlacementConfig()) {
      if (!getCustomPlacementConfig().equals(other.getCustomPlacementConfig())) return false;
    }
    if (hasHierarchicalNamespace() != other.hasHierarchicalNamespace()) return false;
    if (hasHierarchicalNamespace()) {
      if (!getHierarchicalNamespace().equals(other.getHierarchicalNamespace())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + LOCATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getLocationType().hashCode();
    if (hasCustomPlacementConfig()) {
      hash = (37 * hash) + CUSTOM_PLACEMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCustomPlacementConfig().hashCode();
    }
    if (hasHierarchicalNamespace()) {
      hash = (37 * hash) + HIERARCHICAL_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getHierarchicalNamespace().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.StorageLayout parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.StorageLayout parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.StorageLayout parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.control.v2.StorageLayout prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The storage layout configuration of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.StorageLayout}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.StorageLayout)
      com.google.storage.control.v2.StorageLayoutOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.StorageLayout.class,
              com.google.storage.control.v2.StorageLayout.Builder.class);
    }

    // Construct using com.google.storage.control.v2.StorageLayout.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomPlacementConfigFieldBuilder();
        getHierarchicalNamespaceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      location_ = "";
      locationType_ = "";
      customPlacementConfig_ = null;
      if (customPlacementConfigBuilder_ != null) {
        customPlacementConfigBuilder_.dispose();
        customPlacementConfigBuilder_ = null;
      }
      hierarchicalNamespace_ = null;
      if (hierarchicalNamespaceBuilder_ != null) {
        hierarchicalNamespaceBuilder_.dispose();
        hierarchicalNamespaceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_StorageLayout_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.StorageLayout getDefaultInstanceForType() {
      return com.google.storage.control.v2.StorageLayout.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.StorageLayout build() {
      com.google.storage.control.v2.StorageLayout result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.StorageLayout buildPartial() {
      com.google.storage.control.v2.StorageLayout result =
          new com.google.storage.control.v2.StorageLayout(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.StorageLayout result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.locationType_ = locationType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.customPlacementConfig_ =
            customPlacementConfigBuilder_ == null
                ? customPlacementConfig_
                : customPlacementConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.hierarchicalNamespace_ =
            hierarchicalNamespaceBuilder_ == null
                ? hierarchicalNamespace_
                : hierarchicalNamespaceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.StorageLayout) {
        return mergeFrom((com.google.storage.control.v2.StorageLayout) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.StorageLayout other) {
      if (other == com.google.storage.control.v2.StorageLayout.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getLocationType().isEmpty()) {
        locationType_ = other.locationType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCustomPlacementConfig()) {
        mergeCustomPlacementConfig(other.getCustomPlacementConfig());
      }
      if (other.hasHierarchicalNamespace()) {
        mergeHierarchicalNamespace(other.getHierarchicalNamespace());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                locationType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getCustomPlacementConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getHierarchicalNamespaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The name of the StorageLayout resource.
     * Format: `projects/{project}/buckets/{bucket}/storageLayout`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The name of the StorageLayout resource.
     * Format: `projects/{project}/buckets/{bucket}/storageLayout`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The name of the StorageLayout resource.
     * Format: `projects/{project}/buckets/{bucket}/storageLayout`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The name of the StorageLayout resource.
     * Format: `projects/{project}/buckets/{bucket}/storageLayout`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The name of the StorageLayout resource.
     * Format: `projects/{project}/buckets/{bucket}/storageLayout`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The location of the bucket.
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The location of the bucket.
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The location of the bucket.
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The location of the bucket.
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The location of the bucket.
     * </pre>
     *
     * <code>string location = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object locationType_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The locationType.
     */
    public java.lang.String getLocationType() {
      java.lang.Object ref = locationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for locationType.
     */
    public com.google.protobuf.ByteString getLocationTypeBytes() {
      java.lang.Object ref = locationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationType() {
      locationType_ = getDefaultInstance().getLocationType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The location type of the bucket (region, dual-region,
     * multi-region, etc).
     * </pre>
     *
     * <code>string location_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for locationType to set.
     * @return This builder for chaining.
     */
    public Builder setLocationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        customPlacementConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfig,
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder,
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder>
        customPlacementConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the customPlacementConfig field is set.
     */
    public boolean hasCustomPlacementConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The customPlacementConfig.
     */
    public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
        getCustomPlacementConfig() {
      if (customPlacementConfigBuilder_ == null) {
        return customPlacementConfig_ == null
            ? com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.getDefaultInstance()
            : customPlacementConfig_;
      } else {
        return customPlacementConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomPlacementConfig(
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig value) {
      if (customPlacementConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customPlacementConfig_ = value;
      } else {
        customPlacementConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomPlacementConfig(
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder builderForValue) {
      if (customPlacementConfigBuilder_ == null) {
        customPlacementConfig_ = builderForValue.build();
      } else {
        customPlacementConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCustomPlacementConfig(
        com.google.storage.control.v2.StorageLayout.CustomPlacementConfig value) {
      if (customPlacementConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && customPlacementConfig_ != null
            && customPlacementConfig_
                != com.google.storage.control.v2.StorageLayout.CustomPlacementConfig
                    .getDefaultInstance()) {
          getCustomPlacementConfigBuilder().mergeFrom(value);
        } else {
          customPlacementConfig_ = value;
        }
      } else {
        customPlacementConfigBuilder_.mergeFrom(value);
      }
      if (customPlacementConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCustomPlacementConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      customPlacementConfig_ = null;
      if (customPlacementConfigBuilder_ != null) {
        customPlacementConfigBuilder_.dispose();
        customPlacementConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder
        getCustomPlacementConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCustomPlacementConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder
        getCustomPlacementConfigOrBuilder() {
      if (customPlacementConfigBuilder_ != null) {
        return customPlacementConfigBuilder_.getMessageOrBuilder();
      } else {
        return customPlacementConfig_ == null
            ? com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.getDefaultInstance()
            : customPlacementConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The data placement configuration for custom dual region. If
     * there is no configuration, this is not a custom dual region bucket.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.CustomPlacementConfig custom_placement_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfig,
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder,
            com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder>
        getCustomPlacementConfigFieldBuilder() {
      if (customPlacementConfigBuilder_ == null) {
        customPlacementConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.StorageLayout.CustomPlacementConfig,
                com.google.storage.control.v2.StorageLayout.CustomPlacementConfig.Builder,
                com.google.storage.control.v2.StorageLayout.CustomPlacementConfigOrBuilder>(
                getCustomPlacementConfig(), getParentForChildren(), isClean());
        customPlacementConfig_ = null;
      }
      return customPlacementConfigBuilder_;
    }

    private com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        hierarchicalNamespace_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespace,
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder,
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder>
        hierarchicalNamespaceBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the hierarchicalNamespace field is set.
     */
    public boolean hasHierarchicalNamespace() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The hierarchicalNamespace.
     */
    public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
        getHierarchicalNamespace() {
      if (hierarchicalNamespaceBuilder_ == null) {
        return hierarchicalNamespace_ == null
            ? com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.getDefaultInstance()
            : hierarchicalNamespace_;
      } else {
        return hierarchicalNamespaceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHierarchicalNamespace(
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace value) {
      if (hierarchicalNamespaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hierarchicalNamespace_ = value;
      } else {
        hierarchicalNamespaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHierarchicalNamespace(
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder builderForValue) {
      if (hierarchicalNamespaceBuilder_ == null) {
        hierarchicalNamespace_ = builderForValue.build();
      } else {
        hierarchicalNamespaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeHierarchicalNamespace(
        com.google.storage.control.v2.StorageLayout.HierarchicalNamespace value) {
      if (hierarchicalNamespaceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && hierarchicalNamespace_ != null
            && hierarchicalNamespace_
                != com.google.storage.control.v2.StorageLayout.HierarchicalNamespace
                    .getDefaultInstance()) {
          getHierarchicalNamespaceBuilder().mergeFrom(value);
        } else {
          hierarchicalNamespace_ = value;
        }
      } else {
        hierarchicalNamespaceBuilder_.mergeFrom(value);
      }
      if (hierarchicalNamespace_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearHierarchicalNamespace() {
      bitField0_ = (bitField0_ & ~0x00000010);
      hierarchicalNamespace_ = null;
      if (hierarchicalNamespaceBuilder_ != null) {
        hierarchicalNamespaceBuilder_.dispose();
        hierarchicalNamespaceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder
        getHierarchicalNamespaceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getHierarchicalNamespaceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder
        getHierarchicalNamespaceOrBuilder() {
      if (hierarchicalNamespaceBuilder_ != null) {
        return hierarchicalNamespaceBuilder_.getMessageOrBuilder();
      } else {
        return hierarchicalNamespace_ == null
            ? com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.getDefaultInstance()
            : hierarchicalNamespace_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The bucket's hierarchical namespace configuration. If there is
     * no configuration, the hierarchical namespace is disabled.
     * </pre>
     *
     * <code>
     * .google.storage.control.v2.StorageLayout.HierarchicalNamespace hierarchical_namespace = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespace,
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder,
            com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder>
        getHierarchicalNamespaceFieldBuilder() {
      if (hierarchicalNamespaceBuilder_ == null) {
        hierarchicalNamespaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.control.v2.StorageLayout.HierarchicalNamespace,
                com.google.storage.control.v2.StorageLayout.HierarchicalNamespace.Builder,
                com.google.storage.control.v2.StorageLayout.HierarchicalNamespaceOrBuilder>(
                getHierarchicalNamespace(), getParentForChildren(), isClean());
        hierarchicalNamespace_ = null;
      }
      return hierarchicalNamespaceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.StorageLayout)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.StorageLayout)
  private static final com.google.storage.control.v2.StorageLayout DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.StorageLayout();
  }

  public static com.google.storage.control.v2.StorageLayout getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StorageLayout> PARSER =
      new com.google.protobuf.AbstractParser<StorageLayout>() {
        @java.lang.Override
        public StorageLayout parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StorageLayout> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StorageLayout> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.StorageLayout getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
