/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

public interface IntelligenceConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.control.v2.IntelligenceConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. The name of the `IntelligenceConfig` resource associated with
   * your organization, folder, or project.
   *
   * The name format varies based on the GCP resource hierarchy as follows:
   *
   * * For project:
   * `projects/{project_number}/locations/global/intelligenceConfig`
   * * For organization:
   * `organizations/{org_id}/locations/global/intelligenceConfig`
   * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. The name of the `IntelligenceConfig` resource associated with
   * your organization, folder, or project.
   *
   * The name format varies based on the GCP resource hierarchy as follows:
   *
   * * For project:
   * `projects/{project_number}/locations/global/intelligenceConfig`
   * * For organization:
   * `organizations/{org_id}/locations/global/intelligenceConfig`
   * * For folder: `folders/{folder_id}/locations/global/intelligenceConfig`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. The edition configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for editionConfig.
   */
  int getEditionConfigValue();

  /**
   *
   *
   * <pre>
   * Optional. The edition configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EditionConfig edition_config = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The editionConfig.
   */
  com.google.storage.control.v2.IntelligenceConfig.EditionConfig getEditionConfig();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the `IntelligenceConfig` resource is last
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  boolean hasFilter();

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filter.
   */
  com.google.storage.control.v2.IntelligenceConfig.Filter getFilter();

  /**
   *
   *
   * <pre>
   * Optional. Filter over location and bucket.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.Filter filter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.control.v2.IntelligenceConfig.FilterOrBuilder getFilterOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the effectiveIntelligenceConfig field is set.
   */
  boolean hasEffectiveIntelligenceConfig();

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The effectiveIntelligenceConfig.
   */
  com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig
      getEffectiveIntelligenceConfig();

  /**
   *
   *
   * <pre>
   * Output only. The `IntelligenceConfig` resource that is applicable for the
   * resource.
   * </pre>
   *
   * <code>
   * .google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfig effective_intelligence_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.storage.control.v2.IntelligenceConfig.EffectiveIntelligenceConfigOrBuilder
      getEffectiveIntelligenceConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   *
   * @return Whether the trialConfig field is set.
   */
  boolean hasTrialConfig();

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   *
   * @return The trialConfig.
   */
  com.google.storage.control.v2.IntelligenceConfig.TrialConfig getTrialConfig();

  /**
   *
   *
   * <pre>
   * The trial configuration of the `IntelligenceConfig` resource.
   * </pre>
   *
   * <code>.google.storage.control.v2.IntelligenceConfig.TrialConfig trial_config = 7;</code>
   */
  com.google.storage.control.v2.IntelligenceConfig.TrialConfigOrBuilder getTrialConfigOrBuilder();
}
