/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/config");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;

    @Deprecated
    protected ConfigName() {
        this.project = null;
        this.location = null;
    }

    private ConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConfigName of(String project, String location) {
        return ConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return ConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static ConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION.validatedMatch(formattedString, "ConfigName.parse: formattedString not in valid format");
        return ConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"));
    }

    public static List<ConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ConfigName> list = new ArrayList<ConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConfigName configName = this;
            synchronized (configName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION.instantiate(new String[]{"project", this.project, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConfigName that = (ConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(ConfigName configName) {
            this.project = configName.project;
            this.location = configName.location;
        }

        public ConfigName build() {
            return new ConfigName(this);
        }
    }
}

