/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1p1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PhraseSetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/phraseSets/{phrase_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String phraseSet;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPhraseSet() {
        return this.phraseSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PhraseSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.phraseSet = (String)Preconditions.checkNotNull((Object)builder.getPhraseSet());
    }

    public static PhraseSetName of(String project, String location, String phraseSet) {
        return PhraseSetName.newBuilder().setProject(project).setLocation(location).setPhraseSet(phraseSet).build();
    }

    public static String format(String project, String location, String phraseSet) {
        return PhraseSetName.newBuilder().setProject(project).setLocation(location).setPhraseSet(phraseSet).build().toString();
    }

    public static PhraseSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "PhraseSetName.parse: formattedString not in valid format");
        return PhraseSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("phrase_set"));
    }

    public static List<PhraseSetName> parseList(List<String> formattedStrings) {
        ArrayList<PhraseSetName> list = new ArrayList<PhraseSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PhraseSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PhraseSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PhraseSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PhraseSetName phraseSetName = this;
            synchronized (phraseSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"phraseSet", (Object)this.phraseSet);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "phrase_set", this.phraseSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PhraseSetName) {
            PhraseSetName that = (PhraseSetName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.phraseSet.equals(that.phraseSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.phraseSet.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String phraseSet;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPhraseSet() {
            return this.phraseSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPhraseSet(String phraseSet) {
            this.phraseSet = phraseSet;
            return this;
        }

        private Builder() {
        }

        private Builder(PhraseSetName phraseSetName) {
            this.project = phraseSetName.project;
            this.location = phraseSetName.location;
            this.phraseSet = phraseSetName.phraseSet;
        }

        public PhraseSetName build() {
            return new PhraseSetName(this);
        }
    }
}

