/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Action that updates the schema of a Cloud Spanner database.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.UpdateCloudDatabaseDdlAction}
 */
public final class UpdateCloudDatabaseDdlAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.UpdateCloudDatabaseDdlAction)
    UpdateCloudDatabaseDdlActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateCloudDatabaseDdlAction.newBuilder() to construct.
  private UpdateCloudDatabaseDdlAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateCloudDatabaseDdlAction() {
    instanceId_ = "";
    projectId_ = "";
    databaseId_ = "";
    sdlStatement_ = com.google.protobuf.LazyStringArrayList.emptyList();
    operationId_ = "";
    protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateCloudDatabaseDdlAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_UpdateCloudDatabaseDdlAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_UpdateCloudDatabaseDdlAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.class,
            com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder.class);
  }

  private int bitField0_;
  public static final int INSTANCE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path), e.g. "test-instance".
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path), e.g. "test-instance".
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud database ID (not full path), e.g. "db0".
   * </pre>
   *
   * <code>string database_id = 3;</code>
   *
   * @return The databaseId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseId() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud database ID (not full path), e.g. "db0".
   * </pre>
   *
   * <code>string database_id = 3;</code>
   *
   * @return The bytes for databaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseIdBytes() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SDL_STATEMENT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sdlStatement_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * SDL statements to apply to the database.
   * </pre>
   *
   * <code>repeated string sdl_statement = 4;</code>
   *
   * @return A list containing the sdlStatement.
   */
  public com.google.protobuf.ProtocolStringList getSdlStatementList() {
    return sdlStatement_;
  }
  /**
   *
   *
   * <pre>
   * SDL statements to apply to the database.
   * </pre>
   *
   * <code>repeated string sdl_statement = 4;</code>
   *
   * @return The count of sdlStatement.
   */
  public int getSdlStatementCount() {
    return sdlStatement_.size();
  }
  /**
   *
   *
   * <pre>
   * SDL statements to apply to the database.
   * </pre>
   *
   * <code>repeated string sdl_statement = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The sdlStatement at the given index.
   */
  public java.lang.String getSdlStatement(int index) {
    return sdlStatement_.get(index);
  }
  /**
   *
   *
   * <pre>
   * SDL statements to apply to the database.
   * </pre>
   *
   * <code>repeated string sdl_statement = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sdlStatement at the given index.
   */
  public com.google.protobuf.ByteString getSdlStatementBytes(int index) {
    return sdlStatement_.getByteString(index);
  }

  public static final int OPERATION_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationId_ = "";
  /**
   *
   *
   * <pre>
   * Op ID can be used to track progress of the update. If set, it must be
   * unique per database. If not set, Cloud Spanner will generate operation ID
   * automatically.
   * </pre>
   *
   * <code>string operation_id = 5;</code>
   *
   * @return The operationId.
   */
  @java.lang.Override
  public java.lang.String getOperationId() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Op ID can be used to track progress of the update. If set, it must be
   * unique per database. If not set, Cloud Spanner will generate operation ID
   * automatically.
   * </pre>
   *
   * <code>string operation_id = 5;</code>
   *
   * @return The bytes for operationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationIdBytes() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTO_DESCRIPTORS_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
  /**
   * <code>optional bytes proto_descriptors = 6;</code>
   *
   * @return Whether the protoDescriptors field is set.
   */
  @java.lang.Override
  public boolean hasProtoDescriptors() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <code>optional bytes proto_descriptors = 6;</code>
   *
   * @return The protoDescriptors.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtoDescriptors() {
    return protoDescriptors_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, databaseId_);
    }
    for (int i = 0; i < sdlStatement_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sdlStatement_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, operationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBytes(6, protoDescriptors_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, databaseId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sdlStatement_.size(); i++) {
        dataSize += computeStringSizeNoTag(sdlStatement_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSdlStatementList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, operationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, protoDescriptors_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction other =
        (com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) obj;

    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getDatabaseId().equals(other.getDatabaseId())) return false;
    if (!getSdlStatementList().equals(other.getSdlStatementList())) return false;
    if (!getOperationId().equals(other.getOperationId())) return false;
    if (hasProtoDescriptors() != other.hasProtoDescriptors()) return false;
    if (hasProtoDescriptors()) {
      if (!getProtoDescriptors().equals(other.getProtoDescriptors())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + DATABASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseId().hashCode();
    if (getSdlStatementCount() > 0) {
      hash = (37 * hash) + SDL_STATEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSdlStatementList().hashCode();
    }
    hash = (37 * hash) + OPERATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOperationId().hashCode();
    if (hasProtoDescriptors()) {
      hash = (37 * hash) + PROTO_DESCRIPTORS_FIELD_NUMBER;
      hash = (53 * hash) + getProtoDescriptors().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Action that updates the schema of a Cloud Spanner database.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.UpdateCloudDatabaseDdlAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.UpdateCloudDatabaseDdlAction)
      com.google.spanner.executor.v1.UpdateCloudDatabaseDdlActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudDatabaseDdlAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudDatabaseDdlAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.class,
              com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceId_ = "";
      projectId_ = "";
      databaseId_ = "";
      sdlStatement_ = com.google.protobuf.LazyStringArrayList.emptyList();
      operationId_ = "";
      protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_UpdateCloudDatabaseDdlAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction build() {
      com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction buildPartial() {
      com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction result =
          new com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceId_ = instanceId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.databaseId_ = databaseId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        sdlStatement_.makeImmutable();
        result.sdlStatement_ = sdlStatement_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.operationId_ = operationId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.protoDescriptors_ = protoDescriptors_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) {
        return mergeFrom((com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction other) {
      if (other == com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction.getDefaultInstance())
        return this;
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDatabaseId().isEmpty()) {
        databaseId_ = other.databaseId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.sdlStatement_.isEmpty()) {
        if (sdlStatement_.isEmpty()) {
          sdlStatement_ = other.sdlStatement_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSdlStatementIsMutable();
          sdlStatement_.addAll(other.sdlStatement_);
        }
        onChanged();
      }
      if (!other.getOperationId().isEmpty()) {
        operationId_ = other.operationId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasProtoDescriptors()) {
        setProtoDescriptors(other.getProtoDescriptors());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                instanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                databaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSdlStatementIsMutable();
                sdlStatement_.add(s);
                break;
              } // case 34
            case 42:
              {
                operationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                protoDescriptors_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {
      instanceId_ = getDefaultInstance().getInstanceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path), e.g. "test-instance".
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object databaseId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud database ID (not full path), e.g. "db0".
     * </pre>
     *
     * <code>string database_id = 3;</code>
     *
     * @return The databaseId.
     */
    public java.lang.String getDatabaseId() {
      java.lang.Object ref = databaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud database ID (not full path), e.g. "db0".
     * </pre>
     *
     * <code>string database_id = 3;</code>
     *
     * @return The bytes for databaseId.
     */
    public com.google.protobuf.ByteString getDatabaseIdBytes() {
      java.lang.Object ref = databaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud database ID (not full path), e.g. "db0".
     * </pre>
     *
     * <code>string database_id = 3;</code>
     *
     * @param value The databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud database ID (not full path), e.g. "db0".
     * </pre>
     *
     * <code>string database_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseId() {
      databaseId_ = getDefaultInstance().getDatabaseId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud database ID (not full path), e.g. "db0".
     * </pre>
     *
     * <code>string database_id = 3;</code>
     *
     * @param value The bytes for databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sdlStatement_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSdlStatementIsMutable() {
      if (!sdlStatement_.isModifiable()) {
        sdlStatement_ = new com.google.protobuf.LazyStringArrayList(sdlStatement_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @return A list containing the sdlStatement.
     */
    public com.google.protobuf.ProtocolStringList getSdlStatementList() {
      sdlStatement_.makeImmutable();
      return sdlStatement_;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @return The count of sdlStatement.
     */
    public int getSdlStatementCount() {
      return sdlStatement_.size();
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The sdlStatement at the given index.
     */
    public java.lang.String getSdlStatement(int index) {
      return sdlStatement_.get(index);
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sdlStatement at the given index.
     */
    public com.google.protobuf.ByteString getSdlStatementBytes(int index) {
      return sdlStatement_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The sdlStatement to set.
     * @return This builder for chaining.
     */
    public Builder setSdlStatement(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSdlStatementIsMutable();
      sdlStatement_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param value The sdlStatement to add.
     * @return This builder for chaining.
     */
    public Builder addSdlStatement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSdlStatementIsMutable();
      sdlStatement_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param values The sdlStatement to add.
     * @return This builder for chaining.
     */
    public Builder addAllSdlStatement(java.lang.Iterable<java.lang.String> values) {
      ensureSdlStatementIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sdlStatement_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSdlStatement() {
      sdlStatement_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SDL statements to apply to the database.
     * </pre>
     *
     * <code>repeated string sdl_statement = 4;</code>
     *
     * @param value The bytes of the sdlStatement to add.
     * @return This builder for chaining.
     */
    public Builder addSdlStatementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSdlStatementIsMutable();
      sdlStatement_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object operationId_ = "";
    /**
     *
     *
     * <pre>
     * Op ID can be used to track progress of the update. If set, it must be
     * unique per database. If not set, Cloud Spanner will generate operation ID
     * automatically.
     * </pre>
     *
     * <code>string operation_id = 5;</code>
     *
     * @return The operationId.
     */
    public java.lang.String getOperationId() {
      java.lang.Object ref = operationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Op ID can be used to track progress of the update. If set, it must be
     * unique per database. If not set, Cloud Spanner will generate operation ID
     * automatically.
     * </pre>
     *
     * <code>string operation_id = 5;</code>
     *
     * @return The bytes for operationId.
     */
    public com.google.protobuf.ByteString getOperationIdBytes() {
      java.lang.Object ref = operationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Op ID can be used to track progress of the update. If set, it must be
     * unique per database. If not set, Cloud Spanner will generate operation ID
     * automatically.
     * </pre>
     *
     * <code>string operation_id = 5;</code>
     *
     * @param value The operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Op ID can be used to track progress of the update. If set, it must be
     * unique per database. If not set, Cloud Spanner will generate operation ID
     * automatically.
     * </pre>
     *
     * <code>string operation_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationId() {
      operationId_ = getDefaultInstance().getOperationId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Op ID can be used to track progress of the update. If set, it must be
     * unique per database. If not set, Cloud Spanner will generate operation ID
     * automatically.
     * </pre>
     *
     * <code>string operation_id = 5;</code>
     *
     * @param value The bytes for operationId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString protoDescriptors_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <code>optional bytes proto_descriptors = 6;</code>
     *
     * @return Whether the protoDescriptors field is set.
     */
    @java.lang.Override
    public boolean hasProtoDescriptors() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional bytes proto_descriptors = 6;</code>
     *
     * @return The protoDescriptors.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtoDescriptors() {
      return protoDescriptors_;
    }
    /**
     * <code>optional bytes proto_descriptors = 6;</code>
     *
     * @param value The protoDescriptors to set.
     * @return This builder for chaining.
     */
    public Builder setProtoDescriptors(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protoDescriptors_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <code>optional bytes proto_descriptors = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtoDescriptors() {
      bitField0_ = (bitField0_ & ~0x00000020);
      protoDescriptors_ = getDefaultInstance().getProtoDescriptors();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.UpdateCloudDatabaseDdlAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.UpdateCloudDatabaseDdlAction)
  private static final com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction();
  }

  public static com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateCloudDatabaseDdlAction> PARSER =
      new com.google.protobuf.AbstractParser<UpdateCloudDatabaseDdlAction>() {
        @java.lang.Override
        public UpdateCloudDatabaseDdlAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateCloudDatabaseDdlAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateCloudDatabaseDdlAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.UpdateCloudDatabaseDdlAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
