/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * StartTransactionAction defines an action of initializing a transaction.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.StartTransactionAction}
 */
public final class StartTransactionAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.StartTransactionAction)
    StartTransactionActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StartTransactionAction.newBuilder() to construct.
  private StartTransactionAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StartTransactionAction() {
    table_ = java.util.Collections.emptyList();
    transactionSeed_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StartTransactionAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_StartTransactionAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_StartTransactionAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.StartTransactionAction.class,
            com.google.spanner.executor.v1.StartTransactionAction.Builder.class);
  }

  private int bitField0_;
  public static final int CONCURRENCY_FIELD_NUMBER = 1;
  private com.google.spanner.executor.v1.Concurrency concurrency_;
  /**
   *
   *
   * <pre>
   * Concurrency is for read-only transactions and must be omitted for
   * read-write transactions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
   *
   * @return Whether the concurrency field is set.
   */
  @java.lang.Override
  public boolean hasConcurrency() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Concurrency is for read-only transactions and must be omitted for
   * read-write transactions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
   *
   * @return The concurrency.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.Concurrency getConcurrency() {
    return concurrency_ == null
        ? com.google.spanner.executor.v1.Concurrency.getDefaultInstance()
        : concurrency_;
  }
  /**
   *
   *
   * <pre>
   * Concurrency is for read-only transactions and must be omitted for
   * read-write transactions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ConcurrencyOrBuilder getConcurrencyOrBuilder() {
    return concurrency_ == null
        ? com.google.spanner.executor.v1.Concurrency.getDefaultInstance()
        : concurrency_;
  }

  public static final int TABLE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.TableMetadata> table_;
  /**
   *
   *
   * <pre>
   * Metadata about tables and columns that will be involved in this
   * transaction. It is to convert values of key parts correctly.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.TableMetadata> getTableList() {
    return table_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about tables and columns that will be involved in this
   * transaction. It is to convert values of key parts correctly.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.TableMetadataOrBuilder>
      getTableOrBuilderList() {
    return table_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about tables and columns that will be involved in this
   * transaction. It is to convert values of key parts correctly.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public int getTableCount() {
    return table_.size();
  }
  /**
   *
   *
   * <pre>
   * Metadata about tables and columns that will be involved in this
   * transaction. It is to convert values of key parts correctly.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TableMetadata getTable(int index) {
    return table_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Metadata about tables and columns that will be involved in this
   * transaction. It is to convert values of key parts correctly.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TableMetadataOrBuilder getTableOrBuilder(int index) {
    return table_.get(index);
  }

  public static final int TRANSACTION_SEED_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object transactionSeed_ = "";
  /**
   *
   *
   * <pre>
   * Transaction_seed contains workid and op pair for this transaction, used for
   * testing.
   * </pre>
   *
   * <code>string transaction_seed = 3;</code>
   *
   * @return The transactionSeed.
   */
  @java.lang.Override
  public java.lang.String getTransactionSeed() {
    java.lang.Object ref = transactionSeed_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transactionSeed_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Transaction_seed contains workid and op pair for this transaction, used for
   * testing.
   * </pre>
   *
   * <code>string transaction_seed = 3;</code>
   *
   * @return The bytes for transactionSeed.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransactionSeedBytes() {
    java.lang.Object ref = transactionSeed_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transactionSeed_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_OPTIONS_FIELD_NUMBER = 4;
  private com.google.spanner.executor.v1.TransactionExecutionOptions executionOptions_;
  /**
   *
   *
   * <pre>
   * Execution options (e.g., whether transaction is opaque, optimistic).
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
   * </code>
   *
   * @return Whether the executionOptions field is set.
   */
  @java.lang.Override
  public boolean hasExecutionOptions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Execution options (e.g., whether transaction is opaque, optimistic).
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
   * </code>
   *
   * @return The executionOptions.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TransactionExecutionOptions getExecutionOptions() {
    return executionOptions_ == null
        ? com.google.spanner.executor.v1.TransactionExecutionOptions.getDefaultInstance()
        : executionOptions_;
  }
  /**
   *
   *
   * <pre>
   * Execution options (e.g., whether transaction is opaque, optimistic).
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.TransactionExecutionOptionsOrBuilder
      getExecutionOptionsOrBuilder() {
    return executionOptions_ == null
        ? com.google.spanner.executor.v1.TransactionExecutionOptions.getDefaultInstance()
        : executionOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getConcurrency());
    }
    for (int i = 0; i < table_.size(); i++) {
      output.writeMessage(2, table_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionSeed_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, transactionSeed_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getExecutionOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getConcurrency());
    }
    for (int i = 0; i < table_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, table_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionSeed_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, transactionSeed_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExecutionOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.StartTransactionAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.StartTransactionAction other =
        (com.google.spanner.executor.v1.StartTransactionAction) obj;

    if (hasConcurrency() != other.hasConcurrency()) return false;
    if (hasConcurrency()) {
      if (!getConcurrency().equals(other.getConcurrency())) return false;
    }
    if (!getTableList().equals(other.getTableList())) return false;
    if (!getTransactionSeed().equals(other.getTransactionSeed())) return false;
    if (hasExecutionOptions() != other.hasExecutionOptions()) return false;
    if (hasExecutionOptions()) {
      if (!getExecutionOptions().equals(other.getExecutionOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConcurrency()) {
      hash = (37 * hash) + CONCURRENCY_FIELD_NUMBER;
      hash = (53 * hash) + getConcurrency().hashCode();
    }
    if (getTableCount() > 0) {
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTableList().hashCode();
    }
    hash = (37 * hash) + TRANSACTION_SEED_FIELD_NUMBER;
    hash = (53 * hash) + getTransactionSeed().hashCode();
    if (hasExecutionOptions()) {
      hash = (37 * hash) + EXECUTION_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExecutionOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.StartTransactionAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.StartTransactionAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * StartTransactionAction defines an action of initializing a transaction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.StartTransactionAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.StartTransactionAction)
      com.google.spanner.executor.v1.StartTransactionActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartTransactionAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartTransactionAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.StartTransactionAction.class,
              com.google.spanner.executor.v1.StartTransactionAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.StartTransactionAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConcurrencyFieldBuilder();
        getTableFieldBuilder();
        getExecutionOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      concurrency_ = null;
      if (concurrencyBuilder_ != null) {
        concurrencyBuilder_.dispose();
        concurrencyBuilder_ = null;
      }
      if (tableBuilder_ == null) {
        table_ = java.util.Collections.emptyList();
      } else {
        table_ = null;
        tableBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      transactionSeed_ = "";
      executionOptions_ = null;
      if (executionOptionsBuilder_ != null) {
        executionOptionsBuilder_.dispose();
        executionOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_StartTransactionAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartTransactionAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartTransactionAction build() {
      com.google.spanner.executor.v1.StartTransactionAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.StartTransactionAction buildPartial() {
      com.google.spanner.executor.v1.StartTransactionAction result =
          new com.google.spanner.executor.v1.StartTransactionAction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.StartTransactionAction result) {
      if (tableBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          table_ = java.util.Collections.unmodifiableList(table_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.table_ = table_;
      } else {
        result.table_ = tableBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.StartTransactionAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.concurrency_ =
            concurrencyBuilder_ == null ? concurrency_ : concurrencyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.transactionSeed_ = transactionSeed_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.executionOptions_ =
            executionOptionsBuilder_ == null ? executionOptions_ : executionOptionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.StartTransactionAction) {
        return mergeFrom((com.google.spanner.executor.v1.StartTransactionAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.StartTransactionAction other) {
      if (other == com.google.spanner.executor.v1.StartTransactionAction.getDefaultInstance())
        return this;
      if (other.hasConcurrency()) {
        mergeConcurrency(other.getConcurrency());
      }
      if (tableBuilder_ == null) {
        if (!other.table_.isEmpty()) {
          if (table_.isEmpty()) {
            table_ = other.table_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTableIsMutable();
            table_.addAll(other.table_);
          }
          onChanged();
        }
      } else {
        if (!other.table_.isEmpty()) {
          if (tableBuilder_.isEmpty()) {
            tableBuilder_.dispose();
            tableBuilder_ = null;
            table_ = other.table_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tableBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTableFieldBuilder()
                    : null;
          } else {
            tableBuilder_.addAllMessages(other.table_);
          }
        }
      }
      if (!other.getTransactionSeed().isEmpty()) {
        transactionSeed_ = other.transactionSeed_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasExecutionOptions()) {
        mergeExecutionOptions(other.getExecutionOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getConcurrencyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.spanner.executor.v1.TableMetadata m =
                    input.readMessage(
                        com.google.spanner.executor.v1.TableMetadata.parser(), extensionRegistry);
                if (tableBuilder_ == null) {
                  ensureTableIsMutable();
                  table_.add(m);
                } else {
                  tableBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                transactionSeed_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getExecutionOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.executor.v1.Concurrency concurrency_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.Concurrency,
            com.google.spanner.executor.v1.Concurrency.Builder,
            com.google.spanner.executor.v1.ConcurrencyOrBuilder>
        concurrencyBuilder_;
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     *
     * @return Whether the concurrency field is set.
     */
    public boolean hasConcurrency() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     *
     * @return The concurrency.
     */
    public com.google.spanner.executor.v1.Concurrency getConcurrency() {
      if (concurrencyBuilder_ == null) {
        return concurrency_ == null
            ? com.google.spanner.executor.v1.Concurrency.getDefaultInstance()
            : concurrency_;
      } else {
        return concurrencyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public Builder setConcurrency(com.google.spanner.executor.v1.Concurrency value) {
      if (concurrencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        concurrency_ = value;
      } else {
        concurrencyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public Builder setConcurrency(
        com.google.spanner.executor.v1.Concurrency.Builder builderForValue) {
      if (concurrencyBuilder_ == null) {
        concurrency_ = builderForValue.build();
      } else {
        concurrencyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public Builder mergeConcurrency(com.google.spanner.executor.v1.Concurrency value) {
      if (concurrencyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && concurrency_ != null
            && concurrency_ != com.google.spanner.executor.v1.Concurrency.getDefaultInstance()) {
          getConcurrencyBuilder().mergeFrom(value);
        } else {
          concurrency_ = value;
        }
      } else {
        concurrencyBuilder_.mergeFrom(value);
      }
      if (concurrency_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public Builder clearConcurrency() {
      bitField0_ = (bitField0_ & ~0x00000001);
      concurrency_ = null;
      if (concurrencyBuilder_ != null) {
        concurrencyBuilder_.dispose();
        concurrencyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public com.google.spanner.executor.v1.Concurrency.Builder getConcurrencyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConcurrencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    public com.google.spanner.executor.v1.ConcurrencyOrBuilder getConcurrencyOrBuilder() {
      if (concurrencyBuilder_ != null) {
        return concurrencyBuilder_.getMessageOrBuilder();
      } else {
        return concurrency_ == null
            ? com.google.spanner.executor.v1.Concurrency.getDefaultInstance()
            : concurrency_;
      }
    }
    /**
     *
     *
     * <pre>
     * Concurrency is for read-only transactions and must be omitted for
     * read-write transactions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.Concurrency concurrency = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.Concurrency,
            com.google.spanner.executor.v1.Concurrency.Builder,
            com.google.spanner.executor.v1.ConcurrencyOrBuilder>
        getConcurrencyFieldBuilder() {
      if (concurrencyBuilder_ == null) {
        concurrencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.Concurrency,
                com.google.spanner.executor.v1.Concurrency.Builder,
                com.google.spanner.executor.v1.ConcurrencyOrBuilder>(
                getConcurrency(), getParentForChildren(), isClean());
        concurrency_ = null;
      }
      return concurrencyBuilder_;
    }

    private java.util.List<com.google.spanner.executor.v1.TableMetadata> table_ =
        java.util.Collections.emptyList();

    private void ensureTableIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        table_ = new java.util.ArrayList<com.google.spanner.executor.v1.TableMetadata>(table_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.TableMetadata,
            com.google.spanner.executor.v1.TableMetadata.Builder,
            com.google.spanner.executor.v1.TableMetadataOrBuilder>
        tableBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.TableMetadata> getTableList() {
      if (tableBuilder_ == null) {
        return java.util.Collections.unmodifiableList(table_);
      } else {
        return tableBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public int getTableCount() {
      if (tableBuilder_ == null) {
        return table_.size();
      } else {
        return tableBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata getTable(int index) {
      if (tableBuilder_ == null) {
        return table_.get(index);
      } else {
        return tableBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder setTable(int index, com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.set(index, value);
        onChanged();
      } else {
        tableBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder setTable(
        int index, com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.set(index, builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.add(value);
        onChanged();
      } else {
        tableBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(int index, com.google.spanner.executor.v1.TableMetadata value) {
      if (tableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableIsMutable();
        table_.add(index, value);
        onChanged();
      } else {
        tableBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.add(builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addTable(
        int index, com.google.spanner.executor.v1.TableMetadata.Builder builderForValue) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.add(index, builderForValue.build());
        onChanged();
      } else {
        tableBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder addAllTable(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.TableMetadata> values) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, table_);
        onChanged();
      } else {
        tableBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder clearTable() {
      if (tableBuilder_ == null) {
        table_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tableBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public Builder removeTable(int index) {
      if (tableBuilder_ == null) {
        ensureTableIsMutable();
        table_.remove(index);
        onChanged();
      } else {
        tableBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder getTableBuilder(int index) {
      return getTableFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadataOrBuilder getTableOrBuilder(int index) {
      if (tableBuilder_ == null) {
        return table_.get(index);
      } else {
        return tableBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.TableMetadataOrBuilder>
        getTableOrBuilderList() {
      if (tableBuilder_ != null) {
        return tableBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(table_);
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder addTableBuilder() {
      return getTableFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.TableMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public com.google.spanner.executor.v1.TableMetadata.Builder addTableBuilder(int index) {
      return getTableFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.TableMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Metadata about tables and columns that will be involved in this
     * transaction. It is to convert values of key parts correctly.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.TableMetadata table = 2;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.TableMetadata.Builder>
        getTableBuilderList() {
      return getTableFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.TableMetadata,
            com.google.spanner.executor.v1.TableMetadata.Builder,
            com.google.spanner.executor.v1.TableMetadataOrBuilder>
        getTableFieldBuilder() {
      if (tableBuilder_ == null) {
        tableBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.TableMetadata,
                com.google.spanner.executor.v1.TableMetadata.Builder,
                com.google.spanner.executor.v1.TableMetadataOrBuilder>(
                table_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        table_ = null;
      }
      return tableBuilder_;
    }

    private java.lang.Object transactionSeed_ = "";
    /**
     *
     *
     * <pre>
     * Transaction_seed contains workid and op pair for this transaction, used for
     * testing.
     * </pre>
     *
     * <code>string transaction_seed = 3;</code>
     *
     * @return The transactionSeed.
     */
    public java.lang.String getTransactionSeed() {
      java.lang.Object ref = transactionSeed_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionSeed_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction_seed contains workid and op pair for this transaction, used for
     * testing.
     * </pre>
     *
     * <code>string transaction_seed = 3;</code>
     *
     * @return The bytes for transactionSeed.
     */
    public com.google.protobuf.ByteString getTransactionSeedBytes() {
      java.lang.Object ref = transactionSeed_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transactionSeed_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction_seed contains workid and op pair for this transaction, used for
     * testing.
     * </pre>
     *
     * <code>string transaction_seed = 3;</code>
     *
     * @param value The transactionSeed to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionSeed(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transactionSeed_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction_seed contains workid and op pair for this transaction, used for
     * testing.
     * </pre>
     *
     * <code>string transaction_seed = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionSeed() {
      transactionSeed_ = getDefaultInstance().getTransactionSeed();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction_seed contains workid and op pair for this transaction, used for
     * testing.
     * </pre>
     *
     * <code>string transaction_seed = 3;</code>
     *
     * @param value The bytes for transactionSeed to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionSeedBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      transactionSeed_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.spanner.executor.v1.TransactionExecutionOptions executionOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.TransactionExecutionOptions,
            com.google.spanner.executor.v1.TransactionExecutionOptions.Builder,
            com.google.spanner.executor.v1.TransactionExecutionOptionsOrBuilder>
        executionOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     *
     * @return Whether the executionOptions field is set.
     */
    public boolean hasExecutionOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     *
     * @return The executionOptions.
     */
    public com.google.spanner.executor.v1.TransactionExecutionOptions getExecutionOptions() {
      if (executionOptionsBuilder_ == null) {
        return executionOptions_ == null
            ? com.google.spanner.executor.v1.TransactionExecutionOptions.getDefaultInstance()
            : executionOptions_;
      } else {
        return executionOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public Builder setExecutionOptions(
        com.google.spanner.executor.v1.TransactionExecutionOptions value) {
      if (executionOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executionOptions_ = value;
      } else {
        executionOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public Builder setExecutionOptions(
        com.google.spanner.executor.v1.TransactionExecutionOptions.Builder builderForValue) {
      if (executionOptionsBuilder_ == null) {
        executionOptions_ = builderForValue.build();
      } else {
        executionOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public Builder mergeExecutionOptions(
        com.google.spanner.executor.v1.TransactionExecutionOptions value) {
      if (executionOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && executionOptions_ != null
            && executionOptions_
                != com.google.spanner.executor.v1.TransactionExecutionOptions
                    .getDefaultInstance()) {
          getExecutionOptionsBuilder().mergeFrom(value);
        } else {
          executionOptions_ = value;
        }
      } else {
        executionOptionsBuilder_.mergeFrom(value);
      }
      if (executionOptions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public Builder clearExecutionOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      executionOptions_ = null;
      if (executionOptionsBuilder_ != null) {
        executionOptionsBuilder_.dispose();
        executionOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public com.google.spanner.executor.v1.TransactionExecutionOptions.Builder
        getExecutionOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExecutionOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    public com.google.spanner.executor.v1.TransactionExecutionOptionsOrBuilder
        getExecutionOptionsOrBuilder() {
      if (executionOptionsBuilder_ != null) {
        return executionOptionsBuilder_.getMessageOrBuilder();
      } else {
        return executionOptions_ == null
            ? com.google.spanner.executor.v1.TransactionExecutionOptions.getDefaultInstance()
            : executionOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Execution options (e.g., whether transaction is opaque, optimistic).
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.TransactionExecutionOptions execution_options = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.TransactionExecutionOptions,
            com.google.spanner.executor.v1.TransactionExecutionOptions.Builder,
            com.google.spanner.executor.v1.TransactionExecutionOptionsOrBuilder>
        getExecutionOptionsFieldBuilder() {
      if (executionOptionsBuilder_ == null) {
        executionOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.TransactionExecutionOptions,
                com.google.spanner.executor.v1.TransactionExecutionOptions.Builder,
                com.google.spanner.executor.v1.TransactionExecutionOptionsOrBuilder>(
                getExecutionOptions(), getParentForChildren(), isClean());
        executionOptions_ = null;
      }
      return executionOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.StartTransactionAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.StartTransactionAction)
  private static final com.google.spanner.executor.v1.StartTransactionAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.StartTransactionAction();
  }

  public static com.google.spanner.executor.v1.StartTransactionAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StartTransactionAction> PARSER =
      new com.google.protobuf.AbstractParser<StartTransactionAction>() {
        @java.lang.Override
        public StartTransactionAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StartTransactionAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StartTransactionAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.StartTransactionAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
