/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * SpannerActionOutcome defines a result of execution of a single SpannerAction.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.SpannerActionOutcome}
 */
public final class SpannerActionOutcome extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.SpannerActionOutcome)
    SpannerActionOutcomeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpannerActionOutcome.newBuilder() to construct.
  private SpannerActionOutcome(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpannerActionOutcome() {
    batchTxnId_ = com.google.protobuf.ByteString.EMPTY;
    dbPartition_ = java.util.Collections.emptyList();
    dmlRowsModified_ = emptyLongList();
    changeStreamRecords_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpannerActionOutcome();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_SpannerActionOutcome_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_SpannerActionOutcome_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.SpannerActionOutcome.class,
            com.google.spanner.executor.v1.SpannerActionOutcome.Builder.class);
  }

  private int bitField0_;
  public static final int STATUS_FIELD_NUMBER = 1;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * If an outcome is split into multiple parts, status will be set only in the
   * last part.
   * </pre>
   *
   * <code>optional .google.rpc.Status status = 1;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If an outcome is split into multiple parts, status will be set only in the
   * last part.
   * </pre>
   *
   * <code>optional .google.rpc.Status status = 1;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * If an outcome is split into multiple parts, status will be set only in the
   * last part.
   * </pre>
   *
   * <code>optional .google.rpc.Status status = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int COMMIT_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp commitTime_;
  /**
   *
   *
   * <pre>
   * Transaction timestamp. It must be set for successful committed actions.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
   *
   * @return Whether the commitTime field is set.
   */
  @java.lang.Override
  public boolean hasCommitTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Transaction timestamp. It must be set for successful committed actions.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
   *
   * @return The commitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTime() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }
  /**
   *
   *
   * <pre>
   * Transaction timestamp. It must be set for successful committed actions.
   * </pre>
   *
   * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }

  public static final int READ_RESULT_FIELD_NUMBER = 3;
  private com.google.spanner.executor.v1.ReadResult readResult_;
  /**
   *
   *
   * <pre>
   * Result of a ReadAction. This field must be set for ReadActions even if
   * no rows were read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
   *
   * @return Whether the readResult field is set.
   */
  @java.lang.Override
  public boolean hasReadResult() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Result of a ReadAction. This field must be set for ReadActions even if
   * no rows were read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
   *
   * @return The readResult.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadResult getReadResult() {
    return readResult_ == null
        ? com.google.spanner.executor.v1.ReadResult.getDefaultInstance()
        : readResult_;
  }
  /**
   *
   *
   * <pre>
   * Result of a ReadAction. This field must be set for ReadActions even if
   * no rows were read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ReadResultOrBuilder getReadResultOrBuilder() {
    return readResult_ == null
        ? com.google.spanner.executor.v1.ReadResult.getDefaultInstance()
        : readResult_;
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 4;
  private com.google.spanner.executor.v1.QueryResult queryResult_;
  /**
   *
   *
   * <pre>
   * Result of a Query. This field must be set for Queries even if no rows were
   * read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Result of a Query. This field must be set for Queries even if no rows were
   * read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryResult getQueryResult() {
    return queryResult_ == null
        ? com.google.spanner.executor.v1.QueryResult.getDefaultInstance()
        : queryResult_;
  }
  /**
   *
   *
   * <pre>
   * Result of a Query. This field must be set for Queries even if no rows were
   * read.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryResultOrBuilder getQueryResultOrBuilder() {
    return queryResult_ == null
        ? com.google.spanner.executor.v1.QueryResult.getDefaultInstance()
        : queryResult_;
  }

  public static final int TRANSACTION_RESTARTED_FIELD_NUMBER = 5;
  private boolean transactionRestarted_ = false;
  /**
   *
   *
   * <pre>
   * This bit indicates that Spanner has restarted the current transaction. It
   * means that the client should replay all the reads and writes.
   * Setting it to true is only valid in the context of a read-write
   * transaction, as an outcome of a committing FinishTransactionAction.
   * </pre>
   *
   * <code>optional bool transaction_restarted = 5;</code>
   *
   * @return Whether the transactionRestarted field is set.
   */
  @java.lang.Override
  public boolean hasTransactionRestarted() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * This bit indicates that Spanner has restarted the current transaction. It
   * means that the client should replay all the reads and writes.
   * Setting it to true is only valid in the context of a read-write
   * transaction, as an outcome of a committing FinishTransactionAction.
   * </pre>
   *
   * <code>optional bool transaction_restarted = 5;</code>
   *
   * @return The transactionRestarted.
   */
  @java.lang.Override
  public boolean getTransactionRestarted() {
    return transactionRestarted_;
  }

  public static final int BATCH_TXN_ID_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString batchTxnId_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * In successful StartBatchTransactionAction outcomes, this contains the ID of
   * the transaction.
   * </pre>
   *
   * <code>optional bytes batch_txn_id = 6;</code>
   *
   * @return Whether the batchTxnId field is set.
   */
  @java.lang.Override
  public boolean hasBatchTxnId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * In successful StartBatchTransactionAction outcomes, this contains the ID of
   * the transaction.
   * </pre>
   *
   * <code>optional bytes batch_txn_id = 6;</code>
   *
   * @return The batchTxnId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBatchTxnId() {
    return batchTxnId_;
  }

  public static final int DB_PARTITION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.BatchPartition> dbPartition_;
  /**
   *
   *
   * <pre>
   * Generated database partitions (result of a
   * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.BatchPartition> getDbPartitionList() {
    return dbPartition_;
  }
  /**
   *
   *
   * <pre>
   * Generated database partitions (result of a
   * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.BatchPartitionOrBuilder>
      getDbPartitionOrBuilderList() {
    return dbPartition_;
  }
  /**
   *
   *
   * <pre>
   * Generated database partitions (result of a
   * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
   */
  @java.lang.Override
  public int getDbPartitionCount() {
    return dbPartition_.size();
  }
  /**
   *
   *
   * <pre>
   * Generated database partitions (result of a
   * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.BatchPartition getDbPartition(int index) {
    return dbPartition_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Generated database partitions (result of a
   * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.BatchPartitionOrBuilder getDbPartitionOrBuilder(int index) {
    return dbPartition_.get(index);
  }

  public static final int ADMIN_RESULT_FIELD_NUMBER = 8;
  private com.google.spanner.executor.v1.AdminResult adminResult_;
  /**
   *
   *
   * <pre>
   * Result of admin related actions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
   *
   * @return Whether the adminResult field is set.
   */
  @java.lang.Override
  public boolean hasAdminResult() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Result of admin related actions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
   *
   * @return The adminResult.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.AdminResult getAdminResult() {
    return adminResult_ == null
        ? com.google.spanner.executor.v1.AdminResult.getDefaultInstance()
        : adminResult_;
  }
  /**
   *
   *
   * <pre>
   * Result of admin related actions.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.AdminResultOrBuilder getAdminResultOrBuilder() {
    return adminResult_ == null
        ? com.google.spanner.executor.v1.AdminResult.getDefaultInstance()
        : adminResult_;
  }

  public static final int DML_ROWS_MODIFIED_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList dmlRowsModified_ = emptyLongList();
  /**
   *
   *
   * <pre>
   * Stores rows modified by query in single DML or batch DML action.
   * In case of batch DML action, stores 0 as row count of errored DML query.
   * </pre>
   *
   * <code>repeated int64 dml_rows_modified = 9;</code>
   *
   * @return A list containing the dmlRowsModified.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getDmlRowsModifiedList() {
    return dmlRowsModified_;
  }
  /**
   *
   *
   * <pre>
   * Stores rows modified by query in single DML or batch DML action.
   * In case of batch DML action, stores 0 as row count of errored DML query.
   * </pre>
   *
   * <code>repeated int64 dml_rows_modified = 9;</code>
   *
   * @return The count of dmlRowsModified.
   */
  public int getDmlRowsModifiedCount() {
    return dmlRowsModified_.size();
  }
  /**
   *
   *
   * <pre>
   * Stores rows modified by query in single DML or batch DML action.
   * In case of batch DML action, stores 0 as row count of errored DML query.
   * </pre>
   *
   * <code>repeated int64 dml_rows_modified = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The dmlRowsModified at the given index.
   */
  public long getDmlRowsModified(int index) {
    return dmlRowsModified_.getLong(index);
  }

  private int dmlRowsModifiedMemoizedSerializedSize = -1;

  public static final int CHANGE_STREAM_RECORDS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.executor.v1.ChangeStreamRecord> changeStreamRecords_;
  /**
   *
   *
   * <pre>
   * Change stream records returned by a change stream query.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.executor.v1.ChangeStreamRecord>
      getChangeStreamRecordsList() {
    return changeStreamRecords_;
  }
  /**
   *
   *
   * <pre>
   * Change stream records returned by a change stream query.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder>
      getChangeStreamRecordsOrBuilderList() {
    return changeStreamRecords_;
  }
  /**
   *
   *
   * <pre>
   * Change stream records returned by a change stream query.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
   * </code>
   */
  @java.lang.Override
  public int getChangeStreamRecordsCount() {
    return changeStreamRecords_.size();
  }
  /**
   *
   *
   * <pre>
   * Change stream records returned by a change stream query.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChangeStreamRecord getChangeStreamRecords(int index) {
    return changeStreamRecords_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Change stream records returned by a change stream query.
   * </pre>
   *
   * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder getChangeStreamRecordsOrBuilder(
      int index) {
    return changeStreamRecords_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getCommitTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getReadResult());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getQueryResult());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(5, transactionRestarted_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBytes(6, batchTxnId_);
    }
    for (int i = 0; i < dbPartition_.size(); i++) {
      output.writeMessage(7, dbPartition_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(8, getAdminResult());
    }
    if (getDmlRowsModifiedList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(dmlRowsModifiedMemoizedSerializedSize);
    }
    for (int i = 0; i < dmlRowsModified_.size(); i++) {
      output.writeInt64NoTag(dmlRowsModified_.getLong(i));
    }
    for (int i = 0; i < changeStreamRecords_.size(); i++) {
      output.writeMessage(10, changeStreamRecords_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCommitTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReadResult());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getQueryResult());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, transactionRestarted_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, batchTxnId_);
    }
    for (int i = 0; i < dbPartition_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, dbPartition_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAdminResult());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dmlRowsModified_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(
                dmlRowsModified_.getLong(i));
      }
      size += dataSize;
      if (!getDmlRowsModifiedList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      dmlRowsModifiedMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < changeStreamRecords_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, changeStreamRecords_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.SpannerActionOutcome)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.SpannerActionOutcome other =
        (com.google.spanner.executor.v1.SpannerActionOutcome) obj;

    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasCommitTime() != other.hasCommitTime()) return false;
    if (hasCommitTime()) {
      if (!getCommitTime().equals(other.getCommitTime())) return false;
    }
    if (hasReadResult() != other.hasReadResult()) return false;
    if (hasReadResult()) {
      if (!getReadResult().equals(other.getReadResult())) return false;
    }
    if (hasQueryResult() != other.hasQueryResult()) return false;
    if (hasQueryResult()) {
      if (!getQueryResult().equals(other.getQueryResult())) return false;
    }
    if (hasTransactionRestarted() != other.hasTransactionRestarted()) return false;
    if (hasTransactionRestarted()) {
      if (getTransactionRestarted() != other.getTransactionRestarted()) return false;
    }
    if (hasBatchTxnId() != other.hasBatchTxnId()) return false;
    if (hasBatchTxnId()) {
      if (!getBatchTxnId().equals(other.getBatchTxnId())) return false;
    }
    if (!getDbPartitionList().equals(other.getDbPartitionList())) return false;
    if (hasAdminResult() != other.hasAdminResult()) return false;
    if (hasAdminResult()) {
      if (!getAdminResult().equals(other.getAdminResult())) return false;
    }
    if (!getDmlRowsModifiedList().equals(other.getDmlRowsModifiedList())) return false;
    if (!getChangeStreamRecordsList().equals(other.getChangeStreamRecordsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasCommitTime()) {
      hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTime().hashCode();
    }
    if (hasReadResult()) {
      hash = (37 * hash) + READ_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getReadResult().hashCode();
    }
    if (hasQueryResult()) {
      hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryResult().hashCode();
    }
    if (hasTransactionRestarted()) {
      hash = (37 * hash) + TRANSACTION_RESTARTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTransactionRestarted());
    }
    if (hasBatchTxnId()) {
      hash = (37 * hash) + BATCH_TXN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getBatchTxnId().hashCode();
    }
    if (getDbPartitionCount() > 0) {
      hash = (37 * hash) + DB_PARTITION_FIELD_NUMBER;
      hash = (53 * hash) + getDbPartitionList().hashCode();
    }
    if (hasAdminResult()) {
      hash = (37 * hash) + ADMIN_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getAdminResult().hashCode();
    }
    if (getDmlRowsModifiedCount() > 0) {
      hash = (37 * hash) + DML_ROWS_MODIFIED_FIELD_NUMBER;
      hash = (53 * hash) + getDmlRowsModifiedList().hashCode();
    }
    if (getChangeStreamRecordsCount() > 0) {
      hash = (37 * hash) + CHANGE_STREAM_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getChangeStreamRecordsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.SpannerActionOutcome prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SpannerActionOutcome defines a result of execution of a single SpannerAction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.SpannerActionOutcome}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.SpannerActionOutcome)
      com.google.spanner.executor.v1.SpannerActionOutcomeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerActionOutcome_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerActionOutcome_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.SpannerActionOutcome.class,
              com.google.spanner.executor.v1.SpannerActionOutcome.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.SpannerActionOutcome.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatusFieldBuilder();
        getCommitTimeFieldBuilder();
        getReadResultFieldBuilder();
        getQueryResultFieldBuilder();
        getDbPartitionFieldBuilder();
        getAdminResultFieldBuilder();
        getChangeStreamRecordsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      readResult_ = null;
      if (readResultBuilder_ != null) {
        readResultBuilder_.dispose();
        readResultBuilder_ = null;
      }
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      transactionRestarted_ = false;
      batchTxnId_ = com.google.protobuf.ByteString.EMPTY;
      if (dbPartitionBuilder_ == null) {
        dbPartition_ = java.util.Collections.emptyList();
      } else {
        dbPartition_ = null;
        dbPartitionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      adminResult_ = null;
      if (adminResultBuilder_ != null) {
        adminResultBuilder_.dispose();
        adminResultBuilder_ = null;
      }
      dmlRowsModified_ = emptyLongList();
      if (changeStreamRecordsBuilder_ == null) {
        changeStreamRecords_ = java.util.Collections.emptyList();
      } else {
        changeStreamRecords_ = null;
        changeStreamRecordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_SpannerActionOutcome_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerActionOutcome getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.SpannerActionOutcome.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerActionOutcome build() {
      com.google.spanner.executor.v1.SpannerActionOutcome result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.SpannerActionOutcome buildPartial() {
      com.google.spanner.executor.v1.SpannerActionOutcome result =
          new com.google.spanner.executor.v1.SpannerActionOutcome(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.SpannerActionOutcome result) {
      if (dbPartitionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          dbPartition_ = java.util.Collections.unmodifiableList(dbPartition_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.dbPartition_ = dbPartition_;
      } else {
        result.dbPartition_ = dbPartitionBuilder_.build();
      }
      if (changeStreamRecordsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          changeStreamRecords_ = java.util.Collections.unmodifiableList(changeStreamRecords_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.changeStreamRecords_ = changeStreamRecords_;
      } else {
        result.changeStreamRecords_ = changeStreamRecordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.SpannerActionOutcome result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.commitTime_ = commitTimeBuilder_ == null ? commitTime_ : commitTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.readResult_ = readResultBuilder_ == null ? readResult_ : readResultBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.queryResult_ =
            queryResultBuilder_ == null ? queryResult_ : queryResultBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.transactionRestarted_ = transactionRestarted_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.batchTxnId_ = batchTxnId_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.adminResult_ =
            adminResultBuilder_ == null ? adminResult_ : adminResultBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        dmlRowsModified_.makeImmutable();
        result.dmlRowsModified_ = dmlRowsModified_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.SpannerActionOutcome) {
        return mergeFrom((com.google.spanner.executor.v1.SpannerActionOutcome) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.SpannerActionOutcome other) {
      if (other == com.google.spanner.executor.v1.SpannerActionOutcome.getDefaultInstance())
        return this;
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (other.hasCommitTime()) {
        mergeCommitTime(other.getCommitTime());
      }
      if (other.hasReadResult()) {
        mergeReadResult(other.getReadResult());
      }
      if (other.hasQueryResult()) {
        mergeQueryResult(other.getQueryResult());
      }
      if (other.hasTransactionRestarted()) {
        setTransactionRestarted(other.getTransactionRestarted());
      }
      if (other.hasBatchTxnId()) {
        setBatchTxnId(other.getBatchTxnId());
      }
      if (dbPartitionBuilder_ == null) {
        if (!other.dbPartition_.isEmpty()) {
          if (dbPartition_.isEmpty()) {
            dbPartition_ = other.dbPartition_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureDbPartitionIsMutable();
            dbPartition_.addAll(other.dbPartition_);
          }
          onChanged();
        }
      } else {
        if (!other.dbPartition_.isEmpty()) {
          if (dbPartitionBuilder_.isEmpty()) {
            dbPartitionBuilder_.dispose();
            dbPartitionBuilder_ = null;
            dbPartition_ = other.dbPartition_;
            bitField0_ = (bitField0_ & ~0x00000040);
            dbPartitionBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDbPartitionFieldBuilder()
                    : null;
          } else {
            dbPartitionBuilder_.addAllMessages(other.dbPartition_);
          }
        }
      }
      if (other.hasAdminResult()) {
        mergeAdminResult(other.getAdminResult());
      }
      if (!other.dmlRowsModified_.isEmpty()) {
        if (dmlRowsModified_.isEmpty()) {
          dmlRowsModified_ = other.dmlRowsModified_;
          dmlRowsModified_.makeImmutable();
          bitField0_ |= 0x00000100;
        } else {
          ensureDmlRowsModifiedIsMutable();
          dmlRowsModified_.addAll(other.dmlRowsModified_);
        }
        onChanged();
      }
      if (changeStreamRecordsBuilder_ == null) {
        if (!other.changeStreamRecords_.isEmpty()) {
          if (changeStreamRecords_.isEmpty()) {
            changeStreamRecords_ = other.changeStreamRecords_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureChangeStreamRecordsIsMutable();
            changeStreamRecords_.addAll(other.changeStreamRecords_);
          }
          onChanged();
        }
      } else {
        if (!other.changeStreamRecords_.isEmpty()) {
          if (changeStreamRecordsBuilder_.isEmpty()) {
            changeStreamRecordsBuilder_.dispose();
            changeStreamRecordsBuilder_ = null;
            changeStreamRecords_ = other.changeStreamRecords_;
            bitField0_ = (bitField0_ & ~0x00000200);
            changeStreamRecordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChangeStreamRecordsFieldBuilder()
                    : null;
          } else {
            changeStreamRecordsBuilder_.addAllMessages(other.changeStreamRecords_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCommitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getReadResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                transactionRestarted_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                batchTxnId_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.spanner.executor.v1.BatchPartition m =
                    input.readMessage(
                        com.google.spanner.executor.v1.BatchPartition.parser(), extensionRegistry);
                if (dbPartitionBuilder_ == null) {
                  ensureDbPartitionIsMutable();
                  dbPartition_.add(m);
                } else {
                  dbPartitionBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getAdminResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                long v = input.readInt64();
                ensureDmlRowsModifiedIsMutable();
                dmlRowsModified_.addLong(v);
                break;
              } // case 72
            case 74:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureDmlRowsModifiedIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  dmlRowsModified_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 74
            case 82:
              {
                com.google.spanner.executor.v1.ChangeStreamRecord m =
                    input.readMessage(
                        com.google.spanner.executor.v1.ChangeStreamRecord.parser(),
                        extensionRegistry);
                if (changeStreamRecordsBuilder_ == null) {
                  ensureChangeStreamRecordsIsMutable();
                  changeStreamRecords_.add(m);
                } else {
                  changeStreamRecordsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000001);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * If an outcome is split into multiple parts, status will be set only in the
     * last part.
     * </pre>
     *
     * <code>optional .google.rpc.Status status = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.Timestamp commitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     *
     * @return Whether the commitTime field is set.
     */
    public boolean hasCommitTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     *
     * @return The commitTime.
     */
    public com.google.protobuf.Timestamp getCommitTime() {
      if (commitTimeBuilder_ == null) {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      } else {
        return commitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitTime_ = value;
      } else {
        commitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimeBuilder_ == null) {
        commitTime_ = builderForValue.build();
      } else {
        commitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && commitTime_ != null
            && commitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitTimeBuilder().mergeFrom(value);
        } else {
          commitTime_ = value;
        }
      } else {
        commitTimeBuilder_.mergeFrom(value);
      }
      if (commitTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public Builder clearCommitTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCommitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      if (commitTimeBuilder_ != null) {
        return commitTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction timestamp. It must be set for successful committed actions.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp commit_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimeFieldBuilder() {
      if (commitTimeBuilder_ == null) {
        commitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitTime(), getParentForChildren(), isClean());
        commitTime_ = null;
      }
      return commitTimeBuilder_;
    }

    private com.google.spanner.executor.v1.ReadResult readResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadResult,
            com.google.spanner.executor.v1.ReadResult.Builder,
            com.google.spanner.executor.v1.ReadResultOrBuilder>
        readResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     *
     * @return Whether the readResult field is set.
     */
    public boolean hasReadResult() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     *
     * @return The readResult.
     */
    public com.google.spanner.executor.v1.ReadResult getReadResult() {
      if (readResultBuilder_ == null) {
        return readResult_ == null
            ? com.google.spanner.executor.v1.ReadResult.getDefaultInstance()
            : readResult_;
      } else {
        return readResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public Builder setReadResult(com.google.spanner.executor.v1.ReadResult value) {
      if (readResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readResult_ = value;
      } else {
        readResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public Builder setReadResult(
        com.google.spanner.executor.v1.ReadResult.Builder builderForValue) {
      if (readResultBuilder_ == null) {
        readResult_ = builderForValue.build();
      } else {
        readResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public Builder mergeReadResult(com.google.spanner.executor.v1.ReadResult value) {
      if (readResultBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && readResult_ != null
            && readResult_ != com.google.spanner.executor.v1.ReadResult.getDefaultInstance()) {
          getReadResultBuilder().mergeFrom(value);
        } else {
          readResult_ = value;
        }
      } else {
        readResultBuilder_.mergeFrom(value);
      }
      if (readResult_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public Builder clearReadResult() {
      bitField0_ = (bitField0_ & ~0x00000004);
      readResult_ = null;
      if (readResultBuilder_ != null) {
        readResultBuilder_.dispose();
        readResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public com.google.spanner.executor.v1.ReadResult.Builder getReadResultBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReadResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    public com.google.spanner.executor.v1.ReadResultOrBuilder getReadResultOrBuilder() {
      if (readResultBuilder_ != null) {
        return readResultBuilder_.getMessageOrBuilder();
      } else {
        return readResult_ == null
            ? com.google.spanner.executor.v1.ReadResult.getDefaultInstance()
            : readResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Result of a ReadAction. This field must be set for ReadActions even if
     * no rows were read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.ReadResult read_result = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ReadResult,
            com.google.spanner.executor.v1.ReadResult.Builder,
            com.google.spanner.executor.v1.ReadResultOrBuilder>
        getReadResultFieldBuilder() {
      if (readResultBuilder_ == null) {
        readResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ReadResult,
                com.google.spanner.executor.v1.ReadResult.Builder,
                com.google.spanner.executor.v1.ReadResultOrBuilder>(
                getReadResult(), getParentForChildren(), isClean());
        readResult_ = null;
      }
      return readResultBuilder_;
    }

    private com.google.spanner.executor.v1.QueryResult queryResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryResult,
            com.google.spanner.executor.v1.QueryResult.Builder,
            com.google.spanner.executor.v1.QueryResultOrBuilder>
        queryResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     *
     * @return Whether the queryResult field is set.
     */
    public boolean hasQueryResult() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     *
     * @return The queryResult.
     */
    public com.google.spanner.executor.v1.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        return queryResult_ == null
            ? com.google.spanner.executor.v1.QueryResult.getDefaultInstance()
            : queryResult_;
      } else {
        return queryResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public Builder setQueryResult(com.google.spanner.executor.v1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryResult_ = value;
      } else {
        queryResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public Builder setQueryResult(
        com.google.spanner.executor.v1.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        queryResult_ = builderForValue.build();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public Builder mergeQueryResult(com.google.spanner.executor.v1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && queryResult_ != null
            && queryResult_ != com.google.spanner.executor.v1.QueryResult.getDefaultInstance()) {
          getQueryResultBuilder().mergeFrom(value);
        } else {
          queryResult_ = value;
        }
      } else {
        queryResultBuilder_.mergeFrom(value);
      }
      if (queryResult_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public Builder clearQueryResult() {
      bitField0_ = (bitField0_ & ~0x00000008);
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public com.google.spanner.executor.v1.QueryResult.Builder getQueryResultBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getQueryResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    public com.google.spanner.executor.v1.QueryResultOrBuilder getQueryResultOrBuilder() {
      if (queryResultBuilder_ != null) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        return queryResult_ == null
            ? com.google.spanner.executor.v1.QueryResult.getDefaultInstance()
            : queryResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Result of a Query. This field must be set for Queries even if no rows were
     * read.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.QueryResult query_result = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryResult,
            com.google.spanner.executor.v1.QueryResult.Builder,
            com.google.spanner.executor.v1.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.QueryResult,
                com.google.spanner.executor.v1.QueryResult.Builder,
                com.google.spanner.executor.v1.QueryResultOrBuilder>(
                getQueryResult(), getParentForChildren(), isClean());
        queryResult_ = null;
      }
      return queryResultBuilder_;
    }

    private boolean transactionRestarted_;
    /**
     *
     *
     * <pre>
     * This bit indicates that Spanner has restarted the current transaction. It
     * means that the client should replay all the reads and writes.
     * Setting it to true is only valid in the context of a read-write
     * transaction, as an outcome of a committing FinishTransactionAction.
     * </pre>
     *
     * <code>optional bool transaction_restarted = 5;</code>
     *
     * @return Whether the transactionRestarted field is set.
     */
    @java.lang.Override
    public boolean hasTransactionRestarted() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * This bit indicates that Spanner has restarted the current transaction. It
     * means that the client should replay all the reads and writes.
     * Setting it to true is only valid in the context of a read-write
     * transaction, as an outcome of a committing FinishTransactionAction.
     * </pre>
     *
     * <code>optional bool transaction_restarted = 5;</code>
     *
     * @return The transactionRestarted.
     */
    @java.lang.Override
    public boolean getTransactionRestarted() {
      return transactionRestarted_;
    }
    /**
     *
     *
     * <pre>
     * This bit indicates that Spanner has restarted the current transaction. It
     * means that the client should replay all the reads and writes.
     * Setting it to true is only valid in the context of a read-write
     * transaction, as an outcome of a committing FinishTransactionAction.
     * </pre>
     *
     * <code>optional bool transaction_restarted = 5;</code>
     *
     * @param value The transactionRestarted to set.
     * @return This builder for chaining.
     */
    public Builder setTransactionRestarted(boolean value) {

      transactionRestarted_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This bit indicates that Spanner has restarted the current transaction. It
     * means that the client should replay all the reads and writes.
     * Setting it to true is only valid in the context of a read-write
     * transaction, as an outcome of a committing FinishTransactionAction.
     * </pre>
     *
     * <code>optional bool transaction_restarted = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransactionRestarted() {
      bitField0_ = (bitField0_ & ~0x00000010);
      transactionRestarted_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString batchTxnId_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * In successful StartBatchTransactionAction outcomes, this contains the ID of
     * the transaction.
     * </pre>
     *
     * <code>optional bytes batch_txn_id = 6;</code>
     *
     * @return Whether the batchTxnId field is set.
     */
    @java.lang.Override
    public boolean hasBatchTxnId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * In successful StartBatchTransactionAction outcomes, this contains the ID of
     * the transaction.
     * </pre>
     *
     * <code>optional bytes batch_txn_id = 6;</code>
     *
     * @return The batchTxnId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBatchTxnId() {
      return batchTxnId_;
    }
    /**
     *
     *
     * <pre>
     * In successful StartBatchTransactionAction outcomes, this contains the ID of
     * the transaction.
     * </pre>
     *
     * <code>optional bytes batch_txn_id = 6;</code>
     *
     * @param value The batchTxnId to set.
     * @return This builder for chaining.
     */
    public Builder setBatchTxnId(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      batchTxnId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In successful StartBatchTransactionAction outcomes, this contains the ID of
     * the transaction.
     * </pre>
     *
     * <code>optional bytes batch_txn_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBatchTxnId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      batchTxnId_ = getDefaultInstance().getBatchTxnId();
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.executor.v1.BatchPartition> dbPartition_ =
        java.util.Collections.emptyList();

    private void ensureDbPartitionIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        dbPartition_ =
            new java.util.ArrayList<com.google.spanner.executor.v1.BatchPartition>(dbPartition_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.BatchPartition,
            com.google.spanner.executor.v1.BatchPartition.Builder,
            com.google.spanner.executor.v1.BatchPartitionOrBuilder>
        dbPartitionBuilder_;

    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.BatchPartition> getDbPartitionList() {
      if (dbPartitionBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dbPartition_);
      } else {
        return dbPartitionBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public int getDbPartitionCount() {
      if (dbPartitionBuilder_ == null) {
        return dbPartition_.size();
      } else {
        return dbPartitionBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public com.google.spanner.executor.v1.BatchPartition getDbPartition(int index) {
      if (dbPartitionBuilder_ == null) {
        return dbPartition_.get(index);
      } else {
        return dbPartitionBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder setDbPartition(int index, com.google.spanner.executor.v1.BatchPartition value) {
      if (dbPartitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbPartitionIsMutable();
        dbPartition_.set(index, value);
        onChanged();
      } else {
        dbPartitionBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder setDbPartition(
        int index, com.google.spanner.executor.v1.BatchPartition.Builder builderForValue) {
      if (dbPartitionBuilder_ == null) {
        ensureDbPartitionIsMutable();
        dbPartition_.set(index, builderForValue.build());
        onChanged();
      } else {
        dbPartitionBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder addDbPartition(com.google.spanner.executor.v1.BatchPartition value) {
      if (dbPartitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbPartitionIsMutable();
        dbPartition_.add(value);
        onChanged();
      } else {
        dbPartitionBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder addDbPartition(int index, com.google.spanner.executor.v1.BatchPartition value) {
      if (dbPartitionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDbPartitionIsMutable();
        dbPartition_.add(index, value);
        onChanged();
      } else {
        dbPartitionBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder addDbPartition(
        com.google.spanner.executor.v1.BatchPartition.Builder builderForValue) {
      if (dbPartitionBuilder_ == null) {
        ensureDbPartitionIsMutable();
        dbPartition_.add(builderForValue.build());
        onChanged();
      } else {
        dbPartitionBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder addDbPartition(
        int index, com.google.spanner.executor.v1.BatchPartition.Builder builderForValue) {
      if (dbPartitionBuilder_ == null) {
        ensureDbPartitionIsMutable();
        dbPartition_.add(index, builderForValue.build());
        onChanged();
      } else {
        dbPartitionBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder addAllDbPartition(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.BatchPartition> values) {
      if (dbPartitionBuilder_ == null) {
        ensureDbPartitionIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dbPartition_);
        onChanged();
      } else {
        dbPartitionBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder clearDbPartition() {
      if (dbPartitionBuilder_ == null) {
        dbPartition_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        dbPartitionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public Builder removeDbPartition(int index) {
      if (dbPartitionBuilder_ == null) {
        ensureDbPartitionIsMutable();
        dbPartition_.remove(index);
        onChanged();
      } else {
        dbPartitionBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public com.google.spanner.executor.v1.BatchPartition.Builder getDbPartitionBuilder(int index) {
      return getDbPartitionFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public com.google.spanner.executor.v1.BatchPartitionOrBuilder getDbPartitionOrBuilder(
        int index) {
      if (dbPartitionBuilder_ == null) {
        return dbPartition_.get(index);
      } else {
        return dbPartitionBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.BatchPartitionOrBuilder>
        getDbPartitionOrBuilderList() {
      if (dbPartitionBuilder_ != null) {
        return dbPartitionBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dbPartition_);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public com.google.spanner.executor.v1.BatchPartition.Builder addDbPartitionBuilder() {
      return getDbPartitionFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.BatchPartition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public com.google.spanner.executor.v1.BatchPartition.Builder addDbPartitionBuilder(int index) {
      return getDbPartitionFieldBuilder()
          .addBuilder(index, com.google.spanner.executor.v1.BatchPartition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Generated database partitions (result of a
     * GenetageDbPartitionsForReadAction/GenerateDbPartitionsForQueryAction).
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.BatchPartition db_partition = 7;</code>
     */
    public java.util.List<com.google.spanner.executor.v1.BatchPartition.Builder>
        getDbPartitionBuilderList() {
      return getDbPartitionFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.BatchPartition,
            com.google.spanner.executor.v1.BatchPartition.Builder,
            com.google.spanner.executor.v1.BatchPartitionOrBuilder>
        getDbPartitionFieldBuilder() {
      if (dbPartitionBuilder_ == null) {
        dbPartitionBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.BatchPartition,
                com.google.spanner.executor.v1.BatchPartition.Builder,
                com.google.spanner.executor.v1.BatchPartitionOrBuilder>(
                dbPartition_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        dbPartition_ = null;
      }
      return dbPartitionBuilder_;
    }

    private com.google.spanner.executor.v1.AdminResult adminResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.AdminResult,
            com.google.spanner.executor.v1.AdminResult.Builder,
            com.google.spanner.executor.v1.AdminResultOrBuilder>
        adminResultBuilder_;
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     *
     * @return Whether the adminResult field is set.
     */
    public boolean hasAdminResult() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     *
     * @return The adminResult.
     */
    public com.google.spanner.executor.v1.AdminResult getAdminResult() {
      if (adminResultBuilder_ == null) {
        return adminResult_ == null
            ? com.google.spanner.executor.v1.AdminResult.getDefaultInstance()
            : adminResult_;
      } else {
        return adminResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public Builder setAdminResult(com.google.spanner.executor.v1.AdminResult value) {
      if (adminResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adminResult_ = value;
      } else {
        adminResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public Builder setAdminResult(
        com.google.spanner.executor.v1.AdminResult.Builder builderForValue) {
      if (adminResultBuilder_ == null) {
        adminResult_ = builderForValue.build();
      } else {
        adminResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public Builder mergeAdminResult(com.google.spanner.executor.v1.AdminResult value) {
      if (adminResultBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && adminResult_ != null
            && adminResult_ != com.google.spanner.executor.v1.AdminResult.getDefaultInstance()) {
          getAdminResultBuilder().mergeFrom(value);
        } else {
          adminResult_ = value;
        }
      } else {
        adminResultBuilder_.mergeFrom(value);
      }
      if (adminResult_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public Builder clearAdminResult() {
      bitField0_ = (bitField0_ & ~0x00000080);
      adminResult_ = null;
      if (adminResultBuilder_ != null) {
        adminResultBuilder_.dispose();
        adminResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public com.google.spanner.executor.v1.AdminResult.Builder getAdminResultBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getAdminResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    public com.google.spanner.executor.v1.AdminResultOrBuilder getAdminResultOrBuilder() {
      if (adminResultBuilder_ != null) {
        return adminResultBuilder_.getMessageOrBuilder();
      } else {
        return adminResult_ == null
            ? com.google.spanner.executor.v1.AdminResult.getDefaultInstance()
            : adminResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Result of admin related actions.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.AdminResult admin_result = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.AdminResult,
            com.google.spanner.executor.v1.AdminResult.Builder,
            com.google.spanner.executor.v1.AdminResultOrBuilder>
        getAdminResultFieldBuilder() {
      if (adminResultBuilder_ == null) {
        adminResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.AdminResult,
                com.google.spanner.executor.v1.AdminResult.Builder,
                com.google.spanner.executor.v1.AdminResultOrBuilder>(
                getAdminResult(), getParentForChildren(), isClean());
        adminResult_ = null;
      }
      return adminResultBuilder_;
    }

    private com.google.protobuf.Internal.LongList dmlRowsModified_ = emptyLongList();

    private void ensureDmlRowsModifiedIsMutable() {
      if (!dmlRowsModified_.isModifiable()) {
        dmlRowsModified_ = makeMutableCopy(dmlRowsModified_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @return A list containing the dmlRowsModified.
     */
    public java.util.List<java.lang.Long> getDmlRowsModifiedList() {
      dmlRowsModified_.makeImmutable();
      return dmlRowsModified_;
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @return The count of dmlRowsModified.
     */
    public int getDmlRowsModifiedCount() {
      return dmlRowsModified_.size();
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The dmlRowsModified at the given index.
     */
    public long getDmlRowsModified(int index) {
      return dmlRowsModified_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The dmlRowsModified to set.
     * @return This builder for chaining.
     */
    public Builder setDmlRowsModified(int index, long value) {

      ensureDmlRowsModifiedIsMutable();
      dmlRowsModified_.setLong(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @param value The dmlRowsModified to add.
     * @return This builder for chaining.
     */
    public Builder addDmlRowsModified(long value) {

      ensureDmlRowsModifiedIsMutable();
      dmlRowsModified_.addLong(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @param values The dmlRowsModified to add.
     * @return This builder for chaining.
     */
    public Builder addAllDmlRowsModified(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureDmlRowsModifiedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dmlRowsModified_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stores rows modified by query in single DML or batch DML action.
     * In case of batch DML action, stores 0 as row count of errored DML query.
     * </pre>
     *
     * <code>repeated int64 dml_rows_modified = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDmlRowsModified() {
      dmlRowsModified_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.executor.v1.ChangeStreamRecord> changeStreamRecords_ =
        java.util.Collections.emptyList();

    private void ensureChangeStreamRecordsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        changeStreamRecords_ =
            new java.util.ArrayList<com.google.spanner.executor.v1.ChangeStreamRecord>(
                changeStreamRecords_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ChangeStreamRecord,
            com.google.spanner.executor.v1.ChangeStreamRecord.Builder,
            com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder>
        changeStreamRecordsBuilder_;

    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public java.util.List<com.google.spanner.executor.v1.ChangeStreamRecord>
        getChangeStreamRecordsList() {
      if (changeStreamRecordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(changeStreamRecords_);
      } else {
        return changeStreamRecordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public int getChangeStreamRecordsCount() {
      if (changeStreamRecordsBuilder_ == null) {
        return changeStreamRecords_.size();
      } else {
        return changeStreamRecordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeStreamRecord getChangeStreamRecords(int index) {
      if (changeStreamRecordsBuilder_ == null) {
        return changeStreamRecords_.get(index);
      } else {
        return changeStreamRecordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder setChangeStreamRecords(
        int index, com.google.spanner.executor.v1.ChangeStreamRecord value) {
      if (changeStreamRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.set(index, value);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder setChangeStreamRecords(
        int index, com.google.spanner.executor.v1.ChangeStreamRecord.Builder builderForValue) {
      if (changeStreamRecordsBuilder_ == null) {
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.set(index, builderForValue.build());
        onChanged();
      } else {
        changeStreamRecordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder addChangeStreamRecords(com.google.spanner.executor.v1.ChangeStreamRecord value) {
      if (changeStreamRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.add(value);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder addChangeStreamRecords(
        int index, com.google.spanner.executor.v1.ChangeStreamRecord value) {
      if (changeStreamRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.add(index, value);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder addChangeStreamRecords(
        com.google.spanner.executor.v1.ChangeStreamRecord.Builder builderForValue) {
      if (changeStreamRecordsBuilder_ == null) {
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.add(builderForValue.build());
        onChanged();
      } else {
        changeStreamRecordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder addChangeStreamRecords(
        int index, com.google.spanner.executor.v1.ChangeStreamRecord.Builder builderForValue) {
      if (changeStreamRecordsBuilder_ == null) {
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.add(index, builderForValue.build());
        onChanged();
      } else {
        changeStreamRecordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder addAllChangeStreamRecords(
        java.lang.Iterable<? extends com.google.spanner.executor.v1.ChangeStreamRecord> values) {
      if (changeStreamRecordsBuilder_ == null) {
        ensureChangeStreamRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, changeStreamRecords_);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder clearChangeStreamRecords() {
      if (changeStreamRecordsBuilder_ == null) {
        changeStreamRecords_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public Builder removeChangeStreamRecords(int index) {
      if (changeStreamRecordsBuilder_ == null) {
        ensureChangeStreamRecordsIsMutable();
        changeStreamRecords_.remove(index);
        onChanged();
      } else {
        changeStreamRecordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeStreamRecord.Builder getChangeStreamRecordsBuilder(
        int index) {
      return getChangeStreamRecordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder
        getChangeStreamRecordsOrBuilder(int index) {
      if (changeStreamRecordsBuilder_ == null) {
        return changeStreamRecords_.get(index);
      } else {
        return changeStreamRecordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public java.util.List<? extends com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder>
        getChangeStreamRecordsOrBuilderList() {
      if (changeStreamRecordsBuilder_ != null) {
        return changeStreamRecordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(changeStreamRecords_);
      }
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeStreamRecord.Builder
        addChangeStreamRecordsBuilder() {
      return getChangeStreamRecordsFieldBuilder()
          .addBuilder(com.google.spanner.executor.v1.ChangeStreamRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public com.google.spanner.executor.v1.ChangeStreamRecord.Builder addChangeStreamRecordsBuilder(
        int index) {
      return getChangeStreamRecordsFieldBuilder()
          .addBuilder(
              index, com.google.spanner.executor.v1.ChangeStreamRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Change stream records returned by a change stream query.
     * </pre>
     *
     * <code>repeated .google.spanner.executor.v1.ChangeStreamRecord change_stream_records = 10;
     * </code>
     */
    public java.util.List<com.google.spanner.executor.v1.ChangeStreamRecord.Builder>
        getChangeStreamRecordsBuilderList() {
      return getChangeStreamRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.executor.v1.ChangeStreamRecord,
            com.google.spanner.executor.v1.ChangeStreamRecord.Builder,
            com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder>
        getChangeStreamRecordsFieldBuilder() {
      if (changeStreamRecordsBuilder_ == null) {
        changeStreamRecordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.executor.v1.ChangeStreamRecord,
                com.google.spanner.executor.v1.ChangeStreamRecord.Builder,
                com.google.spanner.executor.v1.ChangeStreamRecordOrBuilder>(
                changeStreamRecords_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        changeStreamRecords_ = null;
      }
      return changeStreamRecordsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.SpannerActionOutcome)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.SpannerActionOutcome)
  private static final com.google.spanner.executor.v1.SpannerActionOutcome DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.SpannerActionOutcome();
  }

  public static com.google.spanner.executor.v1.SpannerActionOutcome getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpannerActionOutcome> PARSER =
      new com.google.protobuf.AbstractParser<SpannerActionOutcome>() {
        @java.lang.Override
        public SpannerActionOutcome parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpannerActionOutcome> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpannerActionOutcome> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.SpannerActionOutcome getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
