/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Action that restores a Cloud Spanner database from a backup.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.RestoreCloudDatabaseAction}
 */
public final class RestoreCloudDatabaseAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.RestoreCloudDatabaseAction)
    RestoreCloudDatabaseActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreCloudDatabaseAction.newBuilder() to construct.
  private RestoreCloudDatabaseAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreCloudDatabaseAction() {
    projectId_ = "";
    backupInstanceId_ = "";
    backupId_ = "";
    databaseInstanceId_ = "";
    databaseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreCloudDatabaseAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_RestoreCloudDatabaseAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_RestoreCloudDatabaseAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction.class,
            com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud project ID, e.g. "spanner-cloud-systest".
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_INSTANCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupInstanceId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
   * </pre>
   *
   * <code>string backup_instance_id = 2;</code>
   *
   * @return The backupInstanceId.
   */
  @java.lang.Override
  public java.lang.String getBackupInstanceId() {
    java.lang.Object ref = backupInstanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupInstanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
   * </pre>
   *
   * <code>string backup_instance_id = 2;</code>
   *
   * @return The bytes for backupInstanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupInstanceIdBytes() {
    java.lang.Object ref = backupInstanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupInstanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupId_ = "";
  /**
   *
   *
   * <pre>
   * The id of the backup from which to restore, e.g. "test-backup".
   * </pre>
   *
   * <code>string backup_id = 3;</code>
   *
   * @return The backupId.
   */
  @java.lang.Override
  public java.lang.String getBackupId() {
    java.lang.Object ref = backupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The id of the backup from which to restore, e.g. "test-backup".
   * </pre>
   *
   * <code>string backup_id = 3;</code>
   *
   * @return The bytes for backupId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupIdBytes() {
    java.lang.Object ref = backupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_INSTANCE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseInstanceId_ = "";
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path) containing the database, e.g.
   * "database-instance".
   * </pre>
   *
   * <code>string database_instance_id = 4;</code>
   *
   * @return The databaseInstanceId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseInstanceId() {
    java.lang.Object ref = databaseInstanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseInstanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud instance ID (not path) containing the database, e.g.
   * "database-instance".
   * </pre>
   *
   * <code>string database_instance_id = 4;</code>
   *
   * @return The bytes for databaseInstanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseInstanceIdBytes() {
    java.lang.Object ref = databaseInstanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseInstanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseId_ = "";
  /**
   *
   *
   * <pre>
   * The id of the database to create and restore to, e.g. "db0". Note that this
   * database must not already exist.
   * </pre>
   *
   * <code>string database_id = 5;</code>
   *
   * @return The databaseId.
   */
  @java.lang.Override
  public java.lang.String getDatabaseId() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The id of the database to create and restore to, e.g. "db0". Note that this
   * database must not already exist.
   * </pre>
   *
   * <code>string database_id = 5;</code>
   *
   * @return The bytes for databaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseIdBytes() {
    java.lang.Object ref = databaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 7;
  private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * The KMS key(s) used to encrypt the restored database to be created if the
   * restored database should be CMEK protected.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The KMS key(s) used to encrypt the restored database to be created if the
   * restored database should be CMEK protected.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * The KMS key(s) used to encrypt the restored database to be created if the
   * restored database should be CMEK protected.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupInstanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, backupInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, backupId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseInstanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, databaseInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, databaseId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getEncryptionConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupInstanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, backupInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, backupId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseInstanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, databaseInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, databaseId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEncryptionConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.RestoreCloudDatabaseAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.RestoreCloudDatabaseAction other =
        (com.google.spanner.executor.v1.RestoreCloudDatabaseAction) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getBackupInstanceId().equals(other.getBackupInstanceId())) return false;
    if (!getBackupId().equals(other.getBackupId())) return false;
    if (!getDatabaseInstanceId().equals(other.getDatabaseInstanceId())) return false;
    if (!getDatabaseId().equals(other.getDatabaseId())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + BACKUP_INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBackupInstanceId().hashCode();
    hash = (37 * hash) + BACKUP_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBackupId().hashCode();
    hash = (37 * hash) + DATABASE_INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseInstanceId().hashCode();
    hash = (37 * hash) + DATABASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseId().hashCode();
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.RestoreCloudDatabaseAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Action that restores a Cloud Spanner database from a backup.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.RestoreCloudDatabaseAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.RestoreCloudDatabaseAction)
      com.google.spanner.executor.v1.RestoreCloudDatabaseActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_RestoreCloudDatabaseAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_RestoreCloudDatabaseAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.RestoreCloudDatabaseAction.class,
              com.google.spanner.executor.v1.RestoreCloudDatabaseAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.RestoreCloudDatabaseAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      backupInstanceId_ = "";
      backupId_ = "";
      databaseInstanceId_ = "";
      databaseId_ = "";
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_RestoreCloudDatabaseAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.RestoreCloudDatabaseAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.RestoreCloudDatabaseAction build() {
      com.google.spanner.executor.v1.RestoreCloudDatabaseAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.RestoreCloudDatabaseAction buildPartial() {
      com.google.spanner.executor.v1.RestoreCloudDatabaseAction result =
          new com.google.spanner.executor.v1.RestoreCloudDatabaseAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.RestoreCloudDatabaseAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.backupInstanceId_ = backupInstanceId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.backupId_ = backupId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.databaseInstanceId_ = databaseInstanceId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.databaseId_ = databaseId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.RestoreCloudDatabaseAction) {
        return mergeFrom((com.google.spanner.executor.v1.RestoreCloudDatabaseAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.RestoreCloudDatabaseAction other) {
      if (other == com.google.spanner.executor.v1.RestoreCloudDatabaseAction.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBackupInstanceId().isEmpty()) {
        backupInstanceId_ = other.backupInstanceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getBackupId().isEmpty()) {
        backupId_ = other.backupId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDatabaseInstanceId().isEmpty()) {
        databaseInstanceId_ = other.databaseInstanceId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDatabaseId().isEmpty()) {
        databaseId_ = other.databaseId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                backupInstanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                backupId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                databaseInstanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                databaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud project ID, e.g. "spanner-cloud-systest".
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object backupInstanceId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
     * </pre>
     *
     * <code>string backup_instance_id = 2;</code>
     *
     * @return The backupInstanceId.
     */
    public java.lang.String getBackupInstanceId() {
      java.lang.Object ref = backupInstanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupInstanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
     * </pre>
     *
     * <code>string backup_instance_id = 2;</code>
     *
     * @return The bytes for backupInstanceId.
     */
    public com.google.protobuf.ByteString getBackupInstanceIdBytes() {
      java.lang.Object ref = backupInstanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupInstanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
     * </pre>
     *
     * <code>string backup_instance_id = 2;</code>
     *
     * @param value The backupInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupInstanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
     * </pre>
     *
     * <code>string backup_instance_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupInstanceId() {
      backupInstanceId_ = getDefaultInstance().getBackupInstanceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the backup, e.g. "backup-instance".
     * </pre>
     *
     * <code>string backup_instance_id = 2;</code>
     *
     * @param value The bytes for backupInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupInstanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object backupId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the backup from which to restore, e.g. "test-backup".
     * </pre>
     *
     * <code>string backup_id = 3;</code>
     *
     * @return The backupId.
     */
    public java.lang.String getBackupId() {
      java.lang.Object ref = backupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the backup from which to restore, e.g. "test-backup".
     * </pre>
     *
     * <code>string backup_id = 3;</code>
     *
     * @return The bytes for backupId.
     */
    public com.google.protobuf.ByteString getBackupIdBytes() {
      java.lang.Object ref = backupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the backup from which to restore, e.g. "test-backup".
     * </pre>
     *
     * <code>string backup_id = 3;</code>
     *
     * @param value The backupId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the backup from which to restore, e.g. "test-backup".
     * </pre>
     *
     * <code>string backup_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupId() {
      backupId_ = getDefaultInstance().getBackupId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the backup from which to restore, e.g. "test-backup".
     * </pre>
     *
     * <code>string backup_id = 3;</code>
     *
     * @param value The bytes for backupId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object databaseInstanceId_ = "";
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the database, e.g.
     * "database-instance".
     * </pre>
     *
     * <code>string database_instance_id = 4;</code>
     *
     * @return The databaseInstanceId.
     */
    public java.lang.String getDatabaseInstanceId() {
      java.lang.Object ref = databaseInstanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseInstanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the database, e.g.
     * "database-instance".
     * </pre>
     *
     * <code>string database_instance_id = 4;</code>
     *
     * @return The bytes for databaseInstanceId.
     */
    public com.google.protobuf.ByteString getDatabaseInstanceIdBytes() {
      java.lang.Object ref = databaseInstanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseInstanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the database, e.g.
     * "database-instance".
     * </pre>
     *
     * <code>string database_instance_id = 4;</code>
     *
     * @param value The databaseInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseInstanceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the database, e.g.
     * "database-instance".
     * </pre>
     *
     * <code>string database_instance_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseInstanceId() {
      databaseInstanceId_ = getDefaultInstance().getDatabaseInstanceId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud instance ID (not path) containing the database, e.g.
     * "database-instance".
     * </pre>
     *
     * <code>string database_instance_id = 4;</code>
     *
     * @param value The bytes for databaseInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseInstanceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object databaseId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the database to create and restore to, e.g. "db0". Note that this
     * database must not already exist.
     * </pre>
     *
     * <code>string database_id = 5;</code>
     *
     * @return The databaseId.
     */
    public java.lang.String getDatabaseId() {
      java.lang.Object ref = databaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the database to create and restore to, e.g. "db0". Note that this
     * database must not already exist.
     * </pre>
     *
     * <code>string database_id = 5;</code>
     *
     * @return The bytes for databaseId.
     */
    public com.google.protobuf.ByteString getDatabaseIdBytes() {
      java.lang.Object ref = databaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the database to create and restore to, e.g. "db0". Note that this
     * database must not already exist.
     * </pre>
     *
     * <code>string database_id = 5;</code>
     *
     * @param value The databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the database to create and restore to, e.g. "db0". Note that this
     * database must not already exist.
     * </pre>
     *
     * <code>string database_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseId() {
      databaseId_ = getDefaultInstance().getDatabaseId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the database to create and restore to, e.g. "db0". Note that this
     * database must not already exist.
     * </pre>
     *
     * <code>string database_id = 5;</code>
     *
     * @param value The bytes for databaseId to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key(s) used to encrypt the restored database to be created if the
     * restored database should be CMEK protected.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.EncryptionConfig encryption_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionConfig,
                com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.RestoreCloudDatabaseAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.RestoreCloudDatabaseAction)
  private static final com.google.spanner.executor.v1.RestoreCloudDatabaseAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.RestoreCloudDatabaseAction();
  }

  public static com.google.spanner.executor.v1.RestoreCloudDatabaseAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreCloudDatabaseAction> PARSER =
      new com.google.protobuf.AbstractParser<RestoreCloudDatabaseAction>() {
        @java.lang.Override
        public RestoreCloudDatabaseAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreCloudDatabaseAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreCloudDatabaseAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.RestoreCloudDatabaseAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
