/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * A single read request.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.ReadAction}
 */
public final class ReadAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.ReadAction)
    ReadActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadAction.newBuilder() to construct.
  private ReadAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadAction() {
    table_ = "";
    index_ = "";
    column_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ReadAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_ReadAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.ReadAction.class,
            com.google.spanner.executor.v1.ReadAction.Builder.class);
  }

  private int bitField0_;
  public static final int TABLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * The table to read at.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The table to read at.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";
  /**
   *
   *
   * <pre>
   * The index to read at if it's an index read.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return Whether the index field is set.
   */
  @java.lang.Override
  public boolean hasIndex() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The index to read at if it's an index read.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The index to read at if it's an index read.
   * </pre>
   *
   * <code>optional string index = 2;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList column_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of columns must begin with the key columns used for the read.
   * </pre>
   *
   * <code>repeated string column = 3;</code>
   *
   * @return A list containing the column.
   */
  public com.google.protobuf.ProtocolStringList getColumnList() {
    return column_;
  }
  /**
   *
   *
   * <pre>
   * List of columns must begin with the key columns used for the read.
   * </pre>
   *
   * <code>repeated string column = 3;</code>
   *
   * @return The count of column.
   */
  public int getColumnCount() {
    return column_.size();
  }
  /**
   *
   *
   * <pre>
   * List of columns must begin with the key columns used for the read.
   * </pre>
   *
   * <code>repeated string column = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The column at the given index.
   */
  public java.lang.String getColumn(int index) {
    return column_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of columns must begin with the key columns used for the read.
   * </pre>
   *
   * <code>repeated string column = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the column at the given index.
   */
  public com.google.protobuf.ByteString getColumnBytes(int index) {
    return column_.getByteString(index);
  }

  public static final int KEYS_FIELD_NUMBER = 4;
  private com.google.spanner.executor.v1.KeySet keys_;
  /**
   *
   *
   * <pre>
   * Keys for performing this read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
   *
   * @return Whether the keys field is set.
   */
  @java.lang.Override
  public boolean hasKeys() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Keys for performing this read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
   *
   * @return The keys.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.KeySet getKeys() {
    return keys_ == null ? com.google.spanner.executor.v1.KeySet.getDefaultInstance() : keys_;
  }
  /**
   *
   *
   * <pre>
   * Keys for performing this read.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.KeySetOrBuilder getKeysOrBuilder() {
    return keys_ == null ? com.google.spanner.executor.v1.KeySet.getDefaultInstance() : keys_;
  }

  public static final int LIMIT_FIELD_NUMBER = 5;
  private int limit_ = 0;
  /**
   *
   *
   * <pre>
   * Limit on number of rows to read. If set, must be positive.
   * </pre>
   *
   * <code>int32 limit = 5;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public int getLimit() {
    return limit_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, index_);
    }
    for (int i = 0; i < column_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, column_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getKeys());
    }
    if (limit_ != 0) {
      output.writeInt32(5, limit_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, index_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < column_.size(); i++) {
        dataSize += computeStringSizeNoTag(column_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getColumnList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getKeys());
    }
    if (limit_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, limit_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.ReadAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.ReadAction other =
        (com.google.spanner.executor.v1.ReadAction) obj;

    if (!getTable().equals(other.getTable())) return false;
    if (hasIndex() != other.hasIndex()) return false;
    if (hasIndex()) {
      if (!getIndex().equals(other.getIndex())) return false;
    }
    if (!getColumnList().equals(other.getColumnList())) return false;
    if (hasKeys() != other.hasKeys()) return false;
    if (hasKeys()) {
      if (!getKeys().equals(other.getKeys())) return false;
    }
    if (getLimit() != other.getLimit()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    if (hasIndex()) {
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex().hashCode();
    }
    if (getColumnCount() > 0) {
      hash = (37 * hash) + COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getColumnList().hashCode();
    }
    if (hasKeys()) {
      hash = (37 * hash) + KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getKeys().hashCode();
    }
    hash = (37 * hash) + LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + getLimit();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.ReadAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.ReadAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single read request.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.ReadAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.ReadAction)
      com.google.spanner.executor.v1.ReadActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.ReadAction.class,
              com.google.spanner.executor.v1.ReadAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.ReadAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getKeysFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      table_ = "";
      index_ = "";
      column_ = com.google.protobuf.LazyStringArrayList.emptyList();
      keys_ = null;
      if (keysBuilder_ != null) {
        keysBuilder_.dispose();
        keysBuilder_ = null;
      }
      limit_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_ReadAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.ReadAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadAction build() {
      com.google.spanner.executor.v1.ReadAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.ReadAction buildPartial() {
      com.google.spanner.executor.v1.ReadAction result =
          new com.google.spanner.executor.v1.ReadAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.ReadAction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.table_ = table_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.index_ = index_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        column_.makeImmutable();
        result.column_ = column_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.keys_ = keysBuilder_ == null ? keys_ : keysBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.limit_ = limit_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.ReadAction) {
        return mergeFrom((com.google.spanner.executor.v1.ReadAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.ReadAction other) {
      if (other == com.google.spanner.executor.v1.ReadAction.getDefaultInstance()) return this;
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasIndex()) {
        index_ = other.index_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.column_.isEmpty()) {
        if (column_.isEmpty()) {
          column_ = other.column_;
          bitField0_ |= 0x00000004;
        } else {
          ensureColumnIsMutable();
          column_.addAll(other.column_);
        }
        onChanged();
      }
      if (other.hasKeys()) {
        mergeKeys(other.getKeys());
      }
      if (other.getLimit() != 0) {
        setLimit(other.getLimit());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureColumnIsMutable();
                column_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getKeysFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                limit_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * The table to read at.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The table to read at.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The table to read at.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The table to read at.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The table to read at.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return Whether the index field is set.
     */
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The index to read at if it's an index read.
     * </pre>
     *
     * <code>optional string index = 2;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList column_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureColumnIsMutable() {
      if (!column_.isModifiable()) {
        column_ = new com.google.protobuf.LazyStringArrayList(column_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @return A list containing the column.
     */
    public com.google.protobuf.ProtocolStringList getColumnList() {
      column_.makeImmutable();
      return column_;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @return The count of column.
     */
    public int getColumnCount() {
      return column_.size();
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The column at the given index.
     */
    public java.lang.String getColumn(int index) {
      return column_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the column at the given index.
     */
    public com.google.protobuf.ByteString getColumnBytes(int index) {
      return column_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The column to set.
     * @return This builder for chaining.
     */
    public Builder setColumn(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnIsMutable();
      column_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param value The column to add.
     * @return This builder for chaining.
     */
    public Builder addColumn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureColumnIsMutable();
      column_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param values The column to add.
     * @return This builder for chaining.
     */
    public Builder addAllColumn(java.lang.Iterable<java.lang.String> values) {
      ensureColumnIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, column_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumn() {
      column_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of columns must begin with the key columns used for the read.
     * </pre>
     *
     * <code>repeated string column = 3;</code>
     *
     * @param value The bytes of the column to add.
     * @return This builder for chaining.
     */
    public Builder addColumnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureColumnIsMutable();
      column_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.spanner.executor.v1.KeySet keys_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.KeySet,
            com.google.spanner.executor.v1.KeySet.Builder,
            com.google.spanner.executor.v1.KeySetOrBuilder>
        keysBuilder_;
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     *
     * @return Whether the keys field is set.
     */
    public boolean hasKeys() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     *
     * @return The keys.
     */
    public com.google.spanner.executor.v1.KeySet getKeys() {
      if (keysBuilder_ == null) {
        return keys_ == null ? com.google.spanner.executor.v1.KeySet.getDefaultInstance() : keys_;
      } else {
        return keysBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public Builder setKeys(com.google.spanner.executor.v1.KeySet value) {
      if (keysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        keys_ = value;
      } else {
        keysBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public Builder setKeys(com.google.spanner.executor.v1.KeySet.Builder builderForValue) {
      if (keysBuilder_ == null) {
        keys_ = builderForValue.build();
      } else {
        keysBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public Builder mergeKeys(com.google.spanner.executor.v1.KeySet value) {
      if (keysBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && keys_ != null
            && keys_ != com.google.spanner.executor.v1.KeySet.getDefaultInstance()) {
          getKeysBuilder().mergeFrom(value);
        } else {
          keys_ = value;
        }
      } else {
        keysBuilder_.mergeFrom(value);
      }
      if (keys_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public Builder clearKeys() {
      bitField0_ = (bitField0_ & ~0x00000008);
      keys_ = null;
      if (keysBuilder_ != null) {
        keysBuilder_.dispose();
        keysBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public com.google.spanner.executor.v1.KeySet.Builder getKeysBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getKeysFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    public com.google.spanner.executor.v1.KeySetOrBuilder getKeysOrBuilder() {
      if (keysBuilder_ != null) {
        return keysBuilder_.getMessageOrBuilder();
      } else {
        return keys_ == null ? com.google.spanner.executor.v1.KeySet.getDefaultInstance() : keys_;
      }
    }
    /**
     *
     *
     * <pre>
     * Keys for performing this read.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.KeySet keys = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.KeySet,
            com.google.spanner.executor.v1.KeySet.Builder,
            com.google.spanner.executor.v1.KeySetOrBuilder>
        getKeysFieldBuilder() {
      if (keysBuilder_ == null) {
        keysBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.KeySet,
                com.google.spanner.executor.v1.KeySet.Builder,
                com.google.spanner.executor.v1.KeySetOrBuilder>(
                getKeys(), getParentForChildren(), isClean());
        keys_ = null;
      }
      return keysBuilder_;
    }

    private int limit_;
    /**
     *
     *
     * <pre>
     * Limit on number of rows to read. If set, must be positive.
     * </pre>
     *
     * <code>int32 limit = 5;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public int getLimit() {
      return limit_;
    }
    /**
     *
     *
     * <pre>
     * Limit on number of rows to read. If set, must be positive.
     * </pre>
     *
     * <code>int32 limit = 5;</code>
     *
     * @param value The limit to set.
     * @return This builder for chaining.
     */
    public Builder setLimit(int value) {

      limit_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limit on number of rows to read. If set, must be positive.
     * </pre>
     *
     * <code>int32 limit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000010);
      limit_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.ReadAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.ReadAction)
  private static final com.google.spanner.executor.v1.ReadAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.ReadAction();
  }

  public static com.google.spanner.executor.v1.ReadAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadAction> PARSER =
      new com.google.protobuf.AbstractParser<ReadAction>() {
        @java.lang.Override
        public ReadAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.ReadAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
