/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * PartitionedUpdateAction defines an action to execute a partitioned DML
 * which runs different partitions in parallel.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.PartitionedUpdateAction}
 */
public final class PartitionedUpdateAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.PartitionedUpdateAction)
    PartitionedUpdateActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartitionedUpdateAction.newBuilder() to construct.
  private PartitionedUpdateAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartitionedUpdateAction() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartitionedUpdateAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.PartitionedUpdateAction.class,
            com.google.spanner.executor.v1.PartitionedUpdateAction.Builder.class);
  }

  public interface ExecutePartitionedUpdateOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return Whether the rpcPriority field is set.
     */
    boolean hasRpcPriority();
    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return The enum numeric value on the wire for rpcPriority.
     */
    int getRpcPriorityValue();
    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return The rpcPriority.
     */
    com.google.spanner.v1.RequestOptions.Priority getRpcPriority();

    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return Whether the tag field is set.
     */
    boolean hasTag();
    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return The tag.
     */
    java.lang.String getTag();
    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return The bytes for tag.
     */
    com.google.protobuf.ByteString getTagBytes();
  }
  /**
   * Protobuf type {@code
   * google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions}
   */
  public static final class ExecutePartitionedUpdateOptions
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
      ExecutePartitionedUpdateOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExecutePartitionedUpdateOptions.newBuilder() to construct.
    private ExecutePartitionedUpdateOptions(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExecutePartitionedUpdateOptions() {
      rpcPriority_ = 0;
      tag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExecutePartitionedUpdateOptions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_ExecutePartitionedUpdateOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_ExecutePartitionedUpdateOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                  .class,
              com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                  .Builder.class);
    }

    private int bitField0_;
    public static final int RPC_PRIORITY_FIELD_NUMBER = 1;
    private int rpcPriority_ = 0;
    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return Whether the rpcPriority field is set.
     */
    @java.lang.Override
    public boolean hasRpcPriority() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return The enum numeric value on the wire for rpcPriority.
     */
    @java.lang.Override
    public int getRpcPriorityValue() {
      return rpcPriority_;
    }
    /**
     *
     *
     * <pre>
     * RPC Priority
     * </pre>
     *
     * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
     *
     * @return The rpcPriority.
     */
    @java.lang.Override
    public com.google.spanner.v1.RequestOptions.Priority getRpcPriority() {
      com.google.spanner.v1.RequestOptions.Priority result =
          com.google.spanner.v1.RequestOptions.Priority.forNumber(rpcPriority_);
      return result == null ? com.google.spanner.v1.RequestOptions.Priority.UNRECOGNIZED : result;
    }

    public static final int TAG_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tag_ = "";
    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return Whether the tag field is set.
     */
    @java.lang.Override
    public boolean hasTag() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return The tag.
     */
    @java.lang.Override
    public java.lang.String getTag() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Transaction tag
     * </pre>
     *
     * <code>optional string tag = 2;</code>
     *
     * @return The bytes for tag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTagBytes() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, rpcPriority_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tag_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, rpcPriority_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tag_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)) {
        return super.equals(obj);
      }
      com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions other =
          (com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
              obj;

      if (hasRpcPriority() != other.hasRpcPriority()) return false;
      if (hasRpcPriority()) {
        if (rpcPriority_ != other.rpcPriority_) return false;
      }
      if (hasTag() != other.hasTag()) return false;
      if (hasTag()) {
        if (!getTag().equals(other.getTag())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRpcPriority()) {
        hash = (37 * hash) + RPC_PRIORITY_FIELD_NUMBER;
        hash = (53 * hash) + rpcPriority_;
      }
      if (hasTag()) {
        hash = (37 * hash) + TAG_FIELD_NUMBER;
        hash = (53 * hash) + getTag().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code
     * google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
        com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_ExecutePartitionedUpdateOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_ExecutePartitionedUpdateOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions.class,
                com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions.Builder.class);
      }

      // Construct using
      // com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        rpcPriority_ = 0;
        tag_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.executor.v1.CloudExecutorProto
            .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_ExecutePartitionedUpdateOptions_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
          getDefaultInstanceForType() {
        return com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
          build() {
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
          buildPartial() {
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            result =
                new com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.rpcPriority_ = rpcPriority_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.tag_ = tag_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.spanner.executor.v1.PartitionedUpdateAction
                .ExecutePartitionedUpdateOptions) {
          return mergeFrom(
              (com.google.spanner.executor.v1.PartitionedUpdateAction
                      .ExecutePartitionedUpdateOptions)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
              other) {
        if (other
            == com.google.spanner.executor.v1.PartitionedUpdateAction
                .ExecutePartitionedUpdateOptions.getDefaultInstance()) return this;
        if (other.hasRpcPriority()) {
          setRpcPriority(other.getRpcPriority());
        }
        if (other.hasTag()) {
          tag_ = other.tag_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  rpcPriority_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  tag_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int rpcPriority_ = 0;
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @return Whether the rpcPriority field is set.
       */
      @java.lang.Override
      public boolean hasRpcPriority() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @return The enum numeric value on the wire for rpcPriority.
       */
      @java.lang.Override
      public int getRpcPriorityValue() {
        return rpcPriority_;
      }
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @param value The enum numeric value on the wire for rpcPriority to set.
       * @return This builder for chaining.
       */
      public Builder setRpcPriorityValue(int value) {
        rpcPriority_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @return The rpcPriority.
       */
      @java.lang.Override
      public com.google.spanner.v1.RequestOptions.Priority getRpcPriority() {
        com.google.spanner.v1.RequestOptions.Priority result =
            com.google.spanner.v1.RequestOptions.Priority.forNumber(rpcPriority_);
        return result == null ? com.google.spanner.v1.RequestOptions.Priority.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @param value The rpcPriority to set.
       * @return This builder for chaining.
       */
      public Builder setRpcPriority(com.google.spanner.v1.RequestOptions.Priority value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        rpcPriority_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * RPC Priority
       * </pre>
       *
       * <code>optional .google.spanner.v1.RequestOptions.Priority rpc_priority = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRpcPriority() {
        bitField0_ = (bitField0_ & ~0x00000001);
        rpcPriority_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object tag_ = "";
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @return Whether the tag field is set.
       */
      public boolean hasTag() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @return The tag.
       */
      public java.lang.String getTag() {
        java.lang.Object ref = tag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @return The bytes for tag.
       */
      public com.google.protobuf.ByteString getTagBytes() {
        java.lang.Object ref = tag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @param value The tag to set.
       * @return This builder for chaining.
       */
      public Builder setTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tag_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTag() {
        tag_ = getDefaultInstance().getTag();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transaction tag
       * </pre>
       *
       * <code>optional string tag = 2;</code>
       *
       * @param value The bytes for tag to set.
       * @return This builder for chaining.
       */
      public Builder setTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tag_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions)
    private static final com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.spanner.executor.v1.PartitionedUpdateAction
              .ExecutePartitionedUpdateOptions();
    }

    public static com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecutePartitionedUpdateOptions> PARSER =
        new com.google.protobuf.AbstractParser<ExecutePartitionedUpdateOptions>() {
          @java.lang.Override
          public ExecutePartitionedUpdateOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExecutePartitionedUpdateOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecutePartitionedUpdateOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int OPTIONS_FIELD_NUMBER = 1;
  private com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
      options_;
  /**
   *
   *
   * <pre>
   * Options for partitioned update.
   * </pre>
   *
   * <code>
   * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
   * </code>
   *
   * @return Whether the options field is set.
   */
  @java.lang.Override
  public boolean hasOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Options for partitioned update.
   * </pre>
   *
   * <code>
   * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
   * </code>
   *
   * @return The options.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
      getOptions() {
    return options_ == null
        ? com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            .getDefaultInstance()
        : options_;
  }
  /**
   *
   *
   * <pre>
   * Options for partitioned update.
   * </pre>
   *
   * <code>
   * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.PartitionedUpdateAction
          .ExecutePartitionedUpdateOptionsOrBuilder
      getOptionsOrBuilder() {
    return options_ == null
        ? com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            .getDefaultInstance()
        : options_;
  }

  public static final int UPDATE_FIELD_NUMBER = 2;
  private com.google.spanner.executor.v1.QueryAction update_;
  /**
   *
   *
   * <pre>
   * Partitioned dml query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
   *
   * @return Whether the update field is set.
   */
  @java.lang.Override
  public boolean hasUpdate() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Partitioned dml query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
   *
   * @return The update.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryAction getUpdate() {
    return update_ == null
        ? com.google.spanner.executor.v1.QueryAction.getDefaultInstance()
        : update_;
  }
  /**
   *
   *
   * <pre>
   * Partitioned dml query.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.QueryActionOrBuilder getUpdateOrBuilder() {
    return update_ == null
        ? com.google.spanner.executor.v1.QueryAction.getDefaultInstance()
        : update_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getOptions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdate());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOptions());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdate());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.PartitionedUpdateAction)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.PartitionedUpdateAction other =
        (com.google.spanner.executor.v1.PartitionedUpdateAction) obj;

    if (hasOptions() != other.hasOptions()) return false;
    if (hasOptions()) {
      if (!getOptions().equals(other.getOptions())) return false;
    }
    if (hasUpdate() != other.hasUpdate()) return false;
    if (hasUpdate()) {
      if (!getUpdate().equals(other.getUpdate())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOptions()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOptions().hashCode();
    }
    if (hasUpdate()) {
      hash = (37 * hash) + UPDATE_FIELD_NUMBER;
      hash = (53 * hash) + getUpdate().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.executor.v1.PartitionedUpdateAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * PartitionedUpdateAction defines an action to execute a partitioned DML
   * which runs different partitions in parallel.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.PartitionedUpdateAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.PartitionedUpdateAction)
      com.google.spanner.executor.v1.PartitionedUpdateActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.PartitionedUpdateAction.class,
              com.google.spanner.executor.v1.PartitionedUpdateAction.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.PartitionedUpdateAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOptionsFieldBuilder();
        getUpdateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      options_ = null;
      if (optionsBuilder_ != null) {
        optionsBuilder_.dispose();
        optionsBuilder_ = null;
      }
      update_ = null;
      if (updateBuilder_ != null) {
        updateBuilder_.dispose();
        updateBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_PartitionedUpdateAction_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateAction getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateAction build() {
      com.google.spanner.executor.v1.PartitionedUpdateAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.PartitionedUpdateAction buildPartial() {
      com.google.spanner.executor.v1.PartitionedUpdateAction result =
          new com.google.spanner.executor.v1.PartitionedUpdateAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.PartitionedUpdateAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.options_ = optionsBuilder_ == null ? options_ : optionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.update_ = updateBuilder_ == null ? update_ : updateBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.PartitionedUpdateAction) {
        return mergeFrom((com.google.spanner.executor.v1.PartitionedUpdateAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.PartitionedUpdateAction other) {
      if (other == com.google.spanner.executor.v1.PartitionedUpdateAction.getDefaultInstance())
        return this;
      if (other.hasOptions()) {
        mergeOptions(other.getOptions());
      }
      if (other.hasUpdate()) {
        mergeUpdate(other.getUpdate());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
        options_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions,
            com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                .Builder,
            com.google.spanner.executor.v1.PartitionedUpdateAction
                .ExecutePartitionedUpdateOptionsOrBuilder>
        optionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     *
     * @return Whether the options field is set.
     */
    public boolean hasOptions() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     *
     * @return The options.
     */
    public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
        getOptions() {
      if (optionsBuilder_ == null) {
        return options_ == null
            ? com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                .getDefaultInstance()
            : options_;
      } else {
        return optionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public Builder setOptions(
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            value) {
      if (optionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
      } else {
        optionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public Builder setOptions(
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                .Builder
            builderForValue) {
      if (optionsBuilder_ == null) {
        options_ = builderForValue.build();
      } else {
        optionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public Builder mergeOptions(
        com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            value) {
      if (optionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && options_ != null
            && options_
                != com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions.getDefaultInstance()) {
          getOptionsBuilder().mergeFrom(value);
        } else {
          options_ = value;
        }
      } else {
        optionsBuilder_.mergeFrom(value);
      }
      if (options_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public Builder clearOptions() {
      bitField0_ = (bitField0_ & ~0x00000001);
      options_ = null;
      if (optionsBuilder_ != null) {
        optionsBuilder_.dispose();
        optionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
            .Builder
        getOptionsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    public com.google.spanner.executor.v1.PartitionedUpdateAction
            .ExecutePartitionedUpdateOptionsOrBuilder
        getOptionsOrBuilder() {
      if (optionsBuilder_ != null) {
        return optionsBuilder_.getMessageOrBuilder();
      } else {
        return options_ == null
            ? com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                .getDefaultInstance()
            : options_;
      }
    }
    /**
     *
     *
     * <pre>
     * Options for partitioned update.
     * </pre>
     *
     * <code>
     * optional .google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions options = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions,
            com.google.spanner.executor.v1.PartitionedUpdateAction.ExecutePartitionedUpdateOptions
                .Builder,
            com.google.spanner.executor.v1.PartitionedUpdateAction
                .ExecutePartitionedUpdateOptionsOrBuilder>
        getOptionsFieldBuilder() {
      if (optionsBuilder_ == null) {
        optionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions,
                com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptions.Builder,
                com.google.spanner.executor.v1.PartitionedUpdateAction
                    .ExecutePartitionedUpdateOptionsOrBuilder>(
                getOptions(), getParentForChildren(), isClean());
        options_ = null;
      }
      return optionsBuilder_;
    }

    private com.google.spanner.executor.v1.QueryAction update_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryAction,
            com.google.spanner.executor.v1.QueryAction.Builder,
            com.google.spanner.executor.v1.QueryActionOrBuilder>
        updateBuilder_;
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     *
     * @return Whether the update field is set.
     */
    public boolean hasUpdate() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     *
     * @return The update.
     */
    public com.google.spanner.executor.v1.QueryAction getUpdate() {
      if (updateBuilder_ == null) {
        return update_ == null
            ? com.google.spanner.executor.v1.QueryAction.getDefaultInstance()
            : update_;
      } else {
        return updateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public Builder setUpdate(com.google.spanner.executor.v1.QueryAction value) {
      if (updateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        update_ = value;
      } else {
        updateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public Builder setUpdate(com.google.spanner.executor.v1.QueryAction.Builder builderForValue) {
      if (updateBuilder_ == null) {
        update_ = builderForValue.build();
      } else {
        updateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public Builder mergeUpdate(com.google.spanner.executor.v1.QueryAction value) {
      if (updateBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && update_ != null
            && update_ != com.google.spanner.executor.v1.QueryAction.getDefaultInstance()) {
          getUpdateBuilder().mergeFrom(value);
        } else {
          update_ = value;
        }
      } else {
        updateBuilder_.mergeFrom(value);
      }
      if (update_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public Builder clearUpdate() {
      bitField0_ = (bitField0_ & ~0x00000002);
      update_ = null;
      if (updateBuilder_ != null) {
        updateBuilder_.dispose();
        updateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public com.google.spanner.executor.v1.QueryAction.Builder getUpdateBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    public com.google.spanner.executor.v1.QueryActionOrBuilder getUpdateOrBuilder() {
      if (updateBuilder_ != null) {
        return updateBuilder_.getMessageOrBuilder();
      } else {
        return update_ == null
            ? com.google.spanner.executor.v1.QueryAction.getDefaultInstance()
            : update_;
      }
    }
    /**
     *
     *
     * <pre>
     * Partitioned dml query.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.QueryAction update = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.QueryAction,
            com.google.spanner.executor.v1.QueryAction.Builder,
            com.google.spanner.executor.v1.QueryActionOrBuilder>
        getUpdateFieldBuilder() {
      if (updateBuilder_ == null) {
        updateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.QueryAction,
                com.google.spanner.executor.v1.QueryAction.Builder,
                com.google.spanner.executor.v1.QueryActionOrBuilder>(
                getUpdate(), getParentForChildren(), isClean());
        update_ = null;
      }
      return updateBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.PartitionedUpdateAction)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.PartitionedUpdateAction)
  private static final com.google.spanner.executor.v1.PartitionedUpdateAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.PartitionedUpdateAction();
  }

  public static com.google.spanner.executor.v1.PartitionedUpdateAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartitionedUpdateAction> PARSER =
      new com.google.protobuf.AbstractParser<PartitionedUpdateAction>() {
        @java.lang.Override
        public PartitionedUpdateAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PartitionedUpdateAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartitionedUpdateAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.PartitionedUpdateAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
