/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * KeyRange represents a range of rows in a table or index.
 *
 * A range has a start key and an end key. These keys can be open or
 * closed, indicating if the range includes rows with that key.
 *
 * Keys are represented by "ValueList", where the ith value in the list
 * corresponds to the ith component of the table or index primary key.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.KeyRange}
 */
public final class KeyRange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.KeyRange)
    KeyRangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KeyRange.newBuilder() to construct.
  private KeyRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KeyRange() {
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KeyRange();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_KeyRange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_KeyRange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.KeyRange.class,
            com.google.spanner.executor.v1.KeyRange.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type controls whether "start" and "limit" are open or closed. By default,
   * "start" is closed, and "limit" is open.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.executor.v1.KeyRange.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * "TYPE_UNSPECIFIED" is equivalent to "CLOSED_OPEN".
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * [start,limit]
     * </pre>
     *
     * <code>CLOSED_CLOSED = 1;</code>
     */
    CLOSED_CLOSED(1),
    /**
     *
     *
     * <pre>
     * [start,limit)
     * </pre>
     *
     * <code>CLOSED_OPEN = 2;</code>
     */
    CLOSED_OPEN(2),
    /**
     *
     *
     * <pre>
     * (start,limit]
     * </pre>
     *
     * <code>OPEN_CLOSED = 3;</code>
     */
    OPEN_CLOSED(3),
    /**
     *
     *
     * <pre>
     * (start,limit)
     * </pre>
     *
     * <code>OPEN_OPEN = 4;</code>
     */
    OPEN_OPEN(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * "TYPE_UNSPECIFIED" is equivalent to "CLOSED_OPEN".
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * [start,limit]
     * </pre>
     *
     * <code>CLOSED_CLOSED = 1;</code>
     */
    public static final int CLOSED_CLOSED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * [start,limit)
     * </pre>
     *
     * <code>CLOSED_OPEN = 2;</code>
     */
    public static final int CLOSED_OPEN_VALUE = 2;
    /**
     *
     *
     * <pre>
     * (start,limit]
     * </pre>
     *
     * <code>OPEN_CLOSED = 3;</code>
     */
    public static final int OPEN_CLOSED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * (start,limit)
     * </pre>
     *
     * <code>OPEN_OPEN = 4;</code>
     */
    public static final int OPEN_OPEN_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return CLOSED_CLOSED;
        case 2:
          return CLOSED_OPEN;
        case 3:
          return OPEN_CLOSED;
        case 4:
          return OPEN_OPEN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.executor.v1.KeyRange.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.executor.v1.KeyRange.Type)
  }

  private int bitField0_;
  public static final int START_FIELD_NUMBER = 1;
  private com.google.spanner.executor.v1.ValueList start_;
  /**
   *
   *
   * <pre>
   * "start" and "limit" must have the same number of key parts,
   * though they may name only a prefix of the table or index key.
   * The start key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
   *
   * @return Whether the start field is set.
   */
  @java.lang.Override
  public boolean hasStart() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * "start" and "limit" must have the same number of key parts,
   * though they may name only a prefix of the table or index key.
   * The start key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
   *
   * @return The start.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getStart() {
    return start_ == null ? com.google.spanner.executor.v1.ValueList.getDefaultInstance() : start_;
  }
  /**
   *
   *
   * <pre>
   * "start" and "limit" must have the same number of key parts,
   * though they may name only a prefix of the table or index key.
   * The start key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getStartOrBuilder() {
    return start_ == null ? com.google.spanner.executor.v1.ValueList.getDefaultInstance() : start_;
  }

  public static final int LIMIT_FIELD_NUMBER = 2;
  private com.google.spanner.executor.v1.ValueList limit_;
  /**
   *
   *
   * <pre>
   * The end key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
   *
   * @return Whether the limit field is set.
   */
  @java.lang.Override
  public boolean hasLimit() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The end key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueList getLimit() {
    return limit_ == null ? com.google.spanner.executor.v1.ValueList.getDefaultInstance() : limit_;
  }
  /**
   *
   *
   * <pre>
   * The end key of this KeyRange.
   * </pre>
   *
   * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.ValueListOrBuilder getLimitOrBuilder() {
    return limit_ == null ? com.google.spanner.executor.v1.ValueList.getDefaultInstance() : limit_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * "start" and "limit" type for this KeyRange.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * "start" and "limit" type for this KeyRange.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * "start" and "limit" type for this KeyRange.
   * </pre>
   *
   * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.spanner.executor.v1.KeyRange.Type getType() {
    com.google.spanner.executor.v1.KeyRange.Type result =
        com.google.spanner.executor.v1.KeyRange.Type.forNumber(type_);
    return result == null ? com.google.spanner.executor.v1.KeyRange.Type.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStart());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getLimit());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeEnum(3, type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStart());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLimit());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.KeyRange)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.KeyRange other = (com.google.spanner.executor.v1.KeyRange) obj;

    if (hasStart() != other.hasStart()) return false;
    if (hasStart()) {
      if (!getStart().equals(other.getStart())) return false;
    }
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (!getLimit().equals(other.getLimit())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (type_ != other.type_) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStart()) {
      hash = (37 * hash) + START_FIELD_NUMBER;
      hash = (53 * hash) + getStart().hashCode();
    }
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeyRange parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeyRange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.KeyRange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.KeyRange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * KeyRange represents a range of rows in a table or index.
   *
   * A range has a start key and an end key. These keys can be open or
   * closed, indicating if the range includes rows with that key.
   *
   * Keys are represented by "ValueList", where the ith value in the list
   * corresponds to the ith component of the table or index primary key.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.KeyRange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.KeyRange)
      com.google.spanner.executor.v1.KeyRangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeyRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeyRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.KeyRange.class,
              com.google.spanner.executor.v1.KeyRange.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.KeyRange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartFieldBuilder();
        getLimitFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      start_ = null;
      if (startBuilder_ != null) {
        startBuilder_.dispose();
        startBuilder_ = null;
      }
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      type_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_KeyRange_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeyRange getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.KeyRange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeyRange build() {
      com.google.spanner.executor.v1.KeyRange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.KeyRange buildPartial() {
      com.google.spanner.executor.v1.KeyRange result =
          new com.google.spanner.executor.v1.KeyRange(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.KeyRange result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.start_ = startBuilder_ == null ? start_ : startBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.limit_ = limitBuilder_ == null ? limit_ : limitBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.KeyRange) {
        return mergeFrom((com.google.spanner.executor.v1.KeyRange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.KeyRange other) {
      if (other == com.google.spanner.executor.v1.KeyRange.getDefaultInstance()) return this;
      if (other.hasStart()) {
        mergeStart(other.getStart());
      }
      if (other.hasLimit()) {
        mergeLimit(other.getLimit());
      }
      if (other.hasType()) {
        setType(other.getType());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getLimitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.executor.v1.ValueList start_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        startBuilder_;
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     *
     * @return Whether the start field is set.
     */
    public boolean hasStart() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     *
     * @return The start.
     */
    public com.google.spanner.executor.v1.ValueList getStart() {
      if (startBuilder_ == null) {
        return start_ == null
            ? com.google.spanner.executor.v1.ValueList.getDefaultInstance()
            : start_;
      } else {
        return startBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public Builder setStart(com.google.spanner.executor.v1.ValueList value) {
      if (startBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        start_ = value;
      } else {
        startBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public Builder setStart(com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (startBuilder_ == null) {
        start_ = builderForValue.build();
      } else {
        startBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public Builder mergeStart(com.google.spanner.executor.v1.ValueList value) {
      if (startBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && start_ != null
            && start_ != com.google.spanner.executor.v1.ValueList.getDefaultInstance()) {
          getStartBuilder().mergeFrom(value);
        } else {
          start_ = value;
        }
      } else {
        startBuilder_.mergeFrom(value);
      }
      if (start_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public Builder clearStart() {
      bitField0_ = (bitField0_ & ~0x00000001);
      start_ = null;
      if (startBuilder_ != null) {
        startBuilder_.dispose();
        startBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getStartBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    public com.google.spanner.executor.v1.ValueListOrBuilder getStartOrBuilder() {
      if (startBuilder_ != null) {
        return startBuilder_.getMessageOrBuilder();
      } else {
        return start_ == null
            ? com.google.spanner.executor.v1.ValueList.getDefaultInstance()
            : start_;
      }
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" must have the same number of key parts,
     * though they may name only a prefix of the table or index key.
     * The start key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList start = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getStartFieldBuilder() {
      if (startBuilder_ == null) {
        startBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                getStart(), getParentForChildren(), isClean());
        start_ = null;
      }
      return startBuilder_;
    }

    private com.google.spanner.executor.v1.ValueList limit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        limitBuilder_;
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     *
     * @return Whether the limit field is set.
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     *
     * @return The limit.
     */
    public com.google.spanner.executor.v1.ValueList getLimit() {
      if (limitBuilder_ == null) {
        return limit_ == null
            ? com.google.spanner.executor.v1.ValueList.getDefaultInstance()
            : limit_;
      } else {
        return limitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public Builder setLimit(com.google.spanner.executor.v1.ValueList value) {
      if (limitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limit_ = value;
      } else {
        limitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public Builder setLimit(com.google.spanner.executor.v1.ValueList.Builder builderForValue) {
      if (limitBuilder_ == null) {
        limit_ = builderForValue.build();
      } else {
        limitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public Builder mergeLimit(com.google.spanner.executor.v1.ValueList value) {
      if (limitBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && limit_ != null
            && limit_ != com.google.spanner.executor.v1.ValueList.getDefaultInstance()) {
          getLimitBuilder().mergeFrom(value);
        } else {
          limit_ = value;
        }
      } else {
        limitBuilder_.mergeFrom(value);
      }
      if (limit_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000002);
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public com.google.spanner.executor.v1.ValueList.Builder getLimitBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    public com.google.spanner.executor.v1.ValueListOrBuilder getLimitOrBuilder() {
      if (limitBuilder_ != null) {
        return limitBuilder_.getMessageOrBuilder();
      } else {
        return limit_ == null
            ? com.google.spanner.executor.v1.ValueList.getDefaultInstance()
            : limit_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end key of this KeyRange.
     * </pre>
     *
     * <code>.google.spanner.executor.v1.ValueList limit = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.executor.v1.ValueList,
            com.google.spanner.executor.v1.ValueList.Builder,
            com.google.spanner.executor.v1.ValueListOrBuilder>
        getLimitFieldBuilder() {
      if (limitBuilder_ == null) {
        limitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.executor.v1.ValueList,
                com.google.spanner.executor.v1.ValueList.Builder,
                com.google.spanner.executor.v1.ValueListOrBuilder>(
                getLimit(), getParentForChildren(), isClean());
        limit_ = null;
      }
      return limitBuilder_;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.spanner.executor.v1.KeyRange.Type getType() {
      com.google.spanner.executor.v1.KeyRange.Type result =
          com.google.spanner.executor.v1.KeyRange.Type.forNumber(type_);
      return result == null ? com.google.spanner.executor.v1.KeyRange.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.spanner.executor.v1.KeyRange.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "start" and "limit" type for this KeyRange.
     * </pre>
     *
     * <code>optional .google.spanner.executor.v1.KeyRange.Type type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.KeyRange)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.KeyRange)
  private static final com.google.spanner.executor.v1.KeyRange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.KeyRange();
  }

  public static com.google.spanner.executor.v1.KeyRange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyRange> PARSER =
      new com.google.protobuf.AbstractParser<KeyRange>() {
        @java.lang.Override
        public KeyRange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KeyRange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyRange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.KeyRange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
