/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * CloudDatabaseResponse contains results returned by cloud database related
 * actions.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.CloudDatabaseResponse}
 */
public final class CloudDatabaseResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.CloudDatabaseResponse)
    CloudDatabaseResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudDatabaseResponse.newBuilder() to construct.
  private CloudDatabaseResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudDatabaseResponse() {
    listedDatabases_ = java.util.Collections.emptyList();
    listedDatabaseOperations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudDatabaseResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudDatabaseResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_CloudDatabaseResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.CloudDatabaseResponse.class,
            com.google.spanner.executor.v1.CloudDatabaseResponse.Builder.class);
  }

  private int bitField0_;
  public static final int LISTED_DATABASES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.Database> listedDatabases_;
  /**
   *
   *
   * <pre>
   * List of databases returned by ListCloudDatabasesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.Database> getListedDatabasesList() {
    return listedDatabases_;
  }
  /**
   *
   *
   * <pre>
   * List of databases returned by ListCloudDatabasesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.DatabaseOrBuilder>
      getListedDatabasesOrBuilderList() {
    return listedDatabases_;
  }
  /**
   *
   *
   * <pre>
   * List of databases returned by ListCloudDatabasesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
   */
  @java.lang.Override
  public int getListedDatabasesCount() {
    return listedDatabases_.size();
  }
  /**
   *
   *
   * <pre>
   * List of databases returned by ListCloudDatabasesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database getListedDatabases(int index) {
    return listedDatabases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of databases returned by ListCloudDatabasesAction.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseOrBuilder getListedDatabasesOrBuilder(
      int index) {
    return listedDatabases_.get(index);
  }

  public static final int LISTED_DATABASE_OPERATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.longrunning.Operation> listedDatabaseOperations_;
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudDatabaseOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.longrunning.Operation> getListedDatabaseOperationsList() {
    return listedDatabaseOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudDatabaseOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
      getListedDatabaseOperationsOrBuilderList() {
    return listedDatabaseOperations_;
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudDatabaseOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
   */
  @java.lang.Override
  public int getListedDatabaseOperationsCount() {
    return listedDatabaseOperations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudDatabaseOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
   */
  @java.lang.Override
  public com.google.longrunning.Operation getListedDatabaseOperations(int index) {
    return listedDatabaseOperations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of operations returned by ListCloudDatabaseOperationsAction.
   * </pre>
   *
   * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
   */
  @java.lang.Override
  public com.google.longrunning.OperationOrBuilder getListedDatabaseOperationsOrBuilder(int index) {
    return listedDatabaseOperations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * "next_page_token" can be sent in a subsequent list action
   * to fetch more of the matching data.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.Database database_;
  /**
   *
   *
   * <pre>
   * Database returned by GetCloudDatabaseAction
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
   *
   * @return Whether the database field is set.
   */
  @java.lang.Override
  public boolean hasDatabase() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Database returned by GetCloudDatabaseAction
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database getDatabase() {
    return database_ == null
        ? com.google.spanner.admin.database.v1.Database.getDefaultInstance()
        : database_;
  }
  /**
   *
   *
   * <pre>
   * Database returned by GetCloudDatabaseAction
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseOrBuilder getDatabaseOrBuilder() {
    return database_ == null
        ? com.google.spanner.admin.database.v1.Database.getDefaultInstance()
        : database_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < listedDatabases_.size(); i++) {
      output.writeMessage(1, listedDatabases_.get(i));
    }
    for (int i = 0; i < listedDatabaseOperations_.size(); i++) {
      output.writeMessage(2, listedDatabaseOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getDatabase());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < listedDatabases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, listedDatabases_.get(i));
    }
    for (int i = 0; i < listedDatabaseOperations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, listedDatabaseOperations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDatabase());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.CloudDatabaseResponse)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.CloudDatabaseResponse other =
        (com.google.spanner.executor.v1.CloudDatabaseResponse) obj;

    if (!getListedDatabasesList().equals(other.getListedDatabasesList())) return false;
    if (!getListedDatabaseOperationsList().equals(other.getListedDatabaseOperationsList()))
      return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasDatabase() != other.hasDatabase()) return false;
    if (hasDatabase()) {
      if (!getDatabase().equals(other.getDatabase())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getListedDatabasesCount() > 0) {
      hash = (37 * hash) + LISTED_DATABASES_FIELD_NUMBER;
      hash = (53 * hash) + getListedDatabasesList().hashCode();
    }
    if (getListedDatabaseOperationsCount() > 0) {
      hash = (37 * hash) + LISTED_DATABASE_OPERATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getListedDatabaseOperationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasDatabase()) {
      hash = (37 * hash) + DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDatabase().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.CloudDatabaseResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CloudDatabaseResponse contains results returned by cloud database related
   * actions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.CloudDatabaseResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.CloudDatabaseResponse)
      com.google.spanner.executor.v1.CloudDatabaseResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudDatabaseResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudDatabaseResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.CloudDatabaseResponse.class,
              com.google.spanner.executor.v1.CloudDatabaseResponse.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.CloudDatabaseResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getListedDatabasesFieldBuilder();
        getListedDatabaseOperationsFieldBuilder();
        getDatabaseFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (listedDatabasesBuilder_ == null) {
        listedDatabases_ = java.util.Collections.emptyList();
      } else {
        listedDatabases_ = null;
        listedDatabasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (listedDatabaseOperationsBuilder_ == null) {
        listedDatabaseOperations_ = java.util.Collections.emptyList();
      } else {
        listedDatabaseOperations_ = null;
        listedDatabaseOperationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      nextPageToken_ = "";
      database_ = null;
      if (databaseBuilder_ != null) {
        databaseBuilder_.dispose();
        databaseBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_CloudDatabaseResponse_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudDatabaseResponse getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.CloudDatabaseResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudDatabaseResponse build() {
      com.google.spanner.executor.v1.CloudDatabaseResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.CloudDatabaseResponse buildPartial() {
      com.google.spanner.executor.v1.CloudDatabaseResponse result =
          new com.google.spanner.executor.v1.CloudDatabaseResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.executor.v1.CloudDatabaseResponse result) {
      if (listedDatabasesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          listedDatabases_ = java.util.Collections.unmodifiableList(listedDatabases_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.listedDatabases_ = listedDatabases_;
      } else {
        result.listedDatabases_ = listedDatabasesBuilder_.build();
      }
      if (listedDatabaseOperationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          listedDatabaseOperations_ =
              java.util.Collections.unmodifiableList(listedDatabaseOperations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.listedDatabaseOperations_ = listedDatabaseOperations_;
      } else {
        result.listedDatabaseOperations_ = listedDatabaseOperationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.executor.v1.CloudDatabaseResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.database_ = databaseBuilder_ == null ? database_ : databaseBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.CloudDatabaseResponse) {
        return mergeFrom((com.google.spanner.executor.v1.CloudDatabaseResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.CloudDatabaseResponse other) {
      if (other == com.google.spanner.executor.v1.CloudDatabaseResponse.getDefaultInstance())
        return this;
      if (listedDatabasesBuilder_ == null) {
        if (!other.listedDatabases_.isEmpty()) {
          if (listedDatabases_.isEmpty()) {
            listedDatabases_ = other.listedDatabases_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureListedDatabasesIsMutable();
            listedDatabases_.addAll(other.listedDatabases_);
          }
          onChanged();
        }
      } else {
        if (!other.listedDatabases_.isEmpty()) {
          if (listedDatabasesBuilder_.isEmpty()) {
            listedDatabasesBuilder_.dispose();
            listedDatabasesBuilder_ = null;
            listedDatabases_ = other.listedDatabases_;
            bitField0_ = (bitField0_ & ~0x00000001);
            listedDatabasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedDatabasesFieldBuilder()
                    : null;
          } else {
            listedDatabasesBuilder_.addAllMessages(other.listedDatabases_);
          }
        }
      }
      if (listedDatabaseOperationsBuilder_ == null) {
        if (!other.listedDatabaseOperations_.isEmpty()) {
          if (listedDatabaseOperations_.isEmpty()) {
            listedDatabaseOperations_ = other.listedDatabaseOperations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureListedDatabaseOperationsIsMutable();
            listedDatabaseOperations_.addAll(other.listedDatabaseOperations_);
          }
          onChanged();
        }
      } else {
        if (!other.listedDatabaseOperations_.isEmpty()) {
          if (listedDatabaseOperationsBuilder_.isEmpty()) {
            listedDatabaseOperationsBuilder_.dispose();
            listedDatabaseOperationsBuilder_ = null;
            listedDatabaseOperations_ = other.listedDatabaseOperations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            listedDatabaseOperationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getListedDatabaseOperationsFieldBuilder()
                    : null;
          } else {
            listedDatabaseOperationsBuilder_.addAllMessages(other.listedDatabaseOperations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDatabase()) {
        mergeDatabase(other.getDatabase());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.spanner.admin.database.v1.Database m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.Database.parser(), extensionRegistry);
                if (listedDatabasesBuilder_ == null) {
                  ensureListedDatabasesIsMutable();
                  listedDatabases_.add(m);
                } else {
                  listedDatabasesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.longrunning.Operation m =
                    input.readMessage(com.google.longrunning.Operation.parser(), extensionRegistry);
                if (listedDatabaseOperationsBuilder_ == null) {
                  ensureListedDatabaseOperationsIsMutable();
                  listedDatabaseOperations_.add(m);
                } else {
                  listedDatabaseOperationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.spanner.admin.database.v1.Database> listedDatabases_ =
        java.util.Collections.emptyList();

    private void ensureListedDatabasesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        listedDatabases_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.Database>(
                listedDatabases_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.Database,
            com.google.spanner.admin.database.v1.Database.Builder,
            com.google.spanner.admin.database.v1.DatabaseOrBuilder>
        listedDatabasesBuilder_;

    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.Database> getListedDatabasesList() {
      if (listedDatabasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedDatabases_);
      } else {
        return listedDatabasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public int getListedDatabasesCount() {
      if (listedDatabasesBuilder_ == null) {
        return listedDatabases_.size();
      } else {
        return listedDatabasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Database getListedDatabases(int index) {
      if (listedDatabasesBuilder_ == null) {
        return listedDatabases_.get(index);
      } else {
        return listedDatabasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder setListedDatabases(
        int index, com.google.spanner.admin.database.v1.Database value) {
      if (listedDatabasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabasesIsMutable();
        listedDatabases_.set(index, value);
        onChanged();
      } else {
        listedDatabasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder setListedDatabases(
        int index, com.google.spanner.admin.database.v1.Database.Builder builderForValue) {
      if (listedDatabasesBuilder_ == null) {
        ensureListedDatabasesIsMutable();
        listedDatabases_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedDatabasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder addListedDatabases(com.google.spanner.admin.database.v1.Database value) {
      if (listedDatabasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabasesIsMutable();
        listedDatabases_.add(value);
        onChanged();
      } else {
        listedDatabasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder addListedDatabases(
        int index, com.google.spanner.admin.database.v1.Database value) {
      if (listedDatabasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabasesIsMutable();
        listedDatabases_.add(index, value);
        onChanged();
      } else {
        listedDatabasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder addListedDatabases(
        com.google.spanner.admin.database.v1.Database.Builder builderForValue) {
      if (listedDatabasesBuilder_ == null) {
        ensureListedDatabasesIsMutable();
        listedDatabases_.add(builderForValue.build());
        onChanged();
      } else {
        listedDatabasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder addListedDatabases(
        int index, com.google.spanner.admin.database.v1.Database.Builder builderForValue) {
      if (listedDatabasesBuilder_ == null) {
        ensureListedDatabasesIsMutable();
        listedDatabases_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedDatabasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder addAllListedDatabases(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.Database> values) {
      if (listedDatabasesBuilder_ == null) {
        ensureListedDatabasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedDatabases_);
        onChanged();
      } else {
        listedDatabasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder clearListedDatabases() {
      if (listedDatabasesBuilder_ == null) {
        listedDatabases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        listedDatabasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public Builder removeListedDatabases(int index) {
      if (listedDatabasesBuilder_ == null) {
        ensureListedDatabasesIsMutable();
        listedDatabases_.remove(index);
        onChanged();
      } else {
        listedDatabasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Database.Builder getListedDatabasesBuilder(
        int index) {
      return getListedDatabasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public com.google.spanner.admin.database.v1.DatabaseOrBuilder getListedDatabasesOrBuilder(
        int index) {
      if (listedDatabasesBuilder_ == null) {
        return listedDatabases_.get(index);
      } else {
        return listedDatabasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.DatabaseOrBuilder>
        getListedDatabasesOrBuilderList() {
      if (listedDatabasesBuilder_ != null) {
        return listedDatabasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedDatabases_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Database.Builder addListedDatabasesBuilder() {
      return getListedDatabasesFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.Database.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public com.google.spanner.admin.database.v1.Database.Builder addListedDatabasesBuilder(
        int index) {
      return getListedDatabasesFieldBuilder()
          .addBuilder(index, com.google.spanner.admin.database.v1.Database.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of databases returned by ListCloudDatabasesAction.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.Database listed_databases = 1;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.Database.Builder>
        getListedDatabasesBuilderList() {
      return getListedDatabasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.Database,
            com.google.spanner.admin.database.v1.Database.Builder,
            com.google.spanner.admin.database.v1.DatabaseOrBuilder>
        getListedDatabasesFieldBuilder() {
      if (listedDatabasesBuilder_ == null) {
        listedDatabasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.Database,
                com.google.spanner.admin.database.v1.Database.Builder,
                com.google.spanner.admin.database.v1.DatabaseOrBuilder>(
                listedDatabases_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        listedDatabases_ = null;
      }
      return listedDatabasesBuilder_;
    }

    private java.util.List<com.google.longrunning.Operation> listedDatabaseOperations_ =
        java.util.Collections.emptyList();

    private void ensureListedDatabaseOperationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        listedDatabaseOperations_ =
            new java.util.ArrayList<com.google.longrunning.Operation>(listedDatabaseOperations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        listedDatabaseOperationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public java.util.List<com.google.longrunning.Operation> getListedDatabaseOperationsList() {
      if (listedDatabaseOperationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(listedDatabaseOperations_);
      } else {
        return listedDatabaseOperationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public int getListedDatabaseOperationsCount() {
      if (listedDatabaseOperationsBuilder_ == null) {
        return listedDatabaseOperations_.size();
      } else {
        return listedDatabaseOperationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public com.google.longrunning.Operation getListedDatabaseOperations(int index) {
      if (listedDatabaseOperationsBuilder_ == null) {
        return listedDatabaseOperations_.get(index);
      } else {
        return listedDatabaseOperationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder setListedDatabaseOperations(int index, com.google.longrunning.Operation value) {
      if (listedDatabaseOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.set(index, value);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder setListedDatabaseOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedDatabaseOperationsBuilder_ == null) {
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.set(index, builderForValue.build());
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder addListedDatabaseOperations(com.google.longrunning.Operation value) {
      if (listedDatabaseOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.add(value);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder addListedDatabaseOperations(int index, com.google.longrunning.Operation value) {
      if (listedDatabaseOperationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.add(index, value);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder addListedDatabaseOperations(
        com.google.longrunning.Operation.Builder builderForValue) {
      if (listedDatabaseOperationsBuilder_ == null) {
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.add(builderForValue.build());
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder addListedDatabaseOperations(
        int index, com.google.longrunning.Operation.Builder builderForValue) {
      if (listedDatabaseOperationsBuilder_ == null) {
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.add(index, builderForValue.build());
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder addAllListedDatabaseOperations(
        java.lang.Iterable<? extends com.google.longrunning.Operation> values) {
      if (listedDatabaseOperationsBuilder_ == null) {
        ensureListedDatabaseOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, listedDatabaseOperations_);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder clearListedDatabaseOperations() {
      if (listedDatabaseOperationsBuilder_ == null) {
        listedDatabaseOperations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public Builder removeListedDatabaseOperations(int index) {
      if (listedDatabaseOperationsBuilder_ == null) {
        ensureListedDatabaseOperationsIsMutable();
        listedDatabaseOperations_.remove(index);
        onChanged();
      } else {
        listedDatabaseOperationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder getListedDatabaseOperationsBuilder(int index) {
      return getListedDatabaseOperationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public com.google.longrunning.OperationOrBuilder getListedDatabaseOperationsOrBuilder(
        int index) {
      if (listedDatabaseOperationsBuilder_ == null) {
        return listedDatabaseOperations_.get(index);
      } else {
        return listedDatabaseOperationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public java.util.List<? extends com.google.longrunning.OperationOrBuilder>
        getListedDatabaseOperationsOrBuilderList() {
      if (listedDatabaseOperationsBuilder_ != null) {
        return listedDatabaseOperationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(listedDatabaseOperations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder addListedDatabaseOperationsBuilder() {
      return getListedDatabaseOperationsFieldBuilder()
          .addBuilder(com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public com.google.longrunning.Operation.Builder addListedDatabaseOperationsBuilder(int index) {
      return getListedDatabaseOperationsFieldBuilder()
          .addBuilder(index, com.google.longrunning.Operation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of operations returned by ListCloudDatabaseOperationsAction.
     * </pre>
     *
     * <code>repeated .google.longrunning.Operation listed_database_operations = 2;</code>
     */
    public java.util.List<com.google.longrunning.Operation.Builder>
        getListedDatabaseOperationsBuilderList() {
      return getListedDatabaseOperationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.longrunning.Operation,
            com.google.longrunning.Operation.Builder,
            com.google.longrunning.OperationOrBuilder>
        getListedDatabaseOperationsFieldBuilder() {
      if (listedDatabaseOperationsBuilder_ == null) {
        listedDatabaseOperationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.longrunning.Operation,
                com.google.longrunning.Operation.Builder,
                com.google.longrunning.OperationOrBuilder>(
                listedDatabaseOperations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        listedDatabaseOperations_ = null;
      }
      return listedDatabaseOperationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * "next_page_token" can be sent in a subsequent list action
     * to fetch more of the matching data.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.Database database_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.Database,
            com.google.spanner.admin.database.v1.Database.Builder,
            com.google.spanner.admin.database.v1.DatabaseOrBuilder>
        databaseBuilder_;
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     *
     * @return Whether the database field is set.
     */
    public boolean hasDatabase() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     *
     * @return The database.
     */
    public com.google.spanner.admin.database.v1.Database getDatabase() {
      if (databaseBuilder_ == null) {
        return database_ == null
            ? com.google.spanner.admin.database.v1.Database.getDefaultInstance()
            : database_;
      } else {
        return databaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public Builder setDatabase(com.google.spanner.admin.database.v1.Database value) {
      if (databaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        database_ = value;
      } else {
        databaseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public Builder setDatabase(
        com.google.spanner.admin.database.v1.Database.Builder builderForValue) {
      if (databaseBuilder_ == null) {
        database_ = builderForValue.build();
      } else {
        databaseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public Builder mergeDatabase(com.google.spanner.admin.database.v1.Database value) {
      if (databaseBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && database_ != null
            && database_ != com.google.spanner.admin.database.v1.Database.getDefaultInstance()) {
          getDatabaseBuilder().mergeFrom(value);
        } else {
          database_ = value;
        }
      } else {
        databaseBuilder_.mergeFrom(value);
      }
      if (database_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public Builder clearDatabase() {
      bitField0_ = (bitField0_ & ~0x00000008);
      database_ = null;
      if (databaseBuilder_ != null) {
        databaseBuilder_.dispose();
        databaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public com.google.spanner.admin.database.v1.Database.Builder getDatabaseBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    public com.google.spanner.admin.database.v1.DatabaseOrBuilder getDatabaseOrBuilder() {
      if (databaseBuilder_ != null) {
        return databaseBuilder_.getMessageOrBuilder();
      } else {
        return database_ == null
            ? com.google.spanner.admin.database.v1.Database.getDefaultInstance()
            : database_;
      }
    }
    /**
     *
     *
     * <pre>
     * Database returned by GetCloudDatabaseAction
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.Database database = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.Database,
            com.google.spanner.admin.database.v1.Database.Builder,
            com.google.spanner.admin.database.v1.DatabaseOrBuilder>
        getDatabaseFieldBuilder() {
      if (databaseBuilder_ == null) {
        databaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.Database,
                com.google.spanner.admin.database.v1.Database.Builder,
                com.google.spanner.admin.database.v1.DatabaseOrBuilder>(
                getDatabase(), getParentForChildren(), isClean());
        database_ = null;
      }
      return databaseBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.CloudDatabaseResponse)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.CloudDatabaseResponse)
  private static final com.google.spanner.executor.v1.CloudDatabaseResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.CloudDatabaseResponse();
  }

  public static com.google.spanner.executor.v1.CloudDatabaseResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudDatabaseResponse> PARSER =
      new com.google.protobuf.AbstractParser<CloudDatabaseResponse>() {
        @java.lang.Override
        public CloudDatabaseResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudDatabaseResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudDatabaseResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.CloudDatabaseResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
