/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/executor/v1/cloud_executor.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.executor.v1;

/**
 *
 *
 * <pre>
 * Identifies a database partition generated for a particular read or query. To
 * read rows from the partition, use ExecutePartitionAction.
 * </pre>
 *
 * Protobuf type {@code google.spanner.executor.v1.BatchPartition}
 */
public final class BatchPartition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.executor.v1.BatchPartition)
    BatchPartitionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchPartition.newBuilder() to construct.
  private BatchPartition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchPartition() {
    partition_ = com.google.protobuf.ByteString.EMPTY;
    partitionToken_ = com.google.protobuf.ByteString.EMPTY;
    table_ = "";
    index_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchPartition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_BatchPartition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.executor.v1.CloudExecutorProto
        .internal_static_google_spanner_executor_v1_BatchPartition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.executor.v1.BatchPartition.class,
            com.google.spanner.executor.v1.BatchPartition.Builder.class);
  }

  private int bitField0_;
  public static final int PARTITION_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString partition_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Serialized Partition instance.
   * </pre>
   *
   * <code>bytes partition = 1;</code>
   *
   * @return The partition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartition() {
    return partition_;
  }

  public static final int PARTITION_TOKEN_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The partition token decrypted from partition.
   * </pre>
   *
   * <code>bytes partition_token = 2;</code>
   *
   * @return The partitionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPartitionToken() {
    return partitionToken_;
  }

  public static final int TABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * Table name is set iff the partition was generated for a read (as opposed to
   * a query).
   * </pre>
   *
   * <code>optional string table = 3;</code>
   *
   * @return Whether the table field is set.
   */
  @java.lang.Override
  public boolean hasTable() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Table name is set iff the partition was generated for a read (as opposed to
   * a query).
   * </pre>
   *
   * <code>optional string table = 3;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Table name is set iff the partition was generated for a read (as opposed to
   * a query).
   * </pre>
   *
   * <code>optional string table = 3;</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";
  /**
   *
   *
   * <pre>
   * Index name if the partition was generated for an index read.
   * </pre>
   *
   * <code>optional string index = 4;</code>
   *
   * @return Whether the index field is set.
   */
  @java.lang.Override
  public boolean hasIndex() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Index name if the partition was generated for an index read.
   * </pre>
   *
   * <code>optional string index = 4;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Index name if the partition was generated for an index read.
   * </pre>
   *
   * <code>optional string index = 4;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!partition_.isEmpty()) {
      output.writeBytes(1, partition_);
    }
    if (!partitionToken_.isEmpty()) {
      output.writeBytes(2, partitionToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, table_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, index_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!partition_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, partition_);
    }
    if (!partitionToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, partitionToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, table_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, index_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.executor.v1.BatchPartition)) {
      return super.equals(obj);
    }
    com.google.spanner.executor.v1.BatchPartition other =
        (com.google.spanner.executor.v1.BatchPartition) obj;

    if (!getPartition().equals(other.getPartition())) return false;
    if (!getPartitionToken().equals(other.getPartitionToken())) return false;
    if (hasTable() != other.hasTable()) return false;
    if (hasTable()) {
      if (!getTable().equals(other.getTable())) return false;
    }
    if (hasIndex() != other.hasIndex()) return false;
    if (hasIndex()) {
      if (!getIndex().equals(other.getIndex())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTITION_FIELD_NUMBER;
    hash = (53 * hash) + getPartition().hashCode();
    hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPartitionToken().hashCode();
    if (hasTable()) {
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
    }
    if (hasIndex()) {
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.executor.v1.BatchPartition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.executor.v1.BatchPartition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Identifies a database partition generated for a particular read or query. To
   * read rows from the partition, use ExecutePartitionAction.
   * </pre>
   *
   * Protobuf type {@code google.spanner.executor.v1.BatchPartition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.executor.v1.BatchPartition)
      com.google.spanner.executor.v1.BatchPartitionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_BatchPartition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_BatchPartition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.executor.v1.BatchPartition.class,
              com.google.spanner.executor.v1.BatchPartition.Builder.class);
    }

    // Construct using com.google.spanner.executor.v1.BatchPartition.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      partition_ = com.google.protobuf.ByteString.EMPTY;
      partitionToken_ = com.google.protobuf.ByteString.EMPTY;
      table_ = "";
      index_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.executor.v1.CloudExecutorProto
          .internal_static_google_spanner_executor_v1_BatchPartition_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.BatchPartition getDefaultInstanceForType() {
      return com.google.spanner.executor.v1.BatchPartition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.BatchPartition build() {
      com.google.spanner.executor.v1.BatchPartition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.executor.v1.BatchPartition buildPartial() {
      com.google.spanner.executor.v1.BatchPartition result =
          new com.google.spanner.executor.v1.BatchPartition(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.executor.v1.BatchPartition result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.partition_ = partition_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.partitionToken_ = partitionToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.table_ = table_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.index_ = index_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.executor.v1.BatchPartition) {
        return mergeFrom((com.google.spanner.executor.v1.BatchPartition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.executor.v1.BatchPartition other) {
      if (other == com.google.spanner.executor.v1.BatchPartition.getDefaultInstance()) return this;
      if (other.getPartition() != com.google.protobuf.ByteString.EMPTY) {
        setPartition(other.getPartition());
      }
      if (other.getPartitionToken() != com.google.protobuf.ByteString.EMPTY) {
        setPartitionToken(other.getPartitionToken());
      }
      if (other.hasTable()) {
        table_ = other.table_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasIndex()) {
        index_ = other.index_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                partition_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                partitionToken_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString partition_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Serialized Partition instance.
     * </pre>
     *
     * <code>bytes partition = 1;</code>
     *
     * @return The partition.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartition() {
      return partition_;
    }
    /**
     *
     *
     * <pre>
     * Serialized Partition instance.
     * </pre>
     *
     * <code>bytes partition = 1;</code>
     *
     * @param value The partition to set.
     * @return This builder for chaining.
     */
    public Builder setPartition(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      partition_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized Partition instance.
     * </pre>
     *
     * <code>bytes partition = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartition() {
      bitField0_ = (bitField0_ & ~0x00000001);
      partition_ = getDefaultInstance().getPartition();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString partitionToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The partition token decrypted from partition.
     * </pre>
     *
     * <code>bytes partition_token = 2;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionToken() {
      return partitionToken_;
    }
    /**
     *
     *
     * <pre>
     * The partition token decrypted from partition.
     * </pre>
     *
     * <code>bytes partition_token = 2;</code>
     *
     * @param value The partitionToken to set.
     * @return This builder for chaining.
     */
    public Builder setPartitionToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      partitionToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The partition token decrypted from partition.
     * </pre>
     *
     * <code>bytes partition_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitionToken() {
      bitField0_ = (bitField0_ & ~0x00000002);
      partitionToken_ = getDefaultInstance().getPartitionToken();
      onChanged();
      return this;
    }

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @return Whether the table field is set.
     */
    public boolean hasTable() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table name is set iff the partition was generated for a read (as opposed to
     * a query).
     * </pre>
     *
     * <code>optional string table = 3;</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @return Whether the index field is set.
     */
    public boolean hasIndex() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Index name if the partition was generated for an index read.
     * </pre>
     *
     * <code>optional string index = 4;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.executor.v1.BatchPartition)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.executor.v1.BatchPartition)
  private static final com.google.spanner.executor.v1.BatchPartition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.executor.v1.BatchPartition();
  }

  public static com.google.spanner.executor.v1.BatchPartition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchPartition> PARSER =
      new com.google.protobuf.AbstractParser<BatchPartition>() {
        @java.lang.Override
        public BatchPartition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchPartition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchPartition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.executor.v1.BatchPartition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
