/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.instance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instanceConfigs/{instance_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instanceConfig;

    @Deprecated
    protected InstanceConfigName() {
        this.project = null;
        this.instanceConfig = null;
    }

    private InstanceConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instanceConfig = (String)Preconditions.checkNotNull((Object)builder.getInstanceConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstanceConfig() {
        return this.instanceConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceConfigName of(String project, String instanceConfig) {
        return InstanceConfigName.newBuilder().setProject(project).setInstanceConfig(instanceConfig).build();
    }

    public static String format(String project, String instanceConfig) {
        return InstanceConfigName.newBuilder().setProject(project).setInstanceConfig(instanceConfig).build().toString();
    }

    public static InstanceConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_CONFIG.validatedMatch(formattedString, "InstanceConfigName.parse: formattedString not in valid format");
        return InstanceConfigName.of((String)matchMap.get("project"), (String)matchMap.get("instance_config"));
    }

    public static List<InstanceConfigName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceConfigName> list = new ArrayList<InstanceConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceConfigName instanceConfigName = this;
            synchronized (instanceConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instanceConfig != null) {
                        fieldMapBuilder.put((Object)"instance_config", (Object)this.instanceConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_CONFIG.instantiate(new String[]{"project", this.project, "instance_config", this.instanceConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InstanceConfigName that = (InstanceConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instanceConfig, that.instanceConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instanceConfig);
    }

    public static class Builder {
        private String project;
        private String instanceConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstanceConfig() {
            return this.instanceConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstanceConfig(String instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        private Builder(InstanceConfigName instanceConfigName) {
            this.project = instanceConfigName.project;
            this.instanceConfig = instanceConfigName.instanceConfig;
        }

        public InstanceConfigName build() {
            return new InstanceConfigName(this);
        }
    }
}

