/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The split points of a table/index.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.SplitPoints}
 */
public final class SplitPoints extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.SplitPoints)
    SplitPointsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SplitPoints.newBuilder() to construct.
  private SplitPoints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SplitPoints() {
    table_ = "";
    index_ = "";
    keys_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SplitPoints();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_SplitPoints_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_SplitPoints_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.SplitPoints.class,
            com.google.spanner.admin.database.v1.SplitPoints.Builder.class);
  }

  public interface KeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.admin.database.v1.SplitPoints.Key)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the keyParts field is set.
     */
    boolean hasKeyParts();

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The keyParts.
     */
    com.google.protobuf.ListValue getKeyParts();

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protobuf.ListValueOrBuilder getKeyPartsOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A split key.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.SplitPoints.Key}
   */
  public static final class Key extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.SplitPoints.Key)
      KeyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Key.newBuilder() to construct.
    private Key(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Key() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Key();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_SplitPoints_Key_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_SplitPoints_Key_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.SplitPoints.Key.class,
              com.google.spanner.admin.database.v1.SplitPoints.Key.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_PARTS_FIELD_NUMBER = 1;
    private com.google.protobuf.ListValue keyParts_;

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the keyParts field is set.
     */
    @java.lang.Override
    public boolean hasKeyParts() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The keyParts.
     */
    @java.lang.Override
    public com.google.protobuf.ListValue getKeyParts() {
      return keyParts_ == null ? com.google.protobuf.ListValue.getDefaultInstance() : keyParts_;
    }

    /**
     *
     *
     * <pre>
     * Required. The column values making up the split key.
     * </pre>
     *
     * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.ListValueOrBuilder getKeyPartsOrBuilder() {
      return keyParts_ == null ? com.google.protobuf.ListValue.getDefaultInstance() : keyParts_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeyParts());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getKeyParts());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.admin.database.v1.SplitPoints.Key)) {
        return super.equals(obj);
      }
      com.google.spanner.admin.database.v1.SplitPoints.Key other =
          (com.google.spanner.admin.database.v1.SplitPoints.Key) obj;

      if (hasKeyParts() != other.hasKeyParts()) return false;
      if (hasKeyParts()) {
        if (!getKeyParts().equals(other.getKeyParts())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeyParts()) {
        hash = (37 * hash) + KEY_PARTS_FIELD_NUMBER;
        hash = (53 * hash) + getKeyParts().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.admin.database.v1.SplitPoints.Key prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A split key.
     * </pre>
     *
     * Protobuf type {@code google.spanner.admin.database.v1.SplitPoints.Key}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.SplitPoints.Key)
        com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
            .internal_static_google_spanner_admin_database_v1_SplitPoints_Key_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
            .internal_static_google_spanner_admin_database_v1_SplitPoints_Key_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.admin.database.v1.SplitPoints.Key.class,
                com.google.spanner.admin.database.v1.SplitPoints.Key.Builder.class);
      }

      // Construct using com.google.spanner.admin.database.v1.SplitPoints.Key.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getKeyPartsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keyParts_ = null;
        if (keyPartsBuilder_ != null) {
          keyPartsBuilder_.dispose();
          keyPartsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
            .internal_static_google_spanner_admin_database_v1_SplitPoints_Key_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.admin.database.v1.SplitPoints.Key getDefaultInstanceForType() {
        return com.google.spanner.admin.database.v1.SplitPoints.Key.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.admin.database.v1.SplitPoints.Key build() {
        com.google.spanner.admin.database.v1.SplitPoints.Key result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.admin.database.v1.SplitPoints.Key buildPartial() {
        com.google.spanner.admin.database.v1.SplitPoints.Key result =
            new com.google.spanner.admin.database.v1.SplitPoints.Key(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.admin.database.v1.SplitPoints.Key result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keyParts_ = keyPartsBuilder_ == null ? keyParts_ : keyPartsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.admin.database.v1.SplitPoints.Key) {
          return mergeFrom((com.google.spanner.admin.database.v1.SplitPoints.Key) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.admin.database.v1.SplitPoints.Key other) {
        if (other == com.google.spanner.admin.database.v1.SplitPoints.Key.getDefaultInstance())
          return this;
        if (other.hasKeyParts()) {
          mergeKeyParts(other.getKeyParts());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getKeyPartsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ListValue keyParts_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.ListValue,
              com.google.protobuf.ListValue.Builder,
              com.google.protobuf.ListValueOrBuilder>
          keyPartsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the keyParts field is set.
       */
      public boolean hasKeyParts() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The keyParts.
       */
      public com.google.protobuf.ListValue getKeyParts() {
        if (keyPartsBuilder_ == null) {
          return keyParts_ == null ? com.google.protobuf.ListValue.getDefaultInstance() : keyParts_;
        } else {
          return keyPartsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setKeyParts(com.google.protobuf.ListValue value) {
        if (keyPartsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keyParts_ = value;
        } else {
          keyPartsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setKeyParts(com.google.protobuf.ListValue.Builder builderForValue) {
        if (keyPartsBuilder_ == null) {
          keyParts_ = builderForValue.build();
        } else {
          keyPartsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeKeyParts(com.google.protobuf.ListValue value) {
        if (keyPartsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && keyParts_ != null
              && keyParts_ != com.google.protobuf.ListValue.getDefaultInstance()) {
            getKeyPartsBuilder().mergeFrom(value);
          } else {
            keyParts_ = value;
          }
        } else {
          keyPartsBuilder_.mergeFrom(value);
        }
        if (keyParts_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearKeyParts() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keyParts_ = null;
        if (keyPartsBuilder_ != null) {
          keyPartsBuilder_.dispose();
          keyPartsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.ListValue.Builder getKeyPartsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getKeyPartsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protobuf.ListValueOrBuilder getKeyPartsOrBuilder() {
        if (keyPartsBuilder_ != null) {
          return keyPartsBuilder_.getMessageOrBuilder();
        } else {
          return keyParts_ == null ? com.google.protobuf.ListValue.getDefaultInstance() : keyParts_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The column values making up the split key.
       * </pre>
       *
       * <code>.google.protobuf.ListValue key_parts = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.ListValue,
              com.google.protobuf.ListValue.Builder,
              com.google.protobuf.ListValueOrBuilder>
          getKeyPartsFieldBuilder() {
        if (keyPartsBuilder_ == null) {
          keyPartsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.ListValue,
                  com.google.protobuf.ListValue.Builder,
                  com.google.protobuf.ListValueOrBuilder>(
                  getKeyParts(), getParentForChildren(), isClean());
          keyParts_ = null;
        }
        return keyPartsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.SplitPoints.Key)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.SplitPoints.Key)
    private static final com.google.spanner.admin.database.v1.SplitPoints.Key DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.SplitPoints.Key();
    }

    public static com.google.spanner.admin.database.v1.SplitPoints.Key getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Key> PARSER =
        new com.google.protobuf.AbstractParser<Key>() {
          @java.lang.Override
          public Key parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Key> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Key> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.SplitPoints.Key getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TABLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";

  /**
   *
   *
   * <pre>
   * The table to split.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The table to split.
   * </pre>
   *
   * <code>string table = 1;</code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object index_ = "";

  /**
   *
   *
   * <pre>
   * The index to split.
   * If specified, the `table` field must refer to the index's base table.
   * </pre>
   *
   * <code>string index = 2;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public java.lang.String getIndex() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      index_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The index to split.
   * If specified, the `table` field must refer to the index's base table.
   * </pre>
   *
   * <code>string index = 2;</code>
   *
   * @return The bytes for index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexBytes() {
    java.lang.Object ref = index_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      index_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEYS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Key> keys_;

  /**
   *
   *
   * <pre>
   * Required. The list of split keys, i.e., the split boundaries.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Key> getKeysList() {
    return keys_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of split keys, i.e., the split boundaries.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder>
      getKeysOrBuilderList() {
    return keys_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of split keys, i.e., the split boundaries.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getKeysCount() {
    return keys_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The list of split keys, i.e., the split boundaries.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.SplitPoints.Key getKeys(int index) {
    return keys_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The list of split keys, i.e., the split boundaries.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder getKeysOrBuilder(int index) {
    return keys_.get(index);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp expireTime_;

  /**
   *
   *
   * <pre>
   * Optional. The expiration timestamp of the split points.
   * A timestamp in the past means immediate expiration.
   * The maximum value can be 30 days in the future.
   * Defaults to 10 days in the future if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The expiration timestamp of the split points.
   * A timestamp in the past means immediate expiration.
   * The maximum value can be 30 days in the future.
   * Defaults to 10 days in the future if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The expiration timestamp of the split points.
   * A timestamp in the past means immediate expiration.
   * The maximum value can be 30 days in the future.
   * Defaults to 10 days in the future if not specified.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, table_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, index_);
    }
    for (int i = 0; i < keys_.size(); i++) {
      output.writeMessage(3, keys_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getExpireTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, table_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, index_);
    }
    for (int i = 0; i < keys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, keys_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getExpireTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.SplitPoints)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.SplitPoints other =
        (com.google.spanner.admin.database.v1.SplitPoints) obj;

    if (!getTable().equals(other.getTable())) return false;
    if (!getIndex().equals(other.getIndex())) return false;
    if (!getKeysList().equals(other.getKeysList())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex().hashCode();
    if (getKeysCount() > 0) {
      hash = (37 * hash) + KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getKeysList().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.SplitPoints parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.SplitPoints prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The split points of a table/index.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.SplitPoints}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.SplitPoints)
      com.google.spanner.admin.database.v1.SplitPointsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_SplitPoints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_SplitPoints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.SplitPoints.class,
              com.google.spanner.admin.database.v1.SplitPoints.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.SplitPoints.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getKeysFieldBuilder();
        getExpireTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      table_ = "";
      index_ = "";
      if (keysBuilder_ == null) {
        keys_ = java.util.Collections.emptyList();
      } else {
        keys_ = null;
        keysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_SplitPoints_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.SplitPoints getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.SplitPoints.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.SplitPoints build() {
      com.google.spanner.admin.database.v1.SplitPoints result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.SplitPoints buildPartial() {
      com.google.spanner.admin.database.v1.SplitPoints result =
          new com.google.spanner.admin.database.v1.SplitPoints(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.admin.database.v1.SplitPoints result) {
      if (keysBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          keys_ = java.util.Collections.unmodifiableList(keys_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.keys_ = keys_;
      } else {
        result.keys_ = keysBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.SplitPoints result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.table_ = table_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.index_ = index_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.SplitPoints) {
        return mergeFrom((com.google.spanner.admin.database.v1.SplitPoints) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.SplitPoints other) {
      if (other == com.google.spanner.admin.database.v1.SplitPoints.getDefaultInstance())
        return this;
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getIndex().isEmpty()) {
        index_ = other.index_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (keysBuilder_ == null) {
        if (!other.keys_.isEmpty()) {
          if (keys_.isEmpty()) {
            keys_ = other.keys_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureKeysIsMutable();
            keys_.addAll(other.keys_);
          }
          onChanged();
        }
      } else {
        if (!other.keys_.isEmpty()) {
          if (keysBuilder_.isEmpty()) {
            keysBuilder_.dispose();
            keysBuilder_ = null;
            keys_ = other.keys_;
            bitField0_ = (bitField0_ & ~0x00000004);
            keysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getKeysFieldBuilder()
                    : null;
          } else {
            keysBuilder_.addAllMessages(other.keys_);
          }
        }
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                index_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.spanner.admin.database.v1.SplitPoints.Key m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.SplitPoints.Key.parser(),
                        extensionRegistry);
                if (keysBuilder_ == null) {
                  ensureKeysIsMutable();
                  keys_.add(m);
                } else {
                  keysBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object table_ = "";

    /**
     *
     *
     * <pre>
     * The table to split.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The table to split.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The table to split.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The table to split.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The table to split.
     * </pre>
     *
     * <code>string table = 1;</code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object index_ = "";

    /**
     *
     *
     * <pre>
     * The index to split.
     * If specified, the `table` field must refer to the index's base table.
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The index.
     */
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The index to split.
     * If specified, the `table` field must refer to the index's base table.
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return The bytes for index.
     */
    public com.google.protobuf.ByteString getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The index to split.
     * If specified, the `table` field must refer to the index's base table.
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index to split.
     * If specified, the `table` field must refer to the index's base table.
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      index_ = getDefaultInstance().getIndex();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index to split.
     * If specified, the `table` field must refer to the index's base table.
     * </pre>
     *
     * <code>string index = 2;</code>
     *
     * @param value The bytes for index to set.
     * @return This builder for chaining.
     */
    public Builder setIndexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      index_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Key> keys_ =
        java.util.Collections.emptyList();

    private void ensureKeysIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        keys_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.SplitPoints.Key>(keys_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.SplitPoints.Key,
            com.google.spanner.admin.database.v1.SplitPoints.Key.Builder,
            com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder>
        keysBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Key> getKeysList() {
      if (keysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(keys_);
      } else {
        return keysBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getKeysCount() {
      if (keysBuilder_ == null) {
        return keys_.size();
      } else {
        return keysBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Key getKeys(int index) {
      if (keysBuilder_ == null) {
        return keys_.get(index);
      } else {
        return keysBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setKeys(int index, com.google.spanner.admin.database.v1.SplitPoints.Key value) {
      if (keysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeysIsMutable();
        keys_.set(index, value);
        onChanged();
      } else {
        keysBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setKeys(
        int index, com.google.spanner.admin.database.v1.SplitPoints.Key.Builder builderForValue) {
      if (keysBuilder_ == null) {
        ensureKeysIsMutable();
        keys_.set(index, builderForValue.build());
        onChanged();
      } else {
        keysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addKeys(com.google.spanner.admin.database.v1.SplitPoints.Key value) {
      if (keysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeysIsMutable();
        keys_.add(value);
        onChanged();
      } else {
        keysBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addKeys(int index, com.google.spanner.admin.database.v1.SplitPoints.Key value) {
      if (keysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeysIsMutable();
        keys_.add(index, value);
        onChanged();
      } else {
        keysBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addKeys(
        com.google.spanner.admin.database.v1.SplitPoints.Key.Builder builderForValue) {
      if (keysBuilder_ == null) {
        ensureKeysIsMutable();
        keys_.add(builderForValue.build());
        onChanged();
      } else {
        keysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addKeys(
        int index, com.google.spanner.admin.database.v1.SplitPoints.Key.Builder builderForValue) {
      if (keysBuilder_ == null) {
        ensureKeysIsMutable();
        keys_.add(index, builderForValue.build());
        onChanged();
      } else {
        keysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllKeys(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.SplitPoints.Key> values) {
      if (keysBuilder_ == null) {
        ensureKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, keys_);
        onChanged();
      } else {
        keysBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearKeys() {
      if (keysBuilder_ == null) {
        keys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        keysBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeKeys(int index) {
      if (keysBuilder_ == null) {
        ensureKeysIsMutable();
        keys_.remove(index);
        onChanged();
      } else {
        keysBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Key.Builder getKeysBuilder(int index) {
      return getKeysFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder getKeysOrBuilder(
        int index) {
      if (keysBuilder_ == null) {
        return keys_.get(index);
      } else {
        return keysBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder>
        getKeysOrBuilderList() {
      if (keysBuilder_ != null) {
        return keysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(keys_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Key.Builder addKeysBuilder() {
      return getKeysFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.SplitPoints.Key.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.database.v1.SplitPoints.Key.Builder addKeysBuilder(int index) {
      return getKeysFieldBuilder()
          .addBuilder(
              index, com.google.spanner.admin.database.v1.SplitPoints.Key.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of split keys, i.e., the split boundaries.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.SplitPoints.Key keys = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.SplitPoints.Key.Builder>
        getKeysBuilderList() {
      return getKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.SplitPoints.Key,
            com.google.spanner.admin.database.v1.SplitPoints.Key.Builder,
            com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder>
        getKeysFieldBuilder() {
      if (keysBuilder_ == null) {
        keysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.SplitPoints.Key,
                com.google.spanner.admin.database.v1.SplitPoints.Key.Builder,
                com.google.spanner.admin.database.v1.SplitPoints.KeyOrBuilder>(
                keys_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        keys_ = null;
      }
      return keysBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The expiration timestamp of the split points.
     * A timestamp in the past means immediate expiration.
     * The maximum value can be 30 days in the future.
     * Defaults to 10 days in the future if not specified.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.SplitPoints)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.SplitPoints)
  private static final com.google.spanner.admin.database.v1.SplitPoints DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.SplitPoints();
  }

  public static com.google.spanner.admin.database.v1.SplitPoints getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SplitPoints> PARSER =
      new com.google.protobuf.AbstractParser<SplitPoints>() {
        @java.lang.Override
        public SplitPoints parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SplitPoints> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SplitPoints> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.SplitPoints getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
