/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Metadata type for the operation returned by
 * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.CreateBackupMetadata}
 */
public final class CreateBackupMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.CreateBackupMetadata)
    CreateBackupMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateBackupMetadata.newBuilder() to construct.
  private CreateBackupMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateBackupMetadata() {
    name_ = "";
    database_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateBackupMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_CreateBackupMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_CreateBackupMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.CreateBackupMetadata.class,
            com.google.spanner.admin.database.v1.CreateBackupMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of the backup being created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the backup being created.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * The name of the database the backup is created from.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the database the backup is created from.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROGRESS_FIELD_NUMBER = 3;
  private com.google.spanner.admin.database.v1.OperationProgress progress_;

  /**
   *
   *
   * <pre>
   * The progress of the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The progress of the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgress getProgress() {
    return progress_ == null
        ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
        : progress_;
  }

  /**
   *
   *
   * <pre>
   * The progress of the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder() {
    return progress_ == null
        ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
        : progress_;
  }

  public static final int CANCEL_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp cancelTime_;

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1,
   * corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
   *
   * @return Whether the cancelTime field is set.
   */
  @java.lang.Override
  public boolean hasCancelTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1,
   * corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
   *
   * @return The cancelTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCancelTime() {
    return cancelTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : cancelTime_;
  }

  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1,
   * corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCancelTimeOrBuilder() {
    return cancelTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : cancelTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, database_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getProgress());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getCancelTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, database_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProgress());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCancelTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.CreateBackupMetadata)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.CreateBackupMetadata other =
        (com.google.spanner.admin.database.v1.CreateBackupMetadata) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDatabase().equals(other.getDatabase())) return false;
    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (!getProgress().equals(other.getProgress())) return false;
    }
    if (hasCancelTime() != other.hasCancelTime()) return false;
    if (hasCancelTime()) {
      if (!getCancelTime().equals(other.getCancelTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress().hashCode();
    }
    if (hasCancelTime()) {
      hash = (37 * hash) + CANCEL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCancelTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.CreateBackupMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata type for the operation returned by
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.CreateBackupMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.CreateBackupMetadata)
      com.google.spanner.admin.database.v1.CreateBackupMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CreateBackupMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CreateBackupMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.CreateBackupMetadata.class,
              com.google.spanner.admin.database.v1.CreateBackupMetadata.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.CreateBackupMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProgressFieldBuilder();
        getCancelTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      database_ = "";
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      cancelTime_ = null;
      if (cancelTimeBuilder_ != null) {
        cancelTimeBuilder_.dispose();
        cancelTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CreateBackupMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateBackupMetadata getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.CreateBackupMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateBackupMetadata build() {
      com.google.spanner.admin.database.v1.CreateBackupMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateBackupMetadata buildPartial() {
      com.google.spanner.admin.database.v1.CreateBackupMetadata result =
          new com.google.spanner.admin.database.v1.CreateBackupMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.CreateBackupMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.database_ = database_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.progress_ = progressBuilder_ == null ? progress_ : progressBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cancelTime_ = cancelTimeBuilder_ == null ? cancelTime_ : cancelTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.CreateBackupMetadata) {
        return mergeFrom((com.google.spanner.admin.database.v1.CreateBackupMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.CreateBackupMetadata other) {
      if (other == com.google.spanner.admin.database.v1.CreateBackupMetadata.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasProgress()) {
        mergeProgress(other.getProgress());
      }
      if (other.hasCancelTime()) {
        mergeCancelTime(other.getCancelTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getProgressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCancelTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of the backup being created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the backup being created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the backup being created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the backup being created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the backup being created.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * The name of the database the backup is created from.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the database the backup is created from.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the database the backup is created from.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the database the backup is created from.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the database the backup is created from.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.OperationProgress progress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        progressBuilder_;

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     *
     * @return Whether the progress field is set.
     */
    public boolean hasProgress() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     *
     * @return The progress.
     */
    public com.google.spanner.admin.database.v1.OperationProgress getProgress() {
      if (progressBuilder_ == null) {
        return progress_ == null
            ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
            : progress_;
      } else {
        return progressBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public Builder setProgress(com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progress_ = value;
      } else {
        progressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public Builder setProgress(
        com.google.spanner.admin.database.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        progress_ = builderForValue.build();
      } else {
        progressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public Builder mergeProgress(com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && progress_ != null
            && progress_
                != com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()) {
          getProgressBuilder().mergeFrom(value);
        } else {
          progress_ = value;
        }
      } else {
        progressBuilder_.mergeFrom(value);
      }
      if (progress_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00000004);
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress.Builder getProgressBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getProgressFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilder();
      } else {
        return progress_ == null
            ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
            : progress_;
      }
    }

    /**
     *
     *
     * <pre>
     * The progress of the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        getProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.OperationProgress,
                com.google.spanner.admin.database.v1.OperationProgress.Builder,
                com.google.spanner.admin.database.v1.OperationProgressOrBuilder>(
                getProgress(), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    private com.google.protobuf.Timestamp cancelTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        cancelTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     *
     * @return Whether the cancelTime field is set.
     */
    public boolean hasCancelTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     *
     * @return The cancelTime.
     */
    public com.google.protobuf.Timestamp getCancelTime() {
      if (cancelTimeBuilder_ == null) {
        return cancelTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : cancelTime_;
      } else {
        return cancelTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public Builder setCancelTime(com.google.protobuf.Timestamp value) {
      if (cancelTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cancelTime_ = value;
      } else {
        cancelTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public Builder setCancelTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (cancelTimeBuilder_ == null) {
        cancelTime_ = builderForValue.build();
      } else {
        cancelTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public Builder mergeCancelTime(com.google.protobuf.Timestamp value) {
      if (cancelTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && cancelTime_ != null
            && cancelTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCancelTimeBuilder().mergeFrom(value);
        } else {
          cancelTime_ = value;
        }
      } else {
        cancelTimeBuilder_.mergeFrom(value);
      }
      if (cancelTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public Builder clearCancelTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cancelTime_ = null;
      if (cancelTimeBuilder_ != null) {
        cancelTimeBuilder_.dispose();
        cancelTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCancelTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCancelTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCancelTimeOrBuilder() {
      if (cancelTimeBuilder_ != null) {
        return cancelTimeBuilder_.getMessageOrBuilder();
      } else {
        return cancelTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : cancelTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCancelTimeFieldBuilder() {
      if (cancelTimeBuilder_ == null) {
        cancelTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCancelTime(), getParentForChildren(), isClean());
        cancelTime_ = null;
      }
      return cancelTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.CreateBackupMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.CreateBackupMetadata)
  private static final com.google.spanner.admin.database.v1.CreateBackupMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.CreateBackupMetadata();
  }

  public static com.google.spanner.admin.database.v1.CreateBackupMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateBackupMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CreateBackupMetadata>() {
        @java.lang.Override
        public CreateBackupMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateBackupMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateBackupMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.CreateBackupMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
