/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.database.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupScheduleName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_DATABASE_SCHEDULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/databases/{database}/backupSchedules/{schedule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String database;
    private final String schedule;

    @Deprecated
    protected BackupScheduleName() {
        this.project = null;
        this.instance = null;
        this.database = null;
        this.schedule = null;
    }

    private BackupScheduleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.schedule = (String)Preconditions.checkNotNull((Object)builder.getSchedule());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupScheduleName of(String project, String instance, String database, String schedule) {
        return BackupScheduleName.newBuilder().setProject(project).setInstance(instance).setDatabase(database).setSchedule(schedule).build();
    }

    public static String format(String project, String instance, String database, String schedule) {
        return BackupScheduleName.newBuilder().setProject(project).setInstance(instance).setDatabase(database).setSchedule(schedule).build().toString();
    }

    public static BackupScheduleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_INSTANCE_DATABASE_SCHEDULE.validatedMatch(formattedString, "BackupScheduleName.parse: formattedString not in valid format");
        return BackupScheduleName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("database"), (String)matchMap.get("schedule"));
    }

    public static List<BackupScheduleName> parseList(List<String> formattedStrings) {
        ArrayList<BackupScheduleName> list = new ArrayList<BackupScheduleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupScheduleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupScheduleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupScheduleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_DATABASE_SCHEDULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupScheduleName backupScheduleName = this;
            synchronized (backupScheduleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.schedule != null) {
                        fieldMapBuilder.put((Object)"schedule", (Object)this.schedule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_DATABASE_SCHEDULE.instantiate(new String[]{"project", this.project, "instance", this.instance, "database", this.database, "schedule", this.schedule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupScheduleName that = (BackupScheduleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.database, that.database) && Objects.equals(this.schedule, that.schedule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.schedule);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String database;
        private String schedule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setSchedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        private Builder(BackupScheduleName backupScheduleName) {
            this.project = backupScheduleName.project;
            this.instance = backupScheduleName.instance;
            this.database = backupScheduleName.database;
            this.schedule = backupScheduleName.schedule;
        }

        public BackupScheduleName build() {
            return new BackupScheduleName(this);
        }
    }
}

