/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.shell.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnvironmentName
implements ResourceName {
    private static final PathTemplate USER_ENVIRONMENT = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/environments/{environment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String environment;

    @Deprecated
    protected EnvironmentName() {
        this.user = null;
        this.environment = null;
    }

    private EnvironmentName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
    }

    public String getUser() {
        return this.user;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EnvironmentName of(String user, String environment) {
        return EnvironmentName.newBuilder().setUser(user).setEnvironment(environment).build();
    }

    public static String format(String user, String environment) {
        return EnvironmentName.newBuilder().setUser(user).setEnvironment(environment).build().toString();
    }

    public static EnvironmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER_ENVIRONMENT.validatedMatch(formattedString, "EnvironmentName.parse: formattedString not in valid format");
        return EnvironmentName.of((String)matchMap.get("user"), (String)matchMap.get("environment"));
    }

    public static List<EnvironmentName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentName> list = new ArrayList<EnvironmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER_ENVIRONMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentName environmentName = this;
            synchronized (environmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER_ENVIRONMENT.instantiate(new String[]{"user", this.user, "environment", this.environment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EnvironmentName that = (EnvironmentName)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.environment, that.environment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.environment);
    }

    public static class Builder {
        private String user;
        private String environment;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        private Builder(EnvironmentName environmentName) {
            this.user = environmentName.user;
            this.environment = environmentName.environment;
        }

        public EnvironmentName build() {
            return new EnvironmentName(this);
        }
    }
}

