/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrganizationImpactName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_ORGANIZATION_IMPACT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/organizationImpacts/{organization_impact}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String organizationImpact;

    @Deprecated
    protected OrganizationImpactName() {
        this.organization = null;
        this.location = null;
        this.organizationImpact = null;
    }

    private OrganizationImpactName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.organizationImpact = (String)Preconditions.checkNotNull((Object)builder.getOrganizationImpact());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrganizationImpact() {
        return this.organizationImpact;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrganizationImpactName of(String organization, String location, String organizationImpact) {
        return OrganizationImpactName.newBuilder().setOrganization(organization).setLocation(location).setOrganizationImpact(organizationImpact).build();
    }

    public static String format(String organization, String location, String organizationImpact) {
        return OrganizationImpactName.newBuilder().setOrganization(organization).setLocation(location).setOrganizationImpact(organizationImpact).build().toString();
    }

    public static OrganizationImpactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_ORGANIZATION_IMPACT.validatedMatch(formattedString, "OrganizationImpactName.parse: formattedString not in valid format");
        return OrganizationImpactName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("organization_impact"));
    }

    public static List<OrganizationImpactName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationImpactName> list = new ArrayList<OrganizationImpactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationImpactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationImpactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationImpactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_ORGANIZATION_IMPACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationImpactName organizationImpactName = this;
            synchronized (organizationImpactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.organizationImpact != null) {
                        fieldMapBuilder.put((Object)"organization_impact", (Object)this.organizationImpact);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_ORGANIZATION_IMPACT.instantiate(new String[]{"organization", this.organization, "location", this.location, "organization_impact", this.organizationImpact});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrganizationImpactName that = (OrganizationImpactName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.organizationImpact, that.organizationImpact);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organizationImpact);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String organizationImpact;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrganizationImpact() {
            return this.organizationImpact;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrganizationImpact(String organizationImpact) {
            this.organizationImpact = organizationImpact;
            return this;
        }

        private Builder(OrganizationImpactName organizationImpactName) {
            this.organization = organizationImpactName.organization;
            this.location = organizationImpactName.location;
            this.organizationImpact = organizationImpactName.organizationImpact;
        }

        public OrganizationImpactName build() {
            return new OrganizationImpactName(this);
        }
    }
}

