/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicehealth.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrganizationEventName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_EVENT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/organizationEvents/{event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String event;

    @Deprecated
    protected OrganizationEventName() {
        this.organization = null;
        this.location = null;
        this.event = null;
    }

    private OrganizationEventName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.event = (String)Preconditions.checkNotNull((Object)builder.getEvent());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEvent() {
        return this.event;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrganizationEventName of(String organization, String location, String event) {
        return OrganizationEventName.newBuilder().setOrganization(organization).setLocation(location).setEvent(event).build();
    }

    public static String format(String organization, String location, String event) {
        return OrganizationEventName.newBuilder().setOrganization(organization).setLocation(location).setEvent(event).build().toString();
    }

    public static OrganizationEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_EVENT.validatedMatch(formattedString, "OrganizationEventName.parse: formattedString not in valid format");
        return OrganizationEventName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("event"));
    }

    public static List<OrganizationEventName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationEventName> list = new ArrayList<OrganizationEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationEventName organizationEventName = this;
            synchronized (organizationEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.event != null) {
                        fieldMapBuilder.put((Object)"event", (Object)this.event);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_EVENT.instantiate(new String[]{"organization", this.organization, "location", this.location, "event", this.event});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrganizationEventName that = (OrganizationEventName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.event, that.event);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.event);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String event;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEvent() {
            return this.event;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEvent(String event) {
            this.event = event;
            return this;
        }

        private Builder(OrganizationEventName organizationEventName) {
            this.organization = organizationEventName.organization;
            this.location = organizationEventName.location;
            this.event = organizationEventName.event;
        }

        public OrganizationEventName build() {
            return new OrganizationEventName(this);
        }
    }
}

