/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NamespaceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NAMESPACE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/namespaces/{namespace}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String namespace;

    @Deprecated
    protected NamespaceName() {
        this.project = null;
        this.location = null;
        this.namespace = null;
    }

    private NamespaceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.namespace = (String)Preconditions.checkNotNull((Object)builder.getNamespace());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NamespaceName of(String project, String location, String namespace) {
        return NamespaceName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).build();
    }

    public static String format(String project, String location, String namespace) {
        return NamespaceName.newBuilder().setProject(project).setLocation(location).setNamespace(namespace).build().toString();
    }

    public static NamespaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NAMESPACE.validatedMatch(formattedString, "NamespaceName.parse: formattedString not in valid format");
        return NamespaceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("namespace"));
    }

    public static List<NamespaceName> parseList(List<String> formattedStrings) {
        ArrayList<NamespaceName> list = new ArrayList<NamespaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NamespaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NamespaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NamespaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NAMESPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NamespaceName namespaceName = this;
            synchronized (namespaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.namespace != null) {
                        fieldMapBuilder.put((Object)"namespace", (Object)this.namespace);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NAMESPACE.instantiate(new String[]{"project", this.project, "location", this.location, "namespace", this.namespace});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NamespaceName that = (NamespaceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.namespace, that.namespace);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.namespace);
    }

    public static class Builder {
        private String project;
        private String location;
        private String namespace;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        private Builder(NamespaceName namespaceName) {
            this.project = namespaceName.project;
            this.location = namespaceName.location;
            this.namespace = namespaceName.namespace;
        }

        public NamespaceName build() {
            return new NamespaceName(this);
        }
    }
}

