/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PostureName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_POSTURE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/postures/{posture}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String posture;

    @Deprecated
    protected PostureName() {
        this.organization = null;
        this.location = null;
        this.posture = null;
    }

    private PostureName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.posture = (String)Preconditions.checkNotNull((Object)builder.getPosture());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPosture() {
        return this.posture;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PostureName of(String organization, String location, String posture) {
        return PostureName.newBuilder().setOrganization(organization).setLocation(location).setPosture(posture).build();
    }

    public static String format(String organization, String location, String posture) {
        return PostureName.newBuilder().setOrganization(organization).setLocation(location).setPosture(posture).build().toString();
    }

    public static PostureName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_POSTURE.validatedMatch(formattedString, "PostureName.parse: formattedString not in valid format");
        return PostureName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("posture"));
    }

    public static List<PostureName> parseList(List<String> formattedStrings) {
        ArrayList<PostureName> list = new ArrayList<PostureName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PostureName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PostureName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PostureName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_POSTURE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PostureName postureName = this;
            synchronized (postureName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.posture != null) {
                        fieldMapBuilder.put((Object)"posture", (Object)this.posture);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_POSTURE.instantiate(new String[]{"organization", this.organization, "location", this.location, "posture", this.posture});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PostureName that = (PostureName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.posture, that.posture);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.posture);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String posture;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPosture() {
            return this.posture;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPosture(String posture) {
            this.posture = posture;
            return this;
        }

        private Builder(PostureName postureName) {
            this.organization = postureName.organization;
            this.location = postureName.location;
            this.posture = postureName.posture;
        }

        public PostureName build() {
            return new PostureName(this);
        }
    }
}

