/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimulationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SIMULATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/simulations/{simulation}");
    private static final PathTemplate ORGANIZATION_LOCATION_SIMLUATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/simulations/{simluation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String simulation;
    private final String location;
    private final String simluation;

    @Deprecated
    protected SimulationName() {
        this.organization = null;
        this.simulation = null;
        this.location = null;
        this.simluation = null;
    }

    private SimulationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.simulation = (String)Preconditions.checkNotNull((Object)builder.getSimulation());
        this.location = null;
        this.simluation = null;
        this.pathTemplate = ORGANIZATION_SIMULATION;
    }

    private SimulationName(OrganizationLocationSimluationBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.simluation = (String)Preconditions.checkNotNull((Object)builder.getSimluation());
        this.simulation = null;
        this.pathTemplate = ORGANIZATION_LOCATION_SIMLUATION;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSimluation() {
        return this.simluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationSimulationBuilder() {
        return new Builder();
    }

    public static OrganizationLocationSimluationBuilder newOrganizationLocationSimluationBuilder() {
        return new OrganizationLocationSimluationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SimulationName of(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build();
    }

    public static SimulationName ofOrganizationSimulationName(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build();
    }

    public static SimulationName ofOrganizationLocationSimluationName(String organization, String location, String simluation) {
        return SimulationName.newOrganizationLocationSimluationBuilder().setOrganization(organization).setLocation(location).setSimluation(simluation).build();
    }

    public static String format(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build().toString();
    }

    public static String formatOrganizationSimulationName(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build().toString();
    }

    public static String formatOrganizationLocationSimluationName(String organization, String location, String simluation) {
        return SimulationName.newOrganizationLocationSimluationBuilder().setOrganization(organization).setLocation(location).setSimluation(simluation).build().toString();
    }

    public static SimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_SIMULATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SIMULATION.match(formattedString);
            return SimulationName.ofOrganizationSimulationName((String)matchMap.get("organization"), (String)matchMap.get("simulation"));
        }
        if (ORGANIZATION_LOCATION_SIMLUATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_SIMLUATION.match(formattedString);
            return SimulationName.ofOrganizationLocationSimluationName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("simluation"));
        }
        throw new ValidationException("SimulationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SimulationName> parseList(List<String> formattedStrings) {
        ArrayList<SimulationName> list = new ArrayList<SimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SIMULATION.matches(formattedString) || ORGANIZATION_LOCATION_SIMLUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SimulationName simulationName = this;
            synchronized (simulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.simulation != null) {
                        fieldMapBuilder.put((Object)"simulation", (Object)this.simulation);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.simluation != null) {
                        fieldMapBuilder.put((Object)"simluation", (Object)this.simluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SimulationName that = (SimulationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.simulation, that.simulation) && Objects.equals(this.location, that.location) && Objects.equals(this.simluation, that.simluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.simulation);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.simluation);
    }

    public static class OrganizationLocationSimluationBuilder {
        private String organization;
        private String location;
        private String simluation;

        protected OrganizationLocationSimluationBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSimluation() {
            return this.simluation;
        }

        public OrganizationLocationSimluationBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationSimluationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationSimluationBuilder setSimluation(String simluation) {
            this.simluation = simluation;
            return this;
        }

        public SimulationName build() {
            return new SimulationName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String simulation;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSimulation() {
            return this.simulation;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        private Builder(SimulationName simulationName) {
            Preconditions.checkArgument((boolean)Objects.equals(simulationName.pathTemplate, ORGANIZATION_SIMULATION), (Object)"toBuilder is only supported when SimulationName has the pattern of organizations/{organization}/simulations/{simulation}");
            this.organization = simulationName.organization;
            this.simulation = simulationName.simulation;
        }

        public SimulationName build() {
            return new SimulationName(this);
        }
    }
}

