/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimulationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SIMULATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/simulations/{simulation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String simulation;

    @Deprecated
    protected SimulationName() {
        this.organization = null;
        this.simulation = null;
    }

    private SimulationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.simulation = (String)Preconditions.checkNotNull((Object)builder.getSimulation());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SimulationName of(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build();
    }

    public static String format(String organization, String simulation) {
        return SimulationName.newBuilder().setOrganization(organization).setSimulation(simulation).build().toString();
    }

    public static SimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_SIMULATION.validatedMatch(formattedString, "SimulationName.parse: formattedString not in valid format");
        return SimulationName.of((String)matchMap.get("organization"), (String)matchMap.get("simulation"));
    }

    public static List<SimulationName> parseList(List<String> formattedStrings) {
        ArrayList<SimulationName> list = new ArrayList<SimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SIMULATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SimulationName simulationName = this;
            synchronized (simulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.simulation != null) {
                        fieldMapBuilder.put((Object)"simulation", (Object)this.simulation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_SIMULATION.instantiate(new String[]{"organization", this.organization, "simulation", this.simulation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SimulationName that = (SimulationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.simulation, that.simulation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.simulation);
    }

    public static class Builder {
        private String organization;
        private String simulation;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSimulation() {
            return this.simulation;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        private Builder(SimulationName simulationName) {
            this.organization = simulationName.organization;
            this.simulation = simulationName.simulation;
        }

        public SimulationName build() {
            return new SimulationName(this);
        }
    }
}

