/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceValueConfigName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_RESOURCE_VALUE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/resourceValueConfigs/{resource_value_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String resourceValueConfig;

    @Deprecated
    protected ResourceValueConfigName() {
        this.organization = null;
        this.resourceValueConfig = null;
    }

    private ResourceValueConfigName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.resourceValueConfig = (String)Preconditions.checkNotNull((Object)builder.getResourceValueConfig());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getResourceValueConfig() {
        return this.resourceValueConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceValueConfigName of(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build();
    }

    public static String format(String organization, String resourceValueConfig) {
        return ResourceValueConfigName.newBuilder().setOrganization(organization).setResourceValueConfig(resourceValueConfig).build().toString();
    }

    public static ResourceValueConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_RESOURCE_VALUE_CONFIG.validatedMatch(formattedString, "ResourceValueConfigName.parse: formattedString not in valid format");
        return ResourceValueConfigName.of((String)matchMap.get("organization"), (String)matchMap.get("resource_value_config"));
    }

    public static List<ResourceValueConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceValueConfigName> list = new ArrayList<ResourceValueConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceValueConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceValueConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceValueConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_RESOURCE_VALUE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceValueConfigName resourceValueConfigName = this;
            synchronized (resourceValueConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.resourceValueConfig != null) {
                        fieldMapBuilder.put((Object)"resource_value_config", (Object)this.resourceValueConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_RESOURCE_VALUE_CONFIG.instantiate(new String[]{"organization", this.organization, "resource_value_config", this.resourceValueConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceValueConfigName that = (ResourceValueConfigName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.resourceValueConfig, that.resourceValueConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceValueConfig);
    }

    public static class Builder {
        private String organization;
        private String resourceValueConfig;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getResourceValueConfig() {
            return this.resourceValueConfig;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setResourceValueConfig(String resourceValueConfig) {
            this.resourceValueConfig = resourceValueConfig;
            return this;
        }

        private Builder(ResourceValueConfigName resourceValueConfigName) {
            this.organization = resourceValueConfigName.organization;
            this.resourceValueConfig = resourceValueConfigName.resourceValueConfig;
        }

        public ResourceValueConfigName build() {
            return new ResourceValueConfigName(this);
        }
    }
}

