/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BigQueryExportName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/bigQueryExports/{export}");
    private static final PathTemplate FOLDER_LOCATION_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/bigQueryExports/{export}");
    private static final PathTemplate PROJECT_LOCATION_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/bigQueryExports/{export}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String export;
    private final String folder;
    private final String project;

    @Deprecated
    protected BigQueryExportName() {
        this.organization = null;
        this.location = null;
        this.export = null;
        this.folder = null;
        this.project = null;
    }

    private BigQueryExportName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_EXPORT;
    }

    private BigQueryExportName(FolderLocationExportBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_LOCATION_EXPORT;
    }

    private BigQueryExportName(ProjectLocationExportBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.export = (String)Preconditions.checkNotNull((Object)builder.getExport());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_LOCATION_EXPORT;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExport() {
        return this.export;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationExportBuilder() {
        return new Builder();
    }

    public static FolderLocationExportBuilder newFolderLocationExportBuilder() {
        return new FolderLocationExportBuilder();
    }

    public static ProjectLocationExportBuilder newProjectLocationExportBuilder() {
        return new ProjectLocationExportBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BigQueryExportName of(String organization, String location, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setLocation(location).setExport(export).build();
    }

    public static BigQueryExportName ofOrganizationLocationExportName(String organization, String location, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setLocation(location).setExport(export).build();
    }

    public static BigQueryExportName ofFolderLocationExportName(String folder, String location, String export) {
        return BigQueryExportName.newFolderLocationExportBuilder().setFolder(folder).setLocation(location).setExport(export).build();
    }

    public static BigQueryExportName ofProjectLocationExportName(String project, String location, String export) {
        return BigQueryExportName.newProjectLocationExportBuilder().setProject(project).setLocation(location).setExport(export).build();
    }

    public static String format(String organization, String location, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setLocation(location).setExport(export).build().toString();
    }

    public static String formatOrganizationLocationExportName(String organization, String location, String export) {
        return BigQueryExportName.newBuilder().setOrganization(organization).setLocation(location).setExport(export).build().toString();
    }

    public static String formatFolderLocationExportName(String folder, String location, String export) {
        return BigQueryExportName.newFolderLocationExportBuilder().setFolder(folder).setLocation(location).setExport(export).build().toString();
    }

    public static String formatProjectLocationExportName(String project, String location, String export) {
        return BigQueryExportName.newProjectLocationExportBuilder().setProject(project).setLocation(location).setExport(export).build().toString();
    }

    public static BigQueryExportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_EXPORT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_EXPORT.match(formattedString);
            return BigQueryExportName.ofOrganizationLocationExportName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("export"));
        }
        if (FOLDER_LOCATION_EXPORT.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_EXPORT.match(formattedString);
            return BigQueryExportName.ofFolderLocationExportName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("export"));
        }
        if (PROJECT_LOCATION_EXPORT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_EXPORT.match(formattedString);
            return BigQueryExportName.ofProjectLocationExportName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("export"));
        }
        throw new ValidationException("BigQueryExportName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BigQueryExportName> parseList(List<String> formattedStrings) {
        ArrayList<BigQueryExportName> list = new ArrayList<BigQueryExportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BigQueryExportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BigQueryExportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BigQueryExportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_EXPORT.matches(formattedString) || FOLDER_LOCATION_EXPORT.matches(formattedString) || PROJECT_LOCATION_EXPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BigQueryExportName bigQueryExportName = this;
            synchronized (bigQueryExportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.export != null) {
                        fieldMapBuilder.put((Object)"export", (Object)this.export);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BigQueryExportName that = (BigQueryExportName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.export, that.export) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.export);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationExportBuilder {
        private String project;
        private String location;
        private String export;

        protected ProjectLocationExportBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExport() {
            return this.export;
        }

        public ProjectLocationExportBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationExportBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationExportBuilder setExport(String export) {
            this.export = export;
            return this;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }

    public static class FolderLocationExportBuilder {
        private String folder;
        private String location;
        private String export;

        protected FolderLocationExportBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExport() {
            return this.export;
        }

        public FolderLocationExportBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationExportBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationExportBuilder setExport(String export) {
            this.export = export;
            return this;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String export;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExport() {
            return this.export;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setExport(String export) {
            this.export = export;
            return this;
        }

        private Builder(BigQueryExportName bigQueryExportName) {
            Preconditions.checkArgument((boolean)Objects.equals(bigQueryExportName.pathTemplate, ORGANIZATION_LOCATION_EXPORT), (Object)"toBuilder is only supported when BigQueryExportName has the pattern of organizations/{organization}/locations/{location}/bigQueryExports/{export}");
            this.organization = bigQueryExportName.organization;
            this.location = bigQueryExportName.location;
            this.export = bigQueryExportName.export;
        }

        public BigQueryExportName build() {
            return new BigQueryExportName(this);
        }
    }
}

