/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ValuedResourceName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SIMULATION_VALUED_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String simulation;
    private final String valuedResource;

    @Deprecated
    protected ValuedResourceName() {
        this.organization = null;
        this.simulation = null;
        this.valuedResource = null;
    }

    private ValuedResourceName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.simulation = (String)Preconditions.checkNotNull((Object)builder.getSimulation());
        this.valuedResource = (String)Preconditions.checkNotNull((Object)builder.getValuedResource());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public String getValuedResource() {
        return this.valuedResource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ValuedResourceName of(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build();
    }

    public static String format(String organization, String simulation, String valuedResource) {
        return ValuedResourceName.newBuilder().setOrganization(organization).setSimulation(simulation).setValuedResource(valuedResource).build().toString();
    }

    public static ValuedResourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_SIMULATION_VALUED_RESOURCE.validatedMatch(formattedString, "ValuedResourceName.parse: formattedString not in valid format");
        return ValuedResourceName.of((String)matchMap.get("organization"), (String)matchMap.get("simulation"), (String)matchMap.get("valued_resource"));
    }

    public static List<ValuedResourceName> parseList(List<String> formattedStrings) {
        ArrayList<ValuedResourceName> list = new ArrayList<ValuedResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ValuedResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ValuedResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ValuedResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SIMULATION_VALUED_RESOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ValuedResourceName valuedResourceName = this;
            synchronized (valuedResourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.simulation != null) {
                        fieldMapBuilder.put((Object)"simulation", (Object)this.simulation);
                    }
                    if (this.valuedResource != null) {
                        fieldMapBuilder.put((Object)"valued_resource", (Object)this.valuedResource);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_SIMULATION_VALUED_RESOURCE.instantiate(new String[]{"organization", this.organization, "simulation", this.simulation, "valued_resource", this.valuedResource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ValuedResourceName that = (ValuedResourceName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.simulation, that.simulation) && Objects.equals(this.valuedResource, that.valuedResource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.simulation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.valuedResource);
    }

    public static class Builder {
        private String organization;
        private String simulation;
        private String valuedResource;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSimulation() {
            return this.simulation;
        }

        public String getValuedResource() {
            return this.valuedResource;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public Builder setValuedResource(String valuedResource) {
            this.valuedResource = valuedResource;
            return this;
        }

        private Builder(ValuedResourceName valuedResourceName) {
            this.organization = valuedResourceName.organization;
            this.simulation = valuedResourceName.simulation;
            this.valuedResource = valuedResourceName.valuedResource;
        }

        public ValuedResourceName build() {
            return new ValuedResourceName(this);
        }
    }
}

