/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FindingName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}/findings/{finding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String source;
    private final String finding;

    @Deprecated
    protected FindingName() {
        this.organization = null;
        this.source = null;
        this.finding = null;
    }

    private FindingName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getSource() {
        return this.source;
    }

    public String getFinding() {
        return this.finding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FindingName of(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build();
    }

    public static String format(String organization, String source, String finding) {
        return FindingName.newBuilder().setOrganization(organization).setSource(source).setFinding(finding).build().toString();
    }

    public static FindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_SOURCE_FINDING.validatedMatch(formattedString, "FindingName.parse: formattedString not in valid format");
        return FindingName.of((String)matchMap.get("organization"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
    }

    public static List<FindingName> parseList(List<String> formattedStrings) {
        ArrayList<FindingName> list = new ArrayList<FindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_SOURCE_FINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FindingName findingName = this;
            synchronized (findingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_SOURCE_FINDING.instantiate(new String[]{"organization", this.organization, "source", this.source, "finding", this.finding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FindingName that = (FindingName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.source, that.source) && Objects.equals(this.finding, that.finding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.finding);
    }

    public static class Builder {
        private String organization;
        private String source;
        private String finding;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        private Builder(FindingName findingName) {
            this.organization = findingName.organization;
            this.source = findingName.source;
            this.finding = findingName.finding;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }
}

